/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ZendeskDestinationProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ZendeskDestinationProperties.Builder, ZendeskDestinationProperties> {
    private static final SdkField<String> OBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("object")
            .getter(getter(ZendeskDestinationProperties::object)).setter(setter(Builder::object))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("object").build()).build();

    private static final SdkField<List<String>> ID_FIELD_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("idFieldNames")
            .getter(getter(ZendeskDestinationProperties::idFieldNames))
            .setter(setter(Builder::idFieldNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idFieldNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ErrorHandlingConfig> ERROR_HANDLING_CONFIG_FIELD = SdkField
            .<ErrorHandlingConfig> builder(MarshallingType.SDK_POJO).memberName("errorHandlingConfig")
            .getter(getter(ZendeskDestinationProperties::errorHandlingConfig)).setter(setter(Builder::errorHandlingConfig))
            .constructor(ErrorHandlingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorHandlingConfig").build())
            .build();

    private static final SdkField<String> WRITE_OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("writeOperationType").getter(getter(ZendeskDestinationProperties::writeOperationTypeAsString))
            .setter(setter(Builder::writeOperationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeOperationType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_FIELD,
            ID_FIELD_NAMES_FIELD, ERROR_HANDLING_CONFIG_FIELD, WRITE_OPERATION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String object;

    private final List<String> idFieldNames;

    private final ErrorHandlingConfig errorHandlingConfig;

    private final String writeOperationType;

    private ZendeskDestinationProperties(BuilderImpl builder) {
        this.object = builder.object;
        this.idFieldNames = builder.idFieldNames;
        this.errorHandlingConfig = builder.errorHandlingConfig;
        this.writeOperationType = builder.writeOperationType;
    }

    /**
     * Returns the value of the Object property for this object.
     * 
     * @return The value of the Object property for this object.
     */
    public final String object() {
        return object;
    }

    /**
     * Returns true if the IdFieldNames property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIdFieldNames() {
        return idFieldNames != null && !(idFieldNames instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the IdFieldNames property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIdFieldNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the IdFieldNames property for this object.
     */
    public final List<String> idFieldNames() {
        return idFieldNames;
    }

    /**
     * Returns the value of the ErrorHandlingConfig property for this object.
     * 
     * @return The value of the ErrorHandlingConfig property for this object.
     */
    public final ErrorHandlingConfig errorHandlingConfig() {
        return errorHandlingConfig;
    }

    /**
     * Returns the value of the WriteOperationType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #writeOperationType} will return {@link WriteOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #writeOperationTypeAsString}.
     * </p>
     * 
     * @return The value of the WriteOperationType property for this object.
     * @see WriteOperationType
     */
    public final WriteOperationType writeOperationType() {
        return WriteOperationType.fromValue(writeOperationType);
    }

    /**
     * Returns the value of the WriteOperationType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #writeOperationType} will return {@link WriteOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #writeOperationTypeAsString}.
     * </p>
     * 
     * @return The value of the WriteOperationType property for this object.
     * @see WriteOperationType
     */
    public final String writeOperationTypeAsString() {
        return writeOperationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(object());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdFieldNames() ? idFieldNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(errorHandlingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(writeOperationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZendeskDestinationProperties)) {
            return false;
        }
        ZendeskDestinationProperties other = (ZendeskDestinationProperties) obj;
        return Objects.equals(object(), other.object()) && hasIdFieldNames() == other.hasIdFieldNames()
                && Objects.equals(idFieldNames(), other.idFieldNames())
                && Objects.equals(errorHandlingConfig(), other.errorHandlingConfig())
                && Objects.equals(writeOperationTypeAsString(), other.writeOperationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ZendeskDestinationProperties").add("Object", object())
                .add("IdFieldNames", hasIdFieldNames() ? idFieldNames() : null).add("ErrorHandlingConfig", errorHandlingConfig())
                .add("WriteOperationType", writeOperationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "object":
            return Optional.ofNullable(clazz.cast(object()));
        case "idFieldNames":
            return Optional.ofNullable(clazz.cast(idFieldNames()));
        case "errorHandlingConfig":
            return Optional.ofNullable(clazz.cast(errorHandlingConfig()));
        case "writeOperationType":
            return Optional.ofNullable(clazz.cast(writeOperationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ZendeskDestinationProperties, T> g) {
        return obj -> g.apply((ZendeskDestinationProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ZendeskDestinationProperties> {
        /**
         * Sets the value of the Object property for this object.
         *
         * @param object
         *        The new value for the Object property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder object(String object);

        /**
         * Sets the value of the IdFieldNames property for this object.
         *
         * @param idFieldNames
         *        The new value for the IdFieldNames property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idFieldNames(Collection<String> idFieldNames);

        /**
         * Sets the value of the IdFieldNames property for this object.
         *
         * @param idFieldNames
         *        The new value for the IdFieldNames property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idFieldNames(String... idFieldNames);

        /**
         * Sets the value of the ErrorHandlingConfig property for this object.
         *
         * @param errorHandlingConfig
         *        The new value for the ErrorHandlingConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorHandlingConfig(ErrorHandlingConfig errorHandlingConfig);

        /**
         * Sets the value of the ErrorHandlingConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link ErrorHandlingConfig.Builder} avoiding the need
         * to create one manually via {@link ErrorHandlingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorHandlingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #errorHandlingConfig(ErrorHandlingConfig)}.
         * 
         * @param errorHandlingConfig
         *        a consumer that will call methods on {@link ErrorHandlingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorHandlingConfig(ErrorHandlingConfig)
         */
        default Builder errorHandlingConfig(Consumer<ErrorHandlingConfig.Builder> errorHandlingConfig) {
            return errorHandlingConfig(ErrorHandlingConfig.builder().applyMutation(errorHandlingConfig).build());
        }

        /**
         * Sets the value of the WriteOperationType property for this object.
         *
         * @param writeOperationType
         *        The new value for the WriteOperationType property for this object.
         * @see WriteOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WriteOperationType
         */
        Builder writeOperationType(String writeOperationType);

        /**
         * Sets the value of the WriteOperationType property for this object.
         *
         * @param writeOperationType
         *        The new value for the WriteOperationType property for this object.
         * @see WriteOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WriteOperationType
         */
        Builder writeOperationType(WriteOperationType writeOperationType);
    }

    static final class BuilderImpl implements Builder {
        private String object;

        private List<String> idFieldNames = DefaultSdkAutoConstructList.getInstance();

        private ErrorHandlingConfig errorHandlingConfig;

        private String writeOperationType;

        private BuilderImpl() {
        }

        private BuilderImpl(ZendeskDestinationProperties model) {
            object(model.object);
            idFieldNames(model.idFieldNames);
            errorHandlingConfig(model.errorHandlingConfig);
            writeOperationType(model.writeOperationType);
        }

        public final String getObject() {
            return object;
        }

        @Override
        public final Builder object(String object) {
            this.object = object;
            return this;
        }

        public final void setObject(String object) {
            this.object = object;
        }

        public final Collection<String> getIdFieldNames() {
            if (idFieldNames instanceof SdkAutoConstructList) {
                return null;
            }
            return idFieldNames;
        }

        @Override
        public final Builder idFieldNames(Collection<String> idFieldNames) {
            this.idFieldNames = IdFieldNameListCopier.copy(idFieldNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idFieldNames(String... idFieldNames) {
            idFieldNames(Arrays.asList(idFieldNames));
            return this;
        }

        public final void setIdFieldNames(Collection<String> idFieldNames) {
            this.idFieldNames = IdFieldNameListCopier.copy(idFieldNames);
        }

        public final ErrorHandlingConfig.Builder getErrorHandlingConfig() {
            return errorHandlingConfig != null ? errorHandlingConfig.toBuilder() : null;
        }

        @Override
        public final Builder errorHandlingConfig(ErrorHandlingConfig errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig;
            return this;
        }

        public final void setErrorHandlingConfig(ErrorHandlingConfig.BuilderImpl errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig != null ? errorHandlingConfig.build() : null;
        }

        public final String getWriteOperationType() {
            return writeOperationType;
        }

        @Override
        public final Builder writeOperationType(String writeOperationType) {
            this.writeOperationType = writeOperationType;
            return this;
        }

        @Override
        public final Builder writeOperationType(WriteOperationType writeOperationType) {
            this.writeOperationType(writeOperationType == null ? null : writeOperationType.toString());
            return this;
        }

        public final void setWriteOperationType(String writeOperationType) {
            this.writeOperationType = writeOperationType;
        }

        @Override
        public ZendeskDestinationProperties build() {
            return new ZendeskDestinationProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
