/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectorProfileRequest extends AppflowRequest implements
        ToCopyableBuilder<CreateConnectorProfileRequest.Builder, CreateConnectorProfileRequest> {
    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorProfileName").getter(getter(CreateConnectorProfileRequest::connectorProfileName))
            .setter(setter(Builder::connectorProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build())
            .build();

    private static final SdkField<String> KMS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("kmsArn")
            .getter(getter(CreateConnectorProfileRequest::kmsArn)).setter(setter(Builder::kmsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsArn").build()).build();

    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorType").getter(getter(CreateConnectorProfileRequest::connectorTypeAsString))
            .setter(setter(Builder::connectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()).build();

    private static final SdkField<String> CONNECTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionMode").getter(getter(CreateConnectorProfileRequest::connectionModeAsString))
            .setter(setter(Builder::connectionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionMode").build()).build();

    private static final SdkField<ConnectorProfileConfig> CONNECTOR_PROFILE_CONFIG_FIELD = SdkField
            .<ConnectorProfileConfig> builder(MarshallingType.SDK_POJO).memberName("connectorProfileConfig")
            .getter(getter(CreateConnectorProfileRequest::connectorProfileConfig))
            .setter(setter(Builder::connectorProfileConfig)).constructor(ConnectorProfileConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_PROFILE_NAME_FIELD,
            KMS_ARN_FIELD, CONNECTOR_TYPE_FIELD, CONNECTION_MODE_FIELD, CONNECTOR_PROFILE_CONFIG_FIELD));

    private final String connectorProfileName;

    private final String kmsArn;

    private final String connectorType;

    private final String connectionMode;

    private final ConnectorProfileConfig connectorProfileConfig;

    private CreateConnectorProfileRequest(BuilderImpl builder) {
        super(builder);
        this.connectorProfileName = builder.connectorProfileName;
        this.kmsArn = builder.kmsArn;
        this.connectorType = builder.connectorType;
        this.connectionMode = builder.connectionMode;
        this.connectorProfileConfig = builder.connectorProfileConfig;
    }

    /**
     * <p>
     * The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your Amazon Web
     * Services account.
     * </p>
     * 
     * @return The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your
     *         Amazon Web Services account.
     */
    public final String connectorProfileName() {
        return connectorProfileName;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is
     * required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon
     * AppFlow uses the Amazon AppFlow-managed KMS key.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This
     *         is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything
     *         here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    public final String kmsArn() {
        return kmsArn;
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(connectorType);
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final String connectorTypeAsString() {
        return connectorType;
    }

    /**
     * <p>
     * Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web
     * Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public
     * internet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionMode}
     * will return {@link ConnectionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionModeAsString}.
     * </p>
     * 
     * @return Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web
     *         Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the
     *         public internet.
     * @see ConnectionMode
     */
    public final ConnectionMode connectionMode() {
        return ConnectionMode.fromValue(connectionMode);
    }

    /**
     * <p>
     * Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web
     * Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public
     * internet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionMode}
     * will return {@link ConnectionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionModeAsString}.
     * </p>
     * 
     * @return Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web
     *         Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the
     *         public internet.
     * @see ConnectionMode
     */
    public final String connectionModeAsString() {
        return connectionMode;
    }

    /**
     * <p>
     * Defines the connector-specific configuration and credentials.
     * </p>
     * 
     * @return Defines the connector-specific configuration and credentials.
     */
    public final ConnectorProfileConfig connectorProfileConfig() {
        return connectorProfileConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorProfileRequest)) {
            return false;
        }
        CreateConnectorProfileRequest other = (CreateConnectorProfileRequest) obj;
        return Objects.equals(connectorProfileName(), other.connectorProfileName()) && Objects.equals(kmsArn(), other.kmsArn())
                && Objects.equals(connectorTypeAsString(), other.connectorTypeAsString())
                && Objects.equals(connectionModeAsString(), other.connectionModeAsString())
                && Objects.equals(connectorProfileConfig(), other.connectorProfileConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectorProfileRequest").add("ConnectorProfileName", connectorProfileName())
                .add("KmsArn", kmsArn()).add("ConnectorType", connectorTypeAsString())
                .add("ConnectionMode", connectionModeAsString()).add("ConnectorProfileConfig", connectorProfileConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorProfileName":
            return Optional.ofNullable(clazz.cast(connectorProfileName()));
        case "kmsArn":
            return Optional.ofNullable(clazz.cast(kmsArn()));
        case "connectorType":
            return Optional.ofNullable(clazz.cast(connectorTypeAsString()));
        case "connectionMode":
            return Optional.ofNullable(clazz.cast(connectionModeAsString()));
        case "connectorProfileConfig":
            return Optional.ofNullable(clazz.cast(connectorProfileConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorProfileRequest, T> g) {
        return obj -> g.apply((CreateConnectorProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateConnectorProfileRequest> {
        /**
         * <p>
         * The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your Amazon
         * Web Services account.
         * </p>
         * 
         * @param connectorProfileName
         *        The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your
         *        Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileName(String connectorProfileName);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is
         * required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here,
         * Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
         * </p>
         * 
         * @param kmsArn
         *        The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
         *        This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide
         *        anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsArn(String kmsArn);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(ConnectorType connectorType);

        /**
         * <p>
         * Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web
         * Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public
         * internet.
         * </p>
         * 
         * @param connectionMode
         *        Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon
         *        Web Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to
         *        the public internet.
         * @see ConnectionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionMode
         */
        Builder connectionMode(String connectionMode);

        /**
         * <p>
         * Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web
         * Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public
         * internet.
         * </p>
         * 
         * @param connectionMode
         *        Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon
         *        Web Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to
         *        the public internet.
         * @see ConnectionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionMode
         */
        Builder connectionMode(ConnectionMode connectionMode);

        /**
         * <p>
         * Defines the connector-specific configuration and credentials.
         * </p>
         * 
         * @param connectorProfileConfig
         *        Defines the connector-specific configuration and credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileConfig(ConnectorProfileConfig connectorProfileConfig);

        /**
         * <p>
         * Defines the connector-specific configuration and credentials.
         * </p>
         * This is a convenience that creates an instance of the {@link ConnectorProfileConfig.Builder} avoiding the
         * need to create one manually via {@link ConnectorProfileConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectorProfileConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #connectorProfileConfig(ConnectorProfileConfig)}.
         * 
         * @param connectorProfileConfig
         *        a consumer that will call methods on {@link ConnectorProfileConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorProfileConfig(ConnectorProfileConfig)
         */
        default Builder connectorProfileConfig(Consumer<ConnectorProfileConfig.Builder> connectorProfileConfig) {
            return connectorProfileConfig(ConnectorProfileConfig.builder().applyMutation(connectorProfileConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppflowRequest.BuilderImpl implements Builder {
        private String connectorProfileName;

        private String kmsArn;

        private String connectorType;

        private String connectionMode;

        private ConnectorProfileConfig connectorProfileConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorProfileRequest model) {
            super(model);
            connectorProfileName(model.connectorProfileName);
            kmsArn(model.kmsArn);
            connectorType(model.connectorType);
            connectionMode(model.connectionMode);
            connectorProfileConfig(model.connectorProfileConfig);
        }

        public final String getConnectorProfileName() {
            return connectorProfileName;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        @Transient
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final String getKmsArn() {
            return kmsArn;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        @Override
        @Transient
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final String getConnectorType() {
            return connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        @Transient
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        @Transient
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getConnectionMode() {
            return connectionMode;
        }

        public final void setConnectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
        }

        @Override
        @Transient
        public final Builder connectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
            return this;
        }

        @Override
        @Transient
        public final Builder connectionMode(ConnectionMode connectionMode) {
            this.connectionMode(connectionMode == null ? null : connectionMode.toString());
            return this;
        }

        public final ConnectorProfileConfig.Builder getConnectorProfileConfig() {
            return connectorProfileConfig != null ? connectorProfileConfig.toBuilder() : null;
        }

        public final void setConnectorProfileConfig(ConnectorProfileConfig.BuilderImpl connectorProfileConfig) {
            this.connectorProfileConfig = connectorProfileConfig != null ? connectorProfileConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder connectorProfileConfig(ConnectorProfileConfig connectorProfileConfig) {
            this.connectorProfileConfig = connectorProfileConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectorProfileRequest build() {
            return new CreateConnectorProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
