/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFlowRequest extends AppflowRequest implements
        ToCopyableBuilder<DeleteFlowRequest.Builder, DeleteFlowRequest> {
    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowName").getter(getter(DeleteFlowRequest::flowName)).setter(setter(Builder::flowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowName").build()).build();

    private static final SdkField<Boolean> FORCE_DELETE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("forceDelete").getter(getter(DeleteFlowRequest::forceDelete)).setter(setter(Builder::forceDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceDelete").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_NAME_FIELD,
            FORCE_DELETE_FIELD));

    private final String flowName;

    private final Boolean forceDelete;

    private DeleteFlowRequest(BuilderImpl builder) {
        super(builder);
        this.flowName = builder.flowName;
        this.forceDelete = builder.forceDelete;
    }

    /**
     * <p>
     * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     * </p>
     * 
     * @return The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     */
    public final String flowName() {
        return flowName;
    }

    /**
     * <p>
     * Indicates whether Amazon AppFlow should delete the flow, even if it is currently in use.
     * </p>
     * 
     * @return Indicates whether Amazon AppFlow should delete the flow, even if it is currently in use.
     */
    public final Boolean forceDelete() {
        return forceDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowName());
        hashCode = 31 * hashCode + Objects.hashCode(forceDelete());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFlowRequest)) {
            return false;
        }
        DeleteFlowRequest other = (DeleteFlowRequest) obj;
        return Objects.equals(flowName(), other.flowName()) && Objects.equals(forceDelete(), other.forceDelete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFlowRequest").add("FlowName", flowName()).add("ForceDelete", forceDelete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flowName":
            return Optional.ofNullable(clazz.cast(flowName()));
        case "forceDelete":
            return Optional.ofNullable(clazz.cast(forceDelete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFlowRequest, T> g) {
        return obj -> g.apply((DeleteFlowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFlowRequest> {
        /**
         * <p>
         * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         * </p>
         * 
         * @param flowName
         *        The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowName(String flowName);

        /**
         * <p>
         * Indicates whether Amazon AppFlow should delete the flow, even if it is currently in use.
         * </p>
         * 
         * @param forceDelete
         *        Indicates whether Amazon AppFlow should delete the flow, even if it is currently in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceDelete(Boolean forceDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppflowRequest.BuilderImpl implements Builder {
        private String flowName;

        private Boolean forceDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFlowRequest model) {
            super(model);
            flowName(model.flowName);
            forceDelete(model.forceDelete);
        }

        public final String getFlowName() {
            return flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        @Transient
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final Boolean getForceDelete() {
            return forceDelete;
        }

        public final void setForceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
        }

        @Override
        @Transient
        public final Builder forceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFlowRequest build() {
            return new DeleteFlowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
