/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectorEntityRequest extends AppflowRequest implements
        ToCopyableBuilder<DescribeConnectorEntityRequest.Builder, DescribeConnectorEntityRequest> {
    private static final SdkField<String> CONNECTOR_ENTITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorEntityName").getter(getter(DescribeConnectorEntityRequest::connectorEntityName))
            .setter(setter(Builder::connectorEntityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorEntityName").build())
            .build();

    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorType").getter(getter(DescribeConnectorEntityRequest::connectorTypeAsString))
            .setter(setter(Builder::connectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()).build();

    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorProfileName").getter(getter(DescribeConnectorEntityRequest::connectorProfileName))
            .setter(setter(Builder::connectorProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ENTITY_NAME_FIELD,
            CONNECTOR_TYPE_FIELD, CONNECTOR_PROFILE_NAME_FIELD));

    private final String connectorEntityName;

    private final String connectorType;

    private final String connectorProfileName;

    private DescribeConnectorEntityRequest(BuilderImpl builder) {
        super(builder);
        this.connectorEntityName = builder.connectorEntityName;
        this.connectorType = builder.connectorType;
        this.connectorProfileName = builder.connectorProfileName;
    }

    /**
     * <p>
     * The entity name for that connector.
     * </p>
     * 
     * @return The entity name for that connector.
     */
    public final String connectorEntityName() {
        return connectorEntityName;
    }

    /**
     * <p>
     * The type of connector application, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector application, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(connectorType);
    }

    /**
     * <p>
     * The type of connector application, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector application, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final String connectorTypeAsString() {
        return connectorType;
    }

    /**
     * <p>
     * The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web
     * Services account.
     * </p>
     * 
     * @return The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the
     *         Amazon Web Services account.
     */
    public final String connectorProfileName() {
        return connectorProfileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorEntityName());
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorEntityRequest)) {
            return false;
        }
        DescribeConnectorEntityRequest other = (DescribeConnectorEntityRequest) obj;
        return Objects.equals(connectorEntityName(), other.connectorEntityName())
                && Objects.equals(connectorTypeAsString(), other.connectorTypeAsString())
                && Objects.equals(connectorProfileName(), other.connectorProfileName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConnectorEntityRequest").add("ConnectorEntityName", connectorEntityName())
                .add("ConnectorType", connectorTypeAsString()).add("ConnectorProfileName", connectorProfileName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorEntityName":
            return Optional.ofNullable(clazz.cast(connectorEntityName()));
        case "connectorType":
            return Optional.ofNullable(clazz.cast(connectorTypeAsString()));
        case "connectorProfileName":
            return Optional.ofNullable(clazz.cast(connectorProfileName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorEntityRequest, T> g) {
        return obj -> g.apply((DescribeConnectorEntityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConnectorEntityRequest> {
        /**
         * <p>
         * The entity name for that connector.
         * </p>
         * 
         * @param connectorEntityName
         *        The entity name for that connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorEntityName(String connectorEntityName);

        /**
         * <p>
         * The type of connector application, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector application, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The type of connector application, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector application, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(ConnectorType connectorType);

        /**
         * <p>
         * The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon
         * Web Services account.
         * </p>
         * 
         * @param connectorProfileName
         *        The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the
         *        Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileName(String connectorProfileName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppflowRequest.BuilderImpl implements Builder {
        private String connectorEntityName;

        private String connectorType;

        private String connectorProfileName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorEntityRequest model) {
            super(model);
            connectorEntityName(model.connectorEntityName);
            connectorType(model.connectorType);
            connectorProfileName(model.connectorProfileName);
        }

        public final String getConnectorEntityName() {
            return connectorEntityName;
        }

        public final void setConnectorEntityName(String connectorEntityName) {
            this.connectorEntityName = connectorEntityName;
        }

        @Override
        @Transient
        public final Builder connectorEntityName(String connectorEntityName) {
            this.connectorEntityName = connectorEntityName;
            return this;
        }

        public final String getConnectorType() {
            return connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        @Transient
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        @Transient
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getConnectorProfileName() {
            return connectorProfileName;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        @Transient
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConnectorEntityRequest build() {
            return new DescribeConnectorEntityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
