/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFlowExecutionRecordsResponse extends AppflowResponse implements
        ToCopyableBuilder<DescribeFlowExecutionRecordsResponse.Builder, DescribeFlowExecutionRecordsResponse> {
    private static final SdkField<List<ExecutionRecord>> FLOW_EXECUTIONS_FIELD = SdkField
            .<List<ExecutionRecord>> builder(MarshallingType.LIST)
            .memberName("flowExecutions")
            .getter(getter(DescribeFlowExecutionRecordsResponse::flowExecutions))
            .setter(setter(Builder::flowExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExecutionRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExecutionRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeFlowExecutionRecordsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_EXECUTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ExecutionRecord> flowExecutions;

    private final String nextToken;

    private DescribeFlowExecutionRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.flowExecutions = builder.flowExecutions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FlowExecutions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFlowExecutions() {
        return flowExecutions != null && !(flowExecutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of all instances when this flow was run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFlowExecutions} method.
     * </p>
     * 
     * @return Returns a list of all instances when this flow was run.
     */
    public final List<ExecutionRecord> flowExecutions() {
        return flowExecutions;
    }

    /**
     * <p>
     * The pagination token for the next page of data.
     * </p>
     * 
     * @return The pagination token for the next page of data.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFlowExecutions() ? flowExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowExecutionRecordsResponse)) {
            return false;
        }
        DescribeFlowExecutionRecordsResponse other = (DescribeFlowExecutionRecordsResponse) obj;
        return hasFlowExecutions() == other.hasFlowExecutions() && Objects.equals(flowExecutions(), other.flowExecutions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFlowExecutionRecordsResponse")
                .add("FlowExecutions", hasFlowExecutions() ? flowExecutions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flowExecutions":
            return Optional.ofNullable(clazz.cast(flowExecutions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlowExecutionRecordsResponse, T> g) {
        return obj -> g.apply((DescribeFlowExecutionRecordsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFlowExecutionRecordsResponse> {
        /**
         * <p>
         * Returns a list of all instances when this flow was run.
         * </p>
         * 
         * @param flowExecutions
         *        Returns a list of all instances when this flow was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowExecutions(Collection<ExecutionRecord> flowExecutions);

        /**
         * <p>
         * Returns a list of all instances when this flow was run.
         * </p>
         * 
         * @param flowExecutions
         *        Returns a list of all instances when this flow was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowExecutions(ExecutionRecord... flowExecutions);

        /**
         * <p>
         * Returns a list of all instances when this flow was run.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExecutionRecord>.Builder} avoiding the need
         * to create one manually via {@link List<ExecutionRecord>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExecutionRecord>.Builder#build()} is called immediately and
         * its result is passed to {@link #flowExecutions(List<ExecutionRecord>)}.
         * 
         * @param flowExecutions
         *        a consumer that will call methods on {@link List<ExecutionRecord>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowExecutions(List<ExecutionRecord>)
         */
        Builder flowExecutions(Consumer<ExecutionRecord.Builder>... flowExecutions);

        /**
         * <p>
         * The pagination token for the next page of data.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the next page of data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppflowResponse.BuilderImpl implements Builder {
        private List<ExecutionRecord> flowExecutions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowExecutionRecordsResponse model) {
            super(model);
            flowExecutions(model.flowExecutions);
            nextToken(model.nextToken);
        }

        public final List<ExecutionRecord.Builder> getFlowExecutions() {
            List<ExecutionRecord.Builder> result = FlowExecutionListCopier.copyToBuilder(this.flowExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlowExecutions(Collection<ExecutionRecord.BuilderImpl> flowExecutions) {
            this.flowExecutions = FlowExecutionListCopier.copyFromBuilder(flowExecutions);
        }

        @Override
        @Transient
        public final Builder flowExecutions(Collection<ExecutionRecord> flowExecutions) {
            this.flowExecutions = FlowExecutionListCopier.copy(flowExecutions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder flowExecutions(ExecutionRecord... flowExecutions) {
            flowExecutions(Arrays.asList(flowExecutions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder flowExecutions(Consumer<ExecutionRecord.Builder>... flowExecutions) {
            flowExecutions(Stream.of(flowExecutions).map(c -> ExecutionRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFlowExecutionRecordsResponse build() {
            return new DescribeFlowExecutionRecordsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
