/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties that can be applied to a field when connector is being used as a destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationFieldProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationFieldProperties.Builder, DestinationFieldProperties> {
    private static final SdkField<Boolean> IS_CREATABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isCreatable").getter(getter(DestinationFieldProperties::isCreatable))
            .setter(setter(Builder::isCreatable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isCreatable").build()).build();

    private static final SdkField<Boolean> IS_NULLABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isNullable").getter(getter(DestinationFieldProperties::isNullable)).setter(setter(Builder::isNullable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isNullable").build()).build();

    private static final SdkField<Boolean> IS_UPSERTABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isUpsertable").getter(getter(DestinationFieldProperties::isUpsertable))
            .setter(setter(Builder::isUpsertable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isUpsertable").build()).build();

    private static final SdkField<Boolean> IS_UPDATABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isUpdatable").getter(getter(DestinationFieldProperties::isUpdatable))
            .setter(setter(Builder::isUpdatable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isUpdatable").build()).build();

    private static final SdkField<List<String>> SUPPORTED_WRITE_OPERATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedWriteOperations")
            .getter(getter(DestinationFieldProperties::supportedWriteOperationsAsStrings))
            .setter(setter(Builder::supportedWriteOperationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedWriteOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_CREATABLE_FIELD,
            IS_NULLABLE_FIELD, IS_UPSERTABLE_FIELD, IS_UPDATABLE_FIELD, SUPPORTED_WRITE_OPERATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isCreatable;

    private final Boolean isNullable;

    private final Boolean isUpsertable;

    private final Boolean isUpdatable;

    private final List<String> supportedWriteOperations;

    private DestinationFieldProperties(BuilderImpl builder) {
        this.isCreatable = builder.isCreatable;
        this.isNullable = builder.isNullable;
        this.isUpsertable = builder.isUpsertable;
        this.isUpdatable = builder.isUpdatable;
        this.supportedWriteOperations = builder.supportedWriteOperations;
    }

    /**
     * <p>
     * Specifies if the destination field can be created by the current user.
     * </p>
     * 
     * @return Specifies if the destination field can be created by the current user.
     */
    public final Boolean isCreatable() {
        return isCreatable;
    }

    /**
     * <p>
     * Specifies if the destination field can have a null value.
     * </p>
     * 
     * @return Specifies if the destination field can have a null value.
     */
    public final Boolean isNullable() {
        return isNullable;
    }

    /**
     * <p>
     * Specifies if the flow run can either insert new rows in the destination field if they do not already exist, or
     * update them if they do.
     * </p>
     * 
     * @return Specifies if the flow run can either insert new rows in the destination field if they do not already
     *         exist, or update them if they do.
     */
    public final Boolean isUpsertable() {
        return isUpsertable;
    }

    /**
     * <p>
     * Specifies whether the field can be updated during an <code>UPDATE</code> or <code>UPSERT</code> write operation.
     * </p>
     * 
     * @return Specifies whether the field can be updated during an <code>UPDATE</code> or <code>UPSERT</code> write
     *         operation.
     */
    public final Boolean isUpdatable() {
        return isUpdatable;
    }

    /**
     * <p>
     * A list of supported write operations. For each write operation listed, this field can be used in
     * <code>idFieldNames</code> when that write operation is present as a destination option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedWriteOperations} method.
     * </p>
     * 
     * @return A list of supported write operations. For each write operation listed, this field can be used in
     *         <code>idFieldNames</code> when that write operation is present as a destination option.
     */
    public final List<WriteOperationType> supportedWriteOperations() {
        return SupportedWriteOperationListCopier.copyStringToEnum(supportedWriteOperations);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedWriteOperations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedWriteOperations() {
        return supportedWriteOperations != null && !(supportedWriteOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of supported write operations. For each write operation listed, this field can be used in
     * <code>idFieldNames</code> when that write operation is present as a destination option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedWriteOperations} method.
     * </p>
     * 
     * @return A list of supported write operations. For each write operation listed, this field can be used in
     *         <code>idFieldNames</code> when that write operation is present as a destination option.
     */
    public final List<String> supportedWriteOperationsAsStrings() {
        return supportedWriteOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isCreatable());
        hashCode = 31 * hashCode + Objects.hashCode(isNullable());
        hashCode = 31 * hashCode + Objects.hashCode(isUpsertable());
        hashCode = 31 * hashCode + Objects.hashCode(isUpdatable());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedWriteOperations() ? supportedWriteOperationsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationFieldProperties)) {
            return false;
        }
        DestinationFieldProperties other = (DestinationFieldProperties) obj;
        return Objects.equals(isCreatable(), other.isCreatable()) && Objects.equals(isNullable(), other.isNullable())
                && Objects.equals(isUpsertable(), other.isUpsertable()) && Objects.equals(isUpdatable(), other.isUpdatable())
                && hasSupportedWriteOperations() == other.hasSupportedWriteOperations()
                && Objects.equals(supportedWriteOperationsAsStrings(), other.supportedWriteOperationsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationFieldProperties").add("IsCreatable", isCreatable()).add("IsNullable", isNullable())
                .add("IsUpsertable", isUpsertable()).add("IsUpdatable", isUpdatable())
                .add("SupportedWriteOperations", hasSupportedWriteOperations() ? supportedWriteOperationsAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isCreatable":
            return Optional.ofNullable(clazz.cast(isCreatable()));
        case "isNullable":
            return Optional.ofNullable(clazz.cast(isNullable()));
        case "isUpsertable":
            return Optional.ofNullable(clazz.cast(isUpsertable()));
        case "isUpdatable":
            return Optional.ofNullable(clazz.cast(isUpdatable()));
        case "supportedWriteOperations":
            return Optional.ofNullable(clazz.cast(supportedWriteOperationsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationFieldProperties, T> g) {
        return obj -> g.apply((DestinationFieldProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationFieldProperties> {
        /**
         * <p>
         * Specifies if the destination field can be created by the current user.
         * </p>
         * 
         * @param isCreatable
         *        Specifies if the destination field can be created by the current user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isCreatable(Boolean isCreatable);

        /**
         * <p>
         * Specifies if the destination field can have a null value.
         * </p>
         * 
         * @param isNullable
         *        Specifies if the destination field can have a null value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNullable(Boolean isNullable);

        /**
         * <p>
         * Specifies if the flow run can either insert new rows in the destination field if they do not already exist,
         * or update them if they do.
         * </p>
         * 
         * @param isUpsertable
         *        Specifies if the flow run can either insert new rows in the destination field if they do not already
         *        exist, or update them if they do.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isUpsertable(Boolean isUpsertable);

        /**
         * <p>
         * Specifies whether the field can be updated during an <code>UPDATE</code> or <code>UPSERT</code> write
         * operation.
         * </p>
         * 
         * @param isUpdatable
         *        Specifies whether the field can be updated during an <code>UPDATE</code> or <code>UPSERT</code> write
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isUpdatable(Boolean isUpdatable);

        /**
         * <p>
         * A list of supported write operations. For each write operation listed, this field can be used in
         * <code>idFieldNames</code> when that write operation is present as a destination option.
         * </p>
         * 
         * @param supportedWriteOperations
         *        A list of supported write operations. For each write operation listed, this field can be used in
         *        <code>idFieldNames</code> when that write operation is present as a destination option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedWriteOperationsWithStrings(Collection<String> supportedWriteOperations);

        /**
         * <p>
         * A list of supported write operations. For each write operation listed, this field can be used in
         * <code>idFieldNames</code> when that write operation is present as a destination option.
         * </p>
         * 
         * @param supportedWriteOperations
         *        A list of supported write operations. For each write operation listed, this field can be used in
         *        <code>idFieldNames</code> when that write operation is present as a destination option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedWriteOperationsWithStrings(String... supportedWriteOperations);

        /**
         * <p>
         * A list of supported write operations. For each write operation listed, this field can be used in
         * <code>idFieldNames</code> when that write operation is present as a destination option.
         * </p>
         * 
         * @param supportedWriteOperations
         *        A list of supported write operations. For each write operation listed, this field can be used in
         *        <code>idFieldNames</code> when that write operation is present as a destination option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedWriteOperations(Collection<WriteOperationType> supportedWriteOperations);

        /**
         * <p>
         * A list of supported write operations. For each write operation listed, this field can be used in
         * <code>idFieldNames</code> when that write operation is present as a destination option.
         * </p>
         * 
         * @param supportedWriteOperations
         *        A list of supported write operations. For each write operation listed, this field can be used in
         *        <code>idFieldNames</code> when that write operation is present as a destination option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedWriteOperations(WriteOperationType... supportedWriteOperations);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isCreatable;

        private Boolean isNullable;

        private Boolean isUpsertable;

        private Boolean isUpdatable;

        private List<String> supportedWriteOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationFieldProperties model) {
            isCreatable(model.isCreatable);
            isNullable(model.isNullable);
            isUpsertable(model.isUpsertable);
            isUpdatable(model.isUpdatable);
            supportedWriteOperationsWithStrings(model.supportedWriteOperations);
        }

        public final Boolean getIsCreatable() {
            return isCreatable;
        }

        public final void setIsCreatable(Boolean isCreatable) {
            this.isCreatable = isCreatable;
        }

        @Override
        @Transient
        public final Builder isCreatable(Boolean isCreatable) {
            this.isCreatable = isCreatable;
            return this;
        }

        public final Boolean getIsNullable() {
            return isNullable;
        }

        public final void setIsNullable(Boolean isNullable) {
            this.isNullable = isNullable;
        }

        @Override
        @Transient
        public final Builder isNullable(Boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public final Boolean getIsUpsertable() {
            return isUpsertable;
        }

        public final void setIsUpsertable(Boolean isUpsertable) {
            this.isUpsertable = isUpsertable;
        }

        @Override
        @Transient
        public final Builder isUpsertable(Boolean isUpsertable) {
            this.isUpsertable = isUpsertable;
            return this;
        }

        public final Boolean getIsUpdatable() {
            return isUpdatable;
        }

        public final void setIsUpdatable(Boolean isUpdatable) {
            this.isUpdatable = isUpdatable;
        }

        @Override
        @Transient
        public final Builder isUpdatable(Boolean isUpdatable) {
            this.isUpdatable = isUpdatable;
            return this;
        }

        public final Collection<String> getSupportedWriteOperations() {
            if (supportedWriteOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedWriteOperations;
        }

        public final void setSupportedWriteOperations(Collection<String> supportedWriteOperations) {
            this.supportedWriteOperations = SupportedWriteOperationListCopier.copy(supportedWriteOperations);
        }

        @Override
        @Transient
        public final Builder supportedWriteOperationsWithStrings(Collection<String> supportedWriteOperations) {
            this.supportedWriteOperations = SupportedWriteOperationListCopier.copy(supportedWriteOperations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedWriteOperationsWithStrings(String... supportedWriteOperations) {
            supportedWriteOperationsWithStrings(Arrays.asList(supportedWriteOperations));
            return this;
        }

        @Override
        @Transient
        public final Builder supportedWriteOperations(Collection<WriteOperationType> supportedWriteOperations) {
            this.supportedWriteOperations = SupportedWriteOperationListCopier.copyEnumToString(supportedWriteOperations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedWriteOperations(WriteOperationType... supportedWriteOperations) {
            supportedWriteOperations(Arrays.asList(supportedWriteOperations));
            return this;
        }

        @Override
        public DestinationFieldProperties build() {
            return new DestinationFieldProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
