/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific profile credentials required by Dynatrace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DynatraceConnectorProfileCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<DynatraceConnectorProfileCredentials.Builder, DynatraceConnectorProfileCredentials> {
    private static final SdkField<String> API_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiToken").getter(getter(DynatraceConnectorProfileCredentials::apiToken))
            .setter(setter(Builder::apiToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String apiToken;

    private DynatraceConnectorProfileCredentials(BuilderImpl builder) {
        this.apiToken = builder.apiToken;
    }

    /**
     * <p>
     * The API tokens used by Dynatrace API to authenticate various API calls.
     * </p>
     * 
     * @return The API tokens used by Dynatrace API to authenticate various API calls.
     */
    public final String apiToken() {
        return apiToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynatraceConnectorProfileCredentials)) {
            return false;
        }
        DynatraceConnectorProfileCredentials other = (DynatraceConnectorProfileCredentials) obj;
        return Objects.equals(apiToken(), other.apiToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DynatraceConnectorProfileCredentials").add("ApiToken", apiToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiToken":
            return Optional.ofNullable(clazz.cast(apiToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DynatraceConnectorProfileCredentials, T> g) {
        return obj -> g.apply((DynatraceConnectorProfileCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DynatraceConnectorProfileCredentials> {
        /**
         * <p>
         * The API tokens used by Dynatrace API to authenticate various API calls.
         * </p>
         * 
         * @param apiToken
         *        The API tokens used by Dynatrace API to authenticate various API calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiToken(String apiToken);
    }

    static final class BuilderImpl implements Builder {
        private String apiToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DynatraceConnectorProfileCredentials model) {
            apiToken(model.apiToken);
        }

        public final String getApiToken() {
            return apiToken;
        }

        public final void setApiToken(String apiToken) {
            this.apiToken = apiToken;
        }

        @Override
        @Transient
        public final Builder apiToken(String apiToken) {
            this.apiToken = apiToken;
            return this;
        }

        @Override
        public DynatraceConnectorProfileCredentials build() {
            return new DynatraceConnectorProfileCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
