/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConnectorEntitiesResponse extends AppflowResponse implements
        ToCopyableBuilder<ListConnectorEntitiesResponse.Builder, ListConnectorEntitiesResponse> {
    private static final SdkField<Map<String, List<ConnectorEntity>>> CONNECTOR_ENTITY_MAP_FIELD = SdkField
            .<Map<String, List<ConnectorEntity>>> builder(MarshallingType.MAP)
            .memberName("connectorEntityMap")
            .getter(getter(ListConnectorEntitiesResponse::connectorEntityMap))
            .setter(setter(Builder::connectorEntityMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorEntityMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<ConnectorEntity>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<ConnectorEntity> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(ConnectorEntity::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ENTITY_MAP_FIELD));

    private final Map<String, List<ConnectorEntity>> connectorEntityMap;

    private ListConnectorEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.connectorEntityMap = builder.connectorEntityMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectorEntityMap property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectorEntityMap() {
        return connectorEntityMap != null && !(connectorEntityMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The response of <code>ListConnectorEntities</code> lists entities grouped by category. This map's key represents
     * the group name, and its value contains the list of entities belonging to that group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectorEntityMap} method.
     * </p>
     * 
     * @return The response of <code>ListConnectorEntities</code> lists entities grouped by category. This map's key
     *         represents the group name, and its value contains the list of entities belonging to that group.
     */
    public final Map<String, List<ConnectorEntity>> connectorEntityMap() {
        return connectorEntityMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorEntityMap() ? connectorEntityMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectorEntitiesResponse)) {
            return false;
        }
        ListConnectorEntitiesResponse other = (ListConnectorEntitiesResponse) obj;
        return hasConnectorEntityMap() == other.hasConnectorEntityMap()
                && Objects.equals(connectorEntityMap(), other.connectorEntityMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConnectorEntitiesResponse")
                .add("ConnectorEntityMap", hasConnectorEntityMap() ? connectorEntityMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorEntityMap":
            return Optional.ofNullable(clazz.cast(connectorEntityMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConnectorEntitiesResponse, T> g) {
        return obj -> g.apply((ListConnectorEntitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListConnectorEntitiesResponse> {
        /**
         * <p>
         * The response of <code>ListConnectorEntities</code> lists entities grouped by category. This map's key
         * represents the group name, and its value contains the list of entities belonging to that group.
         * </p>
         * 
         * @param connectorEntityMap
         *        The response of <code>ListConnectorEntities</code> lists entities grouped by category. This map's key
         *        represents the group name, and its value contains the list of entities belonging to that group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorEntityMap(Map<String, ? extends Collection<ConnectorEntity>> connectorEntityMap);
    }

    static final class BuilderImpl extends AppflowResponse.BuilderImpl implements Builder {
        private Map<String, List<ConnectorEntity>> connectorEntityMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectorEntitiesResponse model) {
            super(model);
            connectorEntityMap(model.connectorEntityMap);
        }

        public final Map<String, List<ConnectorEntity.Builder>> getConnectorEntityMap() {
            Map<String, List<ConnectorEntity.Builder>> result = ConnectorEntityMapCopier.copyToBuilder(this.connectorEntityMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConnectorEntityMap(Map<String, ? extends Collection<ConnectorEntity.BuilderImpl>> connectorEntityMap) {
            this.connectorEntityMap = ConnectorEntityMapCopier.copyFromBuilder(connectorEntityMap);
        }

        @Override
        @Transient
        public final Builder connectorEntityMap(Map<String, ? extends Collection<ConnectorEntity>> connectorEntityMap) {
            this.connectorEntityMap = ConnectorEntityMapCopier.copy(connectorEntityMap);
            return this;
        }

        @Override
        public ListConnectorEntitiesResponse build() {
            return new ListConnectorEntitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
