/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When you use Amazon S3 as the source, the configuration format that you provide the flow input data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3InputFormatConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<S3InputFormatConfig.Builder, S3InputFormatConfig> {
    private static final SdkField<String> S3_INPUT_FILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3InputFileType").getter(getter(S3InputFormatConfig::s3InputFileTypeAsString))
            .setter(setter(Builder::s3InputFileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3InputFileType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_INPUT_FILE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3InputFileType;

    private S3InputFormatConfig(BuilderImpl builder) {
        this.s3InputFileType = builder.s3InputFileType;
    }

    /**
     * <p>
     * The file type that Amazon AppFlow gets from your Amazon S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3InputFileType}
     * will return {@link S3InputFileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3InputFileTypeAsString}.
     * </p>
     * 
     * @return The file type that Amazon AppFlow gets from your Amazon S3 bucket.
     * @see S3InputFileType
     */
    public final S3InputFileType s3InputFileType() {
        return S3InputFileType.fromValue(s3InputFileType);
    }

    /**
     * <p>
     * The file type that Amazon AppFlow gets from your Amazon S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3InputFileType}
     * will return {@link S3InputFileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3InputFileTypeAsString}.
     * </p>
     * 
     * @return The file type that Amazon AppFlow gets from your Amazon S3 bucket.
     * @see S3InputFileType
     */
    public final String s3InputFileTypeAsString() {
        return s3InputFileType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3InputFileTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3InputFormatConfig)) {
            return false;
        }
        S3InputFormatConfig other = (S3InputFormatConfig) obj;
        return Objects.equals(s3InputFileTypeAsString(), other.s3InputFileTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3InputFormatConfig").add("S3InputFileType", s3InputFileTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3InputFileType":
            return Optional.ofNullable(clazz.cast(s3InputFileTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3InputFormatConfig, T> g) {
        return obj -> g.apply((S3InputFormatConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3InputFormatConfig> {
        /**
         * <p>
         * The file type that Amazon AppFlow gets from your Amazon S3 bucket.
         * </p>
         * 
         * @param s3InputFileType
         *        The file type that Amazon AppFlow gets from your Amazon S3 bucket.
         * @see S3InputFileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3InputFileType
         */
        Builder s3InputFileType(String s3InputFileType);

        /**
         * <p>
         * The file type that Amazon AppFlow gets from your Amazon S3 bucket.
         * </p>
         * 
         * @param s3InputFileType
         *        The file type that Amazon AppFlow gets from your Amazon S3 bucket.
         * @see S3InputFileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3InputFileType
         */
        Builder s3InputFileType(S3InputFileType s3InputFileType);
    }

    static final class BuilderImpl implements Builder {
        private String s3InputFileType;

        private BuilderImpl() {
        }

        private BuilderImpl(S3InputFormatConfig model) {
            s3InputFileType(model.s3InputFileType);
        }

        public final String getS3InputFileType() {
            return s3InputFileType;
        }

        public final void setS3InputFileType(String s3InputFileType) {
            this.s3InputFileType = s3InputFileType;
        }

        @Override
        @Transient
        public final Builder s3InputFileType(String s3InputFileType) {
            this.s3InputFileType = s3InputFileType;
            return this;
        }

        @Override
        @Transient
        public final Builder s3InputFileType(S3InputFileType s3InputFileType) {
            this.s3InputFileType(s3InputFileType == null ? null : s3InputFileType.toString());
            return this;
        }

        @Override
        public S3InputFormatConfig build() {
            return new S3InputFormatConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
