/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties that are applied when Snowflake is being used as a destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnowflakeDestinationProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<SnowflakeDestinationProperties.Builder, SnowflakeDestinationProperties> {
    private static final SdkField<String> OBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("object")
            .getter(getter(SnowflakeDestinationProperties::object)).setter(setter(Builder::object))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("object").build()).build();

    private static final SdkField<String> INTERMEDIATE_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intermediateBucketName").getter(getter(SnowflakeDestinationProperties::intermediateBucketName))
            .setter(setter(Builder::intermediateBucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intermediateBucketName").build())
            .build();

    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketPrefix").getter(getter(SnowflakeDestinationProperties::bucketPrefix))
            .setter(setter(Builder::bucketPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPrefix").build()).build();

    private static final SdkField<ErrorHandlingConfig> ERROR_HANDLING_CONFIG_FIELD = SdkField
            .<ErrorHandlingConfig> builder(MarshallingType.SDK_POJO).memberName("errorHandlingConfig")
            .getter(getter(SnowflakeDestinationProperties::errorHandlingConfig)).setter(setter(Builder::errorHandlingConfig))
            .constructor(ErrorHandlingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorHandlingConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_FIELD,
            INTERMEDIATE_BUCKET_NAME_FIELD, BUCKET_PREFIX_FIELD, ERROR_HANDLING_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String object;

    private final String intermediateBucketName;

    private final String bucketPrefix;

    private final ErrorHandlingConfig errorHandlingConfig;

    private SnowflakeDestinationProperties(BuilderImpl builder) {
        this.object = builder.object;
        this.intermediateBucketName = builder.intermediateBucketName;
        this.bucketPrefix = builder.bucketPrefix;
        this.errorHandlingConfig = builder.errorHandlingConfig;
    }

    /**
     * <p>
     * The object specified in the Snowflake flow destination.
     * </p>
     * 
     * @return The object specified in the Snowflake flow destination.
     */
    public final String object() {
        return object;
    }

    /**
     * <p>
     * The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake.
     * </p>
     * 
     * @return The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake.
     */
    public final String intermediateBucketName() {
        return intermediateBucketName;
    }

    /**
     * <p>
     * The object key for the destination bucket in which Amazon AppFlow places the files.
     * </p>
     * 
     * @return The object key for the destination bucket in which Amazon AppFlow places the files.
     */
    public final String bucketPrefix() {
        return bucketPrefix;
    }

    /**
     * <p>
     * The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake destination.
     * For example, this setting would determine if the flow should fail after one insertion error, or continue and
     * attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of
     * the destination connector details.
     * </p>
     * 
     * @return The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake
     *         destination. For example, this setting would determine if the flow should fail after one insertion error,
     *         or continue and attempt to insert every record regardless of the initial failure.
     *         <code>ErrorHandlingConfig</code> is a part of the destination connector details.
     */
    public final ErrorHandlingConfig errorHandlingConfig() {
        return errorHandlingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(object());
        hashCode = 31 * hashCode + Objects.hashCode(intermediateBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(errorHandlingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeDestinationProperties)) {
            return false;
        }
        SnowflakeDestinationProperties other = (SnowflakeDestinationProperties) obj;
        return Objects.equals(object(), other.object())
                && Objects.equals(intermediateBucketName(), other.intermediateBucketName())
                && Objects.equals(bucketPrefix(), other.bucketPrefix())
                && Objects.equals(errorHandlingConfig(), other.errorHandlingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnowflakeDestinationProperties").add("Object", object())
                .add("IntermediateBucketName", intermediateBucketName()).add("BucketPrefix", bucketPrefix())
                .add("ErrorHandlingConfig", errorHandlingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "object":
            return Optional.ofNullable(clazz.cast(object()));
        case "intermediateBucketName":
            return Optional.ofNullable(clazz.cast(intermediateBucketName()));
        case "bucketPrefix":
            return Optional.ofNullable(clazz.cast(bucketPrefix()));
        case "errorHandlingConfig":
            return Optional.ofNullable(clazz.cast(errorHandlingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeDestinationProperties, T> g) {
        return obj -> g.apply((SnowflakeDestinationProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnowflakeDestinationProperties> {
        /**
         * <p>
         * The object specified in the Snowflake flow destination.
         * </p>
         * 
         * @param object
         *        The object specified in the Snowflake flow destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder object(String object);

        /**
         * <p>
         * The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake.
         * </p>
         * 
         * @param intermediateBucketName
         *        The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intermediateBucketName(String intermediateBucketName);

        /**
         * <p>
         * The object key for the destination bucket in which Amazon AppFlow places the files.
         * </p>
         * 
         * @param bucketPrefix
         *        The object key for the destination bucket in which Amazon AppFlow places the files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketPrefix(String bucketPrefix);

        /**
         * <p>
         * The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake
         * destination. For example, this setting would determine if the flow should fail after one insertion error, or
         * continue and attempt to insert every record regardless of the initial failure.
         * <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         * </p>
         * 
         * @param errorHandlingConfig
         *        The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake
         *        destination. For example, this setting would determine if the flow should fail after one insertion
         *        error, or continue and attempt to insert every record regardless of the initial failure.
         *        <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorHandlingConfig(ErrorHandlingConfig errorHandlingConfig);

        /**
         * <p>
         * The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake
         * destination. For example, this setting would determine if the flow should fail after one insertion error, or
         * continue and attempt to insert every record regardless of the initial failure.
         * <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         * </p>
         * This is a convenience that creates an instance of the {@link ErrorHandlingConfig.Builder} avoiding the need
         * to create one manually via {@link ErrorHandlingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorHandlingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #errorHandlingConfig(ErrorHandlingConfig)}.
         * 
         * @param errorHandlingConfig
         *        a consumer that will call methods on {@link ErrorHandlingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorHandlingConfig(ErrorHandlingConfig)
         */
        default Builder errorHandlingConfig(Consumer<ErrorHandlingConfig.Builder> errorHandlingConfig) {
            return errorHandlingConfig(ErrorHandlingConfig.builder().applyMutation(errorHandlingConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String object;

        private String intermediateBucketName;

        private String bucketPrefix;

        private ErrorHandlingConfig errorHandlingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeDestinationProperties model) {
            object(model.object);
            intermediateBucketName(model.intermediateBucketName);
            bucketPrefix(model.bucketPrefix);
            errorHandlingConfig(model.errorHandlingConfig);
        }

        public final String getObject() {
            return object;
        }

        public final void setObject(String object) {
            this.object = object;
        }

        @Override
        @Transient
        public final Builder object(String object) {
            this.object = object;
            return this;
        }

        public final String getIntermediateBucketName() {
            return intermediateBucketName;
        }

        public final void setIntermediateBucketName(String intermediateBucketName) {
            this.intermediateBucketName = intermediateBucketName;
        }

        @Override
        @Transient
        public final Builder intermediateBucketName(String intermediateBucketName) {
            this.intermediateBucketName = intermediateBucketName;
            return this;
        }

        public final String getBucketPrefix() {
            return bucketPrefix;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        @Transient
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final ErrorHandlingConfig.Builder getErrorHandlingConfig() {
            return errorHandlingConfig != null ? errorHandlingConfig.toBuilder() : null;
        }

        public final void setErrorHandlingConfig(ErrorHandlingConfig.BuilderImpl errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig != null ? errorHandlingConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder errorHandlingConfig(ErrorHandlingConfig errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig;
            return this;
        }

        @Override
        public SnowflakeDestinationProperties build() {
            return new SnowflakeDestinationProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
