/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies information about the past flow run instances for a given flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionRecord implements SdkPojo, Serializable, ToCopyableBuilder<ExecutionRecord.Builder, ExecutionRecord> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(ExecutionRecord::executionId)).setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionStatus").getter(getter(ExecutionRecord::executionStatusAsString))
            .setter(setter(Builder::executionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatus").build()).build();

    private static final SdkField<ExecutionResult> EXECUTION_RESULT_FIELD = SdkField
            .<ExecutionResult> builder(MarshallingType.SDK_POJO).memberName("executionResult")
            .getter(getter(ExecutionRecord::executionResult)).setter(setter(Builder::executionResult))
            .constructor(ExecutionResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionResult").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt").getter(getter(ExecutionRecord::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(ExecutionRecord::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<Instant> DATA_PULL_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("dataPullStartTime").getter(getter(ExecutionRecord::dataPullStartTime))
            .setter(setter(Builder::dataPullStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPullStartTime").build()).build();

    private static final SdkField<Instant> DATA_PULL_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("dataPullEndTime").getter(getter(ExecutionRecord::dataPullEndTime))
            .setter(setter(Builder::dataPullEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPullEndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD,
            EXECUTION_STATUS_FIELD, EXECUTION_RESULT_FIELD, STARTED_AT_FIELD, LAST_UPDATED_AT_FIELD, DATA_PULL_START_TIME_FIELD,
            DATA_PULL_END_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String executionId;

    private final String executionStatus;

    private final ExecutionResult executionResult;

    private final Instant startedAt;

    private final Instant lastUpdatedAt;

    private final Instant dataPullStartTime;

    private final Instant dataPullEndTime;

    private ExecutionRecord(BuilderImpl builder) {
        this.executionId = builder.executionId;
        this.executionStatus = builder.executionStatus;
        this.executionResult = builder.executionResult;
        this.startedAt = builder.startedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.dataPullStartTime = builder.dataPullStartTime;
        this.dataPullEndTime = builder.dataPullEndTime;
    }

    /**
     * <p>
     * Specifies the identifier of the given flow run.
     * </p>
     * 
     * @return Specifies the identifier of the given flow run.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * Specifies the flow run status and whether it is in progress, has completed successfully, or has failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionStatus}
     * will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionStatusAsString}.
     * </p>
     * 
     * @return Specifies the flow run status and whether it is in progress, has completed successfully, or has failed.
     * @see ExecutionStatus
     */
    public final ExecutionStatus executionStatus() {
        return ExecutionStatus.fromValue(executionStatus);
    }

    /**
     * <p>
     * Specifies the flow run status and whether it is in progress, has completed successfully, or has failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionStatus}
     * will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionStatusAsString}.
     * </p>
     * 
     * @return Specifies the flow run status and whether it is in progress, has completed successfully, or has failed.
     * @see ExecutionStatus
     */
    public final String executionStatusAsString() {
        return executionStatus;
    }

    /**
     * <p>
     * Describes the result of the given flow run.
     * </p>
     * 
     * @return Describes the result of the given flow run.
     */
    public final ExecutionResult executionResult() {
        return executionResult;
    }

    /**
     * <p>
     * Specifies the start time of the flow run.
     * </p>
     * 
     * @return Specifies the start time of the flow run.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * Specifies the time of the most recent update.
     * </p>
     * 
     * @return Specifies the time of the most recent update.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The timestamp that determines the first new or updated record to be transferred in the flow run.
     * </p>
     * 
     * @return The timestamp that determines the first new or updated record to be transferred in the flow run.
     */
    public final Instant dataPullStartTime() {
        return dataPullStartTime;
    }

    /**
     * <p>
     * The timestamp that indicates the last new or updated record to be transferred in the flow run.
     * </p>
     * 
     * @return The timestamp that indicates the last new or updated record to be transferred in the flow run.
     */
    public final Instant dataPullEndTime() {
        return dataPullEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionResult());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(dataPullStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataPullEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionRecord)) {
            return false;
        }
        ExecutionRecord other = (ExecutionRecord) obj;
        return Objects.equals(executionId(), other.executionId())
                && Objects.equals(executionStatusAsString(), other.executionStatusAsString())
                && Objects.equals(executionResult(), other.executionResult()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(dataPullStartTime(), other.dataPullStartTime())
                && Objects.equals(dataPullEndTime(), other.dataPullEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionRecord").add("ExecutionId", executionId())
                .add("ExecutionStatus", executionStatusAsString()).add("ExecutionResult", executionResult())
                .add("StartedAt", startedAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("DataPullStartTime", dataPullStartTime()).add("DataPullEndTime", dataPullEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "executionStatus":
            return Optional.ofNullable(clazz.cast(executionStatusAsString()));
        case "executionResult":
            return Optional.ofNullable(clazz.cast(executionResult()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "dataPullStartTime":
            return Optional.ofNullable(clazz.cast(dataPullStartTime()));
        case "dataPullEndTime":
            return Optional.ofNullable(clazz.cast(dataPullEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionRecord, T> g) {
        return obj -> g.apply((ExecutionRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionRecord> {
        /**
         * <p>
         * Specifies the identifier of the given flow run.
         * </p>
         * 
         * @param executionId
         *        Specifies the identifier of the given flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * Specifies the flow run status and whether it is in progress, has completed successfully, or has failed.
         * </p>
         * 
         * @param executionStatus
         *        Specifies the flow run status and whether it is in progress, has completed successfully, or has
         *        failed.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder executionStatus(String executionStatus);

        /**
         * <p>
         * Specifies the flow run status and whether it is in progress, has completed successfully, or has failed.
         * </p>
         * 
         * @param executionStatus
         *        Specifies the flow run status and whether it is in progress, has completed successfully, or has
         *        failed.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder executionStatus(ExecutionStatus executionStatus);

        /**
         * <p>
         * Describes the result of the given flow run.
         * </p>
         * 
         * @param executionResult
         *        Describes the result of the given flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionResult(ExecutionResult executionResult);

        /**
         * <p>
         * Describes the result of the given flow run.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionResult.Builder} avoiding the
         * need to create one manually via {@link ExecutionResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionResult.Builder#build()} is called immediately and its
         * result is passed to {@link #executionResult(ExecutionResult)}.
         * 
         * @param executionResult
         *        a consumer that will call methods on {@link ExecutionResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionResult(ExecutionResult)
         */
        default Builder executionResult(Consumer<ExecutionResult.Builder> executionResult) {
            return executionResult(ExecutionResult.builder().applyMutation(executionResult).build());
        }

        /**
         * <p>
         * Specifies the start time of the flow run.
         * </p>
         * 
         * @param startedAt
         *        Specifies the start time of the flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * Specifies the time of the most recent update.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Specifies the time of the most recent update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The timestamp that determines the first new or updated record to be transferred in the flow run.
         * </p>
         * 
         * @param dataPullStartTime
         *        The timestamp that determines the first new or updated record to be transferred in the flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPullStartTime(Instant dataPullStartTime);

        /**
         * <p>
         * The timestamp that indicates the last new or updated record to be transferred in the flow run.
         * </p>
         * 
         * @param dataPullEndTime
         *        The timestamp that indicates the last new or updated record to be transferred in the flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPullEndTime(Instant dataPullEndTime);
    }

    static final class BuilderImpl implements Builder {
        private String executionId;

        private String executionStatus;

        private ExecutionResult executionResult;

        private Instant startedAt;

        private Instant lastUpdatedAt;

        private Instant dataPullStartTime;

        private Instant dataPullEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionRecord model) {
            executionId(model.executionId);
            executionStatus(model.executionStatus);
            executionResult(model.executionResult);
            startedAt(model.startedAt);
            lastUpdatedAt(model.lastUpdatedAt);
            dataPullStartTime(model.dataPullStartTime);
            dataPullEndTime(model.dataPullEndTime);
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getExecutionStatus() {
            return executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final ExecutionResult.Builder getExecutionResult() {
            return executionResult != null ? executionResult.toBuilder() : null;
        }

        public final void setExecutionResult(ExecutionResult.BuilderImpl executionResult) {
            this.executionResult = executionResult != null ? executionResult.build() : null;
        }

        @Override
        public final Builder executionResult(ExecutionResult executionResult) {
            this.executionResult = executionResult;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getDataPullStartTime() {
            return dataPullStartTime;
        }

        public final void setDataPullStartTime(Instant dataPullStartTime) {
            this.dataPullStartTime = dataPullStartTime;
        }

        @Override
        public final Builder dataPullStartTime(Instant dataPullStartTime) {
            this.dataPullStartTime = dataPullStartTime;
            return this;
        }

        public final Instant getDataPullEndTime() {
            return dataPullEndTime;
        }

        public final void setDataPullEndTime(Instant dataPullEndTime) {
            this.dataPullEndTime = dataPullEndTime;
        }

        @Override
        public final Builder dataPullEndTime(Instant dataPullEndTime) {
            this.dataPullEndTime = dataPullEndTime;
            return this;
        }

        @Override
        public ExecutionRecord build() {
            return new ExecutionRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
