/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This stores the information that is required to query a particular connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationConnectorProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationConnectorProperties.Builder, DestinationConnectorProperties> {
    private static final SdkField<RedshiftDestinationProperties> REDSHIFT_FIELD = SdkField
            .<RedshiftDestinationProperties> builder(MarshallingType.SDK_POJO).memberName("Redshift")
            .getter(getter(DestinationConnectorProperties::redshift)).setter(setter(Builder::redshift))
            .constructor(RedshiftDestinationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Redshift").build()).build();

    private static final SdkField<S3DestinationProperties> S3_FIELD = SdkField
            .<S3DestinationProperties> builder(MarshallingType.SDK_POJO).memberName("S3")
            .getter(getter(DestinationConnectorProperties::s3)).setter(setter(Builder::s3))
            .constructor(S3DestinationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()).build();

    private static final SdkField<SalesforceDestinationProperties> SALESFORCE_FIELD = SdkField
            .<SalesforceDestinationProperties> builder(MarshallingType.SDK_POJO).memberName("Salesforce")
            .getter(getter(DestinationConnectorProperties::salesforce)).setter(setter(Builder::salesforce))
            .constructor(SalesforceDestinationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salesforce").build()).build();

    private static final SdkField<SnowflakeDestinationProperties> SNOWFLAKE_FIELD = SdkField
            .<SnowflakeDestinationProperties> builder(MarshallingType.SDK_POJO).memberName("Snowflake")
            .getter(getter(DestinationConnectorProperties::snowflake)).setter(setter(Builder::snowflake))
            .constructor(SnowflakeDestinationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snowflake").build()).build();

    private static final SdkField<EventBridgeDestinationProperties> EVENT_BRIDGE_FIELD = SdkField
            .<EventBridgeDestinationProperties> builder(MarshallingType.SDK_POJO).memberName("EventBridge")
            .getter(getter(DestinationConnectorProperties::eventBridge)).setter(setter(Builder::eventBridge))
            .constructor(EventBridgeDestinationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridge").build()).build();

    private static final SdkField<LookoutMetricsDestinationProperties> LOOKOUT_METRICS_FIELD = SdkField
            .<LookoutMetricsDestinationProperties> builder(MarshallingType.SDK_POJO).memberName("LookoutMetrics")
            .getter(getter(DestinationConnectorProperties::lookoutMetrics)).setter(setter(Builder::lookoutMetrics))
            .constructor(LookoutMetricsDestinationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookoutMetrics").build()).build();

    private static final SdkField<UpsolverDestinationProperties> UPSOLVER_FIELD = SdkField
            .<UpsolverDestinationProperties> builder(MarshallingType.SDK_POJO).memberName("Upsolver")
            .getter(getter(DestinationConnectorProperties::upsolver)).setter(setter(Builder::upsolver))
            .constructor(UpsolverDestinationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Upsolver").build()).build();

    private static final SdkField<HoneycodeDestinationProperties> HONEYCODE_FIELD = SdkField
            .<HoneycodeDestinationProperties> builder(MarshallingType.SDK_POJO).memberName("Honeycode")
            .getter(getter(DestinationConnectorProperties::honeycode)).setter(setter(Builder::honeycode))
            .constructor(HoneycodeDestinationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Honeycode").build()).build();

    private static final SdkField<CustomerProfilesDestinationProperties> CUSTOMER_PROFILES_FIELD = SdkField
            .<CustomerProfilesDestinationProperties> builder(MarshallingType.SDK_POJO).memberName("CustomerProfiles")
            .getter(getter(DestinationConnectorProperties::customerProfiles)).setter(setter(Builder::customerProfiles))
            .constructor(CustomerProfilesDestinationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerProfiles").build()).build();

    private static final SdkField<ZendeskDestinationProperties> ZENDESK_FIELD = SdkField
            .<ZendeskDestinationProperties> builder(MarshallingType.SDK_POJO).memberName("Zendesk")
            .getter(getter(DestinationConnectorProperties::zendesk)).setter(setter(Builder::zendesk))
            .constructor(ZendeskDestinationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zendesk").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDSHIFT_FIELD, S3_FIELD,
            SALESFORCE_FIELD, SNOWFLAKE_FIELD, EVENT_BRIDGE_FIELD, LOOKOUT_METRICS_FIELD, UPSOLVER_FIELD, HONEYCODE_FIELD,
            CUSTOMER_PROFILES_FIELD, ZENDESK_FIELD));

    private static final long serialVersionUID = 1L;

    private final RedshiftDestinationProperties redshift;

    private final S3DestinationProperties s3;

    private final SalesforceDestinationProperties salesforce;

    private final SnowflakeDestinationProperties snowflake;

    private final EventBridgeDestinationProperties eventBridge;

    private final LookoutMetricsDestinationProperties lookoutMetrics;

    private final UpsolverDestinationProperties upsolver;

    private final HoneycodeDestinationProperties honeycode;

    private final CustomerProfilesDestinationProperties customerProfiles;

    private final ZendeskDestinationProperties zendesk;

    private DestinationConnectorProperties(BuilderImpl builder) {
        this.redshift = builder.redshift;
        this.s3 = builder.s3;
        this.salesforce = builder.salesforce;
        this.snowflake = builder.snowflake;
        this.eventBridge = builder.eventBridge;
        this.lookoutMetrics = builder.lookoutMetrics;
        this.upsolver = builder.upsolver;
        this.honeycode = builder.honeycode;
        this.customerProfiles = builder.customerProfiles;
        this.zendesk = builder.zendesk;
    }

    /**
     * <p>
     * The properties required to query Amazon Redshift.
     * </p>
     * 
     * @return The properties required to query Amazon Redshift.
     */
    public final RedshiftDestinationProperties redshift() {
        return redshift;
    }

    /**
     * <p>
     * The properties required to query Amazon S3.
     * </p>
     * 
     * @return The properties required to query Amazon S3.
     */
    public final S3DestinationProperties s3() {
        return s3;
    }

    /**
     * <p>
     * The properties required to query Salesforce.
     * </p>
     * 
     * @return The properties required to query Salesforce.
     */
    public final SalesforceDestinationProperties salesforce() {
        return salesforce;
    }

    /**
     * <p>
     * The properties required to query Snowflake.
     * </p>
     * 
     * @return The properties required to query Snowflake.
     */
    public final SnowflakeDestinationProperties snowflake() {
        return snowflake;
    }

    /**
     * <p>
     * The properties required to query Amazon EventBridge.
     * </p>
     * 
     * @return The properties required to query Amazon EventBridge.
     */
    public final EventBridgeDestinationProperties eventBridge() {
        return eventBridge;
    }

    /**
     * <p>
     * The properties required to query Amazon Lookout for Metrics.
     * </p>
     * 
     * @return The properties required to query Amazon Lookout for Metrics.
     */
    public final LookoutMetricsDestinationProperties lookoutMetrics() {
        return lookoutMetrics;
    }

    /**
     * <p>
     * The properties required to query Upsolver.
     * </p>
     * 
     * @return The properties required to query Upsolver.
     */
    public final UpsolverDestinationProperties upsolver() {
        return upsolver;
    }

    /**
     * <p>
     * The properties required to query Amazon Honeycode.
     * </p>
     * 
     * @return The properties required to query Amazon Honeycode.
     */
    public final HoneycodeDestinationProperties honeycode() {
        return honeycode;
    }

    /**
     * <p>
     * The properties required to query Amazon Connect Customer Profiles.
     * </p>
     * 
     * @return The properties required to query Amazon Connect Customer Profiles.
     */
    public final CustomerProfilesDestinationProperties customerProfiles() {
        return customerProfiles;
    }

    /**
     * <p>
     * The properties required to query Zendesk.
     * </p>
     * 
     * @return The properties required to query Zendesk.
     */
    public final ZendeskDestinationProperties zendesk() {
        return zendesk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(redshift());
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        hashCode = 31 * hashCode + Objects.hashCode(salesforce());
        hashCode = 31 * hashCode + Objects.hashCode(snowflake());
        hashCode = 31 * hashCode + Objects.hashCode(eventBridge());
        hashCode = 31 * hashCode + Objects.hashCode(lookoutMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(upsolver());
        hashCode = 31 * hashCode + Objects.hashCode(honeycode());
        hashCode = 31 * hashCode + Objects.hashCode(customerProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(zendesk());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationConnectorProperties)) {
            return false;
        }
        DestinationConnectorProperties other = (DestinationConnectorProperties) obj;
        return Objects.equals(redshift(), other.redshift()) && Objects.equals(s3(), other.s3())
                && Objects.equals(salesforce(), other.salesforce()) && Objects.equals(snowflake(), other.snowflake())
                && Objects.equals(eventBridge(), other.eventBridge()) && Objects.equals(lookoutMetrics(), other.lookoutMetrics())
                && Objects.equals(upsolver(), other.upsolver()) && Objects.equals(honeycode(), other.honeycode())
                && Objects.equals(customerProfiles(), other.customerProfiles()) && Objects.equals(zendesk(), other.zendesk());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationConnectorProperties").add("Redshift", redshift()).add("S3", s3())
                .add("Salesforce", salesforce()).add("Snowflake", snowflake()).add("EventBridge", eventBridge())
                .add("LookoutMetrics", lookoutMetrics()).add("Upsolver", upsolver()).add("Honeycode", honeycode())
                .add("CustomerProfiles", customerProfiles()).add("Zendesk", zendesk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Redshift":
            return Optional.ofNullable(clazz.cast(redshift()));
        case "S3":
            return Optional.ofNullable(clazz.cast(s3()));
        case "Salesforce":
            return Optional.ofNullable(clazz.cast(salesforce()));
        case "Snowflake":
            return Optional.ofNullable(clazz.cast(snowflake()));
        case "EventBridge":
            return Optional.ofNullable(clazz.cast(eventBridge()));
        case "LookoutMetrics":
            return Optional.ofNullable(clazz.cast(lookoutMetrics()));
        case "Upsolver":
            return Optional.ofNullable(clazz.cast(upsolver()));
        case "Honeycode":
            return Optional.ofNullable(clazz.cast(honeycode()));
        case "CustomerProfiles":
            return Optional.ofNullable(clazz.cast(customerProfiles()));
        case "Zendesk":
            return Optional.ofNullable(clazz.cast(zendesk()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationConnectorProperties, T> g) {
        return obj -> g.apply((DestinationConnectorProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationConnectorProperties> {
        /**
         * <p>
         * The properties required to query Amazon Redshift.
         * </p>
         * 
         * @param redshift
         *        The properties required to query Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshift(RedshiftDestinationProperties redshift);

        /**
         * <p>
         * The properties required to query Amazon Redshift.
         * </p>
         * This is a convenience that creates an instance of the {@link RedshiftDestinationProperties.Builder} avoiding
         * the need to create one manually via {@link RedshiftDestinationProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link RedshiftDestinationProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #redshift(RedshiftDestinationProperties)}.
         * 
         * @param redshift
         *        a consumer that will call methods on {@link RedshiftDestinationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshift(RedshiftDestinationProperties)
         */
        default Builder redshift(Consumer<RedshiftDestinationProperties.Builder> redshift) {
            return redshift(RedshiftDestinationProperties.builder().applyMutation(redshift).build());
        }

        /**
         * <p>
         * The properties required to query Amazon S3.
         * </p>
         * 
         * @param s3
         *        The properties required to query Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3DestinationProperties s3);

        /**
         * <p>
         * The properties required to query Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DestinationProperties.Builder} avoiding the
         * need to create one manually via {@link S3DestinationProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DestinationProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #s3(S3DestinationProperties)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3DestinationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3DestinationProperties)
         */
        default Builder s3(Consumer<S3DestinationProperties.Builder> s3) {
            return s3(S3DestinationProperties.builder().applyMutation(s3).build());
        }

        /**
         * <p>
         * The properties required to query Salesforce.
         * </p>
         * 
         * @param salesforce
         *        The properties required to query Salesforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesforce(SalesforceDestinationProperties salesforce);

        /**
         * <p>
         * The properties required to query Salesforce.
         * </p>
         * This is a convenience that creates an instance of the {@link SalesforceDestinationProperties.Builder}
         * avoiding the need to create one manually via {@link SalesforceDestinationProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link SalesforceDestinationProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #salesforce(SalesforceDestinationProperties)}.
         * 
         * @param salesforce
         *        a consumer that will call methods on {@link SalesforceDestinationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #salesforce(SalesforceDestinationProperties)
         */
        default Builder salesforce(Consumer<SalesforceDestinationProperties.Builder> salesforce) {
            return salesforce(SalesforceDestinationProperties.builder().applyMutation(salesforce).build());
        }

        /**
         * <p>
         * The properties required to query Snowflake.
         * </p>
         * 
         * @param snowflake
         *        The properties required to query Snowflake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowflake(SnowflakeDestinationProperties snowflake);

        /**
         * <p>
         * The properties required to query Snowflake.
         * </p>
         * This is a convenience that creates an instance of the {@link SnowflakeDestinationProperties.Builder} avoiding
         * the need to create one manually via {@link SnowflakeDestinationProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link SnowflakeDestinationProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #snowflake(SnowflakeDestinationProperties)}.
         * 
         * @param snowflake
         *        a consumer that will call methods on {@link SnowflakeDestinationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snowflake(SnowflakeDestinationProperties)
         */
        default Builder snowflake(Consumer<SnowflakeDestinationProperties.Builder> snowflake) {
            return snowflake(SnowflakeDestinationProperties.builder().applyMutation(snowflake).build());
        }

        /**
         * <p>
         * The properties required to query Amazon EventBridge.
         * </p>
         * 
         * @param eventBridge
         *        The properties required to query Amazon EventBridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridge(EventBridgeDestinationProperties eventBridge);

        /**
         * <p>
         * The properties required to query Amazon EventBridge.
         * </p>
         * This is a convenience that creates an instance of the {@link EventBridgeDestinationProperties.Builder}
         * avoiding the need to create one manually via {@link EventBridgeDestinationProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventBridgeDestinationProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #eventBridge(EventBridgeDestinationProperties)}.
         * 
         * @param eventBridge
         *        a consumer that will call methods on {@link EventBridgeDestinationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBridge(EventBridgeDestinationProperties)
         */
        default Builder eventBridge(Consumer<EventBridgeDestinationProperties.Builder> eventBridge) {
            return eventBridge(EventBridgeDestinationProperties.builder().applyMutation(eventBridge).build());
        }

        /**
         * <p>
         * The properties required to query Amazon Lookout for Metrics.
         * </p>
         * 
         * @param lookoutMetrics
         *        The properties required to query Amazon Lookout for Metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookoutMetrics(LookoutMetricsDestinationProperties lookoutMetrics);

        /**
         * <p>
         * The properties required to query Amazon Lookout for Metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link LookoutMetricsDestinationProperties.Builder}
         * avoiding the need to create one manually via {@link LookoutMetricsDestinationProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link LookoutMetricsDestinationProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #lookoutMetrics(LookoutMetricsDestinationProperties)}.
         * 
         * @param lookoutMetrics
         *        a consumer that will call methods on {@link LookoutMetricsDestinationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lookoutMetrics(LookoutMetricsDestinationProperties)
         */
        default Builder lookoutMetrics(Consumer<LookoutMetricsDestinationProperties.Builder> lookoutMetrics) {
            return lookoutMetrics(LookoutMetricsDestinationProperties.builder().applyMutation(lookoutMetrics).build());
        }

        /**
         * <p>
         * The properties required to query Upsolver.
         * </p>
         * 
         * @param upsolver
         *        The properties required to query Upsolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upsolver(UpsolverDestinationProperties upsolver);

        /**
         * <p>
         * The properties required to query Upsolver.
         * </p>
         * This is a convenience that creates an instance of the {@link UpsolverDestinationProperties.Builder} avoiding
         * the need to create one manually via {@link UpsolverDestinationProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpsolverDestinationProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #upsolver(UpsolverDestinationProperties)}.
         * 
         * @param upsolver
         *        a consumer that will call methods on {@link UpsolverDestinationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #upsolver(UpsolverDestinationProperties)
         */
        default Builder upsolver(Consumer<UpsolverDestinationProperties.Builder> upsolver) {
            return upsolver(UpsolverDestinationProperties.builder().applyMutation(upsolver).build());
        }

        /**
         * <p>
         * The properties required to query Amazon Honeycode.
         * </p>
         * 
         * @param honeycode
         *        The properties required to query Amazon Honeycode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder honeycode(HoneycodeDestinationProperties honeycode);

        /**
         * <p>
         * The properties required to query Amazon Honeycode.
         * </p>
         * This is a convenience that creates an instance of the {@link HoneycodeDestinationProperties.Builder} avoiding
         * the need to create one manually via {@link HoneycodeDestinationProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link HoneycodeDestinationProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #honeycode(HoneycodeDestinationProperties)}.
         * 
         * @param honeycode
         *        a consumer that will call methods on {@link HoneycodeDestinationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #honeycode(HoneycodeDestinationProperties)
         */
        default Builder honeycode(Consumer<HoneycodeDestinationProperties.Builder> honeycode) {
            return honeycode(HoneycodeDestinationProperties.builder().applyMutation(honeycode).build());
        }

        /**
         * <p>
         * The properties required to query Amazon Connect Customer Profiles.
         * </p>
         * 
         * @param customerProfiles
         *        The properties required to query Amazon Connect Customer Profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerProfiles(CustomerProfilesDestinationProperties customerProfiles);

        /**
         * <p>
         * The properties required to query Amazon Connect Customer Profiles.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomerProfilesDestinationProperties.Builder}
         * avoiding the need to create one manually via {@link CustomerProfilesDestinationProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomerProfilesDestinationProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #customerProfiles(CustomerProfilesDestinationProperties)}.
         * 
         * @param customerProfiles
         *        a consumer that will call methods on {@link CustomerProfilesDestinationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerProfiles(CustomerProfilesDestinationProperties)
         */
        default Builder customerProfiles(Consumer<CustomerProfilesDestinationProperties.Builder> customerProfiles) {
            return customerProfiles(CustomerProfilesDestinationProperties.builder().applyMutation(customerProfiles).build());
        }

        /**
         * <p>
         * The properties required to query Zendesk.
         * </p>
         * 
         * @param zendesk
         *        The properties required to query Zendesk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zendesk(ZendeskDestinationProperties zendesk);

        /**
         * <p>
         * The properties required to query Zendesk.
         * </p>
         * This is a convenience that creates an instance of the {@link ZendeskDestinationProperties.Builder} avoiding
         * the need to create one manually via {@link ZendeskDestinationProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ZendeskDestinationProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #zendesk(ZendeskDestinationProperties)}.
         * 
         * @param zendesk
         *        a consumer that will call methods on {@link ZendeskDestinationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zendesk(ZendeskDestinationProperties)
         */
        default Builder zendesk(Consumer<ZendeskDestinationProperties.Builder> zendesk) {
            return zendesk(ZendeskDestinationProperties.builder().applyMutation(zendesk).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RedshiftDestinationProperties redshift;

        private S3DestinationProperties s3;

        private SalesforceDestinationProperties salesforce;

        private SnowflakeDestinationProperties snowflake;

        private EventBridgeDestinationProperties eventBridge;

        private LookoutMetricsDestinationProperties lookoutMetrics;

        private UpsolverDestinationProperties upsolver;

        private HoneycodeDestinationProperties honeycode;

        private CustomerProfilesDestinationProperties customerProfiles;

        private ZendeskDestinationProperties zendesk;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationConnectorProperties model) {
            redshift(model.redshift);
            s3(model.s3);
            salesforce(model.salesforce);
            snowflake(model.snowflake);
            eventBridge(model.eventBridge);
            lookoutMetrics(model.lookoutMetrics);
            upsolver(model.upsolver);
            honeycode(model.honeycode);
            customerProfiles(model.customerProfiles);
            zendesk(model.zendesk);
        }

        public final RedshiftDestinationProperties.Builder getRedshift() {
            return redshift != null ? redshift.toBuilder() : null;
        }

        public final void setRedshift(RedshiftDestinationProperties.BuilderImpl redshift) {
            this.redshift = redshift != null ? redshift.build() : null;
        }

        @Override
        @Transient
        public final Builder redshift(RedshiftDestinationProperties redshift) {
            this.redshift = redshift;
            return this;
        }

        public final S3DestinationProperties.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(S3DestinationProperties.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        @Transient
        public final Builder s3(S3DestinationProperties s3) {
            this.s3 = s3;
            return this;
        }

        public final SalesforceDestinationProperties.Builder getSalesforce() {
            return salesforce != null ? salesforce.toBuilder() : null;
        }

        public final void setSalesforce(SalesforceDestinationProperties.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        @Override
        @Transient
        public final Builder salesforce(SalesforceDestinationProperties salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final SnowflakeDestinationProperties.Builder getSnowflake() {
            return snowflake != null ? snowflake.toBuilder() : null;
        }

        public final void setSnowflake(SnowflakeDestinationProperties.BuilderImpl snowflake) {
            this.snowflake = snowflake != null ? snowflake.build() : null;
        }

        @Override
        @Transient
        public final Builder snowflake(SnowflakeDestinationProperties snowflake) {
            this.snowflake = snowflake;
            return this;
        }

        public final EventBridgeDestinationProperties.Builder getEventBridge() {
            return eventBridge != null ? eventBridge.toBuilder() : null;
        }

        public final void setEventBridge(EventBridgeDestinationProperties.BuilderImpl eventBridge) {
            this.eventBridge = eventBridge != null ? eventBridge.build() : null;
        }

        @Override
        @Transient
        public final Builder eventBridge(EventBridgeDestinationProperties eventBridge) {
            this.eventBridge = eventBridge;
            return this;
        }

        public final LookoutMetricsDestinationProperties.Builder getLookoutMetrics() {
            return lookoutMetrics != null ? lookoutMetrics.toBuilder() : null;
        }

        public final void setLookoutMetrics(LookoutMetricsDestinationProperties.BuilderImpl lookoutMetrics) {
            this.lookoutMetrics = lookoutMetrics != null ? lookoutMetrics.build() : null;
        }

        @Override
        @Transient
        public final Builder lookoutMetrics(LookoutMetricsDestinationProperties lookoutMetrics) {
            this.lookoutMetrics = lookoutMetrics;
            return this;
        }

        public final UpsolverDestinationProperties.Builder getUpsolver() {
            return upsolver != null ? upsolver.toBuilder() : null;
        }

        public final void setUpsolver(UpsolverDestinationProperties.BuilderImpl upsolver) {
            this.upsolver = upsolver != null ? upsolver.build() : null;
        }

        @Override
        @Transient
        public final Builder upsolver(UpsolverDestinationProperties upsolver) {
            this.upsolver = upsolver;
            return this;
        }

        public final HoneycodeDestinationProperties.Builder getHoneycode() {
            return honeycode != null ? honeycode.toBuilder() : null;
        }

        public final void setHoneycode(HoneycodeDestinationProperties.BuilderImpl honeycode) {
            this.honeycode = honeycode != null ? honeycode.build() : null;
        }

        @Override
        @Transient
        public final Builder honeycode(HoneycodeDestinationProperties honeycode) {
            this.honeycode = honeycode;
            return this;
        }

        public final CustomerProfilesDestinationProperties.Builder getCustomerProfiles() {
            return customerProfiles != null ? customerProfiles.toBuilder() : null;
        }

        public final void setCustomerProfiles(CustomerProfilesDestinationProperties.BuilderImpl customerProfiles) {
            this.customerProfiles = customerProfiles != null ? customerProfiles.build() : null;
        }

        @Override
        @Transient
        public final Builder customerProfiles(CustomerProfilesDestinationProperties customerProfiles) {
            this.customerProfiles = customerProfiles;
            return this;
        }

        public final ZendeskDestinationProperties.Builder getZendesk() {
            return zendesk != null ? zendesk.toBuilder() : null;
        }

        public final void setZendesk(ZendeskDestinationProperties.BuilderImpl zendesk) {
            this.zendesk = zendesk != null ? zendesk.build() : null;
        }

        @Override
        @Transient
        public final Builder zendesk(ZendeskDestinationProperties zendesk) {
            this.zendesk = zendesk;
            return this;
        }

        @Override
        public DestinationConnectorProperties build() {
            return new DestinationConnectorProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
