/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific profile credentials required by Infor Nexus.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InforNexusConnectorProfileCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<InforNexusConnectorProfileCredentials.Builder, InforNexusConnectorProfileCredentials> {
    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessKeyId").getter(getter(InforNexusConnectorProfileCredentials::accessKeyId))
            .setter(setter(Builder::accessKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeyId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(InforNexusConnectorProfileCredentials::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<String> SECRET_ACCESS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretAccessKey").getter(getter(InforNexusConnectorProfileCredentials::secretAccessKey))
            .setter(setter(Builder::secretAccessKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretAccessKey").build()).build();

    private static final SdkField<String> DATAKEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("datakey")
            .getter(getter(InforNexusConnectorProfileCredentials::datakey)).setter(setter(Builder::datakey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datakey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_ID_FIELD,
            USER_ID_FIELD, SECRET_ACCESS_KEY_FIELD, DATAKEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accessKeyId;

    private final String userId;

    private final String secretAccessKey;

    private final String datakey;

    private InforNexusConnectorProfileCredentials(BuilderImpl builder) {
        this.accessKeyId = builder.accessKeyId;
        this.userId = builder.userId;
        this.secretAccessKey = builder.secretAccessKey;
        this.datakey = builder.datakey;
    }

    /**
     * <p>
     * The Access Key portion of the credentials.
     * </p>
     * 
     * @return The Access Key portion of the credentials.
     */
    public final String accessKeyId() {
        return accessKeyId;
    }

    /**
     * <p>
     * The identifier for the user.
     * </p>
     * 
     * @return The identifier for the user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The secret key used to sign requests.
     * </p>
     * 
     * @return The secret key used to sign requests.
     */
    public final String secretAccessKey() {
        return secretAccessKey;
    }

    /**
     * <p>
     * The encryption keys used to encrypt data.
     * </p>
     * 
     * @return The encryption keys used to encrypt data.
     */
    public final String datakey() {
        return datakey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(secretAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(datakey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InforNexusConnectorProfileCredentials)) {
            return false;
        }
        InforNexusConnectorProfileCredentials other = (InforNexusConnectorProfileCredentials) obj;
        return Objects.equals(accessKeyId(), other.accessKeyId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(secretAccessKey(), other.secretAccessKey()) && Objects.equals(datakey(), other.datakey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InforNexusConnectorProfileCredentials")
                .add("AccessKeyId", accessKeyId() == null ? null : "*** Sensitive Data Redacted ***").add("UserId", userId())
                .add("SecretAccessKey", secretAccessKey()).add("Datakey", datakey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessKeyId":
            return Optional.ofNullable(clazz.cast(accessKeyId()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "secretAccessKey":
            return Optional.ofNullable(clazz.cast(secretAccessKey()));
        case "datakey":
            return Optional.ofNullable(clazz.cast(datakey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InforNexusConnectorProfileCredentials, T> g) {
        return obj -> g.apply((InforNexusConnectorProfileCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InforNexusConnectorProfileCredentials> {
        /**
         * <p>
         * The Access Key portion of the credentials.
         * </p>
         * 
         * @param accessKeyId
         *        The Access Key portion of the credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeyId(String accessKeyId);

        /**
         * <p>
         * The identifier for the user.
         * </p>
         * 
         * @param userId
         *        The identifier for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The secret key used to sign requests.
         * </p>
         * 
         * @param secretAccessKey
         *        The secret key used to sign requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretAccessKey(String secretAccessKey);

        /**
         * <p>
         * The encryption keys used to encrypt data.
         * </p>
         * 
         * @param datakey
         *        The encryption keys used to encrypt data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datakey(String datakey);
    }

    static final class BuilderImpl implements Builder {
        private String accessKeyId;

        private String userId;

        private String secretAccessKey;

        private String datakey;

        private BuilderImpl() {
        }

        private BuilderImpl(InforNexusConnectorProfileCredentials model) {
            accessKeyId(model.accessKeyId);
            userId(model.userId);
            secretAccessKey(model.secretAccessKey);
            datakey(model.datakey);
        }

        public final String getAccessKeyId() {
            return accessKeyId;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        @Override
        @Transient
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        @Transient
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getSecretAccessKey() {
            return secretAccessKey;
        }

        public final void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        @Override
        @Transient
        public final Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public final String getDatakey() {
            return datakey;
        }

        public final void setDatakey(String datakey) {
            this.datakey = datakey;
        }

        @Override
        @Transient
        public final Builder datakey(String datakey) {
            this.datakey = datakey;
            return this;
        }

        @Override
        public InforNexusConnectorProfileCredentials build() {
            return new InforNexusConnectorProfileCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
