/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific profile credentials required by Marketo.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MarketoConnectorProfileCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<MarketoConnectorProfileCredentials.Builder, MarketoConnectorProfileCredentials> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientId").getter(getter(MarketoConnectorProfileCredentials::clientId))
            .setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();

    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientSecret").getter(getter(MarketoConnectorProfileCredentials::clientSecret))
            .setter(setter(Builder::clientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecret").build()).build();

    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessToken").getter(getter(MarketoConnectorProfileCredentials::accessToken))
            .setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()).build();

    private static final SdkField<ConnectorOAuthRequest> O_AUTH_REQUEST_FIELD = SdkField
            .<ConnectorOAuthRequest> builder(MarshallingType.SDK_POJO).memberName("oAuthRequest")
            .getter(getter(MarketoConnectorProfileCredentials::oAuthRequest)).setter(setter(Builder::oAuthRequest))
            .constructor(ConnectorOAuthRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthRequest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            CLIENT_SECRET_FIELD, ACCESS_TOKEN_FIELD, O_AUTH_REQUEST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientId;

    private final String clientSecret;

    private final String accessToken;

    private final ConnectorOAuthRequest oAuthRequest;

    private MarketoConnectorProfileCredentials(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.accessToken = builder.accessToken;
        this.oAuthRequest = builder.oAuthRequest;
    }

    /**
     * <p>
     * The identifier for the desired client.
     * </p>
     * 
     * @return The identifier for the desired client.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The client secret used by the OAuth client to authenticate to the authorization server.
     * </p>
     * 
     * @return The client secret used by the OAuth client to authenticate to the authorization server.
     */
    public final String clientSecret() {
        return clientSecret;
    }

    /**
     * <p>
     * The credentials used to access protected Marketo resources.
     * </p>
     * 
     * @return The credentials used to access protected Marketo resources.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The OAuth requirement needed to request security tokens from the connector endpoint.
     * </p>
     * 
     * @return The OAuth requirement needed to request security tokens from the connector endpoint.
     */
    public final ConnectorOAuthRequest oAuthRequest() {
        return oAuthRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MarketoConnectorProfileCredentials)) {
            return false;
        }
        MarketoConnectorProfileCredentials other = (MarketoConnectorProfileCredentials) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(clientSecret(), other.clientSecret())
                && Objects.equals(accessToken(), other.accessToken()) && Objects.equals(oAuthRequest(), other.oAuthRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MarketoConnectorProfileCredentials").add("ClientId", clientId())
                .add("ClientSecret", clientSecret() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OAuthRequest", oAuthRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "clientSecret":
            return Optional.ofNullable(clazz.cast(clientSecret()));
        case "accessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "oAuthRequest":
            return Optional.ofNullable(clazz.cast(oAuthRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MarketoConnectorProfileCredentials, T> g) {
        return obj -> g.apply((MarketoConnectorProfileCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MarketoConnectorProfileCredentials> {
        /**
         * <p>
         * The identifier for the desired client.
         * </p>
         * 
         * @param clientId
         *        The identifier for the desired client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The client secret used by the OAuth client to authenticate to the authorization server.
         * </p>
         * 
         * @param clientSecret
         *        The client secret used by the OAuth client to authenticate to the authorization server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecret(String clientSecret);

        /**
         * <p>
         * The credentials used to access protected Marketo resources.
         * </p>
         * 
         * @param accessToken
         *        The credentials used to access protected Marketo resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The OAuth requirement needed to request security tokens from the connector endpoint.
         * </p>
         * 
         * @param oAuthRequest
         *        The OAuth requirement needed to request security tokens from the connector endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthRequest(ConnectorOAuthRequest oAuthRequest);

        /**
         * <p>
         * The OAuth requirement needed to request security tokens from the connector endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link ConnectorOAuthRequest.Builder} avoiding the need
         * to create one manually via {@link ConnectorOAuthRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectorOAuthRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #oAuthRequest(ConnectorOAuthRequest)}.
         * 
         * @param oAuthRequest
         *        a consumer that will call methods on {@link ConnectorOAuthRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuthRequest(ConnectorOAuthRequest)
         */
        default Builder oAuthRequest(Consumer<ConnectorOAuthRequest.Builder> oAuthRequest) {
            return oAuthRequest(ConnectorOAuthRequest.builder().applyMutation(oAuthRequest).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String clientId;

        private String clientSecret;

        private String accessToken;

        private ConnectorOAuthRequest oAuthRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(MarketoConnectorProfileCredentials model) {
            clientId(model.clientId);
            clientSecret(model.clientSecret);
            accessToken(model.accessToken);
            oAuthRequest(model.oAuthRequest);
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        @Transient
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        @Transient
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        @Transient
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final ConnectorOAuthRequest.Builder getOAuthRequest() {
            return oAuthRequest != null ? oAuthRequest.toBuilder() : null;
        }

        public final void setOAuthRequest(ConnectorOAuthRequest.BuilderImpl oAuthRequest) {
            this.oAuthRequest = oAuthRequest != null ? oAuthRequest.build() : null;
        }

        @Override
        @Transient
        public final Builder oAuthRequest(ConnectorOAuthRequest oAuthRequest) {
            this.oAuthRequest = oAuthRequest;
            return this;
        }

        @Override
        public MarketoConnectorProfileCredentials build() {
            return new MarketoConnectorProfileCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
