/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific profile properties when using Amazon Redshift.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftConnectorProfileProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftConnectorProfileProperties.Builder, RedshiftConnectorProfileProperties> {
    private static final SdkField<String> DATABASE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseUrl").getter(getter(RedshiftConnectorProfileProperties::databaseUrl))
            .setter(setter(Builder::databaseUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseUrl").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(RedshiftConnectorProfileProperties::bucketName))
            .setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketPrefix").getter(getter(RedshiftConnectorProfileProperties::bucketPrefix))
            .setter(setter(Builder::bucketPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPrefix").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(RedshiftConnectorProfileProperties::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_URL_FIELD,
            BUCKET_NAME_FIELD, BUCKET_PREFIX_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String databaseUrl;

    private final String bucketName;

    private final String bucketPrefix;

    private final String roleArn;

    private RedshiftConnectorProfileProperties(BuilderImpl builder) {
        this.databaseUrl = builder.databaseUrl;
        this.bucketName = builder.bucketName;
        this.bucketPrefix = builder.bucketPrefix;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The JDBC URL of the Amazon Redshift cluster.
     * </p>
     * 
     * @return The JDBC URL of the Amazon Redshift cluster.
     */
    public final String databaseUrl() {
        return databaseUrl;
    }

    /**
     * <p>
     * A name for the associated Amazon S3 bucket.
     * </p>
     * 
     * @return A name for the associated Amazon S3 bucket.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The object key for the destination bucket in which Amazon AppFlow places the files.
     * </p>
     * 
     * @return The object key for the destination bucket in which Amazon AppFlow places the files.
     */
    public final String bucketPrefix() {
        return bucketPrefix;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftConnectorProfileProperties)) {
            return false;
        }
        RedshiftConnectorProfileProperties other = (RedshiftConnectorProfileProperties) obj;
        return Objects.equals(databaseUrl(), other.databaseUrl()) && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(bucketPrefix(), other.bucketPrefix()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftConnectorProfileProperties").add("DatabaseUrl", databaseUrl())
                .add("BucketName", bucketName()).add("BucketPrefix", bucketPrefix()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "databaseUrl":
            return Optional.ofNullable(clazz.cast(databaseUrl()));
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "bucketPrefix":
            return Optional.ofNullable(clazz.cast(bucketPrefix()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftConnectorProfileProperties, T> g) {
        return obj -> g.apply((RedshiftConnectorProfileProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftConnectorProfileProperties> {
        /**
         * <p>
         * The JDBC URL of the Amazon Redshift cluster.
         * </p>
         * 
         * @param databaseUrl
         *        The JDBC URL of the Amazon Redshift cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseUrl(String databaseUrl);

        /**
         * <p>
         * A name for the associated Amazon S3 bucket.
         * </p>
         * 
         * @param bucketName
         *        A name for the associated Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The object key for the destination bucket in which Amazon AppFlow places the files.
         * </p>
         * 
         * @param bucketPrefix
         *        The object key for the destination bucket in which Amazon AppFlow places the files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketPrefix(String bucketPrefix);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String databaseUrl;

        private String bucketName;

        private String bucketPrefix;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftConnectorProfileProperties model) {
            databaseUrl(model.databaseUrl);
            bucketName(model.bucketName);
            bucketPrefix(model.bucketPrefix);
            roleArn(model.roleArn);
        }

        public final String getDatabaseUrl() {
            return databaseUrl;
        }

        public final void setDatabaseUrl(String databaseUrl) {
            this.databaseUrl = databaseUrl;
        }

        @Override
        @Transient
        public final Builder databaseUrl(String databaseUrl) {
            this.databaseUrl = databaseUrl;
            return this;
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        @Transient
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBucketPrefix() {
            return bucketPrefix;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        @Transient
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public RedshiftConnectorProfileProperties build() {
            return new RedshiftConnectorProfileProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
