/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties that are applied when Amazon S3 is used as a destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3DestinationProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<S3DestinationProperties.Builder, S3DestinationProperties> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(S3DestinationProperties::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketPrefix").getter(getter(S3DestinationProperties::bucketPrefix))
            .setter(setter(Builder::bucketPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPrefix").build()).build();

    private static final SdkField<S3OutputFormatConfig> S3_OUTPUT_FORMAT_CONFIG_FIELD = SdkField
            .<S3OutputFormatConfig> builder(MarshallingType.SDK_POJO).memberName("s3OutputFormatConfig")
            .getter(getter(S3DestinationProperties::s3OutputFormatConfig)).setter(setter(Builder::s3OutputFormatConfig))
            .constructor(S3OutputFormatConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3OutputFormatConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            BUCKET_PREFIX_FIELD, S3_OUTPUT_FORMAT_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String bucketPrefix;

    private final S3OutputFormatConfig s3OutputFormatConfig;

    private S3DestinationProperties(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.bucketPrefix = builder.bucketPrefix;
        this.s3OutputFormatConfig = builder.s3OutputFormatConfig;
    }

    /**
     * <p>
     * The Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
     * </p>
     * 
     * @return The Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The object key for the destination bucket in which Amazon AppFlow places the files.
     * </p>
     * 
     * @return The object key for the destination bucket in which Amazon AppFlow places the files.
     */
    public final String bucketPrefix() {
        return bucketPrefix;
    }

    /**
     * Returns the value of the S3OutputFormatConfig property for this object.
     * 
     * @return The value of the S3OutputFormatConfig property for this object.
     */
    public final S3OutputFormatConfig s3OutputFormatConfig() {
        return s3OutputFormatConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputFormatConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationProperties)) {
            return false;
        }
        S3DestinationProperties other = (S3DestinationProperties) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(bucketPrefix(), other.bucketPrefix())
                && Objects.equals(s3OutputFormatConfig(), other.s3OutputFormatConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3DestinationProperties").add("BucketName", bucketName()).add("BucketPrefix", bucketPrefix())
                .add("S3OutputFormatConfig", s3OutputFormatConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "bucketPrefix":
            return Optional.ofNullable(clazz.cast(bucketPrefix()));
        case "s3OutputFormatConfig":
            return Optional.ofNullable(clazz.cast(s3OutputFormatConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3DestinationProperties, T> g) {
        return obj -> g.apply((S3DestinationProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3DestinationProperties> {
        /**
         * <p>
         * The Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
         * </p>
         * 
         * @param bucketName
         *        The Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The object key for the destination bucket in which Amazon AppFlow places the files.
         * </p>
         * 
         * @param bucketPrefix
         *        The object key for the destination bucket in which Amazon AppFlow places the files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketPrefix(String bucketPrefix);

        /**
         * Sets the value of the S3OutputFormatConfig property for this object.
         *
         * @param s3OutputFormatConfig
         *        The new value for the S3OutputFormatConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputFormatConfig(S3OutputFormatConfig s3OutputFormatConfig);

        /**
         * Sets the value of the S3OutputFormatConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link S3OutputFormatConfig.Builder} avoiding the need
         * to create one manually via {@link S3OutputFormatConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3OutputFormatConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #s3OutputFormatConfig(S3OutputFormatConfig)}.
         * 
         * @param s3OutputFormatConfig
         *        a consumer that will call methods on {@link S3OutputFormatConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3OutputFormatConfig(S3OutputFormatConfig)
         */
        default Builder s3OutputFormatConfig(Consumer<S3OutputFormatConfig.Builder> s3OutputFormatConfig) {
            return s3OutputFormatConfig(S3OutputFormatConfig.builder().applyMutation(s3OutputFormatConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String bucketPrefix;

        private S3OutputFormatConfig s3OutputFormatConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DestinationProperties model) {
            bucketName(model.bucketName);
            bucketPrefix(model.bucketPrefix);
            s3OutputFormatConfig(model.s3OutputFormatConfig);
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        @Transient
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBucketPrefix() {
            return bucketPrefix;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        @Transient
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final S3OutputFormatConfig.Builder getS3OutputFormatConfig() {
            return s3OutputFormatConfig != null ? s3OutputFormatConfig.toBuilder() : null;
        }

        public final void setS3OutputFormatConfig(S3OutputFormatConfig.BuilderImpl s3OutputFormatConfig) {
            this.s3OutputFormatConfig = s3OutputFormatConfig != null ? s3OutputFormatConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder s3OutputFormatConfig(S3OutputFormatConfig s3OutputFormatConfig) {
            this.s3OutputFormatConfig = s3OutputFormatConfig;
            return this;
        }

        @Override
        public S3DestinationProperties build() {
            return new S3DestinationProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
