/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties that are applied when using SAPOData as a flow source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SAPODataSourceProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<SAPODataSourceProperties.Builder, SAPODataSourceProperties> {
    private static final SdkField<String> OBJECT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("objectPath").getter(getter(SAPODataSourceProperties::objectPath)).setter(setter(Builder::objectPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String objectPath;

    private SAPODataSourceProperties(BuilderImpl builder) {
        this.objectPath = builder.objectPath;
    }

    /**
     * <p>
     * The object path specified in the SAPOData flow source.
     * </p>
     * 
     * @return The object path specified in the SAPOData flow source.
     */
    public final String objectPath() {
        return objectPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAPODataSourceProperties)) {
            return false;
        }
        SAPODataSourceProperties other = (SAPODataSourceProperties) obj;
        return Objects.equals(objectPath(), other.objectPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SAPODataSourceProperties").add("ObjectPath", objectPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "objectPath":
            return Optional.ofNullable(clazz.cast(objectPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SAPODataSourceProperties, T> g) {
        return obj -> g.apply((SAPODataSourceProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SAPODataSourceProperties> {
        /**
         * <p>
         * The object path specified in the SAPOData flow source.
         * </p>
         * 
         * @param objectPath
         *        The object path specified in the SAPOData flow source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectPath(String objectPath);
    }

    static final class BuilderImpl implements Builder {
        private String objectPath;

        private BuilderImpl() {
        }

        private BuilderImpl(SAPODataSourceProperties model) {
            objectPath(model.objectPath);
        }

        public final String getObjectPath() {
            return objectPath;
        }

        public final void setObjectPath(String objectPath) {
            this.objectPath = objectPath;
        }

        @Override
        @Transient
        public final Builder objectPath(String objectPath) {
            this.objectPath = objectPath;
            return this;
        }

        @Override
        public SAPODataSourceProperties build() {
            return new SAPODataSourceProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
