/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectorRegistrationRequest extends AppflowRequest implements
        ToCopyableBuilder<UpdateConnectorRegistrationRequest.Builder, UpdateConnectorRegistrationRequest> {
    private static final SdkField<String> CONNECTOR_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorLabel").getter(getter(UpdateConnectorRegistrationRequest::connectorLabel))
            .setter(setter(Builder::connectorLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorLabel").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateConnectorRegistrationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<ConnectorProvisioningConfig> CONNECTOR_PROVISIONING_CONFIG_FIELD = SdkField
            .<ConnectorProvisioningConfig> builder(MarshallingType.SDK_POJO)
            .memberName("connectorProvisioningConfig")
            .getter(getter(UpdateConnectorRegistrationRequest::connectorProvisioningConfig))
            .setter(setter(Builder::connectorProvisioningConfig))
            .constructor(ConnectorProvisioningConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProvisioningConfig")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_LABEL_FIELD,
            DESCRIPTION_FIELD, CONNECTOR_PROVISIONING_CONFIG_FIELD));

    private final String connectorLabel;

    private final String description;

    private final ConnectorProvisioningConfig connectorProvisioningConfig;

    private UpdateConnectorRegistrationRequest(BuilderImpl builder) {
        super(builder);
        this.connectorLabel = builder.connectorLabel;
        this.description = builder.description;
        this.connectorProvisioningConfig = builder.connectorProvisioningConfig;
    }

    /**
     * <p>
     * The name of the connector. The name is unique for each connector registration in your AWS account.
     * </p>
     * 
     * @return The name of the connector. The name is unique for each connector registration in your AWS account.
     */
    public final String connectorLabel() {
        return connectorLabel;
    }

    /**
     * <p>
     * A description about the update that you're applying to the connector.
     * </p>
     * 
     * @return A description about the update that you're applying to the connector.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the ConnectorProvisioningConfig property for this object.
     * 
     * @return The value of the ConnectorProvisioningConfig property for this object.
     */
    public final ConnectorProvisioningConfig connectorProvisioningConfig() {
        return connectorProvisioningConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(connectorProvisioningConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectorRegistrationRequest)) {
            return false;
        }
        UpdateConnectorRegistrationRequest other = (UpdateConnectorRegistrationRequest) obj;
        return Objects.equals(connectorLabel(), other.connectorLabel()) && Objects.equals(description(), other.description())
                && Objects.equals(connectorProvisioningConfig(), other.connectorProvisioningConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectorRegistrationRequest").add("ConnectorLabel", connectorLabel())
                .add("Description", description()).add("ConnectorProvisioningConfig", connectorProvisioningConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorLabel":
            return Optional.ofNullable(clazz.cast(connectorLabel()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "connectorProvisioningConfig":
            return Optional.ofNullable(clazz.cast(connectorProvisioningConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectorRegistrationRequest, T> g) {
        return obj -> g.apply((UpdateConnectorRegistrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConnectorRegistrationRequest> {
        /**
         * <p>
         * The name of the connector. The name is unique for each connector registration in your AWS account.
         * </p>
         * 
         * @param connectorLabel
         *        The name of the connector. The name is unique for each connector registration in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorLabel(String connectorLabel);

        /**
         * <p>
         * A description about the update that you're applying to the connector.
         * </p>
         * 
         * @param description
         *        A description about the update that you're applying to the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the ConnectorProvisioningConfig property for this object.
         *
         * @param connectorProvisioningConfig
         *        The new value for the ConnectorProvisioningConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProvisioningConfig(ConnectorProvisioningConfig connectorProvisioningConfig);

        /**
         * Sets the value of the ConnectorProvisioningConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ConnectorProvisioningConfig.Builder}
         * avoiding the need to create one manually via {@link ConnectorProvisioningConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectorProvisioningConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #connectorProvisioningConfig(ConnectorProvisioningConfig)}.
         * 
         * @param connectorProvisioningConfig
         *        a consumer that will call methods on {@link ConnectorProvisioningConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorProvisioningConfig(ConnectorProvisioningConfig)
         */
        default Builder connectorProvisioningConfig(Consumer<ConnectorProvisioningConfig.Builder> connectorProvisioningConfig) {
            return connectorProvisioningConfig(ConnectorProvisioningConfig.builder().applyMutation(connectorProvisioningConfig)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppflowRequest.BuilderImpl implements Builder {
        private String connectorLabel;

        private String description;

        private ConnectorProvisioningConfig connectorProvisioningConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectorRegistrationRequest model) {
            super(model);
            connectorLabel(model.connectorLabel);
            description(model.description);
            connectorProvisioningConfig(model.connectorProvisioningConfig);
        }

        public final String getConnectorLabel() {
            return connectorLabel;
        }

        public final void setConnectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
        }

        @Override
        public final Builder connectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ConnectorProvisioningConfig.Builder getConnectorProvisioningConfig() {
            return connectorProvisioningConfig != null ? connectorProvisioningConfig.toBuilder() : null;
        }

        public final void setConnectorProvisioningConfig(ConnectorProvisioningConfig.BuilderImpl connectorProvisioningConfig) {
            this.connectorProvisioningConfig = connectorProvisioningConfig != null ? connectorProvisioningConfig.build() : null;
        }

        @Override
        public final Builder connectorProvisioningConfig(ConnectorProvisioningConfig connectorProvisioningConfig) {
            this.connectorProvisioningConfig = connectorProvisioningConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectorRegistrationRequest build() {
            return new UpdateConnectorRegistrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
