/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific credentials required by a connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorProfileCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorProfileCredentials.Builder, ConnectorProfileCredentials> {
    private static final SdkField<AmplitudeConnectorProfileCredentials> AMPLITUDE_FIELD = SdkField
            .<AmplitudeConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("Amplitude")
            .getter(getter(ConnectorProfileCredentials::amplitude)).setter(setter(Builder::amplitude))
            .constructor(AmplitudeConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amplitude").build()).build();

    private static final SdkField<DatadogConnectorProfileCredentials> DATADOG_FIELD = SdkField
            .<DatadogConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("Datadog")
            .getter(getter(ConnectorProfileCredentials::datadog)).setter(setter(Builder::datadog))
            .constructor(DatadogConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datadog").build()).build();

    private static final SdkField<DynatraceConnectorProfileCredentials> DYNATRACE_FIELD = SdkField
            .<DynatraceConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("Dynatrace")
            .getter(getter(ConnectorProfileCredentials::dynatrace)).setter(setter(Builder::dynatrace))
            .constructor(DynatraceConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dynatrace").build()).build();

    private static final SdkField<GoogleAnalyticsConnectorProfileCredentials> GOOGLE_ANALYTICS_FIELD = SdkField
            .<GoogleAnalyticsConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("GoogleAnalytics")
            .getter(getter(ConnectorProfileCredentials::googleAnalytics)).setter(setter(Builder::googleAnalytics))
            .constructor(GoogleAnalyticsConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GoogleAnalytics").build()).build();

    private static final SdkField<HoneycodeConnectorProfileCredentials> HONEYCODE_FIELD = SdkField
            .<HoneycodeConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("Honeycode")
            .getter(getter(ConnectorProfileCredentials::honeycode)).setter(setter(Builder::honeycode))
            .constructor(HoneycodeConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Honeycode").build()).build();

    private static final SdkField<InforNexusConnectorProfileCredentials> INFOR_NEXUS_FIELD = SdkField
            .<InforNexusConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("InforNexus")
            .getter(getter(ConnectorProfileCredentials::inforNexus)).setter(setter(Builder::inforNexus))
            .constructor(InforNexusConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InforNexus").build()).build();

    private static final SdkField<MarketoConnectorProfileCredentials> MARKETO_FIELD = SdkField
            .<MarketoConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("Marketo")
            .getter(getter(ConnectorProfileCredentials::marketo)).setter(setter(Builder::marketo))
            .constructor(MarketoConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketo").build()).build();

    private static final SdkField<RedshiftConnectorProfileCredentials> REDSHIFT_FIELD = SdkField
            .<RedshiftConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("Redshift")
            .getter(getter(ConnectorProfileCredentials::redshift)).setter(setter(Builder::redshift))
            .constructor(RedshiftConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Redshift").build()).build();

    private static final SdkField<SalesforceConnectorProfileCredentials> SALESFORCE_FIELD = SdkField
            .<SalesforceConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("Salesforce")
            .getter(getter(ConnectorProfileCredentials::salesforce)).setter(setter(Builder::salesforce))
            .constructor(SalesforceConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salesforce").build()).build();

    private static final SdkField<ServiceNowConnectorProfileCredentials> SERVICE_NOW_FIELD = SdkField
            .<ServiceNowConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("ServiceNow")
            .getter(getter(ConnectorProfileCredentials::serviceNow)).setter(setter(Builder::serviceNow))
            .constructor(ServiceNowConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNow").build()).build();

    private static final SdkField<SingularConnectorProfileCredentials> SINGULAR_FIELD = SdkField
            .<SingularConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("Singular")
            .getter(getter(ConnectorProfileCredentials::singular)).setter(setter(Builder::singular))
            .constructor(SingularConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Singular").build()).build();

    private static final SdkField<SlackConnectorProfileCredentials> SLACK_FIELD = SdkField
            .<SlackConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("Slack")
            .getter(getter(ConnectorProfileCredentials::slack)).setter(setter(Builder::slack))
            .constructor(SlackConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slack").build()).build();

    private static final SdkField<SnowflakeConnectorProfileCredentials> SNOWFLAKE_FIELD = SdkField
            .<SnowflakeConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("Snowflake")
            .getter(getter(ConnectorProfileCredentials::snowflake)).setter(setter(Builder::snowflake))
            .constructor(SnowflakeConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snowflake").build()).build();

    private static final SdkField<TrendmicroConnectorProfileCredentials> TRENDMICRO_FIELD = SdkField
            .<TrendmicroConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("Trendmicro")
            .getter(getter(ConnectorProfileCredentials::trendmicro)).setter(setter(Builder::trendmicro))
            .constructor(TrendmicroConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trendmicro").build()).build();

    private static final SdkField<VeevaConnectorProfileCredentials> VEEVA_FIELD = SdkField
            .<VeevaConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("Veeva")
            .getter(getter(ConnectorProfileCredentials::veeva)).setter(setter(Builder::veeva))
            .constructor(VeevaConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Veeva").build()).build();

    private static final SdkField<ZendeskConnectorProfileCredentials> ZENDESK_FIELD = SdkField
            .<ZendeskConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("Zendesk")
            .getter(getter(ConnectorProfileCredentials::zendesk)).setter(setter(Builder::zendesk))
            .constructor(ZendeskConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zendesk").build()).build();

    private static final SdkField<SAPODataConnectorProfileCredentials> SAPO_DATA_FIELD = SdkField
            .<SAPODataConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("SAPOData")
            .getter(getter(ConnectorProfileCredentials::sapoData)).setter(setter(Builder::sapoData))
            .constructor(SAPODataConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAPOData").build()).build();

    private static final SdkField<CustomConnectorProfileCredentials> CUSTOM_CONNECTOR_FIELD = SdkField
            .<CustomConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("CustomConnector")
            .getter(getter(ConnectorProfileCredentials::customConnector)).setter(setter(Builder::customConnector))
            .constructor(CustomConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomConnector").build()).build();

    private static final SdkField<PardotConnectorProfileCredentials> PARDOT_FIELD = SdkField
            .<PardotConnectorProfileCredentials> builder(MarshallingType.SDK_POJO).memberName("Pardot")
            .getter(getter(ConnectorProfileCredentials::pardot)).setter(setter(Builder::pardot))
            .constructor(PardotConnectorProfileCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pardot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMPLITUDE_FIELD,
            DATADOG_FIELD, DYNATRACE_FIELD, GOOGLE_ANALYTICS_FIELD, HONEYCODE_FIELD, INFOR_NEXUS_FIELD, MARKETO_FIELD,
            REDSHIFT_FIELD, SALESFORCE_FIELD, SERVICE_NOW_FIELD, SINGULAR_FIELD, SLACK_FIELD, SNOWFLAKE_FIELD, TRENDMICRO_FIELD,
            VEEVA_FIELD, ZENDESK_FIELD, SAPO_DATA_FIELD, CUSTOM_CONNECTOR_FIELD, PARDOT_FIELD));

    private static final long serialVersionUID = 1L;

    private final AmplitudeConnectorProfileCredentials amplitude;

    private final DatadogConnectorProfileCredentials datadog;

    private final DynatraceConnectorProfileCredentials dynatrace;

    private final GoogleAnalyticsConnectorProfileCredentials googleAnalytics;

    private final HoneycodeConnectorProfileCredentials honeycode;

    private final InforNexusConnectorProfileCredentials inforNexus;

    private final MarketoConnectorProfileCredentials marketo;

    private final RedshiftConnectorProfileCredentials redshift;

    private final SalesforceConnectorProfileCredentials salesforce;

    private final ServiceNowConnectorProfileCredentials serviceNow;

    private final SingularConnectorProfileCredentials singular;

    private final SlackConnectorProfileCredentials slack;

    private final SnowflakeConnectorProfileCredentials snowflake;

    private final TrendmicroConnectorProfileCredentials trendmicro;

    private final VeevaConnectorProfileCredentials veeva;

    private final ZendeskConnectorProfileCredentials zendesk;

    private final SAPODataConnectorProfileCredentials sapoData;

    private final CustomConnectorProfileCredentials customConnector;

    private final PardotConnectorProfileCredentials pardot;

    private ConnectorProfileCredentials(BuilderImpl builder) {
        this.amplitude = builder.amplitude;
        this.datadog = builder.datadog;
        this.dynatrace = builder.dynatrace;
        this.googleAnalytics = builder.googleAnalytics;
        this.honeycode = builder.honeycode;
        this.inforNexus = builder.inforNexus;
        this.marketo = builder.marketo;
        this.redshift = builder.redshift;
        this.salesforce = builder.salesforce;
        this.serviceNow = builder.serviceNow;
        this.singular = builder.singular;
        this.slack = builder.slack;
        this.snowflake = builder.snowflake;
        this.trendmicro = builder.trendmicro;
        this.veeva = builder.veeva;
        this.zendesk = builder.zendesk;
        this.sapoData = builder.sapoData;
        this.customConnector = builder.customConnector;
        this.pardot = builder.pardot;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Amplitude.
     * </p>
     * 
     * @return The connector-specific credentials required when using Amplitude.
     */
    public final AmplitudeConnectorProfileCredentials amplitude() {
        return amplitude;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Datadog.
     * </p>
     * 
     * @return The connector-specific credentials required when using Datadog.
     */
    public final DatadogConnectorProfileCredentials datadog() {
        return datadog;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Dynatrace.
     * </p>
     * 
     * @return The connector-specific credentials required when using Dynatrace.
     */
    public final DynatraceConnectorProfileCredentials dynatrace() {
        return dynatrace;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Google Analytics.
     * </p>
     * 
     * @return The connector-specific credentials required when using Google Analytics.
     */
    public final GoogleAnalyticsConnectorProfileCredentials googleAnalytics() {
        return googleAnalytics;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Amazon Honeycode.
     * </p>
     * 
     * @return The connector-specific credentials required when using Amazon Honeycode.
     */
    public final HoneycodeConnectorProfileCredentials honeycode() {
        return honeycode;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Infor Nexus.
     * </p>
     * 
     * @return The connector-specific credentials required when using Infor Nexus.
     */
    public final InforNexusConnectorProfileCredentials inforNexus() {
        return inforNexus;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Marketo.
     * </p>
     * 
     * @return The connector-specific credentials required when using Marketo.
     */
    public final MarketoConnectorProfileCredentials marketo() {
        return marketo;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Amazon Redshift.
     * </p>
     * 
     * @return The connector-specific credentials required when using Amazon Redshift.
     */
    public final RedshiftConnectorProfileCredentials redshift() {
        return redshift;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Salesforce.
     * </p>
     * 
     * @return The connector-specific credentials required when using Salesforce.
     */
    public final SalesforceConnectorProfileCredentials salesforce() {
        return salesforce;
    }

    /**
     * <p>
     * The connector-specific credentials required when using ServiceNow.
     * </p>
     * 
     * @return The connector-specific credentials required when using ServiceNow.
     */
    public final ServiceNowConnectorProfileCredentials serviceNow() {
        return serviceNow;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Singular.
     * </p>
     * 
     * @return The connector-specific credentials required when using Singular.
     */
    public final SingularConnectorProfileCredentials singular() {
        return singular;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Slack.
     * </p>
     * 
     * @return The connector-specific credentials required when using Slack.
     */
    public final SlackConnectorProfileCredentials slack() {
        return slack;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Snowflake.
     * </p>
     * 
     * @return The connector-specific credentials required when using Snowflake.
     */
    public final SnowflakeConnectorProfileCredentials snowflake() {
        return snowflake;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Trend Micro.
     * </p>
     * 
     * @return The connector-specific credentials required when using Trend Micro.
     */
    public final TrendmicroConnectorProfileCredentials trendmicro() {
        return trendmicro;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Veeva.
     * </p>
     * 
     * @return The connector-specific credentials required when using Veeva.
     */
    public final VeevaConnectorProfileCredentials veeva() {
        return veeva;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Zendesk.
     * </p>
     * 
     * @return The connector-specific credentials required when using Zendesk.
     */
    public final ZendeskConnectorProfileCredentials zendesk() {
        return zendesk;
    }

    /**
     * Returns the value of the SAPOData property for this object.
     * 
     * @return The value of the SAPOData property for this object.
     */
    public final SAPODataConnectorProfileCredentials sapoData() {
        return sapoData;
    }

    /**
     * Returns the value of the CustomConnector property for this object.
     * 
     * @return The value of the CustomConnector property for this object.
     */
    public final CustomConnectorProfileCredentials customConnector() {
        return customConnector;
    }

    /**
     * <p>
     * The connector-specific credentials required when using Salesforce Pardot.
     * </p>
     * 
     * @return The connector-specific credentials required when using Salesforce Pardot.
     */
    public final PardotConnectorProfileCredentials pardot() {
        return pardot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amplitude());
        hashCode = 31 * hashCode + Objects.hashCode(datadog());
        hashCode = 31 * hashCode + Objects.hashCode(dynatrace());
        hashCode = 31 * hashCode + Objects.hashCode(googleAnalytics());
        hashCode = 31 * hashCode + Objects.hashCode(honeycode());
        hashCode = 31 * hashCode + Objects.hashCode(inforNexus());
        hashCode = 31 * hashCode + Objects.hashCode(marketo());
        hashCode = 31 * hashCode + Objects.hashCode(redshift());
        hashCode = 31 * hashCode + Objects.hashCode(salesforce());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNow());
        hashCode = 31 * hashCode + Objects.hashCode(singular());
        hashCode = 31 * hashCode + Objects.hashCode(slack());
        hashCode = 31 * hashCode + Objects.hashCode(snowflake());
        hashCode = 31 * hashCode + Objects.hashCode(trendmicro());
        hashCode = 31 * hashCode + Objects.hashCode(veeva());
        hashCode = 31 * hashCode + Objects.hashCode(zendesk());
        hashCode = 31 * hashCode + Objects.hashCode(sapoData());
        hashCode = 31 * hashCode + Objects.hashCode(customConnector());
        hashCode = 31 * hashCode + Objects.hashCode(pardot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorProfileCredentials)) {
            return false;
        }
        ConnectorProfileCredentials other = (ConnectorProfileCredentials) obj;
        return Objects.equals(amplitude(), other.amplitude()) && Objects.equals(datadog(), other.datadog())
                && Objects.equals(dynatrace(), other.dynatrace()) && Objects.equals(googleAnalytics(), other.googleAnalytics())
                && Objects.equals(honeycode(), other.honeycode()) && Objects.equals(inforNexus(), other.inforNexus())
                && Objects.equals(marketo(), other.marketo()) && Objects.equals(redshift(), other.redshift())
                && Objects.equals(salesforce(), other.salesforce()) && Objects.equals(serviceNow(), other.serviceNow())
                && Objects.equals(singular(), other.singular()) && Objects.equals(slack(), other.slack())
                && Objects.equals(snowflake(), other.snowflake()) && Objects.equals(trendmicro(), other.trendmicro())
                && Objects.equals(veeva(), other.veeva()) && Objects.equals(zendesk(), other.zendesk())
                && Objects.equals(sapoData(), other.sapoData()) && Objects.equals(customConnector(), other.customConnector())
                && Objects.equals(pardot(), other.pardot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorProfileCredentials").add("Amplitude", amplitude()).add("Datadog", datadog())
                .add("Dynatrace", dynatrace()).add("GoogleAnalytics", googleAnalytics()).add("Honeycode", honeycode())
                .add("InforNexus", inforNexus()).add("Marketo", marketo()).add("Redshift", redshift())
                .add("Salesforce", salesforce()).add("ServiceNow", serviceNow()).add("Singular", singular())
                .add("Slack", slack()).add("Snowflake", snowflake()).add("Trendmicro", trendmicro()).add("Veeva", veeva())
                .add("Zendesk", zendesk()).add("SAPOData", sapoData()).add("CustomConnector", customConnector())
                .add("Pardot", pardot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Amplitude":
            return Optional.ofNullable(clazz.cast(amplitude()));
        case "Datadog":
            return Optional.ofNullable(clazz.cast(datadog()));
        case "Dynatrace":
            return Optional.ofNullable(clazz.cast(dynatrace()));
        case "GoogleAnalytics":
            return Optional.ofNullable(clazz.cast(googleAnalytics()));
        case "Honeycode":
            return Optional.ofNullable(clazz.cast(honeycode()));
        case "InforNexus":
            return Optional.ofNullable(clazz.cast(inforNexus()));
        case "Marketo":
            return Optional.ofNullable(clazz.cast(marketo()));
        case "Redshift":
            return Optional.ofNullable(clazz.cast(redshift()));
        case "Salesforce":
            return Optional.ofNullable(clazz.cast(salesforce()));
        case "ServiceNow":
            return Optional.ofNullable(clazz.cast(serviceNow()));
        case "Singular":
            return Optional.ofNullable(clazz.cast(singular()));
        case "Slack":
            return Optional.ofNullable(clazz.cast(slack()));
        case "Snowflake":
            return Optional.ofNullable(clazz.cast(snowflake()));
        case "Trendmicro":
            return Optional.ofNullable(clazz.cast(trendmicro()));
        case "Veeva":
            return Optional.ofNullable(clazz.cast(veeva()));
        case "Zendesk":
            return Optional.ofNullable(clazz.cast(zendesk()));
        case "SAPOData":
            return Optional.ofNullable(clazz.cast(sapoData()));
        case "CustomConnector":
            return Optional.ofNullable(clazz.cast(customConnector()));
        case "Pardot":
            return Optional.ofNullable(clazz.cast(pardot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorProfileCredentials, T> g) {
        return obj -> g.apply((ConnectorProfileCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorProfileCredentials> {
        /**
         * <p>
         * The connector-specific credentials required when using Amplitude.
         * </p>
         * 
         * @param amplitude
         *        The connector-specific credentials required when using Amplitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amplitude(AmplitudeConnectorProfileCredentials amplitude);

        /**
         * <p>
         * The connector-specific credentials required when using Amplitude.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AmplitudeConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link AmplitudeConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmplitudeConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #amplitude(AmplitudeConnectorProfileCredentials)}.
         * 
         * @param amplitude
         *        a consumer that will call methods on {@link AmplitudeConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amplitude(AmplitudeConnectorProfileCredentials)
         */
        default Builder amplitude(Consumer<AmplitudeConnectorProfileCredentials.Builder> amplitude) {
            return amplitude(AmplitudeConnectorProfileCredentials.builder().applyMutation(amplitude).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using Datadog.
         * </p>
         * 
         * @param datadog
         *        The connector-specific credentials required when using Datadog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datadog(DatadogConnectorProfileCredentials datadog);

        /**
         * <p>
         * The connector-specific credentials required when using Datadog.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DatadogConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link DatadogConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatadogConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #datadog(DatadogConnectorProfileCredentials)}.
         * 
         * @param datadog
         *        a consumer that will call methods on {@link DatadogConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datadog(DatadogConnectorProfileCredentials)
         */
        default Builder datadog(Consumer<DatadogConnectorProfileCredentials.Builder> datadog) {
            return datadog(DatadogConnectorProfileCredentials.builder().applyMutation(datadog).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using Dynatrace.
         * </p>
         * 
         * @param dynatrace
         *        The connector-specific credentials required when using Dynatrace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynatrace(DynatraceConnectorProfileCredentials dynatrace);

        /**
         * <p>
         * The connector-specific credentials required when using Dynatrace.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DynatraceConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link DynatraceConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DynatraceConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #dynatrace(DynatraceConnectorProfileCredentials)}.
         * 
         * @param dynatrace
         *        a consumer that will call methods on {@link DynatraceConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynatrace(DynatraceConnectorProfileCredentials)
         */
        default Builder dynatrace(Consumer<DynatraceConnectorProfileCredentials.Builder> dynatrace) {
            return dynatrace(DynatraceConnectorProfileCredentials.builder().applyMutation(dynatrace).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using Google Analytics.
         * </p>
         * 
         * @param googleAnalytics
         *        The connector-specific credentials required when using Google Analytics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder googleAnalytics(GoogleAnalyticsConnectorProfileCredentials googleAnalytics);

        /**
         * <p>
         * The connector-specific credentials required when using Google Analytics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GoogleAnalyticsConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link GoogleAnalyticsConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GoogleAnalyticsConnectorProfileCredentials.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #googleAnalytics(GoogleAnalyticsConnectorProfileCredentials)}.
         * 
         * @param googleAnalytics
         *        a consumer that will call methods on {@link GoogleAnalyticsConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #googleAnalytics(GoogleAnalyticsConnectorProfileCredentials)
         */
        default Builder googleAnalytics(Consumer<GoogleAnalyticsConnectorProfileCredentials.Builder> googleAnalytics) {
            return googleAnalytics(GoogleAnalyticsConnectorProfileCredentials.builder().applyMutation(googleAnalytics).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using Amazon Honeycode.
         * </p>
         * 
         * @param honeycode
         *        The connector-specific credentials required when using Amazon Honeycode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder honeycode(HoneycodeConnectorProfileCredentials honeycode);

        /**
         * <p>
         * The connector-specific credentials required when using Amazon Honeycode.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link HoneycodeConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link HoneycodeConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HoneycodeConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #honeycode(HoneycodeConnectorProfileCredentials)}.
         * 
         * @param honeycode
         *        a consumer that will call methods on {@link HoneycodeConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #honeycode(HoneycodeConnectorProfileCredentials)
         */
        default Builder honeycode(Consumer<HoneycodeConnectorProfileCredentials.Builder> honeycode) {
            return honeycode(HoneycodeConnectorProfileCredentials.builder().applyMutation(honeycode).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using Infor Nexus.
         * </p>
         * 
         * @param inforNexus
         *        The connector-specific credentials required when using Infor Nexus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inforNexus(InforNexusConnectorProfileCredentials inforNexus);

        /**
         * <p>
         * The connector-specific credentials required when using Infor Nexus.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InforNexusConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link InforNexusConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InforNexusConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #inforNexus(InforNexusConnectorProfileCredentials)}.
         * 
         * @param inforNexus
         *        a consumer that will call methods on {@link InforNexusConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inforNexus(InforNexusConnectorProfileCredentials)
         */
        default Builder inforNexus(Consumer<InforNexusConnectorProfileCredentials.Builder> inforNexus) {
            return inforNexus(InforNexusConnectorProfileCredentials.builder().applyMutation(inforNexus).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using Marketo.
         * </p>
         * 
         * @param marketo
         *        The connector-specific credentials required when using Marketo.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketo(MarketoConnectorProfileCredentials marketo);

        /**
         * <p>
         * The connector-specific credentials required when using Marketo.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MarketoConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link MarketoConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MarketoConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #marketo(MarketoConnectorProfileCredentials)}.
         * 
         * @param marketo
         *        a consumer that will call methods on {@link MarketoConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #marketo(MarketoConnectorProfileCredentials)
         */
        default Builder marketo(Consumer<MarketoConnectorProfileCredentials.Builder> marketo) {
            return marketo(MarketoConnectorProfileCredentials.builder().applyMutation(marketo).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using Amazon Redshift.
         * </p>
         * 
         * @param redshift
         *        The connector-specific credentials required when using Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshift(RedshiftConnectorProfileCredentials redshift);

        /**
         * <p>
         * The connector-specific credentials required when using Amazon Redshift.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RedshiftConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link RedshiftConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #redshift(RedshiftConnectorProfileCredentials)}.
         * 
         * @param redshift
         *        a consumer that will call methods on {@link RedshiftConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshift(RedshiftConnectorProfileCredentials)
         */
        default Builder redshift(Consumer<RedshiftConnectorProfileCredentials.Builder> redshift) {
            return redshift(RedshiftConnectorProfileCredentials.builder().applyMutation(redshift).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using Salesforce.
         * </p>
         * 
         * @param salesforce
         *        The connector-specific credentials required when using Salesforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesforce(SalesforceConnectorProfileCredentials salesforce);

        /**
         * <p>
         * The connector-specific credentials required when using Salesforce.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SalesforceConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link SalesforceConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SalesforceConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #salesforce(SalesforceConnectorProfileCredentials)}.
         * 
         * @param salesforce
         *        a consumer that will call methods on {@link SalesforceConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #salesforce(SalesforceConnectorProfileCredentials)
         */
        default Builder salesforce(Consumer<SalesforceConnectorProfileCredentials.Builder> salesforce) {
            return salesforce(SalesforceConnectorProfileCredentials.builder().applyMutation(salesforce).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using ServiceNow.
         * </p>
         * 
         * @param serviceNow
         *        The connector-specific credentials required when using ServiceNow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNow(ServiceNowConnectorProfileCredentials serviceNow);

        /**
         * <p>
         * The connector-specific credentials required when using ServiceNow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServiceNowConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link ServiceNowConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceNowConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceNow(ServiceNowConnectorProfileCredentials)}.
         * 
         * @param serviceNow
         *        a consumer that will call methods on {@link ServiceNowConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceNow(ServiceNowConnectorProfileCredentials)
         */
        default Builder serviceNow(Consumer<ServiceNowConnectorProfileCredentials.Builder> serviceNow) {
            return serviceNow(ServiceNowConnectorProfileCredentials.builder().applyMutation(serviceNow).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using Singular.
         * </p>
         * 
         * @param singular
         *        The connector-specific credentials required when using Singular.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singular(SingularConnectorProfileCredentials singular);

        /**
         * <p>
         * The connector-specific credentials required when using Singular.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SingularConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link SingularConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SingularConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #singular(SingularConnectorProfileCredentials)}.
         * 
         * @param singular
         *        a consumer that will call methods on {@link SingularConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singular(SingularConnectorProfileCredentials)
         */
        default Builder singular(Consumer<SingularConnectorProfileCredentials.Builder> singular) {
            return singular(SingularConnectorProfileCredentials.builder().applyMutation(singular).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using Slack.
         * </p>
         * 
         * @param slack
         *        The connector-specific credentials required when using Slack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slack(SlackConnectorProfileCredentials slack);

        /**
         * <p>
         * The connector-specific credentials required when using Slack.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlackConnectorProfileCredentials.Builder}
         * avoiding the need to create one manually via {@link SlackConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlackConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #slack(SlackConnectorProfileCredentials)}.
         * 
         * @param slack
         *        a consumer that will call methods on {@link SlackConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slack(SlackConnectorProfileCredentials)
         */
        default Builder slack(Consumer<SlackConnectorProfileCredentials.Builder> slack) {
            return slack(SlackConnectorProfileCredentials.builder().applyMutation(slack).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using Snowflake.
         * </p>
         * 
         * @param snowflake
         *        The connector-specific credentials required when using Snowflake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowflake(SnowflakeConnectorProfileCredentials snowflake);

        /**
         * <p>
         * The connector-specific credentials required when using Snowflake.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SnowflakeConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link SnowflakeConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnowflakeConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #snowflake(SnowflakeConnectorProfileCredentials)}.
         * 
         * @param snowflake
         *        a consumer that will call methods on {@link SnowflakeConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snowflake(SnowflakeConnectorProfileCredentials)
         */
        default Builder snowflake(Consumer<SnowflakeConnectorProfileCredentials.Builder> snowflake) {
            return snowflake(SnowflakeConnectorProfileCredentials.builder().applyMutation(snowflake).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using Trend Micro.
         * </p>
         * 
         * @param trendmicro
         *        The connector-specific credentials required when using Trend Micro.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trendmicro(TrendmicroConnectorProfileCredentials trendmicro);

        /**
         * <p>
         * The connector-specific credentials required when using Trend Micro.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TrendmicroConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link TrendmicroConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrendmicroConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #trendmicro(TrendmicroConnectorProfileCredentials)}.
         * 
         * @param trendmicro
         *        a consumer that will call methods on {@link TrendmicroConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trendmicro(TrendmicroConnectorProfileCredentials)
         */
        default Builder trendmicro(Consumer<TrendmicroConnectorProfileCredentials.Builder> trendmicro) {
            return trendmicro(TrendmicroConnectorProfileCredentials.builder().applyMutation(trendmicro).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using Veeva.
         * </p>
         * 
         * @param veeva
         *        The connector-specific credentials required when using Veeva.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder veeva(VeevaConnectorProfileCredentials veeva);

        /**
         * <p>
         * The connector-specific credentials required when using Veeva.
         * </p>
         * This is a convenience method that creates an instance of the {@link VeevaConnectorProfileCredentials.Builder}
         * avoiding the need to create one manually via {@link VeevaConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VeevaConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #veeva(VeevaConnectorProfileCredentials)}.
         * 
         * @param veeva
         *        a consumer that will call methods on {@link VeevaConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #veeva(VeevaConnectorProfileCredentials)
         */
        default Builder veeva(Consumer<VeevaConnectorProfileCredentials.Builder> veeva) {
            return veeva(VeevaConnectorProfileCredentials.builder().applyMutation(veeva).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using Zendesk.
         * </p>
         * 
         * @param zendesk
         *        The connector-specific credentials required when using Zendesk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zendesk(ZendeskConnectorProfileCredentials zendesk);

        /**
         * <p>
         * The connector-specific credentials required when using Zendesk.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ZendeskConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link ZendeskConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ZendeskConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #zendesk(ZendeskConnectorProfileCredentials)}.
         * 
         * @param zendesk
         *        a consumer that will call methods on {@link ZendeskConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zendesk(ZendeskConnectorProfileCredentials)
         */
        default Builder zendesk(Consumer<ZendeskConnectorProfileCredentials.Builder> zendesk) {
            return zendesk(ZendeskConnectorProfileCredentials.builder().applyMutation(zendesk).build());
        }

        /**
         * Sets the value of the SAPOData property for this object.
         *
         * @param sapoData
         *        The new value for the SAPOData property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sapoData(SAPODataConnectorProfileCredentials sapoData);

        /**
         * Sets the value of the SAPOData property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link SAPODataConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link SAPODataConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SAPODataConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #sapoData(SAPODataConnectorProfileCredentials)}.
         * 
         * @param sapoData
         *        a consumer that will call methods on {@link SAPODataConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sapoData(SAPODataConnectorProfileCredentials)
         */
        default Builder sapoData(Consumer<SAPODataConnectorProfileCredentials.Builder> sapoData) {
            return sapoData(SAPODataConnectorProfileCredentials.builder().applyMutation(sapoData).build());
        }

        /**
         * Sets the value of the CustomConnector property for this object.
         *
         * @param customConnector
         *        The new value for the CustomConnector property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customConnector(CustomConnectorProfileCredentials customConnector);

        /**
         * Sets the value of the CustomConnector property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link CustomConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link CustomConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #customConnector(CustomConnectorProfileCredentials)}.
         * 
         * @param customConnector
         *        a consumer that will call methods on {@link CustomConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customConnector(CustomConnectorProfileCredentials)
         */
        default Builder customConnector(Consumer<CustomConnectorProfileCredentials.Builder> customConnector) {
            return customConnector(CustomConnectorProfileCredentials.builder().applyMutation(customConnector).build());
        }

        /**
         * <p>
         * The connector-specific credentials required when using Salesforce Pardot.
         * </p>
         * 
         * @param pardot
         *        The connector-specific credentials required when using Salesforce Pardot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pardot(PardotConnectorProfileCredentials pardot);

        /**
         * <p>
         * The connector-specific credentials required when using Salesforce Pardot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PardotConnectorProfileCredentials.Builder} avoiding the need to create one manually via
         * {@link PardotConnectorProfileCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PardotConnectorProfileCredentials.Builder#build()} is called
         * immediately and its result is passed to {@link #pardot(PardotConnectorProfileCredentials)}.
         * 
         * @param pardot
         *        a consumer that will call methods on {@link PardotConnectorProfileCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pardot(PardotConnectorProfileCredentials)
         */
        default Builder pardot(Consumer<PardotConnectorProfileCredentials.Builder> pardot) {
            return pardot(PardotConnectorProfileCredentials.builder().applyMutation(pardot).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AmplitudeConnectorProfileCredentials amplitude;

        private DatadogConnectorProfileCredentials datadog;

        private DynatraceConnectorProfileCredentials dynatrace;

        private GoogleAnalyticsConnectorProfileCredentials googleAnalytics;

        private HoneycodeConnectorProfileCredentials honeycode;

        private InforNexusConnectorProfileCredentials inforNexus;

        private MarketoConnectorProfileCredentials marketo;

        private RedshiftConnectorProfileCredentials redshift;

        private SalesforceConnectorProfileCredentials salesforce;

        private ServiceNowConnectorProfileCredentials serviceNow;

        private SingularConnectorProfileCredentials singular;

        private SlackConnectorProfileCredentials slack;

        private SnowflakeConnectorProfileCredentials snowflake;

        private TrendmicroConnectorProfileCredentials trendmicro;

        private VeevaConnectorProfileCredentials veeva;

        private ZendeskConnectorProfileCredentials zendesk;

        private SAPODataConnectorProfileCredentials sapoData;

        private CustomConnectorProfileCredentials customConnector;

        private PardotConnectorProfileCredentials pardot;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorProfileCredentials model) {
            amplitude(model.amplitude);
            datadog(model.datadog);
            dynatrace(model.dynatrace);
            googleAnalytics(model.googleAnalytics);
            honeycode(model.honeycode);
            inforNexus(model.inforNexus);
            marketo(model.marketo);
            redshift(model.redshift);
            salesforce(model.salesforce);
            serviceNow(model.serviceNow);
            singular(model.singular);
            slack(model.slack);
            snowflake(model.snowflake);
            trendmicro(model.trendmicro);
            veeva(model.veeva);
            zendesk(model.zendesk);
            sapoData(model.sapoData);
            customConnector(model.customConnector);
            pardot(model.pardot);
        }

        public final AmplitudeConnectorProfileCredentials.Builder getAmplitude() {
            return amplitude != null ? amplitude.toBuilder() : null;
        }

        public final void setAmplitude(AmplitudeConnectorProfileCredentials.BuilderImpl amplitude) {
            this.amplitude = amplitude != null ? amplitude.build() : null;
        }

        @Override
        public final Builder amplitude(AmplitudeConnectorProfileCredentials amplitude) {
            this.amplitude = amplitude;
            return this;
        }

        public final DatadogConnectorProfileCredentials.Builder getDatadog() {
            return datadog != null ? datadog.toBuilder() : null;
        }

        public final void setDatadog(DatadogConnectorProfileCredentials.BuilderImpl datadog) {
            this.datadog = datadog != null ? datadog.build() : null;
        }

        @Override
        public final Builder datadog(DatadogConnectorProfileCredentials datadog) {
            this.datadog = datadog;
            return this;
        }

        public final DynatraceConnectorProfileCredentials.Builder getDynatrace() {
            return dynatrace != null ? dynatrace.toBuilder() : null;
        }

        public final void setDynatrace(DynatraceConnectorProfileCredentials.BuilderImpl dynatrace) {
            this.dynatrace = dynatrace != null ? dynatrace.build() : null;
        }

        @Override
        public final Builder dynatrace(DynatraceConnectorProfileCredentials dynatrace) {
            this.dynatrace = dynatrace;
            return this;
        }

        public final GoogleAnalyticsConnectorProfileCredentials.Builder getGoogleAnalytics() {
            return googleAnalytics != null ? googleAnalytics.toBuilder() : null;
        }

        public final void setGoogleAnalytics(GoogleAnalyticsConnectorProfileCredentials.BuilderImpl googleAnalytics) {
            this.googleAnalytics = googleAnalytics != null ? googleAnalytics.build() : null;
        }

        @Override
        public final Builder googleAnalytics(GoogleAnalyticsConnectorProfileCredentials googleAnalytics) {
            this.googleAnalytics = googleAnalytics;
            return this;
        }

        public final HoneycodeConnectorProfileCredentials.Builder getHoneycode() {
            return honeycode != null ? honeycode.toBuilder() : null;
        }

        public final void setHoneycode(HoneycodeConnectorProfileCredentials.BuilderImpl honeycode) {
            this.honeycode = honeycode != null ? honeycode.build() : null;
        }

        @Override
        public final Builder honeycode(HoneycodeConnectorProfileCredentials honeycode) {
            this.honeycode = honeycode;
            return this;
        }

        public final InforNexusConnectorProfileCredentials.Builder getInforNexus() {
            return inforNexus != null ? inforNexus.toBuilder() : null;
        }

        public final void setInforNexus(InforNexusConnectorProfileCredentials.BuilderImpl inforNexus) {
            this.inforNexus = inforNexus != null ? inforNexus.build() : null;
        }

        @Override
        public final Builder inforNexus(InforNexusConnectorProfileCredentials inforNexus) {
            this.inforNexus = inforNexus;
            return this;
        }

        public final MarketoConnectorProfileCredentials.Builder getMarketo() {
            return marketo != null ? marketo.toBuilder() : null;
        }

        public final void setMarketo(MarketoConnectorProfileCredentials.BuilderImpl marketo) {
            this.marketo = marketo != null ? marketo.build() : null;
        }

        @Override
        public final Builder marketo(MarketoConnectorProfileCredentials marketo) {
            this.marketo = marketo;
            return this;
        }

        public final RedshiftConnectorProfileCredentials.Builder getRedshift() {
            return redshift != null ? redshift.toBuilder() : null;
        }

        public final void setRedshift(RedshiftConnectorProfileCredentials.BuilderImpl redshift) {
            this.redshift = redshift != null ? redshift.build() : null;
        }

        @Override
        public final Builder redshift(RedshiftConnectorProfileCredentials redshift) {
            this.redshift = redshift;
            return this;
        }

        public final SalesforceConnectorProfileCredentials.Builder getSalesforce() {
            return salesforce != null ? salesforce.toBuilder() : null;
        }

        public final void setSalesforce(SalesforceConnectorProfileCredentials.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        @Override
        public final Builder salesforce(SalesforceConnectorProfileCredentials salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final ServiceNowConnectorProfileCredentials.Builder getServiceNow() {
            return serviceNow != null ? serviceNow.toBuilder() : null;
        }

        public final void setServiceNow(ServiceNowConnectorProfileCredentials.BuilderImpl serviceNow) {
            this.serviceNow = serviceNow != null ? serviceNow.build() : null;
        }

        @Override
        public final Builder serviceNow(ServiceNowConnectorProfileCredentials serviceNow) {
            this.serviceNow = serviceNow;
            return this;
        }

        public final SingularConnectorProfileCredentials.Builder getSingular() {
            return singular != null ? singular.toBuilder() : null;
        }

        public final void setSingular(SingularConnectorProfileCredentials.BuilderImpl singular) {
            this.singular = singular != null ? singular.build() : null;
        }

        @Override
        public final Builder singular(SingularConnectorProfileCredentials singular) {
            this.singular = singular;
            return this;
        }

        public final SlackConnectorProfileCredentials.Builder getSlack() {
            return slack != null ? slack.toBuilder() : null;
        }

        public final void setSlack(SlackConnectorProfileCredentials.BuilderImpl slack) {
            this.slack = slack != null ? slack.build() : null;
        }

        @Override
        public final Builder slack(SlackConnectorProfileCredentials slack) {
            this.slack = slack;
            return this;
        }

        public final SnowflakeConnectorProfileCredentials.Builder getSnowflake() {
            return snowflake != null ? snowflake.toBuilder() : null;
        }

        public final void setSnowflake(SnowflakeConnectorProfileCredentials.BuilderImpl snowflake) {
            this.snowflake = snowflake != null ? snowflake.build() : null;
        }

        @Override
        public final Builder snowflake(SnowflakeConnectorProfileCredentials snowflake) {
            this.snowflake = snowflake;
            return this;
        }

        public final TrendmicroConnectorProfileCredentials.Builder getTrendmicro() {
            return trendmicro != null ? trendmicro.toBuilder() : null;
        }

        public final void setTrendmicro(TrendmicroConnectorProfileCredentials.BuilderImpl trendmicro) {
            this.trendmicro = trendmicro != null ? trendmicro.build() : null;
        }

        @Override
        public final Builder trendmicro(TrendmicroConnectorProfileCredentials trendmicro) {
            this.trendmicro = trendmicro;
            return this;
        }

        public final VeevaConnectorProfileCredentials.Builder getVeeva() {
            return veeva != null ? veeva.toBuilder() : null;
        }

        public final void setVeeva(VeevaConnectorProfileCredentials.BuilderImpl veeva) {
            this.veeva = veeva != null ? veeva.build() : null;
        }

        @Override
        public final Builder veeva(VeevaConnectorProfileCredentials veeva) {
            this.veeva = veeva;
            return this;
        }

        public final ZendeskConnectorProfileCredentials.Builder getZendesk() {
            return zendesk != null ? zendesk.toBuilder() : null;
        }

        public final void setZendesk(ZendeskConnectorProfileCredentials.BuilderImpl zendesk) {
            this.zendesk = zendesk != null ? zendesk.build() : null;
        }

        @Override
        public final Builder zendesk(ZendeskConnectorProfileCredentials zendesk) {
            this.zendesk = zendesk;
            return this;
        }

        public final SAPODataConnectorProfileCredentials.Builder getSapoData() {
            return sapoData != null ? sapoData.toBuilder() : null;
        }

        public final void setSapoData(SAPODataConnectorProfileCredentials.BuilderImpl sapoData) {
            this.sapoData = sapoData != null ? sapoData.build() : null;
        }

        @Override
        public final Builder sapoData(SAPODataConnectorProfileCredentials sapoData) {
            this.sapoData = sapoData;
            return this;
        }

        public final CustomConnectorProfileCredentials.Builder getCustomConnector() {
            return customConnector != null ? customConnector.toBuilder() : null;
        }

        public final void setCustomConnector(CustomConnectorProfileCredentials.BuilderImpl customConnector) {
            this.customConnector = customConnector != null ? customConnector.build() : null;
        }

        @Override
        public final Builder customConnector(CustomConnectorProfileCredentials customConnector) {
            this.customConnector = customConnector;
            return this;
        }

        public final PardotConnectorProfileCredentials.Builder getPardot() {
            return pardot != null ? pardot.toBuilder() : null;
        }

        public final void setPardot(PardotConnectorProfileCredentials.BuilderImpl pardot) {
            this.pardot = pardot != null ? pardot.build() : null;
        }

        @Override
        public final Builder pardot(PardotConnectorProfileCredentials pardot) {
            this.pardot = pardot;
            return this;
        }

        @Override
        public ConnectorProfileCredentials build() {
            return new ConnectorProfileCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
