/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The OAuth 2.0 credentials required for OAuth 2.0 authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OAuth2Credentials implements SdkPojo, Serializable,
        ToCopyableBuilder<OAuth2Credentials.Builder, OAuth2Credentials> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientId").getter(getter(OAuth2Credentials::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();

    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientSecret").getter(getter(OAuth2Credentials::clientSecret)).setter(setter(Builder::clientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecret").build()).build();

    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessToken").getter(getter(OAuth2Credentials::accessToken)).setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()).build();

    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("refreshToken").getter(getter(OAuth2Credentials::refreshToken)).setter(setter(Builder::refreshToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()).build();

    private static final SdkField<ConnectorOAuthRequest> O_AUTH_REQUEST_FIELD = SdkField
            .<ConnectorOAuthRequest> builder(MarshallingType.SDK_POJO).memberName("oAuthRequest")
            .getter(getter(OAuth2Credentials::oAuthRequest)).setter(setter(Builder::oAuthRequest))
            .constructor(ConnectorOAuthRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthRequest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            CLIENT_SECRET_FIELD, ACCESS_TOKEN_FIELD, REFRESH_TOKEN_FIELD, O_AUTH_REQUEST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientId;

    private final String clientSecret;

    private final String accessToken;

    private final String refreshToken;

    private final ConnectorOAuthRequest oAuthRequest;

    private OAuth2Credentials(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.accessToken = builder.accessToken;
        this.refreshToken = builder.refreshToken;
        this.oAuthRequest = builder.oAuthRequest;
    }

    /**
     * <p>
     * The identifier for the desired client.
     * </p>
     * 
     * @return The identifier for the desired client.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The client secret used by the OAuth client to authenticate to the authorization server.
     * </p>
     * 
     * @return The client secret used by the OAuth client to authenticate to the authorization server.
     */
    public final String clientSecret() {
        return clientSecret;
    }

    /**
     * <p>
     * The access token used to access the connector on your behalf.
     * </p>
     * 
     * @return The access token used to access the connector on your behalf.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The refresh token used to refresh an expired access token.
     * </p>
     * 
     * @return The refresh token used to refresh an expired access token.
     */
    public final String refreshToken() {
        return refreshToken;
    }

    /**
     * Returns the value of the OAuthRequest property for this object.
     * 
     * @return The value of the OAuthRequest property for this object.
     */
    public final ConnectorOAuthRequest oAuthRequest() {
        return oAuthRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2Credentials)) {
            return false;
        }
        OAuth2Credentials other = (OAuth2Credentials) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(clientSecret(), other.clientSecret())
                && Objects.equals(accessToken(), other.accessToken()) && Objects.equals(refreshToken(), other.refreshToken())
                && Objects.equals(oAuthRequest(), other.oAuthRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OAuth2Credentials").add("ClientId", clientId())
                .add("ClientSecret", clientSecret() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RefreshToken", refreshToken()).add("OAuthRequest", oAuthRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "clientSecret":
            return Optional.ofNullable(clazz.cast(clientSecret()));
        case "accessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "refreshToken":
            return Optional.ofNullable(clazz.cast(refreshToken()));
        case "oAuthRequest":
            return Optional.ofNullable(clazz.cast(oAuthRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OAuth2Credentials, T> g) {
        return obj -> g.apply((OAuth2Credentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OAuth2Credentials> {
        /**
         * <p>
         * The identifier for the desired client.
         * </p>
         * 
         * @param clientId
         *        The identifier for the desired client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The client secret used by the OAuth client to authenticate to the authorization server.
         * </p>
         * 
         * @param clientSecret
         *        The client secret used by the OAuth client to authenticate to the authorization server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecret(String clientSecret);

        /**
         * <p>
         * The access token used to access the connector on your behalf.
         * </p>
         * 
         * @param accessToken
         *        The access token used to access the connector on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The refresh token used to refresh an expired access token.
         * </p>
         * 
         * @param refreshToken
         *        The refresh token used to refresh an expired access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshToken(String refreshToken);

        /**
         * Sets the value of the OAuthRequest property for this object.
         *
         * @param oAuthRequest
         *        The new value for the OAuthRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthRequest(ConnectorOAuthRequest oAuthRequest);

        /**
         * Sets the value of the OAuthRequest property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ConnectorOAuthRequest.Builder} avoiding
         * the need to create one manually via {@link ConnectorOAuthRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectorOAuthRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #oAuthRequest(ConnectorOAuthRequest)}.
         * 
         * @param oAuthRequest
         *        a consumer that will call methods on {@link ConnectorOAuthRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuthRequest(ConnectorOAuthRequest)
         */
        default Builder oAuthRequest(Consumer<ConnectorOAuthRequest.Builder> oAuthRequest) {
            return oAuthRequest(ConnectorOAuthRequest.builder().applyMutation(oAuthRequest).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String clientId;

        private String clientSecret;

        private String accessToken;

        private String refreshToken;

        private ConnectorOAuthRequest oAuthRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2Credentials model) {
            clientId(model.clientId);
            clientSecret(model.clientSecret);
            accessToken(model.accessToken);
            refreshToken(model.refreshToken);
            oAuthRequest(model.oAuthRequest);
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getRefreshToken() {
            return refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final ConnectorOAuthRequest.Builder getOAuthRequest() {
            return oAuthRequest != null ? oAuthRequest.toBuilder() : null;
        }

        public final void setOAuthRequest(ConnectorOAuthRequest.BuilderImpl oAuthRequest) {
            this.oAuthRequest = oAuthRequest != null ? oAuthRequest.build() : null;
        }

        @Override
        public final Builder oAuthRequest(ConnectorOAuthRequest oAuthRequest) {
            this.oAuthRequest = oAuthRequest;
            return this;
        }

        @Override
        public OAuth2Credentials build() {
            return new OAuth2Credentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
