/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector metadata specific to Salesforce.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SalesforceMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<SalesforceMetadata.Builder, SalesforceMetadata> {
    private static final SdkField<List<String>> O_AUTH_SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("oAuthScopes")
            .getter(getter(SalesforceMetadata::oAuthScopes))
            .setter(setter(Builder::oAuthScopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DATA_TRANSFER_APIS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dataTransferApis")
            .getter(getter(SalesforceMetadata::dataTransferApisAsStrings))
            .setter(setter(Builder::dataTransferApisWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTransferApis").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OAUTH2_GRANT_TYPES_SUPPORTED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("oauth2GrantTypesSupported")
            .getter(getter(SalesforceMetadata::oauth2GrantTypesSupportedAsStrings))
            .setter(setter(Builder::oauth2GrantTypesSupportedWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauth2GrantTypesSupported").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(O_AUTH_SCOPES_FIELD,
            DATA_TRANSFER_APIS_FIELD, OAUTH2_GRANT_TYPES_SUPPORTED_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> oAuthScopes;

    private final List<String> dataTransferApis;

    private final List<String> oauth2GrantTypesSupported;

    private SalesforceMetadata(BuilderImpl builder) {
        this.oAuthScopes = builder.oAuthScopes;
        this.dataTransferApis = builder.dataTransferApis;
        this.oauth2GrantTypesSupported = builder.oauth2GrantTypesSupported;
    }

    /**
     * For responses, this returns true if the service returned a value for the OAuthScopes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOAuthScopes() {
        return oAuthScopes != null && !(oAuthScopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The desired authorization scope for the Salesforce account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOAuthScopes} method.
     * </p>
     * 
     * @return The desired authorization scope for the Salesforce account.
     */
    public final List<String> oAuthScopes() {
        return oAuthScopes;
    }

    /**
     * <p>
     * The Salesforce APIs that you can have Amazon AppFlow use when your flows transfers data to or from Salesforce.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataTransferApis} method.
     * </p>
     * 
     * @return The Salesforce APIs that you can have Amazon AppFlow use when your flows transfers data to or from
     *         Salesforce.
     */
    public final List<SalesforceDataTransferApi> dataTransferApis() {
        return SalesforceDataTransferApiListCopier.copyStringToEnum(dataTransferApis);
    }

    /**
     * For responses, this returns true if the service returned a value for the DataTransferApis property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataTransferApis() {
        return dataTransferApis != null && !(dataTransferApis instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Salesforce APIs that you can have Amazon AppFlow use when your flows transfers data to or from Salesforce.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataTransferApis} method.
     * </p>
     * 
     * @return The Salesforce APIs that you can have Amazon AppFlow use when your flows transfers data to or from
     *         Salesforce.
     */
    public final List<String> dataTransferApisAsStrings() {
        return dataTransferApis;
    }

    /**
     * <p>
     * The OAuth 2.0 grant types that Amazon AppFlow can use when it requests an access token from Salesforce. Amazon
     * AppFlow requires an access token each time it attempts to access your Salesforce records.
     * </p>
     * <dl>
     * <dt>AUTHORIZATION_CODE</dt>
     * <dd>
     * <p>
     * Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow
     * receives the authorization code from Salesforce after you log in to your Salesforce account and authorize Amazon
     * AppFlow to access your records.
     * </p>
     * </dd>
     * <dt>JWT_BEARER</dt>
     * <dd>
     * <p>
     * Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide the
     * JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant type,
     * you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.
     * </p>
     * </dd>
     * </dl>
     * <note>
     * <p>
     * The CLIENT_CREDENTIALS value is not supported for Salesforce.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOauth2GrantTypesSupported} method.
     * </p>
     * 
     * @return The OAuth 2.0 grant types that Amazon AppFlow can use when it requests an access token from Salesforce.
     *         Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.</p>
     *         <dl>
     *         <dt>AUTHORIZATION_CODE</dt>
     *         <dd>
     *         <p>
     *         Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon
     *         AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account and
     *         authorize Amazon AppFlow to access your records.
     *         </p>
     *         </dd>
     *         <dt>JWT_BEARER</dt>
     *         <dd>
     *         <p>
     *         Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You
     *         provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use
     *         this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to
     *         access your records.
     *         </p>
     *         </dd>
     *         </dl>
     *         <note>
     *         <p>
     *         The CLIENT_CREDENTIALS value is not supported for Salesforce.
     *         </p>
     */
    public final List<OAuth2GrantType> oauth2GrantTypesSupported() {
        return OAuth2GrantTypeSupportedListCopier.copyStringToEnum(oauth2GrantTypesSupported);
    }

    /**
     * For responses, this returns true if the service returned a value for the Oauth2GrantTypesSupported property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOauth2GrantTypesSupported() {
        return oauth2GrantTypesSupported != null && !(oauth2GrantTypesSupported instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The OAuth 2.0 grant types that Amazon AppFlow can use when it requests an access token from Salesforce. Amazon
     * AppFlow requires an access token each time it attempts to access your Salesforce records.
     * </p>
     * <dl>
     * <dt>AUTHORIZATION_CODE</dt>
     * <dd>
     * <p>
     * Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow
     * receives the authorization code from Salesforce after you log in to your Salesforce account and authorize Amazon
     * AppFlow to access your records.
     * </p>
     * </dd>
     * <dt>JWT_BEARER</dt>
     * <dd>
     * <p>
     * Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide the
     * JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant type,
     * you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.
     * </p>
     * </dd>
     * </dl>
     * <note>
     * <p>
     * The CLIENT_CREDENTIALS value is not supported for Salesforce.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOauth2GrantTypesSupported} method.
     * </p>
     * 
     * @return The OAuth 2.0 grant types that Amazon AppFlow can use when it requests an access token from Salesforce.
     *         Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.</p>
     *         <dl>
     *         <dt>AUTHORIZATION_CODE</dt>
     *         <dd>
     *         <p>
     *         Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon
     *         AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account and
     *         authorize Amazon AppFlow to access your records.
     *         </p>
     *         </dd>
     *         <dt>JWT_BEARER</dt>
     *         <dd>
     *         <p>
     *         Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You
     *         provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use
     *         this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to
     *         access your records.
     *         </p>
     *         </dd>
     *         </dl>
     *         <note>
     *         <p>
     *         The CLIENT_CREDENTIALS value is not supported for Salesforce.
     *         </p>
     */
    public final List<String> oauth2GrantTypesSupportedAsStrings() {
        return oauth2GrantTypesSupported;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOAuthScopes() ? oAuthScopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataTransferApis() ? dataTransferApisAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOauth2GrantTypesSupported() ? oauth2GrantTypesSupportedAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceMetadata)) {
            return false;
        }
        SalesforceMetadata other = (SalesforceMetadata) obj;
        return hasOAuthScopes() == other.hasOAuthScopes() && Objects.equals(oAuthScopes(), other.oAuthScopes())
                && hasDataTransferApis() == other.hasDataTransferApis()
                && Objects.equals(dataTransferApisAsStrings(), other.dataTransferApisAsStrings())
                && hasOauth2GrantTypesSupported() == other.hasOauth2GrantTypesSupported()
                && Objects.equals(oauth2GrantTypesSupportedAsStrings(), other.oauth2GrantTypesSupportedAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SalesforceMetadata").add("OAuthScopes", hasOAuthScopes() ? oAuthScopes() : null)
                .add("DataTransferApis", hasDataTransferApis() ? dataTransferApisAsStrings() : null)
                .add("Oauth2GrantTypesSupported", hasOauth2GrantTypesSupported() ? oauth2GrantTypesSupportedAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "oAuthScopes":
            return Optional.ofNullable(clazz.cast(oAuthScopes()));
        case "dataTransferApis":
            return Optional.ofNullable(clazz.cast(dataTransferApisAsStrings()));
        case "oauth2GrantTypesSupported":
            return Optional.ofNullable(clazz.cast(oauth2GrantTypesSupportedAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceMetadata, T> g) {
        return obj -> g.apply((SalesforceMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SalesforceMetadata> {
        /**
         * <p>
         * The desired authorization scope for the Salesforce account.
         * </p>
         * 
         * @param oAuthScopes
         *        The desired authorization scope for the Salesforce account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthScopes(Collection<String> oAuthScopes);

        /**
         * <p>
         * The desired authorization scope for the Salesforce account.
         * </p>
         * 
         * @param oAuthScopes
         *        The desired authorization scope for the Salesforce account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthScopes(String... oAuthScopes);

        /**
         * <p>
         * The Salesforce APIs that you can have Amazon AppFlow use when your flows transfers data to or from
         * Salesforce.
         * </p>
         * 
         * @param dataTransferApis
         *        The Salesforce APIs that you can have Amazon AppFlow use when your flows transfers data to or from
         *        Salesforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferApisWithStrings(Collection<String> dataTransferApis);

        /**
         * <p>
         * The Salesforce APIs that you can have Amazon AppFlow use when your flows transfers data to or from
         * Salesforce.
         * </p>
         * 
         * @param dataTransferApis
         *        The Salesforce APIs that you can have Amazon AppFlow use when your flows transfers data to or from
         *        Salesforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferApisWithStrings(String... dataTransferApis);

        /**
         * <p>
         * The Salesforce APIs that you can have Amazon AppFlow use when your flows transfers data to or from
         * Salesforce.
         * </p>
         * 
         * @param dataTransferApis
         *        The Salesforce APIs that you can have Amazon AppFlow use when your flows transfers data to or from
         *        Salesforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferApis(Collection<SalesforceDataTransferApi> dataTransferApis);

        /**
         * <p>
         * The Salesforce APIs that you can have Amazon AppFlow use when your flows transfers data to or from
         * Salesforce.
         * </p>
         * 
         * @param dataTransferApis
         *        The Salesforce APIs that you can have Amazon AppFlow use when your flows transfers data to or from
         *        Salesforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferApis(SalesforceDataTransferApi... dataTransferApis);

        /**
         * <p>
         * The OAuth 2.0 grant types that Amazon AppFlow can use when it requests an access token from Salesforce.
         * Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.
         * </p>
         * <dl>
         * <dt>AUTHORIZATION_CODE</dt>
         * <dd>
         * <p>
         * Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow
         * receives the authorization code from Salesforce after you log in to your Salesforce account and authorize
         * Amazon AppFlow to access your records.
         * </p>
         * </dd>
         * <dt>JWT_BEARER</dt>
         * <dd>
         * <p>
         * Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide
         * the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant
         * type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.
         * </p>
         * </dd>
         * </dl>
         * <note>
         * <p>
         * The CLIENT_CREDENTIALS value is not supported for Salesforce.
         * </p>
         * </note>
         * 
         * @param oauth2GrantTypesSupported
         *        The OAuth 2.0 grant types that Amazon AppFlow can use when it requests an access token from
         *        Salesforce. Amazon AppFlow requires an access token each time it attempts to access your Salesforce
         *        records.</p>
         *        <dl>
         *        <dt>AUTHORIZATION_CODE</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon
         *        AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account
         *        and authorize Amazon AppFlow to access your records.
         *        </p>
         *        </dd>
         *        <dt>JWT_BEARER</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You
         *        provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you
         *        use this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow
         *        to access your records.
         *        </p>
         *        </dd>
         *        </dl>
         *        <note>
         *        <p>
         *        The CLIENT_CREDENTIALS value is not supported for Salesforce.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauth2GrantTypesSupportedWithStrings(Collection<String> oauth2GrantTypesSupported);

        /**
         * <p>
         * The OAuth 2.0 grant types that Amazon AppFlow can use when it requests an access token from Salesforce.
         * Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.
         * </p>
         * <dl>
         * <dt>AUTHORIZATION_CODE</dt>
         * <dd>
         * <p>
         * Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow
         * receives the authorization code from Salesforce after you log in to your Salesforce account and authorize
         * Amazon AppFlow to access your records.
         * </p>
         * </dd>
         * <dt>JWT_BEARER</dt>
         * <dd>
         * <p>
         * Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide
         * the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant
         * type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.
         * </p>
         * </dd>
         * </dl>
         * <note>
         * <p>
         * The CLIENT_CREDENTIALS value is not supported for Salesforce.
         * </p>
         * </note>
         * 
         * @param oauth2GrantTypesSupported
         *        The OAuth 2.0 grant types that Amazon AppFlow can use when it requests an access token from
         *        Salesforce. Amazon AppFlow requires an access token each time it attempts to access your Salesforce
         *        records.</p>
         *        <dl>
         *        <dt>AUTHORIZATION_CODE</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon
         *        AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account
         *        and authorize Amazon AppFlow to access your records.
         *        </p>
         *        </dd>
         *        <dt>JWT_BEARER</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You
         *        provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you
         *        use this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow
         *        to access your records.
         *        </p>
         *        </dd>
         *        </dl>
         *        <note>
         *        <p>
         *        The CLIENT_CREDENTIALS value is not supported for Salesforce.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauth2GrantTypesSupportedWithStrings(String... oauth2GrantTypesSupported);

        /**
         * <p>
         * The OAuth 2.0 grant types that Amazon AppFlow can use when it requests an access token from Salesforce.
         * Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.
         * </p>
         * <dl>
         * <dt>AUTHORIZATION_CODE</dt>
         * <dd>
         * <p>
         * Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow
         * receives the authorization code from Salesforce after you log in to your Salesforce account and authorize
         * Amazon AppFlow to access your records.
         * </p>
         * </dd>
         * <dt>JWT_BEARER</dt>
         * <dd>
         * <p>
         * Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide
         * the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant
         * type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.
         * </p>
         * </dd>
         * </dl>
         * <note>
         * <p>
         * The CLIENT_CREDENTIALS value is not supported for Salesforce.
         * </p>
         * </note>
         * 
         * @param oauth2GrantTypesSupported
         *        The OAuth 2.0 grant types that Amazon AppFlow can use when it requests an access token from
         *        Salesforce. Amazon AppFlow requires an access token each time it attempts to access your Salesforce
         *        records.</p>
         *        <dl>
         *        <dt>AUTHORIZATION_CODE</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon
         *        AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account
         *        and authorize Amazon AppFlow to access your records.
         *        </p>
         *        </dd>
         *        <dt>JWT_BEARER</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You
         *        provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you
         *        use this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow
         *        to access your records.
         *        </p>
         *        </dd>
         *        </dl>
         *        <note>
         *        <p>
         *        The CLIENT_CREDENTIALS value is not supported for Salesforce.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauth2GrantTypesSupported(Collection<OAuth2GrantType> oauth2GrantTypesSupported);

        /**
         * <p>
         * The OAuth 2.0 grant types that Amazon AppFlow can use when it requests an access token from Salesforce.
         * Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.
         * </p>
         * <dl>
         * <dt>AUTHORIZATION_CODE</dt>
         * <dd>
         * <p>
         * Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow
         * receives the authorization code from Salesforce after you log in to your Salesforce account and authorize
         * Amazon AppFlow to access your records.
         * </p>
         * </dd>
         * <dt>JWT_BEARER</dt>
         * <dd>
         * <p>
         * Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide
         * the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant
         * type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.
         * </p>
         * </dd>
         * </dl>
         * <note>
         * <p>
         * The CLIENT_CREDENTIALS value is not supported for Salesforce.
         * </p>
         * </note>
         * 
         * @param oauth2GrantTypesSupported
         *        The OAuth 2.0 grant types that Amazon AppFlow can use when it requests an access token from
         *        Salesforce. Amazon AppFlow requires an access token each time it attempts to access your Salesforce
         *        records.</p>
         *        <dl>
         *        <dt>AUTHORIZATION_CODE</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon
         *        AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account
         *        and authorize Amazon AppFlow to access your records.
         *        </p>
         *        </dd>
         *        <dt>JWT_BEARER</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You
         *        provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you
         *        use this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow
         *        to access your records.
         *        </p>
         *        </dd>
         *        </dl>
         *        <note>
         *        <p>
         *        The CLIENT_CREDENTIALS value is not supported for Salesforce.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauth2GrantTypesSupported(OAuth2GrantType... oauth2GrantTypesSupported);
    }

    static final class BuilderImpl implements Builder {
        private List<String> oAuthScopes = DefaultSdkAutoConstructList.getInstance();

        private List<String> dataTransferApis = DefaultSdkAutoConstructList.getInstance();

        private List<String> oauth2GrantTypesSupported = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceMetadata model) {
            oAuthScopes(model.oAuthScopes);
            dataTransferApisWithStrings(model.dataTransferApis);
            oauth2GrantTypesSupportedWithStrings(model.oauth2GrantTypesSupported);
        }

        public final Collection<String> getOAuthScopes() {
            if (oAuthScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return oAuthScopes;
        }

        public final void setOAuthScopes(Collection<String> oAuthScopes) {
            this.oAuthScopes = OAuthScopeListCopier.copy(oAuthScopes);
        }

        @Override
        public final Builder oAuthScopes(Collection<String> oAuthScopes) {
            this.oAuthScopes = OAuthScopeListCopier.copy(oAuthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oAuthScopes(String... oAuthScopes) {
            oAuthScopes(Arrays.asList(oAuthScopes));
            return this;
        }

        public final Collection<String> getDataTransferApis() {
            if (dataTransferApis instanceof SdkAutoConstructList) {
                return null;
            }
            return dataTransferApis;
        }

        public final void setDataTransferApis(Collection<String> dataTransferApis) {
            this.dataTransferApis = SalesforceDataTransferApiListCopier.copy(dataTransferApis);
        }

        @Override
        public final Builder dataTransferApisWithStrings(Collection<String> dataTransferApis) {
            this.dataTransferApis = SalesforceDataTransferApiListCopier.copy(dataTransferApis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataTransferApisWithStrings(String... dataTransferApis) {
            dataTransferApisWithStrings(Arrays.asList(dataTransferApis));
            return this;
        }

        @Override
        public final Builder dataTransferApis(Collection<SalesforceDataTransferApi> dataTransferApis) {
            this.dataTransferApis = SalesforceDataTransferApiListCopier.copyEnumToString(dataTransferApis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataTransferApis(SalesforceDataTransferApi... dataTransferApis) {
            dataTransferApis(Arrays.asList(dataTransferApis));
            return this;
        }

        public final Collection<String> getOauth2GrantTypesSupported() {
            if (oauth2GrantTypesSupported instanceof SdkAutoConstructList) {
                return null;
            }
            return oauth2GrantTypesSupported;
        }

        public final void setOauth2GrantTypesSupported(Collection<String> oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupported = OAuth2GrantTypeSupportedListCopier.copy(oauth2GrantTypesSupported);
        }

        @Override
        public final Builder oauth2GrantTypesSupportedWithStrings(Collection<String> oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupported = OAuth2GrantTypeSupportedListCopier.copy(oauth2GrantTypesSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oauth2GrantTypesSupportedWithStrings(String... oauth2GrantTypesSupported) {
            oauth2GrantTypesSupportedWithStrings(Arrays.asList(oauth2GrantTypesSupported));
            return this;
        }

        @Override
        public final Builder oauth2GrantTypesSupported(Collection<OAuth2GrantType> oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupported = OAuth2GrantTypeSupportedListCopier.copyEnumToString(oauth2GrantTypesSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oauth2GrantTypesSupported(OAuth2GrantType... oauth2GrantTypesSupported) {
            oauth2GrantTypesSupported(Arrays.asList(oauth2GrantTypesSupported));
            return this;
        }

        @Override
        public SalesforceMetadata build() {
            return new SalesforceMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
