/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo,
 * Zendesk, and Slack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorOAuthRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorOAuthRequest.Builder, ConnectorOAuthRequest> {
    private static final SdkField<String> AUTH_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authCode").getter(getter(ConnectorOAuthRequest::authCode)).setter(setter(Builder::authCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authCode").build()).build();

    private static final SdkField<String> REDIRECT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("redirectUri").getter(getter(ConnectorOAuthRequest::redirectUri)).setter(setter(Builder::redirectUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_CODE_FIELD,
            REDIRECT_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String authCode;

    private final String redirectUri;

    private ConnectorOAuthRequest(BuilderImpl builder) {
        this.authCode = builder.authCode;
        this.redirectUri = builder.redirectUri;
    }

    /**
     * <p>
     * The code provided by the connector when it has been authenticated via the connected app.
     * </p>
     * 
     * @return The code provided by the connector when it has been authenticated via the connected app.
     */
    public final String authCode() {
        return authCode;
    }

    /**
     * <p>
     * The URL to which the authentication server redirects the browser after authorization has been granted.
     * </p>
     * 
     * @return The URL to which the authentication server redirects the browser after authorization has been granted.
     */
    public final String redirectUri() {
        return redirectUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authCode());
        hashCode = 31 * hashCode + Objects.hashCode(redirectUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorOAuthRequest)) {
            return false;
        }
        ConnectorOAuthRequest other = (ConnectorOAuthRequest) obj;
        return Objects.equals(authCode(), other.authCode()) && Objects.equals(redirectUri(), other.redirectUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorOAuthRequest").add("AuthCode", authCode()).add("RedirectUri", redirectUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authCode":
            return Optional.ofNullable(clazz.cast(authCode()));
        case "redirectUri":
            return Optional.ofNullable(clazz.cast(redirectUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorOAuthRequest, T> g) {
        return obj -> g.apply((ConnectorOAuthRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorOAuthRequest> {
        /**
         * <p>
         * The code provided by the connector when it has been authenticated via the connected app.
         * </p>
         * 
         * @param authCode
         *        The code provided by the connector when it has been authenticated via the connected app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authCode(String authCode);

        /**
         * <p>
         * The URL to which the authentication server redirects the browser after authorization has been granted.
         * </p>
         * 
         * @param redirectUri
         *        The URL to which the authentication server redirects the browser after authorization has been granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectUri(String redirectUri);
    }

    static final class BuilderImpl implements Builder {
        private String authCode;

        private String redirectUri;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorOAuthRequest model) {
            authCode(model.authCode);
            redirectUri(model.redirectUri);
        }

        public final String getAuthCode() {
            return authCode;
        }

        public final void setAuthCode(String authCode) {
            this.authCode = authCode;
        }

        @Override
        public final Builder authCode(String authCode) {
            this.authCode = authCode;
            return this;
        }

        public final String getRedirectUri() {
            return redirectUri;
        }

        public final void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Override
        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        @Override
        public ConnectorOAuthRequest build() {
            return new ConnectorOAuthRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
