/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific credentials required when using Amazon Honeycode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HoneycodeConnectorProfileCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<HoneycodeConnectorProfileCredentials.Builder, HoneycodeConnectorProfileCredentials> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessToken").getter(getter(HoneycodeConnectorProfileCredentials::accessToken))
            .setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()).build();

    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("refreshToken").getter(getter(HoneycodeConnectorProfileCredentials::refreshToken))
            .setter(setter(Builder::refreshToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()).build();

    private static final SdkField<ConnectorOAuthRequest> O_AUTH_REQUEST_FIELD = SdkField
            .<ConnectorOAuthRequest> builder(MarshallingType.SDK_POJO).memberName("oAuthRequest")
            .getter(getter(HoneycodeConnectorProfileCredentials::oAuthRequest)).setter(setter(Builder::oAuthRequest))
            .constructor(ConnectorOAuthRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthRequest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            REFRESH_TOKEN_FIELD, O_AUTH_REQUEST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accessToken;

    private final String refreshToken;

    private final ConnectorOAuthRequest oAuthRequest;

    private HoneycodeConnectorProfileCredentials(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.refreshToken = builder.refreshToken;
        this.oAuthRequest = builder.oAuthRequest;
    }

    /**
     * <p>
     * The credentials used to access protected Amazon Honeycode resources.
     * </p>
     * 
     * @return The credentials used to access protected Amazon Honeycode resources.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The credentials used to acquire new access tokens.
     * </p>
     * 
     * @return The credentials used to acquire new access tokens.
     */
    public final String refreshToken() {
        return refreshToken;
    }

    /**
     * Returns the value of the OAuthRequest property for this object.
     * 
     * @return The value of the OAuthRequest property for this object.
     */
    public final ConnectorOAuthRequest oAuthRequest() {
        return oAuthRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HoneycodeConnectorProfileCredentials)) {
            return false;
        }
        HoneycodeConnectorProfileCredentials other = (HoneycodeConnectorProfileCredentials) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(refreshToken(), other.refreshToken())
                && Objects.equals(oAuthRequest(), other.oAuthRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HoneycodeConnectorProfileCredentials")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RefreshToken", refreshToken()).add("OAuthRequest", oAuthRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "refreshToken":
            return Optional.ofNullable(clazz.cast(refreshToken()));
        case "oAuthRequest":
            return Optional.ofNullable(clazz.cast(oAuthRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HoneycodeConnectorProfileCredentials, T> g) {
        return obj -> g.apply((HoneycodeConnectorProfileCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HoneycodeConnectorProfileCredentials> {
        /**
         * <p>
         * The credentials used to access protected Amazon Honeycode resources.
         * </p>
         * 
         * @param accessToken
         *        The credentials used to access protected Amazon Honeycode resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The credentials used to acquire new access tokens.
         * </p>
         * 
         * @param refreshToken
         *        The credentials used to acquire new access tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshToken(String refreshToken);

        /**
         * Sets the value of the OAuthRequest property for this object.
         *
         * @param oAuthRequest
         *        The new value for the OAuthRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthRequest(ConnectorOAuthRequest oAuthRequest);

        /**
         * Sets the value of the OAuthRequest property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ConnectorOAuthRequest.Builder} avoiding
         * the need to create one manually via {@link ConnectorOAuthRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectorOAuthRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #oAuthRequest(ConnectorOAuthRequest)}.
         * 
         * @param oAuthRequest
         *        a consumer that will call methods on {@link ConnectorOAuthRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuthRequest(ConnectorOAuthRequest)
         */
        default Builder oAuthRequest(Consumer<ConnectorOAuthRequest.Builder> oAuthRequest) {
            return oAuthRequest(ConnectorOAuthRequest.builder().applyMutation(oAuthRequest).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accessToken;

        private String refreshToken;

        private ConnectorOAuthRequest oAuthRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(HoneycodeConnectorProfileCredentials model) {
            accessToken(model.accessToken);
            refreshToken(model.refreshToken);
            oAuthRequest(model.oAuthRequest);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getRefreshToken() {
            return refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final ConnectorOAuthRequest.Builder getOAuthRequest() {
            return oAuthRequest != null ? oAuthRequest.toBuilder() : null;
        }

        public final void setOAuthRequest(ConnectorOAuthRequest.BuilderImpl oAuthRequest) {
            this.oAuthRequest = oAuthRequest != null ? oAuthRequest.build() : null;
        }

        @Override
        public final Builder oAuthRequest(ConnectorOAuthRequest oAuthRequest) {
            this.oAuthRequest = oAuthRequest;
            return this;
        }

        @Override
        public HoneycodeConnectorProfileCredentials build() {
            return new HoneycodeConnectorProfileCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
