/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class OAuth2CustomPropertiesListCopier {
    static List<OAuth2CustomParameter> copy(Collection<? extends OAuth2CustomParameter> oAuth2CustomPropertiesListParam) {
        List<OAuth2CustomParameter> list;
        if (oAuth2CustomPropertiesListParam == null || oAuth2CustomPropertiesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<OAuth2CustomParameter> modifiableList = new ArrayList<>(oAuth2CustomPropertiesListParam.size());
            oAuth2CustomPropertiesListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<OAuth2CustomParameter> copyFromBuilder(
            Collection<? extends OAuth2CustomParameter.Builder> oAuth2CustomPropertiesListParam) {
        List<OAuth2CustomParameter> list;
        if (oAuth2CustomPropertiesListParam == null || oAuth2CustomPropertiesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<OAuth2CustomParameter> modifiableList = new ArrayList<>(oAuth2CustomPropertiesListParam.size());
            oAuth2CustomPropertiesListParam.forEach(entry -> {
                OAuth2CustomParameter member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<OAuth2CustomParameter.Builder> copyToBuilder(
            Collection<? extends OAuth2CustomParameter> oAuth2CustomPropertiesListParam) {
        List<OAuth2CustomParameter.Builder> list;
        if (oAuth2CustomPropertiesListParam == null || oAuth2CustomPropertiesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<OAuth2CustomParameter.Builder> modifiableList = new ArrayList<>(oAuth2CustomPropertiesListParam.size());
            oAuth2CustomPropertiesListParam.forEach(entry -> {
                OAuth2CustomParameter.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
