/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific profile properties when using Amazon Redshift.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftConnectorProfileProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftConnectorProfileProperties.Builder, RedshiftConnectorProfileProperties> {
    private static final SdkField<String> DATABASE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseUrl").getter(getter(RedshiftConnectorProfileProperties::databaseUrl))
            .setter(setter(Builder::databaseUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseUrl").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(RedshiftConnectorProfileProperties::bucketName))
            .setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketPrefix").getter(getter(RedshiftConnectorProfileProperties::bucketPrefix))
            .setter(setter(Builder::bucketPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPrefix").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(RedshiftConnectorProfileProperties::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> DATA_API_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataApiRoleArn").getter(getter(RedshiftConnectorProfileProperties::dataApiRoleArn))
            .setter(setter(Builder::dataApiRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataApiRoleArn").build()).build();

    private static final SdkField<Boolean> IS_REDSHIFT_SERVERLESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isRedshiftServerless").getter(getter(RedshiftConnectorProfileProperties::isRedshiftServerless))
            .setter(setter(Builder::isRedshiftServerless))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRedshiftServerless").build())
            .build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterIdentifier").getter(getter(RedshiftConnectorProfileProperties::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterIdentifier").build()).build();

    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupName").getter(getter(RedshiftConnectorProfileProperties::workgroupName))
            .setter(setter(Builder::workgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(RedshiftConnectorProfileProperties::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_URL_FIELD,
            BUCKET_NAME_FIELD, BUCKET_PREFIX_FIELD, ROLE_ARN_FIELD, DATA_API_ROLE_ARN_FIELD, IS_REDSHIFT_SERVERLESS_FIELD,
            CLUSTER_IDENTIFIER_FIELD, WORKGROUP_NAME_FIELD, DATABASE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String databaseUrl;

    private final String bucketName;

    private final String bucketPrefix;

    private final String roleArn;

    private final String dataApiRoleArn;

    private final Boolean isRedshiftServerless;

    private final String clusterIdentifier;

    private final String workgroupName;

    private final String databaseName;

    private RedshiftConnectorProfileProperties(BuilderImpl builder) {
        this.databaseUrl = builder.databaseUrl;
        this.bucketName = builder.bucketName;
        this.bucketPrefix = builder.bucketPrefix;
        this.roleArn = builder.roleArn;
        this.dataApiRoleArn = builder.dataApiRoleArn;
        this.isRedshiftServerless = builder.isRedshiftServerless;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.workgroupName = builder.workgroupName;
        this.databaseName = builder.databaseName;
    }

    /**
     * <p>
     * The JDBC URL of the Amazon Redshift cluster.
     * </p>
     * 
     * @return The JDBC URL of the Amazon Redshift cluster.
     */
    public final String databaseUrl() {
        return databaseUrl;
    }

    /**
     * <p>
     * A name for the associated Amazon S3 bucket.
     * </p>
     * 
     * @return A name for the associated Amazon S3 bucket.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The object key for the destination bucket in which Amazon AppFlow places the files.
     * </p>
     * 
     * @return The object key for the destination bucket in which Amazon AppFlow places the files.
     */
    public final String bucketPrefix() {
        return bucketPrefix;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of IAM role that grants Amazon Redshift read-only access to Amazon S3. For more
     * information, and for the polices that you attach to this role, see <a href=
     * "https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#redshift-access-s3"
     * >Allow Amazon Redshift to access your Amazon AppFlow data in Amazon S3</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of IAM role that grants Amazon Redshift read-only access to Amazon S3. For
     *         more information, and for the polices that you attach to this role, see <a href=
     *         "https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#redshift-access-s3"
     *         >Allow Amazon Redshift to access your Amazon AppFlow data in Amazon S3</a>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that permits Amazon AppFlow to access your Amazon Redshift database
     * through the Data API. For more information, and for the polices that you attach to this role, see <a href=
     * "https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#access-redshift"
     * >Allow Amazon AppFlow to access Amazon Redshift databases with the Data API</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that permits Amazon AppFlow to access your Amazon Redshift
     *         database through the Data API. For more information, and for the polices that you attach to this role,
     *         see <a href=
     *         "https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#access-redshift"
     *         >Allow Amazon AppFlow to access Amazon Redshift databases with the Data API</a>.
     */
    public final String dataApiRoleArn() {
        return dataApiRoleArn;
    }

    /**
     * <p>
     * Indicates whether the connector profile defines a connection to an Amazon Redshift Serverless data warehouse.
     * </p>
     * 
     * @return Indicates whether the connector profile defines a connection to an Amazon Redshift Serverless data
     *         warehouse.
     */
    public final Boolean isRedshiftServerless() {
        return isRedshiftServerless;
    }

    /**
     * <p>
     * The unique ID that's assigned to an Amazon Redshift cluster.
     * </p>
     * 
     * @return The unique ID that's assigned to an Amazon Redshift cluster.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The name of an Amazon Redshift workgroup.
     * </p>
     * 
     * @return The name of an Amazon Redshift workgroup.
     */
    public final String workgroupName() {
        return workgroupName;
    }

    /**
     * <p>
     * The name of an Amazon Redshift database.
     * </p>
     * 
     * @return The name of an Amazon Redshift database.
     */
    public final String databaseName() {
        return databaseName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataApiRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(isRedshiftServerless());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftConnectorProfileProperties)) {
            return false;
        }
        RedshiftConnectorProfileProperties other = (RedshiftConnectorProfileProperties) obj;
        return Objects.equals(databaseUrl(), other.databaseUrl()) && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(bucketPrefix(), other.bucketPrefix()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(dataApiRoleArn(), other.dataApiRoleArn())
                && Objects.equals(isRedshiftServerless(), other.isRedshiftServerless())
                && Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(workgroupName(), other.workgroupName()) && Objects.equals(databaseName(), other.databaseName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftConnectorProfileProperties").add("DatabaseUrl", databaseUrl())
                .add("BucketName", bucketName()).add("BucketPrefix", bucketPrefix()).add("RoleArn", roleArn())
                .add("DataApiRoleArn", dataApiRoleArn()).add("IsRedshiftServerless", isRedshiftServerless())
                .add("ClusterIdentifier", clusterIdentifier()).add("WorkgroupName", workgroupName())
                .add("DatabaseName", databaseName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "databaseUrl":
            return Optional.ofNullable(clazz.cast(databaseUrl()));
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "bucketPrefix":
            return Optional.ofNullable(clazz.cast(bucketPrefix()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "dataApiRoleArn":
            return Optional.ofNullable(clazz.cast(dataApiRoleArn()));
        case "isRedshiftServerless":
            return Optional.ofNullable(clazz.cast(isRedshiftServerless()));
        case "clusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "workgroupName":
            return Optional.ofNullable(clazz.cast(workgroupName()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftConnectorProfileProperties, T> g) {
        return obj -> g.apply((RedshiftConnectorProfileProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftConnectorProfileProperties> {
        /**
         * <p>
         * The JDBC URL of the Amazon Redshift cluster.
         * </p>
         * 
         * @param databaseUrl
         *        The JDBC URL of the Amazon Redshift cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseUrl(String databaseUrl);

        /**
         * <p>
         * A name for the associated Amazon S3 bucket.
         * </p>
         * 
         * @param bucketName
         *        A name for the associated Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The object key for the destination bucket in which Amazon AppFlow places the files.
         * </p>
         * 
         * @param bucketPrefix
         *        The object key for the destination bucket in which Amazon AppFlow places the files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketPrefix(String bucketPrefix);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of IAM role that grants Amazon Redshift read-only access to Amazon S3. For
         * more information, and for the polices that you attach to this role, see <a href=
         * "https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#redshift-access-s3"
         * >Allow Amazon Redshift to access your Amazon AppFlow data in Amazon S3</a>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of IAM role that grants Amazon Redshift read-only access to Amazon S3.
         *        For more information, and for the polices that you attach to this role, see <a href=
         *        "https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#redshift-access-s3"
         *        >Allow Amazon Redshift to access your Amazon AppFlow data in Amazon S3</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that permits Amazon AppFlow to access your Amazon Redshift
         * database through the Data API. For more information, and for the polices that you attach to this role, see <a
         * href=
         * "https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#access-redshift"
         * >Allow Amazon AppFlow to access Amazon Redshift databases with the Data API</a>.
         * </p>
         * 
         * @param dataApiRoleArn
         *        The Amazon Resource Name (ARN) of an IAM role that permits Amazon AppFlow to access your Amazon
         *        Redshift database through the Data API. For more information, and for the polices that you attach to
         *        this role, see <a href=
         *        "https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#access-redshift"
         *        >Allow Amazon AppFlow to access Amazon Redshift databases with the Data API</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataApiRoleArn(String dataApiRoleArn);

        /**
         * <p>
         * Indicates whether the connector profile defines a connection to an Amazon Redshift Serverless data warehouse.
         * </p>
         * 
         * @param isRedshiftServerless
         *        Indicates whether the connector profile defines a connection to an Amazon Redshift Serverless data
         *        warehouse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRedshiftServerless(Boolean isRedshiftServerless);

        /**
         * <p>
         * The unique ID that's assigned to an Amazon Redshift cluster.
         * </p>
         * 
         * @param clusterIdentifier
         *        The unique ID that's assigned to an Amazon Redshift cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The name of an Amazon Redshift workgroup.
         * </p>
         * 
         * @param workgroupName
         *        The name of an Amazon Redshift workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupName(String workgroupName);

        /**
         * <p>
         * The name of an Amazon Redshift database.
         * </p>
         * 
         * @param databaseName
         *        The name of an Amazon Redshift database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);
    }

    static final class BuilderImpl implements Builder {
        private String databaseUrl;

        private String bucketName;

        private String bucketPrefix;

        private String roleArn;

        private String dataApiRoleArn;

        private Boolean isRedshiftServerless;

        private String clusterIdentifier;

        private String workgroupName;

        private String databaseName;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftConnectorProfileProperties model) {
            databaseUrl(model.databaseUrl);
            bucketName(model.bucketName);
            bucketPrefix(model.bucketPrefix);
            roleArn(model.roleArn);
            dataApiRoleArn(model.dataApiRoleArn);
            isRedshiftServerless(model.isRedshiftServerless);
            clusterIdentifier(model.clusterIdentifier);
            workgroupName(model.workgroupName);
            databaseName(model.databaseName);
        }

        public final String getDatabaseUrl() {
            return databaseUrl;
        }

        public final void setDatabaseUrl(String databaseUrl) {
            this.databaseUrl = databaseUrl;
        }

        @Override
        public final Builder databaseUrl(String databaseUrl) {
            this.databaseUrl = databaseUrl;
            return this;
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBucketPrefix() {
            return bucketPrefix;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDataApiRoleArn() {
            return dataApiRoleArn;
        }

        public final void setDataApiRoleArn(String dataApiRoleArn) {
            this.dataApiRoleArn = dataApiRoleArn;
        }

        @Override
        public final Builder dataApiRoleArn(String dataApiRoleArn) {
            this.dataApiRoleArn = dataApiRoleArn;
            return this;
        }

        public final Boolean getIsRedshiftServerless() {
            return isRedshiftServerless;
        }

        public final void setIsRedshiftServerless(Boolean isRedshiftServerless) {
            this.isRedshiftServerless = isRedshiftServerless;
        }

        @Override
        public final Builder isRedshiftServerless(Boolean isRedshiftServerless) {
            this.isRedshiftServerless = isRedshiftServerless;
            return this;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getWorkgroupName() {
            return workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        @Override
        public RedshiftConnectorProfileProperties build() {
            return new RedshiftConnectorProfileProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
