/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific profile credentials required when using Salesforce.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SalesforceConnectorProfileCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<SalesforceConnectorProfileCredentials.Builder, SalesforceConnectorProfileCredentials> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessToken").getter(getter(SalesforceConnectorProfileCredentials::accessToken))
            .setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()).build();

    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("refreshToken").getter(getter(SalesforceConnectorProfileCredentials::refreshToken))
            .setter(setter(Builder::refreshToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()).build();

    private static final SdkField<ConnectorOAuthRequest> O_AUTH_REQUEST_FIELD = SdkField
            .<ConnectorOAuthRequest> builder(MarshallingType.SDK_POJO).memberName("oAuthRequest")
            .getter(getter(SalesforceConnectorProfileCredentials::oAuthRequest)).setter(setter(Builder::oAuthRequest))
            .constructor(ConnectorOAuthRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthRequest").build()).build();

    private static final SdkField<String> CLIENT_CREDENTIALS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientCredentialsArn").getter(getter(SalesforceConnectorProfileCredentials::clientCredentialsArn))
            .setter(setter(Builder::clientCredentialsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCredentialsArn").build())
            .build();

    private static final SdkField<String> O_AUTH2_GRANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("oAuth2GrantType").getter(getter(SalesforceConnectorProfileCredentials::oAuth2GrantTypeAsString))
            .setter(setter(Builder::oAuth2GrantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2GrantType").build()).build();

    private static final SdkField<String> JWT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jwtToken").getter(getter(SalesforceConnectorProfileCredentials::jwtToken))
            .setter(setter(Builder::jwtToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jwtToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            REFRESH_TOKEN_FIELD, O_AUTH_REQUEST_FIELD, CLIENT_CREDENTIALS_ARN_FIELD, O_AUTH2_GRANT_TYPE_FIELD, JWT_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accessToken;

    private final String refreshToken;

    private final ConnectorOAuthRequest oAuthRequest;

    private final String clientCredentialsArn;

    private final String oAuth2GrantType;

    private final String jwtToken;

    private SalesforceConnectorProfileCredentials(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.refreshToken = builder.refreshToken;
        this.oAuthRequest = builder.oAuthRequest;
        this.clientCredentialsArn = builder.clientCredentialsArn;
        this.oAuth2GrantType = builder.oAuth2GrantType;
        this.jwtToken = builder.jwtToken;
    }

    /**
     * <p>
     * The credentials used to access protected Salesforce resources.
     * </p>
     * 
     * @return The credentials used to access protected Salesforce resources.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The credentials used to acquire new access tokens.
     * </p>
     * 
     * @return The credentials used to acquire new access tokens.
     */
    public final String refreshToken() {
        return refreshToken;
    }

    /**
     * <p>
     * The OAuth requirement needed to request security tokens from the connector endpoint.
     * </p>
     * 
     * @return The OAuth requirement needed to request security tokens from the connector endpoint.
     */
    public final ConnectorOAuthRequest oAuthRequest() {
        return oAuthRequest;
    }

    /**
     * <p>
     * The secret manager ARN, which contains the client ID and client secret of the connected app.
     * </p>
     * 
     * @return The secret manager ARN, which contains the client ID and client secret of the connected app.
     */
    public final String clientCredentialsArn() {
        return clientCredentialsArn;
    }

    /**
     * <p>
     * Specifies the OAuth 2.0 grant type that Amazon AppFlow uses when it requests an access token from Salesforce.
     * Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.
     * </p>
     * <p>
     * You can specify one of the following values:
     * </p>
     * <dl>
     * <dt>AUTHORIZATION_CODE</dt>
     * <dd>
     * <p>
     * Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow
     * receives the authorization code from Salesforce after you log in to your Salesforce account and authorize Amazon
     * AppFlow to access your records.
     * </p>
     * </dd>
     * <dt>JWT_BEARER</dt>
     * <dd>
     * <p>
     * Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide the
     * JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant type,
     * you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.
     * </p>
     * </dd>
     * </dl>
     * <note>
     * <p>
     * The CLIENT_CREDENTIALS value is not supported for Salesforce.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oAuth2GrantType}
     * will return {@link OAuth2GrantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #oAuth2GrantTypeAsString}.
     * </p>
     * 
     * @return Specifies the OAuth 2.0 grant type that Amazon AppFlow uses when it requests an access token from
     *         Salesforce. Amazon AppFlow requires an access token each time it attempts to access your Salesforce
     *         records.</p>
     *         <p>
     *         You can specify one of the following values:
     *         </p>
     *         <dl>
     *         <dt>AUTHORIZATION_CODE</dt>
     *         <dd>
     *         <p>
     *         Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon
     *         AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account and
     *         authorize Amazon AppFlow to access your records.
     *         </p>
     *         </dd>
     *         <dt>JWT_BEARER</dt>
     *         <dd>
     *         <p>
     *         Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You
     *         provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use
     *         this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to
     *         access your records.
     *         </p>
     *         </dd>
     *         </dl>
     *         <note>
     *         <p>
     *         The CLIENT_CREDENTIALS value is not supported for Salesforce.
     *         </p>
     * @see OAuth2GrantType
     */
    public final OAuth2GrantType oAuth2GrantType() {
        return OAuth2GrantType.fromValue(oAuth2GrantType);
    }

    /**
     * <p>
     * Specifies the OAuth 2.0 grant type that Amazon AppFlow uses when it requests an access token from Salesforce.
     * Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.
     * </p>
     * <p>
     * You can specify one of the following values:
     * </p>
     * <dl>
     * <dt>AUTHORIZATION_CODE</dt>
     * <dd>
     * <p>
     * Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow
     * receives the authorization code from Salesforce after you log in to your Salesforce account and authorize Amazon
     * AppFlow to access your records.
     * </p>
     * </dd>
     * <dt>JWT_BEARER</dt>
     * <dd>
     * <p>
     * Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide the
     * JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant type,
     * you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.
     * </p>
     * </dd>
     * </dl>
     * <note>
     * <p>
     * The CLIENT_CREDENTIALS value is not supported for Salesforce.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oAuth2GrantType}
     * will return {@link OAuth2GrantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #oAuth2GrantTypeAsString}.
     * </p>
     * 
     * @return Specifies the OAuth 2.0 grant type that Amazon AppFlow uses when it requests an access token from
     *         Salesforce. Amazon AppFlow requires an access token each time it attempts to access your Salesforce
     *         records.</p>
     *         <p>
     *         You can specify one of the following values:
     *         </p>
     *         <dl>
     *         <dt>AUTHORIZATION_CODE</dt>
     *         <dd>
     *         <p>
     *         Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon
     *         AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account and
     *         authorize Amazon AppFlow to access your records.
     *         </p>
     *         </dd>
     *         <dt>JWT_BEARER</dt>
     *         <dd>
     *         <p>
     *         Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You
     *         provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use
     *         this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to
     *         access your records.
     *         </p>
     *         </dd>
     *         </dl>
     *         <note>
     *         <p>
     *         The CLIENT_CREDENTIALS value is not supported for Salesforce.
     *         </p>
     * @see OAuth2GrantType
     */
    public final String oAuth2GrantTypeAsString() {
        return oAuth2GrantType;
    }

    /**
     * <p>
     * A JSON web token (JWT) that authorizes Amazon AppFlow to access your Salesforce records.
     * </p>
     * 
     * @return A JSON web token (JWT) that authorizes Amazon AppFlow to access your Salesforce records.
     */
    public final String jwtToken() {
        return jwtToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthRequest());
        hashCode = 31 * hashCode + Objects.hashCode(clientCredentialsArn());
        hashCode = 31 * hashCode + Objects.hashCode(oAuth2GrantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jwtToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceConnectorProfileCredentials)) {
            return false;
        }
        SalesforceConnectorProfileCredentials other = (SalesforceConnectorProfileCredentials) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(refreshToken(), other.refreshToken())
                && Objects.equals(oAuthRequest(), other.oAuthRequest())
                && Objects.equals(clientCredentialsArn(), other.clientCredentialsArn())
                && Objects.equals(oAuth2GrantTypeAsString(), other.oAuth2GrantTypeAsString())
                && Objects.equals(jwtToken(), other.jwtToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SalesforceConnectorProfileCredentials")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RefreshToken", refreshToken()).add("OAuthRequest", oAuthRequest())
                .add("ClientCredentialsArn", clientCredentialsArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OAuth2GrantType", oAuth2GrantTypeAsString())
                .add("JwtToken", jwtToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "refreshToken":
            return Optional.ofNullable(clazz.cast(refreshToken()));
        case "oAuthRequest":
            return Optional.ofNullable(clazz.cast(oAuthRequest()));
        case "clientCredentialsArn":
            return Optional.ofNullable(clazz.cast(clientCredentialsArn()));
        case "oAuth2GrantType":
            return Optional.ofNullable(clazz.cast(oAuth2GrantTypeAsString()));
        case "jwtToken":
            return Optional.ofNullable(clazz.cast(jwtToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceConnectorProfileCredentials, T> g) {
        return obj -> g.apply((SalesforceConnectorProfileCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SalesforceConnectorProfileCredentials> {
        /**
         * <p>
         * The credentials used to access protected Salesforce resources.
         * </p>
         * 
         * @param accessToken
         *        The credentials used to access protected Salesforce resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The credentials used to acquire new access tokens.
         * </p>
         * 
         * @param refreshToken
         *        The credentials used to acquire new access tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshToken(String refreshToken);

        /**
         * <p>
         * The OAuth requirement needed to request security tokens from the connector endpoint.
         * </p>
         * 
         * @param oAuthRequest
         *        The OAuth requirement needed to request security tokens from the connector endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthRequest(ConnectorOAuthRequest oAuthRequest);

        /**
         * <p>
         * The OAuth requirement needed to request security tokens from the connector endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectorOAuthRequest.Builder} avoiding
         * the need to create one manually via {@link ConnectorOAuthRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectorOAuthRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #oAuthRequest(ConnectorOAuthRequest)}.
         * 
         * @param oAuthRequest
         *        a consumer that will call methods on {@link ConnectorOAuthRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuthRequest(ConnectorOAuthRequest)
         */
        default Builder oAuthRequest(Consumer<ConnectorOAuthRequest.Builder> oAuthRequest) {
            return oAuthRequest(ConnectorOAuthRequest.builder().applyMutation(oAuthRequest).build());
        }

        /**
         * <p>
         * The secret manager ARN, which contains the client ID and client secret of the connected app.
         * </p>
         * 
         * @param clientCredentialsArn
         *        The secret manager ARN, which contains the client ID and client secret of the connected app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCredentialsArn(String clientCredentialsArn);

        /**
         * <p>
         * Specifies the OAuth 2.0 grant type that Amazon AppFlow uses when it requests an access token from Salesforce.
         * Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.
         * </p>
         * <p>
         * You can specify one of the following values:
         * </p>
         * <dl>
         * <dt>AUTHORIZATION_CODE</dt>
         * <dd>
         * <p>
         * Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow
         * receives the authorization code from Salesforce after you log in to your Salesforce account and authorize
         * Amazon AppFlow to access your records.
         * </p>
         * </dd>
         * <dt>JWT_BEARER</dt>
         * <dd>
         * <p>
         * Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide
         * the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant
         * type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.
         * </p>
         * </dd>
         * </dl>
         * <note>
         * <p>
         * The CLIENT_CREDENTIALS value is not supported for Salesforce.
         * </p>
         * </note>
         * 
         * @param oAuth2GrantType
         *        Specifies the OAuth 2.0 grant type that Amazon AppFlow uses when it requests an access token from
         *        Salesforce. Amazon AppFlow requires an access token each time it attempts to access your Salesforce
         *        records.</p>
         *        <p>
         *        You can specify one of the following values:
         *        </p>
         *        <dl>
         *        <dt>AUTHORIZATION_CODE</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon
         *        AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account
         *        and authorize Amazon AppFlow to access your records.
         *        </p>
         *        </dd>
         *        <dt>JWT_BEARER</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You
         *        provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you
         *        use this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow
         *        to access your records.
         *        </p>
         *        </dd>
         *        </dl>
         *        <note>
         *        <p>
         *        The CLIENT_CREDENTIALS value is not supported for Salesforce.
         *        </p>
         * @see OAuth2GrantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OAuth2GrantType
         */
        Builder oAuth2GrantType(String oAuth2GrantType);

        /**
         * <p>
         * Specifies the OAuth 2.0 grant type that Amazon AppFlow uses when it requests an access token from Salesforce.
         * Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.
         * </p>
         * <p>
         * You can specify one of the following values:
         * </p>
         * <dl>
         * <dt>AUTHORIZATION_CODE</dt>
         * <dd>
         * <p>
         * Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow
         * receives the authorization code from Salesforce after you log in to your Salesforce account and authorize
         * Amazon AppFlow to access your records.
         * </p>
         * </dd>
         * <dt>JWT_BEARER</dt>
         * <dd>
         * <p>
         * Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide
         * the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant
         * type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.
         * </p>
         * </dd>
         * </dl>
         * <note>
         * <p>
         * The CLIENT_CREDENTIALS value is not supported for Salesforce.
         * </p>
         * </note>
         * 
         * @param oAuth2GrantType
         *        Specifies the OAuth 2.0 grant type that Amazon AppFlow uses when it requests an access token from
         *        Salesforce. Amazon AppFlow requires an access token each time it attempts to access your Salesforce
         *        records.</p>
         *        <p>
         *        You can specify one of the following values:
         *        </p>
         *        <dl>
         *        <dt>AUTHORIZATION_CODE</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon
         *        AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account
         *        and authorize Amazon AppFlow to access your records.
         *        </p>
         *        </dd>
         *        <dt>JWT_BEARER</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You
         *        provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you
         *        use this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow
         *        to access your records.
         *        </p>
         *        </dd>
         *        </dl>
         *        <note>
         *        <p>
         *        The CLIENT_CREDENTIALS value is not supported for Salesforce.
         *        </p>
         * @see OAuth2GrantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OAuth2GrantType
         */
        Builder oAuth2GrantType(OAuth2GrantType oAuth2GrantType);

        /**
         * <p>
         * A JSON web token (JWT) that authorizes Amazon AppFlow to access your Salesforce records.
         * </p>
         * 
         * @param jwtToken
         *        A JSON web token (JWT) that authorizes Amazon AppFlow to access your Salesforce records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jwtToken(String jwtToken);
    }

    static final class BuilderImpl implements Builder {
        private String accessToken;

        private String refreshToken;

        private ConnectorOAuthRequest oAuthRequest;

        private String clientCredentialsArn;

        private String oAuth2GrantType;

        private String jwtToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceConnectorProfileCredentials model) {
            accessToken(model.accessToken);
            refreshToken(model.refreshToken);
            oAuthRequest(model.oAuthRequest);
            clientCredentialsArn(model.clientCredentialsArn);
            oAuth2GrantType(model.oAuth2GrantType);
            jwtToken(model.jwtToken);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getRefreshToken() {
            return refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final ConnectorOAuthRequest.Builder getOAuthRequest() {
            return oAuthRequest != null ? oAuthRequest.toBuilder() : null;
        }

        public final void setOAuthRequest(ConnectorOAuthRequest.BuilderImpl oAuthRequest) {
            this.oAuthRequest = oAuthRequest != null ? oAuthRequest.build() : null;
        }

        @Override
        public final Builder oAuthRequest(ConnectorOAuthRequest oAuthRequest) {
            this.oAuthRequest = oAuthRequest;
            return this;
        }

        public final String getClientCredentialsArn() {
            return clientCredentialsArn;
        }

        public final void setClientCredentialsArn(String clientCredentialsArn) {
            this.clientCredentialsArn = clientCredentialsArn;
        }

        @Override
        public final Builder clientCredentialsArn(String clientCredentialsArn) {
            this.clientCredentialsArn = clientCredentialsArn;
            return this;
        }

        public final String getOAuth2GrantType() {
            return oAuth2GrantType;
        }

        public final void setOAuth2GrantType(String oAuth2GrantType) {
            this.oAuth2GrantType = oAuth2GrantType;
        }

        @Override
        public final Builder oAuth2GrantType(String oAuth2GrantType) {
            this.oAuth2GrantType = oAuth2GrantType;
            return this;
        }

        @Override
        public final Builder oAuth2GrantType(OAuth2GrantType oAuth2GrantType) {
            this.oAuth2GrantType(oAuth2GrantType == null ? null : oAuth2GrantType.toString());
            return this;
        }

        public final String getJwtToken() {
            return jwtToken;
        }

        public final void setJwtToken(String jwtToken) {
            this.jwtToken = jwtToken;
        }

        @Override
        public final Builder jwtToken(String jwtToken) {
            this.jwtToken = jwtToken;
            return this;
        }

        @Override
        public SalesforceConnectorProfileCredentials build() {
            return new SalesforceConnectorProfileCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
