/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data model of a connector field. For example, for an <i>account</i> entity, the fields would be
 * <i>account name</i>, <i>account ID</i>, and so on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorEntityField implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorEntityField.Builder, ConnectorEntityField> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(ConnectorEntityField::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> PARENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentIdentifier").getter(getter(ConnectorEntityField::parentIdentifier))
            .setter(setter(Builder::parentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIdentifier").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("label")
            .getter(getter(ConnectorEntityField::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()).build();

    private static final SdkField<Boolean> IS_PRIMARY_KEY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isPrimaryKey").getter(getter(ConnectorEntityField::isPrimaryKey)).setter(setter(Builder::isPrimaryKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPrimaryKey").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultValue").getter(getter(ConnectorEntityField::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final SdkField<Boolean> IS_DEPRECATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isDeprecated").getter(getter(ConnectorEntityField::isDeprecated)).setter(setter(Builder::isDeprecated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDeprecated").build()).build();

    private static final SdkField<SupportedFieldTypeDetails> SUPPORTED_FIELD_TYPE_DETAILS_FIELD = SdkField
            .<SupportedFieldTypeDetails> builder(MarshallingType.SDK_POJO).memberName("supportedFieldTypeDetails")
            .getter(getter(ConnectorEntityField::supportedFieldTypeDetails)).setter(setter(Builder::supportedFieldTypeDetails))
            .constructor(SupportedFieldTypeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedFieldTypeDetails").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ConnectorEntityField::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<SourceFieldProperties> SOURCE_PROPERTIES_FIELD = SdkField
            .<SourceFieldProperties> builder(MarshallingType.SDK_POJO).memberName("sourceProperties")
            .getter(getter(ConnectorEntityField::sourceProperties)).setter(setter(Builder::sourceProperties))
            .constructor(SourceFieldProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceProperties").build()).build();

    private static final SdkField<DestinationFieldProperties> DESTINATION_PROPERTIES_FIELD = SdkField
            .<DestinationFieldProperties> builder(MarshallingType.SDK_POJO).memberName("destinationProperties")
            .getter(getter(ConnectorEntityField::destinationProperties)).setter(setter(Builder::destinationProperties))
            .constructor(DestinationFieldProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationProperties").build())
            .build();

    private static final SdkField<Map<String, String>> CUSTOM_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("customProperties")
            .getter(getter(ConnectorEntityField::customProperties))
            .setter(setter(Builder::customProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            PARENT_IDENTIFIER_FIELD, LABEL_FIELD, IS_PRIMARY_KEY_FIELD, DEFAULT_VALUE_FIELD, IS_DEPRECATED_FIELD,
            SUPPORTED_FIELD_TYPE_DETAILS_FIELD, DESCRIPTION_FIELD, SOURCE_PROPERTIES_FIELD, DESTINATION_PROPERTIES_FIELD,
            CUSTOM_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String identifier;

    private final String parentIdentifier;

    private final String label;

    private final Boolean isPrimaryKey;

    private final String defaultValue;

    private final Boolean isDeprecated;

    private final SupportedFieldTypeDetails supportedFieldTypeDetails;

    private final String description;

    private final SourceFieldProperties sourceProperties;

    private final DestinationFieldProperties destinationProperties;

    private final Map<String, String> customProperties;

    private ConnectorEntityField(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.parentIdentifier = builder.parentIdentifier;
        this.label = builder.label;
        this.isPrimaryKey = builder.isPrimaryKey;
        this.defaultValue = builder.defaultValue;
        this.isDeprecated = builder.isDeprecated;
        this.supportedFieldTypeDetails = builder.supportedFieldTypeDetails;
        this.description = builder.description;
        this.sourceProperties = builder.sourceProperties;
        this.destinationProperties = builder.destinationProperties;
        this.customProperties = builder.customProperties;
    }

    /**
     * <p>
     * The unique identifier of the connector field.
     * </p>
     * 
     * @return The unique identifier of the connector field.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The parent identifier of the connector field.
     * </p>
     * 
     * @return The parent identifier of the connector field.
     */
    public final String parentIdentifier() {
        return parentIdentifier;
    }

    /**
     * <p>
     * The label applied to a connector entity field.
     * </p>
     * 
     * @return The label applied to a connector entity field.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * Booelan value that indicates whether this field can be used as a primary key.
     * </p>
     * 
     * @return Booelan value that indicates whether this field can be used as a primary key.
     */
    public final Boolean isPrimaryKey() {
        return isPrimaryKey;
    }

    /**
     * <p>
     * Default value that can be assigned to this field.
     * </p>
     * 
     * @return Default value that can be assigned to this field.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * Booelan value that indicates whether this field is deprecated or not.
     * </p>
     * 
     * @return Booelan value that indicates whether this field is deprecated or not.
     */
    public final Boolean isDeprecated() {
        return isDeprecated;
    }

    /**
     * <p>
     * Contains details regarding the supported <code>FieldType</code>, including the corresponding
     * <code>filterOperators</code> and <code>supportedValues</code>.
     * </p>
     * 
     * @return Contains details regarding the supported <code>FieldType</code>, including the corresponding
     *         <code>filterOperators</code> and <code>supportedValues</code>.
     */
    public final SupportedFieldTypeDetails supportedFieldTypeDetails() {
        return supportedFieldTypeDetails;
    }

    /**
     * <p>
     * A description of the connector entity field.
     * </p>
     * 
     * @return A description of the connector entity field.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The properties that can be applied to a field when the connector is being used as a source.
     * </p>
     * 
     * @return The properties that can be applied to a field when the connector is being used as a source.
     */
    public final SourceFieldProperties sourceProperties() {
        return sourceProperties;
    }

    /**
     * <p>
     * The properties applied to a field when the connector is being used as a destination.
     * </p>
     * 
     * @return The properties applied to a field when the connector is being used as a destination.
     */
    public final DestinationFieldProperties destinationProperties() {
        return destinationProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomProperties() {
        return customProperties != null && !(customProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that has specific properties related to the ConnectorEntityField.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomProperties} method.
     * </p>
     * 
     * @return A map that has specific properties related to the ConnectorEntityField.
     */
    public final Map<String, String> customProperties() {
        return customProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(parentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(isPrimaryKey());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(isDeprecated());
        hashCode = 31 * hashCode + Objects.hashCode(supportedFieldTypeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(destinationProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomProperties() ? customProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorEntityField)) {
            return false;
        }
        ConnectorEntityField other = (ConnectorEntityField) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(parentIdentifier(), other.parentIdentifier())
                && Objects.equals(label(), other.label()) && Objects.equals(isPrimaryKey(), other.isPrimaryKey())
                && Objects.equals(defaultValue(), other.defaultValue()) && Objects.equals(isDeprecated(), other.isDeprecated())
                && Objects.equals(supportedFieldTypeDetails(), other.supportedFieldTypeDetails())
                && Objects.equals(description(), other.description())
                && Objects.equals(sourceProperties(), other.sourceProperties())
                && Objects.equals(destinationProperties(), other.destinationProperties())
                && hasCustomProperties() == other.hasCustomProperties()
                && Objects.equals(customProperties(), other.customProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorEntityField").add("Identifier", identifier())
                .add("ParentIdentifier", parentIdentifier()).add("Label", label()).add("IsPrimaryKey", isPrimaryKey())
                .add("DefaultValue", defaultValue()).add("IsDeprecated", isDeprecated())
                .add("SupportedFieldTypeDetails", supportedFieldTypeDetails()).add("Description", description())
                .add("SourceProperties", sourceProperties()).add("DestinationProperties", destinationProperties())
                .add("CustomProperties", hasCustomProperties() ? customProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "parentIdentifier":
            return Optional.ofNullable(clazz.cast(parentIdentifier()));
        case "label":
            return Optional.ofNullable(clazz.cast(label()));
        case "isPrimaryKey":
            return Optional.ofNullable(clazz.cast(isPrimaryKey()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "isDeprecated":
            return Optional.ofNullable(clazz.cast(isDeprecated()));
        case "supportedFieldTypeDetails":
            return Optional.ofNullable(clazz.cast(supportedFieldTypeDetails()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "sourceProperties":
            return Optional.ofNullable(clazz.cast(sourceProperties()));
        case "destinationProperties":
            return Optional.ofNullable(clazz.cast(destinationProperties()));
        case "customProperties":
            return Optional.ofNullable(clazz.cast(customProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("parentIdentifier", PARENT_IDENTIFIER_FIELD);
        map.put("label", LABEL_FIELD);
        map.put("isPrimaryKey", IS_PRIMARY_KEY_FIELD);
        map.put("defaultValue", DEFAULT_VALUE_FIELD);
        map.put("isDeprecated", IS_DEPRECATED_FIELD);
        map.put("supportedFieldTypeDetails", SUPPORTED_FIELD_TYPE_DETAILS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("sourceProperties", SOURCE_PROPERTIES_FIELD);
        map.put("destinationProperties", DESTINATION_PROPERTIES_FIELD);
        map.put("customProperties", CUSTOM_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorEntityField, T> g) {
        return obj -> g.apply((ConnectorEntityField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorEntityField> {
        /**
         * <p>
         * The unique identifier of the connector field.
         * </p>
         * 
         * @param identifier
         *        The unique identifier of the connector field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The parent identifier of the connector field.
         * </p>
         * 
         * @param parentIdentifier
         *        The parent identifier of the connector field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentIdentifier(String parentIdentifier);

        /**
         * <p>
         * The label applied to a connector entity field.
         * </p>
         * 
         * @param label
         *        The label applied to a connector entity field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * Booelan value that indicates whether this field can be used as a primary key.
         * </p>
         * 
         * @param isPrimaryKey
         *        Booelan value that indicates whether this field can be used as a primary key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPrimaryKey(Boolean isPrimaryKey);

        /**
         * <p>
         * Default value that can be assigned to this field.
         * </p>
         * 
         * @param defaultValue
         *        Default value that can be assigned to this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * Booelan value that indicates whether this field is deprecated or not.
         * </p>
         * 
         * @param isDeprecated
         *        Booelan value that indicates whether this field is deprecated or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDeprecated(Boolean isDeprecated);

        /**
         * <p>
         * Contains details regarding the supported <code>FieldType</code>, including the corresponding
         * <code>filterOperators</code> and <code>supportedValues</code>.
         * </p>
         * 
         * @param supportedFieldTypeDetails
         *        Contains details regarding the supported <code>FieldType</code>, including the corresponding
         *        <code>filterOperators</code> and <code>supportedValues</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedFieldTypeDetails(SupportedFieldTypeDetails supportedFieldTypeDetails);

        /**
         * <p>
         * Contains details regarding the supported <code>FieldType</code>, including the corresponding
         * <code>filterOperators</code> and <code>supportedValues</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SupportedFieldTypeDetails.Builder}
         * avoiding the need to create one manually via {@link SupportedFieldTypeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SupportedFieldTypeDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #supportedFieldTypeDetails(SupportedFieldTypeDetails)}.
         * 
         * @param supportedFieldTypeDetails
         *        a consumer that will call methods on {@link SupportedFieldTypeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedFieldTypeDetails(SupportedFieldTypeDetails)
         */
        default Builder supportedFieldTypeDetails(Consumer<SupportedFieldTypeDetails.Builder> supportedFieldTypeDetails) {
            return supportedFieldTypeDetails(SupportedFieldTypeDetails.builder().applyMutation(supportedFieldTypeDetails).build());
        }

        /**
         * <p>
         * A description of the connector entity field.
         * </p>
         * 
         * @param description
         *        A description of the connector entity field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The properties that can be applied to a field when the connector is being used as a source.
         * </p>
         * 
         * @param sourceProperties
         *        The properties that can be applied to a field when the connector is being used as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceProperties(SourceFieldProperties sourceProperties);

        /**
         * <p>
         * The properties that can be applied to a field when the connector is being used as a source.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceFieldProperties.Builder} avoiding
         * the need to create one manually via {@link SourceFieldProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceFieldProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceProperties(SourceFieldProperties)}.
         * 
         * @param sourceProperties
         *        a consumer that will call methods on {@link SourceFieldProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceProperties(SourceFieldProperties)
         */
        default Builder sourceProperties(Consumer<SourceFieldProperties.Builder> sourceProperties) {
            return sourceProperties(SourceFieldProperties.builder().applyMutation(sourceProperties).build());
        }

        /**
         * <p>
         * The properties applied to a field when the connector is being used as a destination.
         * </p>
         * 
         * @param destinationProperties
         *        The properties applied to a field when the connector is being used as a destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationProperties(DestinationFieldProperties destinationProperties);

        /**
         * <p>
         * The properties applied to a field when the connector is being used as a destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationFieldProperties.Builder}
         * avoiding the need to create one manually via {@link DestinationFieldProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationFieldProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationProperties(DestinationFieldProperties)}.
         * 
         * @param destinationProperties
         *        a consumer that will call methods on {@link DestinationFieldProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationProperties(DestinationFieldProperties)
         */
        default Builder destinationProperties(Consumer<DestinationFieldProperties.Builder> destinationProperties) {
            return destinationProperties(DestinationFieldProperties.builder().applyMutation(destinationProperties).build());
        }

        /**
         * <p>
         * A map that has specific properties related to the ConnectorEntityField.
         * </p>
         * 
         * @param customProperties
         *        A map that has specific properties related to the ConnectorEntityField.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customProperties(Map<String, String> customProperties);
    }

    static final class BuilderImpl implements Builder {
        private String identifier;

        private String parentIdentifier;

        private String label;

        private Boolean isPrimaryKey;

        private String defaultValue;

        private Boolean isDeprecated;

        private SupportedFieldTypeDetails supportedFieldTypeDetails;

        private String description;

        private SourceFieldProperties sourceProperties;

        private DestinationFieldProperties destinationProperties;

        private Map<String, String> customProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorEntityField model) {
            identifier(model.identifier);
            parentIdentifier(model.parentIdentifier);
            label(model.label);
            isPrimaryKey(model.isPrimaryKey);
            defaultValue(model.defaultValue);
            isDeprecated(model.isDeprecated);
            supportedFieldTypeDetails(model.supportedFieldTypeDetails);
            description(model.description);
            sourceProperties(model.sourceProperties);
            destinationProperties(model.destinationProperties);
            customProperties(model.customProperties);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getParentIdentifier() {
            return parentIdentifier;
        }

        public final void setParentIdentifier(String parentIdentifier) {
            this.parentIdentifier = parentIdentifier;
        }

        @Override
        public final Builder parentIdentifier(String parentIdentifier) {
            this.parentIdentifier = parentIdentifier;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final Boolean getIsPrimaryKey() {
            return isPrimaryKey;
        }

        public final void setIsPrimaryKey(Boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
        }

        @Override
        public final Builder isPrimaryKey(Boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Boolean getIsDeprecated() {
            return isDeprecated;
        }

        public final void setIsDeprecated(Boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
        }

        @Override
        public final Builder isDeprecated(Boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            return this;
        }

        public final SupportedFieldTypeDetails.Builder getSupportedFieldTypeDetails() {
            return supportedFieldTypeDetails != null ? supportedFieldTypeDetails.toBuilder() : null;
        }

        public final void setSupportedFieldTypeDetails(SupportedFieldTypeDetails.BuilderImpl supportedFieldTypeDetails) {
            this.supportedFieldTypeDetails = supportedFieldTypeDetails != null ? supportedFieldTypeDetails.build() : null;
        }

        @Override
        public final Builder supportedFieldTypeDetails(SupportedFieldTypeDetails supportedFieldTypeDetails) {
            this.supportedFieldTypeDetails = supportedFieldTypeDetails;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SourceFieldProperties.Builder getSourceProperties() {
            return sourceProperties != null ? sourceProperties.toBuilder() : null;
        }

        public final void setSourceProperties(SourceFieldProperties.BuilderImpl sourceProperties) {
            this.sourceProperties = sourceProperties != null ? sourceProperties.build() : null;
        }

        @Override
        public final Builder sourceProperties(SourceFieldProperties sourceProperties) {
            this.sourceProperties = sourceProperties;
            return this;
        }

        public final DestinationFieldProperties.Builder getDestinationProperties() {
            return destinationProperties != null ? destinationProperties.toBuilder() : null;
        }

        public final void setDestinationProperties(DestinationFieldProperties.BuilderImpl destinationProperties) {
            this.destinationProperties = destinationProperties != null ? destinationProperties.build() : null;
        }

        @Override
        public final Builder destinationProperties(DestinationFieldProperties destinationProperties) {
            this.destinationProperties = destinationProperties;
            return this;
        }

        public final Map<String, String> getCustomProperties() {
            if (customProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return customProperties;
        }

        public final void setCustomProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
        }

        @Override
        public final Builder customProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
            return this;
        }

        @Override
        public ConnectorEntityField build() {
            return new ConnectorEntityField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
