/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The profile properties required by the custom connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomConnectorProfileProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomConnectorProfileProperties.Builder, CustomConnectorProfileProperties> {
    private static final SdkField<Map<String, String>> PROFILE_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("profileProperties")
            .getter(getter(CustomConnectorProfileProperties::profileProperties))
            .setter(setter(Builder::profileProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<OAuth2Properties> O_AUTH2_PROPERTIES_FIELD = SdkField
            .<OAuth2Properties> builder(MarshallingType.SDK_POJO).memberName("oAuth2Properties")
            .getter(getter(CustomConnectorProfileProperties::oAuth2Properties)).setter(setter(Builder::oAuth2Properties))
            .constructor(OAuth2Properties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2Properties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_PROPERTIES_FIELD,
            O_AUTH2_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> profileProperties;

    private final OAuth2Properties oAuth2Properties;

    private CustomConnectorProfileProperties(BuilderImpl builder) {
        this.profileProperties = builder.profileProperties;
        this.oAuth2Properties = builder.oAuth2Properties;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProfileProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProfileProperties() {
        return profileProperties != null && !(profileProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of properties that are required to create a profile for the custom connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfileProperties} method.
     * </p>
     * 
     * @return A map of properties that are required to create a profile for the custom connector.
     */
    public final Map<String, String> profileProperties() {
        return profileProperties;
    }

    /**
     * Returns the value of the OAuth2Properties property for this object.
     * 
     * @return The value of the OAuth2Properties property for this object.
     */
    public final OAuth2Properties oAuth2Properties() {
        return oAuth2Properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasProfileProperties() ? profileProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(oAuth2Properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomConnectorProfileProperties)) {
            return false;
        }
        CustomConnectorProfileProperties other = (CustomConnectorProfileProperties) obj;
        return hasProfileProperties() == other.hasProfileProperties()
                && Objects.equals(profileProperties(), other.profileProperties())
                && Objects.equals(oAuth2Properties(), other.oAuth2Properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomConnectorProfileProperties")
                .add("ProfileProperties", hasProfileProperties() ? profileProperties() : null)
                .add("OAuth2Properties", oAuth2Properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profileProperties":
            return Optional.ofNullable(clazz.cast(profileProperties()));
        case "oAuth2Properties":
            return Optional.ofNullable(clazz.cast(oAuth2Properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("profileProperties", PROFILE_PROPERTIES_FIELD);
        map.put("oAuth2Properties", O_AUTH2_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomConnectorProfileProperties, T> g) {
        return obj -> g.apply((CustomConnectorProfileProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomConnectorProfileProperties> {
        /**
         * <p>
         * A map of properties that are required to create a profile for the custom connector.
         * </p>
         * 
         * @param profileProperties
         *        A map of properties that are required to create a profile for the custom connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileProperties(Map<String, String> profileProperties);

        /**
         * Sets the value of the OAuth2Properties property for this object.
         *
         * @param oAuth2Properties
         *        The new value for the OAuth2Properties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuth2Properties(OAuth2Properties oAuth2Properties);

        /**
         * Sets the value of the OAuth2Properties property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OAuth2Properties.Builder} avoiding the
         * need to create one manually via {@link OAuth2Properties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OAuth2Properties.Builder#build()} is called immediately and its
         * result is passed to {@link #oAuth2Properties(OAuth2Properties)}.
         * 
         * @param oAuth2Properties
         *        a consumer that will call methods on {@link OAuth2Properties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuth2Properties(OAuth2Properties)
         */
        default Builder oAuth2Properties(Consumer<OAuth2Properties.Builder> oAuth2Properties) {
            return oAuth2Properties(OAuth2Properties.builder().applyMutation(oAuth2Properties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> profileProperties = DefaultSdkAutoConstructMap.getInstance();

        private OAuth2Properties oAuth2Properties;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomConnectorProfileProperties model) {
            profileProperties(model.profileProperties);
            oAuth2Properties(model.oAuth2Properties);
        }

        public final Map<String, String> getProfileProperties() {
            if (profileProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return profileProperties;
        }

        public final void setProfileProperties(Map<String, String> profileProperties) {
            this.profileProperties = ProfilePropertiesMapCopier.copy(profileProperties);
        }

        @Override
        public final Builder profileProperties(Map<String, String> profileProperties) {
            this.profileProperties = ProfilePropertiesMapCopier.copy(profileProperties);
            return this;
        }

        public final OAuth2Properties.Builder getOAuth2Properties() {
            return oAuth2Properties != null ? oAuth2Properties.toBuilder() : null;
        }

        public final void setOAuth2Properties(OAuth2Properties.BuilderImpl oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties != null ? oAuth2Properties.build() : null;
        }

        @Override
        public final Builder oAuth2Properties(OAuth2Properties oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties;
            return this;
        }

        @Override
        public CustomConnectorProfileProperties build() {
            return new CustomConnectorProfileProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
