/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectorsResponse extends AppflowResponse implements
        ToCopyableBuilder<DescribeConnectorsResponse.Builder, DescribeConnectorsResponse> {
    private static final SdkField<Map<String, ConnectorConfiguration>> CONNECTOR_CONFIGURATIONS_FIELD = SdkField
            .<Map<String, ConnectorConfiguration>> builder(MarshallingType.MAP)
            .memberName("connectorConfigurations")
            .getter(getter(DescribeConnectorsResponse::connectorConfigurationsAsStrings))
            .setter(setter(Builder::connectorConfigurationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorConfigurations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ConnectorConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectorConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ConnectorDetail>> CONNECTORS_FIELD = SdkField
            .<List<ConnectorDetail>> builder(MarshallingType.LIST)
            .memberName("connectors")
            .getter(getter(DescribeConnectorsResponse::connectors))
            .setter(setter(Builder::connectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectorDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectorDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeConnectorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONNECTOR_CONFIGURATIONS_FIELD, CONNECTORS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, ConnectorConfiguration> connectorConfigurations;

    private final List<ConnectorDetail> connectors;

    private final String nextToken;

    private DescribeConnectorsResponse(BuilderImpl builder) {
        super(builder);
        this.connectorConfigurations = builder.connectorConfigurations;
        this.connectors = builder.connectors;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The configuration that is applied to the connectors used in the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectorConfigurations} method.
     * </p>
     * 
     * @return The configuration that is applied to the connectors used in the flow.
     */
    public final Map<ConnectorType, ConnectorConfiguration> connectorConfigurations() {
        return ConnectorConfigurationsMapCopier.copyStringToEnum(connectorConfigurations);
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectorConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConnectorConfigurations() {
        return connectorConfigurations != null && !(connectorConfigurations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The configuration that is applied to the connectors used in the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectorConfigurations} method.
     * </p>
     * 
     * @return The configuration that is applied to the connectors used in the flow.
     */
    public final Map<String, ConnectorConfiguration> connectorConfigurationsAsStrings() {
        return connectorConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Connectors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConnectors() {
        return connectors != null && !(connectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the connectors supported in Amazon AppFlow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectors} method.
     * </p>
     * 
     * @return Information about the connectors supported in Amazon AppFlow.
     */
    public final List<ConnectorDetail> connectors() {
        return connectors;
    }

    /**
     * <p>
     * The pagination token for the next page of data.
     * </p>
     * 
     * @return The pagination token for the next page of data.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorConfigurations() ? connectorConfigurationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectors() ? connectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorsResponse)) {
            return false;
        }
        DescribeConnectorsResponse other = (DescribeConnectorsResponse) obj;
        return hasConnectorConfigurations() == other.hasConnectorConfigurations()
                && Objects.equals(connectorConfigurationsAsStrings(), other.connectorConfigurationsAsStrings())
                && hasConnectors() == other.hasConnectors() && Objects.equals(connectors(), other.connectors())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConnectorsResponse")
                .add("ConnectorConfigurations", hasConnectorConfigurations() ? connectorConfigurationsAsStrings() : null)
                .add("Connectors", hasConnectors() ? connectors() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorConfigurations":
            return Optional.ofNullable(clazz.cast(connectorConfigurationsAsStrings()));
        case "connectors":
            return Optional.ofNullable(clazz.cast(connectors()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectorConfigurations", CONNECTOR_CONFIGURATIONS_FIELD);
        map.put("connectors", CONNECTORS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorsResponse, T> g) {
        return obj -> g.apply((DescribeConnectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConnectorsResponse> {
        /**
         * <p>
         * The configuration that is applied to the connectors used in the flow.
         * </p>
         * 
         * @param connectorConfigurations
         *        The configuration that is applied to the connectors used in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorConfigurationsWithStrings(Map<String, ConnectorConfiguration> connectorConfigurations);

        /**
         * <p>
         * The configuration that is applied to the connectors used in the flow.
         * </p>
         * 
         * @param connectorConfigurations
         *        The configuration that is applied to the connectors used in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorConfigurations(Map<ConnectorType, ConnectorConfiguration> connectorConfigurations);

        /**
         * <p>
         * Information about the connectors supported in Amazon AppFlow.
         * </p>
         * 
         * @param connectors
         *        Information about the connectors supported in Amazon AppFlow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectors(Collection<ConnectorDetail> connectors);

        /**
         * <p>
         * Information about the connectors supported in Amazon AppFlow.
         * </p>
         * 
         * @param connectors
         *        Information about the connectors supported in Amazon AppFlow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectors(ConnectorDetail... connectors);

        /**
         * <p>
         * Information about the connectors supported in Amazon AppFlow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appflow.model.ConnectorDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.appflow.model.ConnectorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appflow.model.ConnectorDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #connectors(List<ConnectorDetail>)}.
         * 
         * @param connectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appflow.model.ConnectorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectors(java.util.Collection<ConnectorDetail>)
         */
        Builder connectors(Consumer<ConnectorDetail.Builder>... connectors);

        /**
         * <p>
         * The pagination token for the next page of data.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the next page of data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppflowResponse.BuilderImpl implements Builder {
        private Map<String, ConnectorConfiguration> connectorConfigurations = DefaultSdkAutoConstructMap.getInstance();

        private List<ConnectorDetail> connectors = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorsResponse model) {
            super(model);
            connectorConfigurationsWithStrings(model.connectorConfigurations);
            connectors(model.connectors);
            nextToken(model.nextToken);
        }

        public final Map<String, ConnectorConfiguration.Builder> getConnectorConfigurations() {
            Map<String, ConnectorConfiguration.Builder> result = ConnectorConfigurationsMapCopier
                    .copyToBuilder(this.connectorConfigurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConnectorConfigurations(Map<String, ConnectorConfiguration.BuilderImpl> connectorConfigurations) {
            this.connectorConfigurations = ConnectorConfigurationsMapCopier.copyFromBuilder(connectorConfigurations);
        }

        @Override
        public final Builder connectorConfigurationsWithStrings(Map<String, ConnectorConfiguration> connectorConfigurations) {
            this.connectorConfigurations = ConnectorConfigurationsMapCopier.copy(connectorConfigurations);
            return this;
        }

        @Override
        public final Builder connectorConfigurations(Map<ConnectorType, ConnectorConfiguration> connectorConfigurations) {
            this.connectorConfigurations = ConnectorConfigurationsMapCopier.copyEnumToString(connectorConfigurations);
            return this;
        }

        public final List<ConnectorDetail.Builder> getConnectors() {
            List<ConnectorDetail.Builder> result = ConnectorListCopier.copyToBuilder(this.connectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectors(Collection<ConnectorDetail.BuilderImpl> connectors) {
            this.connectors = ConnectorListCopier.copyFromBuilder(connectors);
        }

        @Override
        public final Builder connectors(Collection<ConnectorDetail> connectors) {
            this.connectors = ConnectorListCopier.copy(connectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectors(ConnectorDetail... connectors) {
            connectors(Arrays.asList(connectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectors(Consumer<ConnectorDetail.Builder>... connectors) {
            connectors(Stream.of(connectors).map(c -> ConnectorDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeConnectorsResponse build() {
            return new DescribeConnectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
