/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the configuration of destination connectors present in the flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationFlowConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationFlowConfig.Builder, DestinationFlowConfig> {
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorType").getter(getter(DestinationFlowConfig::connectorTypeAsString))
            .setter(setter(Builder::connectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()).build();

    private static final SdkField<String> API_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiVersion").getter(getter(DestinationFlowConfig::apiVersion)).setter(setter(Builder::apiVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiVersion").build()).build();

    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorProfileName").getter(getter(DestinationFlowConfig::connectorProfileName))
            .setter(setter(Builder::connectorProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build())
            .build();

    private static final SdkField<DestinationConnectorProperties> DESTINATION_CONNECTOR_PROPERTIES_FIELD = SdkField
            .<DestinationConnectorProperties> builder(MarshallingType.SDK_POJO)
            .memberName("destinationConnectorProperties")
            .getter(getter(DestinationFlowConfig::destinationConnectorProperties))
            .setter(setter(Builder::destinationConnectorProperties))
            .constructor(DestinationConnectorProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConnectorProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_TYPE_FIELD,
            API_VERSION_FIELD, CONNECTOR_PROFILE_NAME_FIELD, DESTINATION_CONNECTOR_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectorType;

    private final String apiVersion;

    private final String connectorProfileName;

    private final DestinationConnectorProperties destinationConnectorProperties;

    private DestinationFlowConfig(BuilderImpl builder) {
        this.connectorType = builder.connectorType;
        this.apiVersion = builder.apiVersion;
        this.connectorProfileName = builder.connectorProfileName;
        this.destinationConnectorProperties = builder.destinationConnectorProperties;
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(connectorType);
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final String connectorTypeAsString() {
        return connectorType;
    }

    /**
     * <p>
     * The API version that the destination connector uses.
     * </p>
     * 
     * @return The API version that the destination connector uses.
     */
    public final String apiVersion() {
        return apiVersion;
    }

    /**
     * <p>
     * The name of the connector profile. This name must be unique for each connector profile in the Amazon Web Services
     * account.
     * </p>
     * 
     * @return The name of the connector profile. This name must be unique for each connector profile in the Amazon Web
     *         Services account.
     */
    public final String connectorProfileName() {
        return connectorProfileName;
    }

    /**
     * <p>
     * This stores the information that is required to query a particular connector.
     * </p>
     * 
     * @return This stores the information that is required to query a particular connector.
     */
    public final DestinationConnectorProperties destinationConnectorProperties() {
        return destinationConnectorProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(apiVersion());
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConnectorProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationFlowConfig)) {
            return false;
        }
        DestinationFlowConfig other = (DestinationFlowConfig) obj;
        return Objects.equals(connectorTypeAsString(), other.connectorTypeAsString())
                && Objects.equals(apiVersion(), other.apiVersion())
                && Objects.equals(connectorProfileName(), other.connectorProfileName())
                && Objects.equals(destinationConnectorProperties(), other.destinationConnectorProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationFlowConfig").add("ConnectorType", connectorTypeAsString())
                .add("ApiVersion", apiVersion()).add("ConnectorProfileName", connectorProfileName())
                .add("DestinationConnectorProperties", destinationConnectorProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorType":
            return Optional.ofNullable(clazz.cast(connectorTypeAsString()));
        case "apiVersion":
            return Optional.ofNullable(clazz.cast(apiVersion()));
        case "connectorProfileName":
            return Optional.ofNullable(clazz.cast(connectorProfileName()));
        case "destinationConnectorProperties":
            return Optional.ofNullable(clazz.cast(destinationConnectorProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectorType", CONNECTOR_TYPE_FIELD);
        map.put("apiVersion", API_VERSION_FIELD);
        map.put("connectorProfileName", CONNECTOR_PROFILE_NAME_FIELD);
        map.put("destinationConnectorProperties", DESTINATION_CONNECTOR_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DestinationFlowConfig, T> g) {
        return obj -> g.apply((DestinationFlowConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationFlowConfig> {
        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(ConnectorType connectorType);

        /**
         * <p>
         * The API version that the destination connector uses.
         * </p>
         * 
         * @param apiVersion
         *        The API version that the destination connector uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiVersion(String apiVersion);

        /**
         * <p>
         * The name of the connector profile. This name must be unique for each connector profile in the Amazon Web
         * Services account.
         * </p>
         * 
         * @param connectorProfileName
         *        The name of the connector profile. This name must be unique for each connector profile in the Amazon
         *        Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileName(String connectorProfileName);

        /**
         * <p>
         * This stores the information that is required to query a particular connector.
         * </p>
         * 
         * @param destinationConnectorProperties
         *        This stores the information that is required to query a particular connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConnectorProperties(DestinationConnectorProperties destinationConnectorProperties);

        /**
         * <p>
         * This stores the information that is required to query a particular connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConnectorProperties.Builder}
         * avoiding the need to create one manually via {@link DestinationConnectorProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConnectorProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #destinationConnectorProperties(DestinationConnectorProperties)}.
         * 
         * @param destinationConnectorProperties
         *        a consumer that will call methods on {@link DestinationConnectorProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConnectorProperties(DestinationConnectorProperties)
         */
        default Builder destinationConnectorProperties(
                Consumer<DestinationConnectorProperties.Builder> destinationConnectorProperties) {
            return destinationConnectorProperties(DestinationConnectorProperties.builder()
                    .applyMutation(destinationConnectorProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String connectorType;

        private String apiVersion;

        private String connectorProfileName;

        private DestinationConnectorProperties destinationConnectorProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationFlowConfig model) {
            connectorType(model.connectorType);
            apiVersion(model.apiVersion);
            connectorProfileName(model.connectorProfileName);
            destinationConnectorProperties(model.destinationConnectorProperties);
        }

        public final String getConnectorType() {
            return connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getApiVersion() {
            return apiVersion;
        }

        public final void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        @Override
        public final Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public final String getConnectorProfileName() {
            return connectorProfileName;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final DestinationConnectorProperties.Builder getDestinationConnectorProperties() {
            return destinationConnectorProperties != null ? destinationConnectorProperties.toBuilder() : null;
        }

        public final void setDestinationConnectorProperties(
                DestinationConnectorProperties.BuilderImpl destinationConnectorProperties) {
            this.destinationConnectorProperties = destinationConnectorProperties != null ? destinationConnectorProperties.build()
                    : null;
        }

        @Override
        public final Builder destinationConnectorProperties(DestinationConnectorProperties destinationConnectorProperties) {
            this.destinationConnectorProperties = destinationConnectorProperties;
            return this;
        }

        @Override
        public DestinationFlowConfig build() {
            return new DestinationFlowConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
