/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the default values required for OAuth 2.0 authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OAuth2Defaults implements SdkPojo, Serializable, ToCopyableBuilder<OAuth2Defaults.Builder, OAuth2Defaults> {
    private static final SdkField<List<String>> OAUTH_SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("oauthScopes")
            .getter(getter(OAuth2Defaults::oauthScopes))
            .setter(setter(Builder::oauthScopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauthScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TOKEN_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("tokenUrls")
            .getter(getter(OAuth2Defaults::tokenUrls))
            .setter(setter(Builder::tokenUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AUTH_CODE_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("authCodeUrls")
            .getter(getter(OAuth2Defaults::authCodeUrls))
            .setter(setter(Builder::authCodeUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authCodeUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OAUTH2_GRANT_TYPES_SUPPORTED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("oauth2GrantTypesSupported")
            .getter(getter(OAuth2Defaults::oauth2GrantTypesSupportedAsStrings))
            .setter(setter(Builder::oauth2GrantTypesSupportedWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauth2GrantTypesSupported").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OAuth2CustomParameter>> OAUTH2_CUSTOM_PROPERTIES_FIELD = SdkField
            .<List<OAuth2CustomParameter>> builder(MarshallingType.LIST)
            .memberName("oauth2CustomProperties")
            .getter(getter(OAuth2Defaults::oauth2CustomProperties))
            .setter(setter(Builder::oauth2CustomProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauth2CustomProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OAuth2CustomParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OAuth2CustomParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OAUTH_SCOPES_FIELD,
            TOKEN_URLS_FIELD, AUTH_CODE_URLS_FIELD, OAUTH2_GRANT_TYPES_SUPPORTED_FIELD, OAUTH2_CUSTOM_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> oauthScopes;

    private final List<String> tokenUrls;

    private final List<String> authCodeUrls;

    private final List<String> oauth2GrantTypesSupported;

    private final List<OAuth2CustomParameter> oauth2CustomProperties;

    private OAuth2Defaults(BuilderImpl builder) {
        this.oauthScopes = builder.oauthScopes;
        this.tokenUrls = builder.tokenUrls;
        this.authCodeUrls = builder.authCodeUrls;
        this.oauth2GrantTypesSupported = builder.oauth2GrantTypesSupported;
        this.oauth2CustomProperties = builder.oauth2CustomProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the OauthScopes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOauthScopes() {
        return oauthScopes != null && !(oauthScopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * OAuth 2.0 scopes that the connector supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOauthScopes} method.
     * </p>
     * 
     * @return OAuth 2.0 scopes that the connector supports.
     */
    public final List<String> oauthScopes() {
        return oauthScopes;
    }

    /**
     * For responses, this returns true if the service returned a value for the TokenUrls property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTokenUrls() {
        return tokenUrls != null && !(tokenUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Token URLs that can be used for OAuth 2.0 authentication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTokenUrls} method.
     * </p>
     * 
     * @return Token URLs that can be used for OAuth 2.0 authentication.
     */
    public final List<String> tokenUrls() {
        return tokenUrls;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthCodeUrls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthCodeUrls() {
        return authCodeUrls != null && !(authCodeUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Auth code URLs that can be used for OAuth 2.0 authentication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthCodeUrls} method.
     * </p>
     * 
     * @return Auth code URLs that can be used for OAuth 2.0 authentication.
     */
    public final List<String> authCodeUrls() {
        return authCodeUrls;
    }

    /**
     * <p>
     * OAuth 2.0 grant types supported by the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOauth2GrantTypesSupported} method.
     * </p>
     * 
     * @return OAuth 2.0 grant types supported by the connector.
     */
    public final List<OAuth2GrantType> oauth2GrantTypesSupported() {
        return OAuth2GrantTypeSupportedListCopier.copyStringToEnum(oauth2GrantTypesSupported);
    }

    /**
     * For responses, this returns true if the service returned a value for the Oauth2GrantTypesSupported property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOauth2GrantTypesSupported() {
        return oauth2GrantTypesSupported != null && !(oauth2GrantTypesSupported instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * OAuth 2.0 grant types supported by the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOauth2GrantTypesSupported} method.
     * </p>
     * 
     * @return OAuth 2.0 grant types supported by the connector.
     */
    public final List<String> oauth2GrantTypesSupportedAsStrings() {
        return oauth2GrantTypesSupported;
    }

    /**
     * For responses, this returns true if the service returned a value for the Oauth2CustomProperties property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOauth2CustomProperties() {
        return oauth2CustomProperties != null && !(oauth2CustomProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of custom parameters required for OAuth 2.0 authentication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOauth2CustomProperties} method.
     * </p>
     * 
     * @return List of custom parameters required for OAuth 2.0 authentication.
     */
    public final List<OAuth2CustomParameter> oauth2CustomProperties() {
        return oauth2CustomProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOauthScopes() ? oauthScopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTokenUrls() ? tokenUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthCodeUrls() ? authCodeUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOauth2GrantTypesSupported() ? oauth2GrantTypesSupportedAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOauth2CustomProperties() ? oauth2CustomProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2Defaults)) {
            return false;
        }
        OAuth2Defaults other = (OAuth2Defaults) obj;
        return hasOauthScopes() == other.hasOauthScopes() && Objects.equals(oauthScopes(), other.oauthScopes())
                && hasTokenUrls() == other.hasTokenUrls() && Objects.equals(tokenUrls(), other.tokenUrls())
                && hasAuthCodeUrls() == other.hasAuthCodeUrls() && Objects.equals(authCodeUrls(), other.authCodeUrls())
                && hasOauth2GrantTypesSupported() == other.hasOauth2GrantTypesSupported()
                && Objects.equals(oauth2GrantTypesSupportedAsStrings(), other.oauth2GrantTypesSupportedAsStrings())
                && hasOauth2CustomProperties() == other.hasOauth2CustomProperties()
                && Objects.equals(oauth2CustomProperties(), other.oauth2CustomProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OAuth2Defaults").add("OauthScopes", hasOauthScopes() ? oauthScopes() : null)
                .add("TokenUrls", hasTokenUrls() ? tokenUrls() : null)
                .add("AuthCodeUrls", hasAuthCodeUrls() ? authCodeUrls() : null)
                .add("Oauth2GrantTypesSupported", hasOauth2GrantTypesSupported() ? oauth2GrantTypesSupportedAsStrings() : null)
                .add("Oauth2CustomProperties", hasOauth2CustomProperties() ? oauth2CustomProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "oauthScopes":
            return Optional.ofNullable(clazz.cast(oauthScopes()));
        case "tokenUrls":
            return Optional.ofNullable(clazz.cast(tokenUrls()));
        case "authCodeUrls":
            return Optional.ofNullable(clazz.cast(authCodeUrls()));
        case "oauth2GrantTypesSupported":
            return Optional.ofNullable(clazz.cast(oauth2GrantTypesSupportedAsStrings()));
        case "oauth2CustomProperties":
            return Optional.ofNullable(clazz.cast(oauth2CustomProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("oauthScopes", OAUTH_SCOPES_FIELD);
        map.put("tokenUrls", TOKEN_URLS_FIELD);
        map.put("authCodeUrls", AUTH_CODE_URLS_FIELD);
        map.put("oauth2GrantTypesSupported", OAUTH2_GRANT_TYPES_SUPPORTED_FIELD);
        map.put("oauth2CustomProperties", OAUTH2_CUSTOM_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuth2Defaults, T> g) {
        return obj -> g.apply((OAuth2Defaults) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OAuth2Defaults> {
        /**
         * <p>
         * OAuth 2.0 scopes that the connector supports.
         * </p>
         * 
         * @param oauthScopes
         *        OAuth 2.0 scopes that the connector supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauthScopes(Collection<String> oauthScopes);

        /**
         * <p>
         * OAuth 2.0 scopes that the connector supports.
         * </p>
         * 
         * @param oauthScopes
         *        OAuth 2.0 scopes that the connector supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauthScopes(String... oauthScopes);

        /**
         * <p>
         * Token URLs that can be used for OAuth 2.0 authentication.
         * </p>
         * 
         * @param tokenUrls
         *        Token URLs that can be used for OAuth 2.0 authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenUrls(Collection<String> tokenUrls);

        /**
         * <p>
         * Token URLs that can be used for OAuth 2.0 authentication.
         * </p>
         * 
         * @param tokenUrls
         *        Token URLs that can be used for OAuth 2.0 authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenUrls(String... tokenUrls);

        /**
         * <p>
         * Auth code URLs that can be used for OAuth 2.0 authentication.
         * </p>
         * 
         * @param authCodeUrls
         *        Auth code URLs that can be used for OAuth 2.0 authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authCodeUrls(Collection<String> authCodeUrls);

        /**
         * <p>
         * Auth code URLs that can be used for OAuth 2.0 authentication.
         * </p>
         * 
         * @param authCodeUrls
         *        Auth code URLs that can be used for OAuth 2.0 authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authCodeUrls(String... authCodeUrls);

        /**
         * <p>
         * OAuth 2.0 grant types supported by the connector.
         * </p>
         * 
         * @param oauth2GrantTypesSupported
         *        OAuth 2.0 grant types supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauth2GrantTypesSupportedWithStrings(Collection<String> oauth2GrantTypesSupported);

        /**
         * <p>
         * OAuth 2.0 grant types supported by the connector.
         * </p>
         * 
         * @param oauth2GrantTypesSupported
         *        OAuth 2.0 grant types supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauth2GrantTypesSupportedWithStrings(String... oauth2GrantTypesSupported);

        /**
         * <p>
         * OAuth 2.0 grant types supported by the connector.
         * </p>
         * 
         * @param oauth2GrantTypesSupported
         *        OAuth 2.0 grant types supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauth2GrantTypesSupported(Collection<OAuth2GrantType> oauth2GrantTypesSupported);

        /**
         * <p>
         * OAuth 2.0 grant types supported by the connector.
         * </p>
         * 
         * @param oauth2GrantTypesSupported
         *        OAuth 2.0 grant types supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauth2GrantTypesSupported(OAuth2GrantType... oauth2GrantTypesSupported);

        /**
         * <p>
         * List of custom parameters required for OAuth 2.0 authentication.
         * </p>
         * 
         * @param oauth2CustomProperties
         *        List of custom parameters required for OAuth 2.0 authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauth2CustomProperties(Collection<OAuth2CustomParameter> oauth2CustomProperties);

        /**
         * <p>
         * List of custom parameters required for OAuth 2.0 authentication.
         * </p>
         * 
         * @param oauth2CustomProperties
         *        List of custom parameters required for OAuth 2.0 authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauth2CustomProperties(OAuth2CustomParameter... oauth2CustomProperties);

        /**
         * <p>
         * List of custom parameters required for OAuth 2.0 authentication.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appflow.model.OAuth2CustomParameter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.appflow.model.OAuth2CustomParameter#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appflow.model.OAuth2CustomParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #oauth2CustomProperties(List<OAuth2CustomParameter>)}.
         * 
         * @param oauth2CustomProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appflow.model.OAuth2CustomParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oauth2CustomProperties(java.util.Collection<OAuth2CustomParameter>)
         */
        Builder oauth2CustomProperties(Consumer<OAuth2CustomParameter.Builder>... oauth2CustomProperties);
    }

    static final class BuilderImpl implements Builder {
        private List<String> oauthScopes = DefaultSdkAutoConstructList.getInstance();

        private List<String> tokenUrls = DefaultSdkAutoConstructList.getInstance();

        private List<String> authCodeUrls = DefaultSdkAutoConstructList.getInstance();

        private List<String> oauth2GrantTypesSupported = DefaultSdkAutoConstructList.getInstance();

        private List<OAuth2CustomParameter> oauth2CustomProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2Defaults model) {
            oauthScopes(model.oauthScopes);
            tokenUrls(model.tokenUrls);
            authCodeUrls(model.authCodeUrls);
            oauth2GrantTypesSupportedWithStrings(model.oauth2GrantTypesSupported);
            oauth2CustomProperties(model.oauth2CustomProperties);
        }

        public final Collection<String> getOauthScopes() {
            if (oauthScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return oauthScopes;
        }

        public final void setOauthScopes(Collection<String> oauthScopes) {
            this.oauthScopes = OAuthScopeListCopier.copy(oauthScopes);
        }

        @Override
        public final Builder oauthScopes(Collection<String> oauthScopes) {
            this.oauthScopes = OAuthScopeListCopier.copy(oauthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oauthScopes(String... oauthScopes) {
            oauthScopes(Arrays.asList(oauthScopes));
            return this;
        }

        public final Collection<String> getTokenUrls() {
            if (tokenUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return tokenUrls;
        }

        public final void setTokenUrls(Collection<String> tokenUrls) {
            this.tokenUrls = TokenUrlListCopier.copy(tokenUrls);
        }

        @Override
        public final Builder tokenUrls(Collection<String> tokenUrls) {
            this.tokenUrls = TokenUrlListCopier.copy(tokenUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenUrls(String... tokenUrls) {
            tokenUrls(Arrays.asList(tokenUrls));
            return this;
        }

        public final Collection<String> getAuthCodeUrls() {
            if (authCodeUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return authCodeUrls;
        }

        public final void setAuthCodeUrls(Collection<String> authCodeUrls) {
            this.authCodeUrls = AuthCodeUrlListCopier.copy(authCodeUrls);
        }

        @Override
        public final Builder authCodeUrls(Collection<String> authCodeUrls) {
            this.authCodeUrls = AuthCodeUrlListCopier.copy(authCodeUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authCodeUrls(String... authCodeUrls) {
            authCodeUrls(Arrays.asList(authCodeUrls));
            return this;
        }

        public final Collection<String> getOauth2GrantTypesSupported() {
            if (oauth2GrantTypesSupported instanceof SdkAutoConstructList) {
                return null;
            }
            return oauth2GrantTypesSupported;
        }

        public final void setOauth2GrantTypesSupported(Collection<String> oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupported = OAuth2GrantTypeSupportedListCopier.copy(oauth2GrantTypesSupported);
        }

        @Override
        public final Builder oauth2GrantTypesSupportedWithStrings(Collection<String> oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupported = OAuth2GrantTypeSupportedListCopier.copy(oauth2GrantTypesSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oauth2GrantTypesSupportedWithStrings(String... oauth2GrantTypesSupported) {
            oauth2GrantTypesSupportedWithStrings(Arrays.asList(oauth2GrantTypesSupported));
            return this;
        }

        @Override
        public final Builder oauth2GrantTypesSupported(Collection<OAuth2GrantType> oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupported = OAuth2GrantTypeSupportedListCopier.copyEnumToString(oauth2GrantTypesSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oauth2GrantTypesSupported(OAuth2GrantType... oauth2GrantTypesSupported) {
            oauth2GrantTypesSupported(Arrays.asList(oauth2GrantTypesSupported));
            return this;
        }

        public final List<OAuth2CustomParameter.Builder> getOauth2CustomProperties() {
            List<OAuth2CustomParameter.Builder> result = OAuth2CustomPropertiesListCopier
                    .copyToBuilder(this.oauth2CustomProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOauth2CustomProperties(Collection<OAuth2CustomParameter.BuilderImpl> oauth2CustomProperties) {
            this.oauth2CustomProperties = OAuth2CustomPropertiesListCopier.copyFromBuilder(oauth2CustomProperties);
        }

        @Override
        public final Builder oauth2CustomProperties(Collection<OAuth2CustomParameter> oauth2CustomProperties) {
            this.oauth2CustomProperties = OAuth2CustomPropertiesListCopier.copy(oauth2CustomProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oauth2CustomProperties(OAuth2CustomParameter... oauth2CustomProperties) {
            oauth2CustomProperties(Arrays.asList(oauth2CustomProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oauth2CustomProperties(Consumer<OAuth2CustomParameter.Builder>... oauth2CustomProperties) {
            oauth2CustomProperties(Stream.of(oauth2CustomProperties)
                    .map(c -> OAuth2CustomParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public OAuth2Defaults build() {
            return new OAuth2Defaults(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
