/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the
 * destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3OutputFormatConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<S3OutputFormatConfig.Builder, S3OutputFormatConfig> {
    private static final SdkField<String> FILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileType").getter(getter(S3OutputFormatConfig::fileTypeAsString)).setter(setter(Builder::fileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileType").build()).build();

    private static final SdkField<PrefixConfig> PREFIX_CONFIG_FIELD = SdkField.<PrefixConfig> builder(MarshallingType.SDK_POJO)
            .memberName("prefixConfig").getter(getter(S3OutputFormatConfig::prefixConfig)).setter(setter(Builder::prefixConfig))
            .constructor(PrefixConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefixConfig").build()).build();

    private static final SdkField<AggregationConfig> AGGREGATION_CONFIG_FIELD = SdkField
            .<AggregationConfig> builder(MarshallingType.SDK_POJO).memberName("aggregationConfig")
            .getter(getter(S3OutputFormatConfig::aggregationConfig)).setter(setter(Builder::aggregationConfig))
            .constructor(AggregationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationConfig").build()).build();

    private static final SdkField<Boolean> PRESERVE_SOURCE_DATA_TYPING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("preserveSourceDataTyping")
            .getter(getter(S3OutputFormatConfig::preserveSourceDataTyping)).setter(setter(Builder::preserveSourceDataTyping))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preserveSourceDataTyping").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_TYPE_FIELD,
            PREFIX_CONFIG_FIELD, AGGREGATION_CONFIG_FIELD, PRESERVE_SOURCE_DATA_TYPING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fileType;

    private final PrefixConfig prefixConfig;

    private final AggregationConfig aggregationConfig;

    private final Boolean preserveSourceDataTyping;

    private S3OutputFormatConfig(BuilderImpl builder) {
        this.fileType = builder.fileType;
        this.prefixConfig = builder.prefixConfig;
        this.aggregationConfig = builder.aggregationConfig;
        this.preserveSourceDataTyping = builder.preserveSourceDataTyping;
    }

    /**
     * <p>
     * Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileType} will
     * return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileTypeAsString}.
     * </p>
     * 
     * @return Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
     * @see FileType
     */
    public final FileType fileType() {
        return FileType.fromValue(fileType);
    }

    /**
     * <p>
     * Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileType} will
     * return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileTypeAsString}.
     * </p>
     * 
     * @return Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
     * @see FileType
     */
    public final String fileTypeAsString() {
        return fileType;
    }

    /**
     * <p>
     * Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name
     * folders according to the flow frequency and date.
     * </p>
     * 
     * @return Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can
     *         name folders according to the flow frequency and date.
     */
    public final PrefixConfig prefixConfig() {
        return prefixConfig;
    }

    /**
     * Returns the value of the AggregationConfig property for this object.
     * 
     * @return The value of the AggregationConfig property for this object.
     */
    public final AggregationConfig aggregationConfig() {
        return aggregationConfig;
    }

    /**
     * <p>
     * If your file output format is Parquet, use this parameter to set whether Amazon AppFlow preserves the data types
     * in your source data when it writes the output to Amazon S3.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>true</code>: Amazon AppFlow preserves the data types when it writes to Amazon S3. For example, an integer
     * or <code>1</code> in your source data is still an integer in your output.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>false</code>: Amazon AppFlow converts all of the source data into strings when it writes to Amazon S3. For
     * example, an integer of <code>1</code> in your source data becomes the string <code>"1"</code> in the output.
     * </p>
     * </li>
     * </ul>
     * 
     * @return If your file output format is Parquet, use this parameter to set whether Amazon AppFlow preserves the
     *         data types in your source data when it writes the output to Amazon S3. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>true</code>: Amazon AppFlow preserves the data types when it writes to Amazon S3. For example, an
     *         integer or <code>1</code> in your source data is still an integer in your output.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>false</code>: Amazon AppFlow converts all of the source data into strings when it writes to Amazon
     *         S3. For example, an integer of <code>1</code> in your source data becomes the string <code>"1"</code> in
     *         the output.
     *         </p>
     *         </li>
     */
    public final Boolean preserveSourceDataTyping() {
        return preserveSourceDataTyping;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(prefixConfig());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(preserveSourceDataTyping());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OutputFormatConfig)) {
            return false;
        }
        S3OutputFormatConfig other = (S3OutputFormatConfig) obj;
        return Objects.equals(fileTypeAsString(), other.fileTypeAsString())
                && Objects.equals(prefixConfig(), other.prefixConfig())
                && Objects.equals(aggregationConfig(), other.aggregationConfig())
                && Objects.equals(preserveSourceDataTyping(), other.preserveSourceDataTyping());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3OutputFormatConfig").add("FileType", fileTypeAsString()).add("PrefixConfig", prefixConfig())
                .add("AggregationConfig", aggregationConfig()).add("PreserveSourceDataTyping", preserveSourceDataTyping())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileType":
            return Optional.ofNullable(clazz.cast(fileTypeAsString()));
        case "prefixConfig":
            return Optional.ofNullable(clazz.cast(prefixConfig()));
        case "aggregationConfig":
            return Optional.ofNullable(clazz.cast(aggregationConfig()));
        case "preserveSourceDataTyping":
            return Optional.ofNullable(clazz.cast(preserveSourceDataTyping()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fileType", FILE_TYPE_FIELD);
        map.put("prefixConfig", PREFIX_CONFIG_FIELD);
        map.put("aggregationConfig", AGGREGATION_CONFIG_FIELD);
        map.put("preserveSourceDataTyping", PRESERVE_SOURCE_DATA_TYPING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3OutputFormatConfig, T> g) {
        return obj -> g.apply((S3OutputFormatConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3OutputFormatConfig> {
        /**
         * <p>
         * Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
         * </p>
         * 
         * @param fileType
         *        Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder fileType(String fileType);

        /**
         * <p>
         * Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
         * </p>
         * 
         * @param fileType
         *        Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder fileType(FileType fileType);

        /**
         * <p>
         * Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name
         * folders according to the flow frequency and date.
         * </p>
         * 
         * @param prefixConfig
         *        Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can
         *        name folders according to the flow frequency and date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixConfig(PrefixConfig prefixConfig);

        /**
         * <p>
         * Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name
         * folders according to the flow frequency and date.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrefixConfig.Builder} avoiding the need
         * to create one manually via {@link PrefixConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrefixConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #prefixConfig(PrefixConfig)}.
         * 
         * @param prefixConfig
         *        a consumer that will call methods on {@link PrefixConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prefixConfig(PrefixConfig)
         */
        default Builder prefixConfig(Consumer<PrefixConfig.Builder> prefixConfig) {
            return prefixConfig(PrefixConfig.builder().applyMutation(prefixConfig).build());
        }

        /**
         * Sets the value of the AggregationConfig property for this object.
         *
         * @param aggregationConfig
         *        The new value for the AggregationConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationConfig(AggregationConfig aggregationConfig);

        /**
         * Sets the value of the AggregationConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AggregationConfig.Builder} avoiding the
         * need to create one manually via {@link AggregationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #aggregationConfig(AggregationConfig)}.
         * 
         * @param aggregationConfig
         *        a consumer that will call methods on {@link AggregationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationConfig(AggregationConfig)
         */
        default Builder aggregationConfig(Consumer<AggregationConfig.Builder> aggregationConfig) {
            return aggregationConfig(AggregationConfig.builder().applyMutation(aggregationConfig).build());
        }

        /**
         * <p>
         * If your file output format is Parquet, use this parameter to set whether Amazon AppFlow preserves the data
         * types in your source data when it writes the output to Amazon S3.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>true</code>: Amazon AppFlow preserves the data types when it writes to Amazon S3. For example, an
         * integer or <code>1</code> in your source data is still an integer in your output.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>false</code>: Amazon AppFlow converts all of the source data into strings when it writes to Amazon S3.
         * For example, an integer of <code>1</code> in your source data becomes the string <code>"1"</code> in the
         * output.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preserveSourceDataTyping
         *        If your file output format is Parquet, use this parameter to set whether Amazon AppFlow preserves the
         *        data types in your source data when it writes the output to Amazon S3. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>true</code>: Amazon AppFlow preserves the data types when it writes to Amazon S3. For example,
         *        an integer or <code>1</code> in your source data is still an integer in your output.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>false</code>: Amazon AppFlow converts all of the source data into strings when it writes to
         *        Amazon S3. For example, an integer of <code>1</code> in your source data becomes the string
         *        <code>"1"</code> in the output.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preserveSourceDataTyping(Boolean preserveSourceDataTyping);
    }

    static final class BuilderImpl implements Builder {
        private String fileType;

        private PrefixConfig prefixConfig;

        private AggregationConfig aggregationConfig;

        private Boolean preserveSourceDataTyping;

        private BuilderImpl() {
        }

        private BuilderImpl(S3OutputFormatConfig model) {
            fileType(model.fileType);
            prefixConfig(model.prefixConfig);
            aggregationConfig(model.aggregationConfig);
            preserveSourceDataTyping(model.preserveSourceDataTyping);
        }

        public final String getFileType() {
            return fileType;
        }

        public final void setFileType(String fileType) {
            this.fileType = fileType;
        }

        @Override
        public final Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        @Override
        public final Builder fileType(FileType fileType) {
            this.fileType(fileType == null ? null : fileType.toString());
            return this;
        }

        public final PrefixConfig.Builder getPrefixConfig() {
            return prefixConfig != null ? prefixConfig.toBuilder() : null;
        }

        public final void setPrefixConfig(PrefixConfig.BuilderImpl prefixConfig) {
            this.prefixConfig = prefixConfig != null ? prefixConfig.build() : null;
        }

        @Override
        public final Builder prefixConfig(PrefixConfig prefixConfig) {
            this.prefixConfig = prefixConfig;
            return this;
        }

        public final AggregationConfig.Builder getAggregationConfig() {
            return aggregationConfig != null ? aggregationConfig.toBuilder() : null;
        }

        public final void setAggregationConfig(AggregationConfig.BuilderImpl aggregationConfig) {
            this.aggregationConfig = aggregationConfig != null ? aggregationConfig.build() : null;
        }

        @Override
        public final Builder aggregationConfig(AggregationConfig aggregationConfig) {
            this.aggregationConfig = aggregationConfig;
            return this;
        }

        public final Boolean getPreserveSourceDataTyping() {
            return preserveSourceDataTyping;
        }

        public final void setPreserveSourceDataTyping(Boolean preserveSourceDataTyping) {
            this.preserveSourceDataTyping = preserveSourceDataTyping;
        }

        @Override
        public final Builder preserveSourceDataTyping(Boolean preserveSourceDataTyping) {
            this.preserveSourceDataTyping = preserveSourceDataTyping;
            return this;
        }

        @Override
        public S3OutputFormatConfig build() {
            return new S3OutputFormatConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
