/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific profile credentials required when using SAPOData.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SAPODataConnectorProfileCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<SAPODataConnectorProfileCredentials.Builder, SAPODataConnectorProfileCredentials> {
    private static final SdkField<BasicAuthCredentials> BASIC_AUTH_CREDENTIALS_FIELD = SdkField
            .<BasicAuthCredentials> builder(MarshallingType.SDK_POJO).memberName("basicAuthCredentials")
            .getter(getter(SAPODataConnectorProfileCredentials::basicAuthCredentials))
            .setter(setter(Builder::basicAuthCredentials)).constructor(BasicAuthCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build())
            .build();

    private static final SdkField<OAuthCredentials> O_AUTH_CREDENTIALS_FIELD = SdkField
            .<OAuthCredentials> builder(MarshallingType.SDK_POJO).memberName("oAuthCredentials")
            .getter(getter(SAPODataConnectorProfileCredentials::oAuthCredentials)).setter(setter(Builder::oAuthCredentials))
            .constructor(OAuthCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthCredentials").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASIC_AUTH_CREDENTIALS_FIELD,
            O_AUTH_CREDENTIALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BasicAuthCredentials basicAuthCredentials;

    private final OAuthCredentials oAuthCredentials;

    private SAPODataConnectorProfileCredentials(BuilderImpl builder) {
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.oAuthCredentials = builder.oAuthCredentials;
    }

    /**
     * <p>
     * The SAPOData basic authentication credentials.
     * </p>
     * 
     * @return The SAPOData basic authentication credentials.
     */
    public final BasicAuthCredentials basicAuthCredentials() {
        return basicAuthCredentials;
    }

    /**
     * <p>
     * The SAPOData OAuth type authentication credentials.
     * </p>
     * 
     * @return The SAPOData OAuth type authentication credentials.
     */
    public final OAuthCredentials oAuthCredentials() {
        return oAuthCredentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthCredentials());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAPODataConnectorProfileCredentials)) {
            return false;
        }
        SAPODataConnectorProfileCredentials other = (SAPODataConnectorProfileCredentials) obj;
        return Objects.equals(basicAuthCredentials(), other.basicAuthCredentials())
                && Objects.equals(oAuthCredentials(), other.oAuthCredentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SAPODataConnectorProfileCredentials").add("BasicAuthCredentials", basicAuthCredentials())
                .add("OAuthCredentials", oAuthCredentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "basicAuthCredentials":
            return Optional.ofNullable(clazz.cast(basicAuthCredentials()));
        case "oAuthCredentials":
            return Optional.ofNullable(clazz.cast(oAuthCredentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("basicAuthCredentials", BASIC_AUTH_CREDENTIALS_FIELD);
        map.put("oAuthCredentials", O_AUTH_CREDENTIALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SAPODataConnectorProfileCredentials, T> g) {
        return obj -> g.apply((SAPODataConnectorProfileCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SAPODataConnectorProfileCredentials> {
        /**
         * <p>
         * The SAPOData basic authentication credentials.
         * </p>
         * 
         * @param basicAuthCredentials
         *        The SAPOData basic authentication credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthCredentials(BasicAuthCredentials basicAuthCredentials);

        /**
         * <p>
         * The SAPOData basic authentication credentials.
         * </p>
         * This is a convenience method that creates an instance of the {@link BasicAuthCredentials.Builder} avoiding
         * the need to create one manually via {@link BasicAuthCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BasicAuthCredentials.Builder#build()} is called immediately and
         * its result is passed to {@link #basicAuthCredentials(BasicAuthCredentials)}.
         * 
         * @param basicAuthCredentials
         *        a consumer that will call methods on {@link BasicAuthCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #basicAuthCredentials(BasicAuthCredentials)
         */
        default Builder basicAuthCredentials(Consumer<BasicAuthCredentials.Builder> basicAuthCredentials) {
            return basicAuthCredentials(BasicAuthCredentials.builder().applyMutation(basicAuthCredentials).build());
        }

        /**
         * <p>
         * The SAPOData OAuth type authentication credentials.
         * </p>
         * 
         * @param oAuthCredentials
         *        The SAPOData OAuth type authentication credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthCredentials(OAuthCredentials oAuthCredentials);

        /**
         * <p>
         * The SAPOData OAuth type authentication credentials.
         * </p>
         * This is a convenience method that creates an instance of the {@link OAuthCredentials.Builder} avoiding the
         * need to create one manually via {@link OAuthCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OAuthCredentials.Builder#build()} is called immediately and its
         * result is passed to {@link #oAuthCredentials(OAuthCredentials)}.
         * 
         * @param oAuthCredentials
         *        a consumer that will call methods on {@link OAuthCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuthCredentials(OAuthCredentials)
         */
        default Builder oAuthCredentials(Consumer<OAuthCredentials.Builder> oAuthCredentials) {
            return oAuthCredentials(OAuthCredentials.builder().applyMutation(oAuthCredentials).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BasicAuthCredentials basicAuthCredentials;

        private OAuthCredentials oAuthCredentials;

        private BuilderImpl() {
        }

        private BuilderImpl(SAPODataConnectorProfileCredentials model) {
            basicAuthCredentials(model.basicAuthCredentials);
            oAuthCredentials(model.oAuthCredentials);
        }

        public final BasicAuthCredentials.Builder getBasicAuthCredentials() {
            return basicAuthCredentials != null ? basicAuthCredentials.toBuilder() : null;
        }

        public final void setBasicAuthCredentials(BasicAuthCredentials.BuilderImpl basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials != null ? basicAuthCredentials.build() : null;
        }

        @Override
        public final Builder basicAuthCredentials(BasicAuthCredentials basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final OAuthCredentials.Builder getOAuthCredentials() {
            return oAuthCredentials != null ? oAuthCredentials.toBuilder() : null;
        }

        public final void setOAuthCredentials(OAuthCredentials.BuilderImpl oAuthCredentials) {
            this.oAuthCredentials = oAuthCredentials != null ? oAuthCredentials.build() : null;
        }

        @Override
        public final Builder oAuthCredentials(OAuthCredentials oAuthCredentials) {
            this.oAuthCredentials = oAuthCredentials;
            return this;
        }

        @Override
        public SAPODataConnectorProfileCredentials build() {
            return new SAPODataConnectorProfileCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
