/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sets the page size for each <i>concurrent process</i> that transfers OData records from your SAP instance. A
 * concurrent process is query that retrieves a batch of records as part of a flow run. Amazon AppFlow can run multiple
 * concurrent processes in parallel to transfer data faster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SAPODataPaginationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SAPODataPaginationConfig.Builder, SAPODataPaginationConfig> {
    private static final SdkField<Integer> MAX_PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxPageSize").getter(getter(SAPODataPaginationConfig::maxPageSize)).setter(setter(Builder::maxPageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxPageSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_PAGE_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maxPageSize;

    private SAPODataPaginationConfig(BuilderImpl builder) {
        this.maxPageSize = builder.maxPageSize;
    }

    /**
     * <p>
     * The maximum number of records that Amazon AppFlow receives in each page of the response from your SAP
     * application. For transfers of OData records, the maximum page size is 3,000. For transfers of data that comes
     * from an ODP provider, the maximum page size is 10,000.
     * </p>
     * 
     * @return The maximum number of records that Amazon AppFlow receives in each page of the response from your SAP
     *         application. For transfers of OData records, the maximum page size is 3,000. For transfers of data that
     *         comes from an ODP provider, the maximum page size is 10,000.
     */
    public final Integer maxPageSize() {
        return maxPageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxPageSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAPODataPaginationConfig)) {
            return false;
        }
        SAPODataPaginationConfig other = (SAPODataPaginationConfig) obj;
        return Objects.equals(maxPageSize(), other.maxPageSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SAPODataPaginationConfig").add("MaxPageSize", maxPageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxPageSize":
            return Optional.ofNullable(clazz.cast(maxPageSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxPageSize", MAX_PAGE_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SAPODataPaginationConfig, T> g) {
        return obj -> g.apply((SAPODataPaginationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SAPODataPaginationConfig> {
        /**
         * <p>
         * The maximum number of records that Amazon AppFlow receives in each page of the response from your SAP
         * application. For transfers of OData records, the maximum page size is 3,000. For transfers of data that comes
         * from an ODP provider, the maximum page size is 10,000.
         * </p>
         * 
         * @param maxPageSize
         *        The maximum number of records that Amazon AppFlow receives in each page of the response from your SAP
         *        application. For transfers of OData records, the maximum page size is 3,000. For transfers of data
         *        that comes from an ODP provider, the maximum page size is 10,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPageSize(Integer maxPageSize);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxPageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(SAPODataPaginationConfig model) {
            maxPageSize(model.maxPageSize);
        }

        public final Integer getMaxPageSize() {
            return maxPageSize;
        }

        public final void setMaxPageSize(Integer maxPageSize) {
            this.maxPageSize = maxPageSize;
        }

        @Override
        public final Builder maxPageSize(Integer maxPageSize) {
            this.maxPageSize = maxPageSize;
            return this;
        }

        @Override
        public SAPODataPaginationConfig build() {
            return new SAPODataPaginationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
