/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.AuthenticationConfig;
import software.amazon.awssdk.services.appflow.model.ConnectorMetadata;
import software.amazon.awssdk.services.appflow.model.ConnectorModeListCopier;
import software.amazon.awssdk.services.appflow.model.ConnectorProvisioningConfig;
import software.amazon.awssdk.services.appflow.model.ConnectorProvisioningType;
import software.amazon.awssdk.services.appflow.model.ConnectorRuntimeSetting;
import software.amazon.awssdk.services.appflow.model.ConnectorRuntimeSettingListCopier;
import software.amazon.awssdk.services.appflow.model.ConnectorType;
import software.amazon.awssdk.services.appflow.model.ConnectorTypeListCopier;
import software.amazon.awssdk.services.appflow.model.DataTransferApi;
import software.amazon.awssdk.services.appflow.model.Operators;
import software.amazon.awssdk.services.appflow.model.ScheduleFrequencyType;
import software.amazon.awssdk.services.appflow.model.SchedulingFrequencyTypeListCopier;
import software.amazon.awssdk.services.appflow.model.SupportedApiVersionListCopier;
import software.amazon.awssdk.services.appflow.model.SupportedDataTransferApisCopier;
import software.amazon.awssdk.services.appflow.model.SupportedDataTransferType;
import software.amazon.awssdk.services.appflow.model.SupportedDataTransferTypeListCopier;
import software.amazon.awssdk.services.appflow.model.SupportedOperatorListCopier;
import software.amazon.awssdk.services.appflow.model.SupportedWriteOperationListCopier;
import software.amazon.awssdk.services.appflow.model.TriggerType;
import software.amazon.awssdk.services.appflow.model.TriggerTypeListCopier;
import software.amazon.awssdk.services.appflow.model.WriteOperationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorConfiguration> {
    private static final SdkField<Boolean> CAN_USE_AS_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("canUseAsSource").getter(ConnectorConfiguration.getter(ConnectorConfiguration::canUseAsSource)).setter(ConnectorConfiguration.setter(Builder::canUseAsSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canUseAsSource").build()}).build();
    private static final SdkField<Boolean> CAN_USE_AS_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("canUseAsDestination").getter(ConnectorConfiguration.getter(ConnectorConfiguration::canUseAsDestination)).setter(ConnectorConfiguration.setter(Builder::canUseAsDestination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canUseAsDestination").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_DESTINATION_CONNECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedDestinationConnectors").getter(ConnectorConfiguration.getter(ConnectorConfiguration::supportedDestinationConnectorsAsStrings)).setter(ConnectorConfiguration.setter(Builder::supportedDestinationConnectorsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedDestinationConnectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_SCHEDULING_FREQUENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedSchedulingFrequencies").getter(ConnectorConfiguration.getter(ConnectorConfiguration::supportedSchedulingFrequenciesAsStrings)).setter(ConnectorConfiguration.setter(Builder::supportedSchedulingFrequenciesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedSchedulingFrequencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_PRIVATE_LINK_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isPrivateLinkEnabled").getter(ConnectorConfiguration.getter(ConnectorConfiguration::isPrivateLinkEnabled)).setter(ConnectorConfiguration.setter(Builder::isPrivateLinkEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPrivateLinkEnabled").build()}).build();
    private static final SdkField<Boolean> IS_PRIVATE_LINK_ENDPOINT_URL_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isPrivateLinkEndpointUrlRequired").getter(ConnectorConfiguration.getter(ConnectorConfiguration::isPrivateLinkEndpointUrlRequired)).setter(ConnectorConfiguration.setter(Builder::isPrivateLinkEndpointUrlRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPrivateLinkEndpointUrlRequired").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_TRIGGER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedTriggerTypes").getter(ConnectorConfiguration.getter(ConnectorConfiguration::supportedTriggerTypesAsStrings)).setter(ConnectorConfiguration.setter(Builder::supportedTriggerTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedTriggerTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConnectorMetadata> CONNECTOR_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectorMetadata").getter(ConnectorConfiguration.getter(ConnectorConfiguration::connectorMetadata)).setter(ConnectorConfiguration.setter(Builder::connectorMetadata)).constructor(ConnectorMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorMetadata").build()}).build();
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorType").getter(ConnectorConfiguration.getter(ConnectorConfiguration::connectorTypeAsString)).setter(ConnectorConfiguration.setter(Builder::connectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()}).build();
    private static final SdkField<String> CONNECTOR_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorLabel").getter(ConnectorConfiguration.getter(ConnectorConfiguration::connectorLabel)).setter(ConnectorConfiguration.setter(Builder::connectorLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorLabel").build()}).build();
    private static final SdkField<String> CONNECTOR_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorDescription").getter(ConnectorConfiguration.getter(ConnectorConfiguration::connectorDescription)).setter(ConnectorConfiguration.setter(Builder::connectorDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorDescription").build()}).build();
    private static final SdkField<String> CONNECTOR_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorOwner").getter(ConnectorConfiguration.getter(ConnectorConfiguration::connectorOwner)).setter(ConnectorConfiguration.setter(Builder::connectorOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOwner").build()}).build();
    private static final SdkField<String> CONNECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorName").getter(ConnectorConfiguration.getter(ConnectorConfiguration::connectorName)).setter(ConnectorConfiguration.setter(Builder::connectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorName").build()}).build();
    private static final SdkField<String> CONNECTOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorVersion").getter(ConnectorConfiguration.getter(ConnectorConfiguration::connectorVersion)).setter(ConnectorConfiguration.setter(Builder::connectorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorVersion").build()}).build();
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorArn").getter(ConnectorConfiguration.getter(ConnectorConfiguration::connectorArn)).setter(ConnectorConfiguration.setter(Builder::connectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorArn").build()}).build();
    private static final SdkField<List<String>> CONNECTOR_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("connectorModes").getter(ConnectorConfiguration.getter(ConnectorConfiguration::connectorModes)).setter(ConnectorConfiguration.setter(Builder::connectorModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AuthenticationConfig> AUTHENTICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authenticationConfig").getter(ConnectorConfiguration.getter(ConnectorConfiguration::authenticationConfig)).setter(ConnectorConfiguration.setter(Builder::authenticationConfig)).constructor(AuthenticationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationConfig").build()}).build();
    private static final SdkField<List<ConnectorRuntimeSetting>> CONNECTOR_RUNTIME_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("connectorRuntimeSettings").getter(ConnectorConfiguration.getter(ConnectorConfiguration::connectorRuntimeSettings)).setter(ConnectorConfiguration.setter(Builder::connectorRuntimeSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorRuntimeSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectorRuntimeSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_API_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedApiVersions").getter(ConnectorConfiguration.getter(ConnectorConfiguration::supportedApiVersions)).setter(ConnectorConfiguration.setter(Builder::supportedApiVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedApiVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_OPERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedOperators").getter(ConnectorConfiguration.getter(ConnectorConfiguration::supportedOperatorsAsStrings)).setter(ConnectorConfiguration.setter(Builder::supportedOperatorsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedOperators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_WRITE_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedWriteOperations").getter(ConnectorConfiguration.getter(ConnectorConfiguration::supportedWriteOperationsAsStrings)).setter(ConnectorConfiguration.setter(Builder::supportedWriteOperationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedWriteOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTOR_PROVISIONING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorProvisioningType").getter(ConnectorConfiguration.getter(ConnectorConfiguration::connectorProvisioningTypeAsString)).setter(ConnectorConfiguration.setter(Builder::connectorProvisioningType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProvisioningType").build()}).build();
    private static final SdkField<ConnectorProvisioningConfig> CONNECTOR_PROVISIONING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectorProvisioningConfig").getter(ConnectorConfiguration.getter(ConnectorConfiguration::connectorProvisioningConfig)).setter(ConnectorConfiguration.setter(Builder::connectorProvisioningConfig)).constructor(ConnectorProvisioningConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProvisioningConfig").build()}).build();
    private static final SdkField<String> LOGO_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logoURL").getter(ConnectorConfiguration.getter(ConnectorConfiguration::logoURL)).setter(ConnectorConfiguration.setter(Builder::logoURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logoURL").build()}).build();
    private static final SdkField<Instant> REGISTERED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("registeredAt").getter(ConnectorConfiguration.getter(ConnectorConfiguration::registeredAt)).setter(ConnectorConfiguration.setter(Builder::registeredAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredAt").build()}).build();
    private static final SdkField<String> REGISTERED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registeredBy").getter(ConnectorConfiguration.getter(ConnectorConfiguration::registeredBy)).setter(ConnectorConfiguration.setter(Builder::registeredBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredBy").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_DATA_TRANSFER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedDataTransferTypes").getter(ConnectorConfiguration.getter(ConnectorConfiguration::supportedDataTransferTypesAsStrings)).setter(ConnectorConfiguration.setter(Builder::supportedDataTransferTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedDataTransferTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataTransferApi>> SUPPORTED_DATA_TRANSFER_APIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedDataTransferApis").getter(ConnectorConfiguration.getter(ConnectorConfiguration::supportedDataTransferApis)).setter(ConnectorConfiguration.setter(Builder::supportedDataTransferApis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedDataTransferApis").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataTransferApi::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAN_USE_AS_SOURCE_FIELD, CAN_USE_AS_DESTINATION_FIELD, SUPPORTED_DESTINATION_CONNECTORS_FIELD, SUPPORTED_SCHEDULING_FREQUENCIES_FIELD, IS_PRIVATE_LINK_ENABLED_FIELD, IS_PRIVATE_LINK_ENDPOINT_URL_REQUIRED_FIELD, SUPPORTED_TRIGGER_TYPES_FIELD, CONNECTOR_METADATA_FIELD, CONNECTOR_TYPE_FIELD, CONNECTOR_LABEL_FIELD, CONNECTOR_DESCRIPTION_FIELD, CONNECTOR_OWNER_FIELD, CONNECTOR_NAME_FIELD, CONNECTOR_VERSION_FIELD, CONNECTOR_ARN_FIELD, CONNECTOR_MODES_FIELD, AUTHENTICATION_CONFIG_FIELD, CONNECTOR_RUNTIME_SETTINGS_FIELD, SUPPORTED_API_VERSIONS_FIELD, SUPPORTED_OPERATORS_FIELD, SUPPORTED_WRITE_OPERATIONS_FIELD, CONNECTOR_PROVISIONING_TYPE_FIELD, CONNECTOR_PROVISIONING_CONFIG_FIELD, LOGO_URL_FIELD, REGISTERED_AT_FIELD, REGISTERED_BY_FIELD, SUPPORTED_DATA_TRANSFER_TYPES_FIELD, SUPPORTED_DATA_TRANSFER_APIS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectorConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean canUseAsSource;
    private final Boolean canUseAsDestination;
    private final List<String> supportedDestinationConnectors;
    private final List<String> supportedSchedulingFrequencies;
    private final Boolean isPrivateLinkEnabled;
    private final Boolean isPrivateLinkEndpointUrlRequired;
    private final List<String> supportedTriggerTypes;
    private final ConnectorMetadata connectorMetadata;
    private final String connectorType;
    private final String connectorLabel;
    private final String connectorDescription;
    private final String connectorOwner;
    private final String connectorName;
    private final String connectorVersion;
    private final String connectorArn;
    private final List<String> connectorModes;
    private final AuthenticationConfig authenticationConfig;
    private final List<ConnectorRuntimeSetting> connectorRuntimeSettings;
    private final List<String> supportedApiVersions;
    private final List<String> supportedOperators;
    private final List<String> supportedWriteOperations;
    private final String connectorProvisioningType;
    private final ConnectorProvisioningConfig connectorProvisioningConfig;
    private final String logoURL;
    private final Instant registeredAt;
    private final String registeredBy;
    private final List<String> supportedDataTransferTypes;
    private final List<DataTransferApi> supportedDataTransferApis;

    private ConnectorConfiguration(BuilderImpl builder) {
        this.canUseAsSource = builder.canUseAsSource;
        this.canUseAsDestination = builder.canUseAsDestination;
        this.supportedDestinationConnectors = builder.supportedDestinationConnectors;
        this.supportedSchedulingFrequencies = builder.supportedSchedulingFrequencies;
        this.isPrivateLinkEnabled = builder.isPrivateLinkEnabled;
        this.isPrivateLinkEndpointUrlRequired = builder.isPrivateLinkEndpointUrlRequired;
        this.supportedTriggerTypes = builder.supportedTriggerTypes;
        this.connectorMetadata = builder.connectorMetadata;
        this.connectorType = builder.connectorType;
        this.connectorLabel = builder.connectorLabel;
        this.connectorDescription = builder.connectorDescription;
        this.connectorOwner = builder.connectorOwner;
        this.connectorName = builder.connectorName;
        this.connectorVersion = builder.connectorVersion;
        this.connectorArn = builder.connectorArn;
        this.connectorModes = builder.connectorModes;
        this.authenticationConfig = builder.authenticationConfig;
        this.connectorRuntimeSettings = builder.connectorRuntimeSettings;
        this.supportedApiVersions = builder.supportedApiVersions;
        this.supportedOperators = builder.supportedOperators;
        this.supportedWriteOperations = builder.supportedWriteOperations;
        this.connectorProvisioningType = builder.connectorProvisioningType;
        this.connectorProvisioningConfig = builder.connectorProvisioningConfig;
        this.logoURL = builder.logoURL;
        this.registeredAt = builder.registeredAt;
        this.registeredBy = builder.registeredBy;
        this.supportedDataTransferTypes = builder.supportedDataTransferTypes;
        this.supportedDataTransferApis = builder.supportedDataTransferApis;
    }

    public final Boolean canUseAsSource() {
        return this.canUseAsSource;
    }

    public final Boolean canUseAsDestination() {
        return this.canUseAsDestination;
    }

    public final List<ConnectorType> supportedDestinationConnectors() {
        return ConnectorTypeListCopier.copyStringToEnum(this.supportedDestinationConnectors);
    }

    public final boolean hasSupportedDestinationConnectors() {
        return this.supportedDestinationConnectors != null && !(this.supportedDestinationConnectors instanceof SdkAutoConstructList);
    }

    public final List<String> supportedDestinationConnectorsAsStrings() {
        return this.supportedDestinationConnectors;
    }

    public final List<ScheduleFrequencyType> supportedSchedulingFrequencies() {
        return SchedulingFrequencyTypeListCopier.copyStringToEnum(this.supportedSchedulingFrequencies);
    }

    public final boolean hasSupportedSchedulingFrequencies() {
        return this.supportedSchedulingFrequencies != null && !(this.supportedSchedulingFrequencies instanceof SdkAutoConstructList);
    }

    public final List<String> supportedSchedulingFrequenciesAsStrings() {
        return this.supportedSchedulingFrequencies;
    }

    public final Boolean isPrivateLinkEnabled() {
        return this.isPrivateLinkEnabled;
    }

    public final Boolean isPrivateLinkEndpointUrlRequired() {
        return this.isPrivateLinkEndpointUrlRequired;
    }

    public final List<TriggerType> supportedTriggerTypes() {
        return TriggerTypeListCopier.copyStringToEnum(this.supportedTriggerTypes);
    }

    public final boolean hasSupportedTriggerTypes() {
        return this.supportedTriggerTypes != null && !(this.supportedTriggerTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedTriggerTypesAsStrings() {
        return this.supportedTriggerTypes;
    }

    public final ConnectorMetadata connectorMetadata() {
        return this.connectorMetadata;
    }

    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(this.connectorType);
    }

    public final String connectorTypeAsString() {
        return this.connectorType;
    }

    public final String connectorLabel() {
        return this.connectorLabel;
    }

    public final String connectorDescription() {
        return this.connectorDescription;
    }

    public final String connectorOwner() {
        return this.connectorOwner;
    }

    public final String connectorName() {
        return this.connectorName;
    }

    public final String connectorVersion() {
        return this.connectorVersion;
    }

    public final String connectorArn() {
        return this.connectorArn;
    }

    public final boolean hasConnectorModes() {
        return this.connectorModes != null && !(this.connectorModes instanceof SdkAutoConstructList);
    }

    public final List<String> connectorModes() {
        return this.connectorModes;
    }

    public final AuthenticationConfig authenticationConfig() {
        return this.authenticationConfig;
    }

    public final boolean hasConnectorRuntimeSettings() {
        return this.connectorRuntimeSettings != null && !(this.connectorRuntimeSettings instanceof SdkAutoConstructList);
    }

    public final List<ConnectorRuntimeSetting> connectorRuntimeSettings() {
        return this.connectorRuntimeSettings;
    }

    public final boolean hasSupportedApiVersions() {
        return this.supportedApiVersions != null && !(this.supportedApiVersions instanceof SdkAutoConstructList);
    }

    public final List<String> supportedApiVersions() {
        return this.supportedApiVersions;
    }

    public final List<Operators> supportedOperators() {
        return SupportedOperatorListCopier.copyStringToEnum(this.supportedOperators);
    }

    public final boolean hasSupportedOperators() {
        return this.supportedOperators != null && !(this.supportedOperators instanceof SdkAutoConstructList);
    }

    public final List<String> supportedOperatorsAsStrings() {
        return this.supportedOperators;
    }

    public final List<WriteOperationType> supportedWriteOperations() {
        return SupportedWriteOperationListCopier.copyStringToEnum(this.supportedWriteOperations);
    }

    public final boolean hasSupportedWriteOperations() {
        return this.supportedWriteOperations != null && !(this.supportedWriteOperations instanceof SdkAutoConstructList);
    }

    public final List<String> supportedWriteOperationsAsStrings() {
        return this.supportedWriteOperations;
    }

    public final ConnectorProvisioningType connectorProvisioningType() {
        return ConnectorProvisioningType.fromValue(this.connectorProvisioningType);
    }

    public final String connectorProvisioningTypeAsString() {
        return this.connectorProvisioningType;
    }

    public final ConnectorProvisioningConfig connectorProvisioningConfig() {
        return this.connectorProvisioningConfig;
    }

    public final String logoURL() {
        return this.logoURL;
    }

    public final Instant registeredAt() {
        return this.registeredAt;
    }

    public final String registeredBy() {
        return this.registeredBy;
    }

    public final List<SupportedDataTransferType> supportedDataTransferTypes() {
        return SupportedDataTransferTypeListCopier.copyStringToEnum(this.supportedDataTransferTypes);
    }

    public final boolean hasSupportedDataTransferTypes() {
        return this.supportedDataTransferTypes != null && !(this.supportedDataTransferTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedDataTransferTypesAsStrings() {
        return this.supportedDataTransferTypes;
    }

    public final boolean hasSupportedDataTransferApis() {
        return this.supportedDataTransferApis != null && !(this.supportedDataTransferApis instanceof SdkAutoConstructList);
    }

    public final List<DataTransferApi> supportedDataTransferApis() {
        return this.supportedDataTransferApis;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.canUseAsSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.canUseAsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedDestinationConnectors() ? this.supportedDestinationConnectorsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedSchedulingFrequencies() ? this.supportedSchedulingFrequenciesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isPrivateLinkEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPrivateLinkEndpointUrlRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedTriggerTypes() ? this.supportedTriggerTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectorModes() ? this.connectorModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectorRuntimeSettings() ? this.connectorRuntimeSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedApiVersions() ? this.supportedApiVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedOperators() ? this.supportedOperatorsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedWriteOperations() ? this.supportedWriteOperationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProvisioningTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProvisioningConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.logoURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedDataTransferTypes() ? this.supportedDataTransferTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedDataTransferApis() ? this.supportedDataTransferApis() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorConfiguration)) {
            return false;
        }
        ConnectorConfiguration other = (ConnectorConfiguration)obj;
        return Objects.equals(this.canUseAsSource(), other.canUseAsSource()) && Objects.equals(this.canUseAsDestination(), other.canUseAsDestination()) && this.hasSupportedDestinationConnectors() == other.hasSupportedDestinationConnectors() && Objects.equals(this.supportedDestinationConnectorsAsStrings(), other.supportedDestinationConnectorsAsStrings()) && this.hasSupportedSchedulingFrequencies() == other.hasSupportedSchedulingFrequencies() && Objects.equals(this.supportedSchedulingFrequenciesAsStrings(), other.supportedSchedulingFrequenciesAsStrings()) && Objects.equals(this.isPrivateLinkEnabled(), other.isPrivateLinkEnabled()) && Objects.equals(this.isPrivateLinkEndpointUrlRequired(), other.isPrivateLinkEndpointUrlRequired()) && this.hasSupportedTriggerTypes() == other.hasSupportedTriggerTypes() && Objects.equals(this.supportedTriggerTypesAsStrings(), other.supportedTriggerTypesAsStrings()) && Objects.equals(this.connectorMetadata(), other.connectorMetadata()) && Objects.equals(this.connectorTypeAsString(), other.connectorTypeAsString()) && Objects.equals(this.connectorLabel(), other.connectorLabel()) && Objects.equals(this.connectorDescription(), other.connectorDescription()) && Objects.equals(this.connectorOwner(), other.connectorOwner()) && Objects.equals(this.connectorName(), other.connectorName()) && Objects.equals(this.connectorVersion(), other.connectorVersion()) && Objects.equals(this.connectorArn(), other.connectorArn()) && this.hasConnectorModes() == other.hasConnectorModes() && Objects.equals(this.connectorModes(), other.connectorModes()) && Objects.equals(this.authenticationConfig(), other.authenticationConfig()) && this.hasConnectorRuntimeSettings() == other.hasConnectorRuntimeSettings() && Objects.equals(this.connectorRuntimeSettings(), other.connectorRuntimeSettings()) && this.hasSupportedApiVersions() == other.hasSupportedApiVersions() && Objects.equals(this.supportedApiVersions(), other.supportedApiVersions()) && this.hasSupportedOperators() == other.hasSupportedOperators() && Objects.equals(this.supportedOperatorsAsStrings(), other.supportedOperatorsAsStrings()) && this.hasSupportedWriteOperations() == other.hasSupportedWriteOperations() && Objects.equals(this.supportedWriteOperationsAsStrings(), other.supportedWriteOperationsAsStrings()) && Objects.equals(this.connectorProvisioningTypeAsString(), other.connectorProvisioningTypeAsString()) && Objects.equals(this.connectorProvisioningConfig(), other.connectorProvisioningConfig()) && Objects.equals(this.logoURL(), other.logoURL()) && Objects.equals(this.registeredAt(), other.registeredAt()) && Objects.equals(this.registeredBy(), other.registeredBy()) && this.hasSupportedDataTransferTypes() == other.hasSupportedDataTransferTypes() && Objects.equals(this.supportedDataTransferTypesAsStrings(), other.supportedDataTransferTypesAsStrings()) && this.hasSupportedDataTransferApis() == other.hasSupportedDataTransferApis() && Objects.equals(this.supportedDataTransferApis(), other.supportedDataTransferApis());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectorConfiguration").add("CanUseAsSource", (Object)this.canUseAsSource()).add("CanUseAsDestination", (Object)this.canUseAsDestination()).add("SupportedDestinationConnectors", this.hasSupportedDestinationConnectors() ? this.supportedDestinationConnectorsAsStrings() : null).add("SupportedSchedulingFrequencies", this.hasSupportedSchedulingFrequencies() ? this.supportedSchedulingFrequenciesAsStrings() : null).add("IsPrivateLinkEnabled", (Object)this.isPrivateLinkEnabled()).add("IsPrivateLinkEndpointUrlRequired", (Object)this.isPrivateLinkEndpointUrlRequired()).add("SupportedTriggerTypes", this.hasSupportedTriggerTypes() ? this.supportedTriggerTypesAsStrings() : null).add("ConnectorMetadata", (Object)this.connectorMetadata()).add("ConnectorType", (Object)this.connectorTypeAsString()).add("ConnectorLabel", (Object)this.connectorLabel()).add("ConnectorDescription", (Object)this.connectorDescription()).add("ConnectorOwner", (Object)this.connectorOwner()).add("ConnectorName", (Object)this.connectorName()).add("ConnectorVersion", (Object)this.connectorVersion()).add("ConnectorArn", (Object)this.connectorArn()).add("ConnectorModes", this.hasConnectorModes() ? this.connectorModes() : null).add("AuthenticationConfig", (Object)this.authenticationConfig()).add("ConnectorRuntimeSettings", this.hasConnectorRuntimeSettings() ? this.connectorRuntimeSettings() : null).add("SupportedApiVersions", this.hasSupportedApiVersions() ? this.supportedApiVersions() : null).add("SupportedOperators", this.hasSupportedOperators() ? this.supportedOperatorsAsStrings() : null).add("SupportedWriteOperations", this.hasSupportedWriteOperations() ? this.supportedWriteOperationsAsStrings() : null).add("ConnectorProvisioningType", (Object)this.connectorProvisioningTypeAsString()).add("ConnectorProvisioningConfig", (Object)this.connectorProvisioningConfig()).add("LogoURL", (Object)this.logoURL()).add("RegisteredAt", (Object)this.registeredAt()).add("RegisteredBy", (Object)this.registeredBy()).add("SupportedDataTransferTypes", this.hasSupportedDataTransferTypes() ? this.supportedDataTransferTypesAsStrings() : null).add("SupportedDataTransferApis", this.hasSupportedDataTransferApis() ? this.supportedDataTransferApis() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "canUseAsSource": {
                return Optional.ofNullable(clazz.cast(this.canUseAsSource()));
            }
            case "canUseAsDestination": {
                return Optional.ofNullable(clazz.cast(this.canUseAsDestination()));
            }
            case "supportedDestinationConnectors": {
                return Optional.ofNullable(clazz.cast(this.supportedDestinationConnectorsAsStrings()));
            }
            case "supportedSchedulingFrequencies": {
                return Optional.ofNullable(clazz.cast(this.supportedSchedulingFrequenciesAsStrings()));
            }
            case "isPrivateLinkEnabled": {
                return Optional.ofNullable(clazz.cast(this.isPrivateLinkEnabled()));
            }
            case "isPrivateLinkEndpointUrlRequired": {
                return Optional.ofNullable(clazz.cast(this.isPrivateLinkEndpointUrlRequired()));
            }
            case "supportedTriggerTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedTriggerTypesAsStrings()));
            }
            case "connectorMetadata": {
                return Optional.ofNullable(clazz.cast(this.connectorMetadata()));
            }
            case "connectorType": {
                return Optional.ofNullable(clazz.cast(this.connectorTypeAsString()));
            }
            case "connectorLabel": {
                return Optional.ofNullable(clazz.cast(this.connectorLabel()));
            }
            case "connectorDescription": {
                return Optional.ofNullable(clazz.cast(this.connectorDescription()));
            }
            case "connectorOwner": {
                return Optional.ofNullable(clazz.cast(this.connectorOwner()));
            }
            case "connectorName": {
                return Optional.ofNullable(clazz.cast(this.connectorName()));
            }
            case "connectorVersion": {
                return Optional.ofNullable(clazz.cast(this.connectorVersion()));
            }
            case "connectorArn": {
                return Optional.ofNullable(clazz.cast(this.connectorArn()));
            }
            case "connectorModes": {
                return Optional.ofNullable(clazz.cast(this.connectorModes()));
            }
            case "authenticationConfig": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfig()));
            }
            case "connectorRuntimeSettings": {
                return Optional.ofNullable(clazz.cast(this.connectorRuntimeSettings()));
            }
            case "supportedApiVersions": {
                return Optional.ofNullable(clazz.cast(this.supportedApiVersions()));
            }
            case "supportedOperators": {
                return Optional.ofNullable(clazz.cast(this.supportedOperatorsAsStrings()));
            }
            case "supportedWriteOperations": {
                return Optional.ofNullable(clazz.cast(this.supportedWriteOperationsAsStrings()));
            }
            case "connectorProvisioningType": {
                return Optional.ofNullable(clazz.cast(this.connectorProvisioningTypeAsString()));
            }
            case "connectorProvisioningConfig": {
                return Optional.ofNullable(clazz.cast(this.connectorProvisioningConfig()));
            }
            case "logoURL": {
                return Optional.ofNullable(clazz.cast(this.logoURL()));
            }
            case "registeredAt": {
                return Optional.ofNullable(clazz.cast(this.registeredAt()));
            }
            case "registeredBy": {
                return Optional.ofNullable(clazz.cast(this.registeredBy()));
            }
            case "supportedDataTransferTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedDataTransferTypesAsStrings()));
            }
            case "supportedDataTransferApis": {
                return Optional.ofNullable(clazz.cast(this.supportedDataTransferApis()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("canUseAsSource", CAN_USE_AS_SOURCE_FIELD);
        map.put("canUseAsDestination", CAN_USE_AS_DESTINATION_FIELD);
        map.put("supportedDestinationConnectors", SUPPORTED_DESTINATION_CONNECTORS_FIELD);
        map.put("supportedSchedulingFrequencies", SUPPORTED_SCHEDULING_FREQUENCIES_FIELD);
        map.put("isPrivateLinkEnabled", IS_PRIVATE_LINK_ENABLED_FIELD);
        map.put("isPrivateLinkEndpointUrlRequired", IS_PRIVATE_LINK_ENDPOINT_URL_REQUIRED_FIELD);
        map.put("supportedTriggerTypes", SUPPORTED_TRIGGER_TYPES_FIELD);
        map.put("connectorMetadata", CONNECTOR_METADATA_FIELD);
        map.put("connectorType", CONNECTOR_TYPE_FIELD);
        map.put("connectorLabel", CONNECTOR_LABEL_FIELD);
        map.put("connectorDescription", CONNECTOR_DESCRIPTION_FIELD);
        map.put("connectorOwner", CONNECTOR_OWNER_FIELD);
        map.put("connectorName", CONNECTOR_NAME_FIELD);
        map.put("connectorVersion", CONNECTOR_VERSION_FIELD);
        map.put("connectorArn", CONNECTOR_ARN_FIELD);
        map.put("connectorModes", CONNECTOR_MODES_FIELD);
        map.put("authenticationConfig", AUTHENTICATION_CONFIG_FIELD);
        map.put("connectorRuntimeSettings", CONNECTOR_RUNTIME_SETTINGS_FIELD);
        map.put("supportedApiVersions", SUPPORTED_API_VERSIONS_FIELD);
        map.put("supportedOperators", SUPPORTED_OPERATORS_FIELD);
        map.put("supportedWriteOperations", SUPPORTED_WRITE_OPERATIONS_FIELD);
        map.put("connectorProvisioningType", CONNECTOR_PROVISIONING_TYPE_FIELD);
        map.put("connectorProvisioningConfig", CONNECTOR_PROVISIONING_CONFIG_FIELD);
        map.put("logoURL", LOGO_URL_FIELD);
        map.put("registeredAt", REGISTERED_AT_FIELD);
        map.put("registeredBy", REGISTERED_BY_FIELD);
        map.put("supportedDataTransferTypes", SUPPORTED_DATA_TRANSFER_TYPES_FIELD);
        map.put("supportedDataTransferApis", SUPPORTED_DATA_TRANSFER_APIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorConfiguration, T> g) {
        return obj -> g.apply((ConnectorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean canUseAsSource;
        private Boolean canUseAsDestination;
        private List<String> supportedDestinationConnectors = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedSchedulingFrequencies = DefaultSdkAutoConstructList.getInstance();
        private Boolean isPrivateLinkEnabled;
        private Boolean isPrivateLinkEndpointUrlRequired;
        private List<String> supportedTriggerTypes = DefaultSdkAutoConstructList.getInstance();
        private ConnectorMetadata connectorMetadata;
        private String connectorType;
        private String connectorLabel;
        private String connectorDescription;
        private String connectorOwner;
        private String connectorName;
        private String connectorVersion;
        private String connectorArn;
        private List<String> connectorModes = DefaultSdkAutoConstructList.getInstance();
        private AuthenticationConfig authenticationConfig;
        private List<ConnectorRuntimeSetting> connectorRuntimeSettings = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedApiVersions = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedOperators = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedWriteOperations = DefaultSdkAutoConstructList.getInstance();
        private String connectorProvisioningType;
        private ConnectorProvisioningConfig connectorProvisioningConfig;
        private String logoURL;
        private Instant registeredAt;
        private String registeredBy;
        private List<String> supportedDataTransferTypes = DefaultSdkAutoConstructList.getInstance();
        private List<DataTransferApi> supportedDataTransferApis = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorConfiguration model) {
            this.canUseAsSource(model.canUseAsSource);
            this.canUseAsDestination(model.canUseAsDestination);
            this.supportedDestinationConnectorsWithStrings(model.supportedDestinationConnectors);
            this.supportedSchedulingFrequenciesWithStrings(model.supportedSchedulingFrequencies);
            this.isPrivateLinkEnabled(model.isPrivateLinkEnabled);
            this.isPrivateLinkEndpointUrlRequired(model.isPrivateLinkEndpointUrlRequired);
            this.supportedTriggerTypesWithStrings(model.supportedTriggerTypes);
            this.connectorMetadata(model.connectorMetadata);
            this.connectorType(model.connectorType);
            this.connectorLabel(model.connectorLabel);
            this.connectorDescription(model.connectorDescription);
            this.connectorOwner(model.connectorOwner);
            this.connectorName(model.connectorName);
            this.connectorVersion(model.connectorVersion);
            this.connectorArn(model.connectorArn);
            this.connectorModes(model.connectorModes);
            this.authenticationConfig(model.authenticationConfig);
            this.connectorRuntimeSettings(model.connectorRuntimeSettings);
            this.supportedApiVersions(model.supportedApiVersions);
            this.supportedOperatorsWithStrings(model.supportedOperators);
            this.supportedWriteOperationsWithStrings(model.supportedWriteOperations);
            this.connectorProvisioningType(model.connectorProvisioningType);
            this.connectorProvisioningConfig(model.connectorProvisioningConfig);
            this.logoURL(model.logoURL);
            this.registeredAt(model.registeredAt);
            this.registeredBy(model.registeredBy);
            this.supportedDataTransferTypesWithStrings(model.supportedDataTransferTypes);
            this.supportedDataTransferApis(model.supportedDataTransferApis);
        }

        public final Boolean getCanUseAsSource() {
            return this.canUseAsSource;
        }

        public final void setCanUseAsSource(Boolean canUseAsSource) {
            this.canUseAsSource = canUseAsSource;
        }

        @Override
        public final Builder canUseAsSource(Boolean canUseAsSource) {
            this.canUseAsSource = canUseAsSource;
            return this;
        }

        public final Boolean getCanUseAsDestination() {
            return this.canUseAsDestination;
        }

        public final void setCanUseAsDestination(Boolean canUseAsDestination) {
            this.canUseAsDestination = canUseAsDestination;
        }

        @Override
        public final Builder canUseAsDestination(Boolean canUseAsDestination) {
            this.canUseAsDestination = canUseAsDestination;
            return this;
        }

        public final Collection<String> getSupportedDestinationConnectors() {
            if (this.supportedDestinationConnectors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedDestinationConnectors;
        }

        public final void setSupportedDestinationConnectors(Collection<String> supportedDestinationConnectors) {
            this.supportedDestinationConnectors = ConnectorTypeListCopier.copy(supportedDestinationConnectors);
        }

        @Override
        public final Builder supportedDestinationConnectorsWithStrings(Collection<String> supportedDestinationConnectors) {
            this.supportedDestinationConnectors = ConnectorTypeListCopier.copy(supportedDestinationConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDestinationConnectorsWithStrings(String ... supportedDestinationConnectors) {
            this.supportedDestinationConnectorsWithStrings(Arrays.asList(supportedDestinationConnectors));
            return this;
        }

        @Override
        public final Builder supportedDestinationConnectors(Collection<ConnectorType> supportedDestinationConnectors) {
            this.supportedDestinationConnectors = ConnectorTypeListCopier.copyEnumToString(supportedDestinationConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDestinationConnectors(ConnectorType ... supportedDestinationConnectors) {
            this.supportedDestinationConnectors(Arrays.asList(supportedDestinationConnectors));
            return this;
        }

        public final Collection<String> getSupportedSchedulingFrequencies() {
            if (this.supportedSchedulingFrequencies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedSchedulingFrequencies;
        }

        public final void setSupportedSchedulingFrequencies(Collection<String> supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies = SchedulingFrequencyTypeListCopier.copy(supportedSchedulingFrequencies);
        }

        @Override
        public final Builder supportedSchedulingFrequenciesWithStrings(Collection<String> supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies = SchedulingFrequencyTypeListCopier.copy(supportedSchedulingFrequencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedSchedulingFrequenciesWithStrings(String ... supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequenciesWithStrings(Arrays.asList(supportedSchedulingFrequencies));
            return this;
        }

        @Override
        public final Builder supportedSchedulingFrequencies(Collection<ScheduleFrequencyType> supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies = SchedulingFrequencyTypeListCopier.copyEnumToString(supportedSchedulingFrequencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedSchedulingFrequencies(ScheduleFrequencyType ... supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies(Arrays.asList(supportedSchedulingFrequencies));
            return this;
        }

        public final Boolean getIsPrivateLinkEnabled() {
            return this.isPrivateLinkEnabled;
        }

        public final void setIsPrivateLinkEnabled(Boolean isPrivateLinkEnabled) {
            this.isPrivateLinkEnabled = isPrivateLinkEnabled;
        }

        @Override
        public final Builder isPrivateLinkEnabled(Boolean isPrivateLinkEnabled) {
            this.isPrivateLinkEnabled = isPrivateLinkEnabled;
            return this;
        }

        public final Boolean getIsPrivateLinkEndpointUrlRequired() {
            return this.isPrivateLinkEndpointUrlRequired;
        }

        public final void setIsPrivateLinkEndpointUrlRequired(Boolean isPrivateLinkEndpointUrlRequired) {
            this.isPrivateLinkEndpointUrlRequired = isPrivateLinkEndpointUrlRequired;
        }

        @Override
        public final Builder isPrivateLinkEndpointUrlRequired(Boolean isPrivateLinkEndpointUrlRequired) {
            this.isPrivateLinkEndpointUrlRequired = isPrivateLinkEndpointUrlRequired;
            return this;
        }

        public final Collection<String> getSupportedTriggerTypes() {
            if (this.supportedTriggerTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedTriggerTypes;
        }

        public final void setSupportedTriggerTypes(Collection<String> supportedTriggerTypes) {
            this.supportedTriggerTypes = TriggerTypeListCopier.copy(supportedTriggerTypes);
        }

        @Override
        public final Builder supportedTriggerTypesWithStrings(Collection<String> supportedTriggerTypes) {
            this.supportedTriggerTypes = TriggerTypeListCopier.copy(supportedTriggerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTriggerTypesWithStrings(String ... supportedTriggerTypes) {
            this.supportedTriggerTypesWithStrings(Arrays.asList(supportedTriggerTypes));
            return this;
        }

        @Override
        public final Builder supportedTriggerTypes(Collection<TriggerType> supportedTriggerTypes) {
            this.supportedTriggerTypes = TriggerTypeListCopier.copyEnumToString(supportedTriggerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTriggerTypes(TriggerType ... supportedTriggerTypes) {
            this.supportedTriggerTypes(Arrays.asList(supportedTriggerTypes));
            return this;
        }

        public final ConnectorMetadata.Builder getConnectorMetadata() {
            return this.connectorMetadata != null ? this.connectorMetadata.toBuilder() : null;
        }

        public final void setConnectorMetadata(ConnectorMetadata.BuilderImpl connectorMetadata) {
            this.connectorMetadata = connectorMetadata != null ? connectorMetadata.build() : null;
        }

        @Override
        public final Builder connectorMetadata(ConnectorMetadata connectorMetadata) {
            this.connectorMetadata = connectorMetadata;
            return this;
        }

        public final String getConnectorType() {
            return this.connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getConnectorLabel() {
            return this.connectorLabel;
        }

        public final void setConnectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
        }

        @Override
        public final Builder connectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
            return this;
        }

        public final String getConnectorDescription() {
            return this.connectorDescription;
        }

        public final void setConnectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
        }

        @Override
        public final Builder connectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
            return this;
        }

        public final String getConnectorOwner() {
            return this.connectorOwner;
        }

        public final void setConnectorOwner(String connectorOwner) {
            this.connectorOwner = connectorOwner;
        }

        @Override
        public final Builder connectorOwner(String connectorOwner) {
            this.connectorOwner = connectorOwner;
            return this;
        }

        public final String getConnectorName() {
            return this.connectorName;
        }

        public final void setConnectorName(String connectorName) {
            this.connectorName = connectorName;
        }

        @Override
        public final Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            return this;
        }

        public final String getConnectorVersion() {
            return this.connectorVersion;
        }

        public final void setConnectorVersion(String connectorVersion) {
            this.connectorVersion = connectorVersion;
        }

        @Override
        public final Builder connectorVersion(String connectorVersion) {
            this.connectorVersion = connectorVersion;
            return this;
        }

        public final String getConnectorArn() {
            return this.connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final Collection<String> getConnectorModes() {
            if (this.connectorModes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectorModes;
        }

        public final void setConnectorModes(Collection<String> connectorModes) {
            this.connectorModes = ConnectorModeListCopier.copy(connectorModes);
        }

        @Override
        public final Builder connectorModes(Collection<String> connectorModes) {
            this.connectorModes = ConnectorModeListCopier.copy(connectorModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorModes(String ... connectorModes) {
            this.connectorModes(Arrays.asList(connectorModes));
            return this;
        }

        public final AuthenticationConfig.Builder getAuthenticationConfig() {
            return this.authenticationConfig != null ? this.authenticationConfig.toBuilder() : null;
        }

        public final void setAuthenticationConfig(AuthenticationConfig.BuilderImpl authenticationConfig) {
            this.authenticationConfig = authenticationConfig != null ? authenticationConfig.build() : null;
        }

        @Override
        public final Builder authenticationConfig(AuthenticationConfig authenticationConfig) {
            this.authenticationConfig = authenticationConfig;
            return this;
        }

        public final List<ConnectorRuntimeSetting.Builder> getConnectorRuntimeSettings() {
            List<ConnectorRuntimeSetting.Builder> result = ConnectorRuntimeSettingListCopier.copyToBuilder(this.connectorRuntimeSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectorRuntimeSettings(Collection<ConnectorRuntimeSetting.BuilderImpl> connectorRuntimeSettings) {
            this.connectorRuntimeSettings = ConnectorRuntimeSettingListCopier.copyFromBuilder(connectorRuntimeSettings);
        }

        @Override
        public final Builder connectorRuntimeSettings(Collection<ConnectorRuntimeSetting> connectorRuntimeSettings) {
            this.connectorRuntimeSettings = ConnectorRuntimeSettingListCopier.copy(connectorRuntimeSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorRuntimeSettings(ConnectorRuntimeSetting ... connectorRuntimeSettings) {
            this.connectorRuntimeSettings(Arrays.asList(connectorRuntimeSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorRuntimeSettings(Consumer<ConnectorRuntimeSetting.Builder> ... connectorRuntimeSettings) {
            this.connectorRuntimeSettings(Stream.of(connectorRuntimeSettings).map(c -> (ConnectorRuntimeSetting)((ConnectorRuntimeSetting.Builder)ConnectorRuntimeSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSupportedApiVersions() {
            if (this.supportedApiVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedApiVersions;
        }

        public final void setSupportedApiVersions(Collection<String> supportedApiVersions) {
            this.supportedApiVersions = SupportedApiVersionListCopier.copy(supportedApiVersions);
        }

        @Override
        public final Builder supportedApiVersions(Collection<String> supportedApiVersions) {
            this.supportedApiVersions = SupportedApiVersionListCopier.copy(supportedApiVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedApiVersions(String ... supportedApiVersions) {
            this.supportedApiVersions(Arrays.asList(supportedApiVersions));
            return this;
        }

        public final Collection<String> getSupportedOperators() {
            if (this.supportedOperators instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedOperators;
        }

        public final void setSupportedOperators(Collection<String> supportedOperators) {
            this.supportedOperators = SupportedOperatorListCopier.copy(supportedOperators);
        }

        @Override
        public final Builder supportedOperatorsWithStrings(Collection<String> supportedOperators) {
            this.supportedOperators = SupportedOperatorListCopier.copy(supportedOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedOperatorsWithStrings(String ... supportedOperators) {
            this.supportedOperatorsWithStrings(Arrays.asList(supportedOperators));
            return this;
        }

        @Override
        public final Builder supportedOperators(Collection<Operators> supportedOperators) {
            this.supportedOperators = SupportedOperatorListCopier.copyEnumToString(supportedOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedOperators(Operators ... supportedOperators) {
            this.supportedOperators(Arrays.asList(supportedOperators));
            return this;
        }

        public final Collection<String> getSupportedWriteOperations() {
            if (this.supportedWriteOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedWriteOperations;
        }

        public final void setSupportedWriteOperations(Collection<String> supportedWriteOperations) {
            this.supportedWriteOperations = SupportedWriteOperationListCopier.copy(supportedWriteOperations);
        }

        @Override
        public final Builder supportedWriteOperationsWithStrings(Collection<String> supportedWriteOperations) {
            this.supportedWriteOperations = SupportedWriteOperationListCopier.copy(supportedWriteOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedWriteOperationsWithStrings(String ... supportedWriteOperations) {
            this.supportedWriteOperationsWithStrings(Arrays.asList(supportedWriteOperations));
            return this;
        }

        @Override
        public final Builder supportedWriteOperations(Collection<WriteOperationType> supportedWriteOperations) {
            this.supportedWriteOperations = SupportedWriteOperationListCopier.copyEnumToString(supportedWriteOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedWriteOperations(WriteOperationType ... supportedWriteOperations) {
            this.supportedWriteOperations(Arrays.asList(supportedWriteOperations));
            return this;
        }

        public final String getConnectorProvisioningType() {
            return this.connectorProvisioningType;
        }

        public final void setConnectorProvisioningType(String connectorProvisioningType) {
            this.connectorProvisioningType = connectorProvisioningType;
        }

        @Override
        public final Builder connectorProvisioningType(String connectorProvisioningType) {
            this.connectorProvisioningType = connectorProvisioningType;
            return this;
        }

        @Override
        public final Builder connectorProvisioningType(ConnectorProvisioningType connectorProvisioningType) {
            this.connectorProvisioningType(connectorProvisioningType == null ? null : connectorProvisioningType.toString());
            return this;
        }

        public final ConnectorProvisioningConfig.Builder getConnectorProvisioningConfig() {
            return this.connectorProvisioningConfig != null ? this.connectorProvisioningConfig.toBuilder() : null;
        }

        public final void setConnectorProvisioningConfig(ConnectorProvisioningConfig.BuilderImpl connectorProvisioningConfig) {
            this.connectorProvisioningConfig = connectorProvisioningConfig != null ? connectorProvisioningConfig.build() : null;
        }

        @Override
        public final Builder connectorProvisioningConfig(ConnectorProvisioningConfig connectorProvisioningConfig) {
            this.connectorProvisioningConfig = connectorProvisioningConfig;
            return this;
        }

        public final String getLogoURL() {
            return this.logoURL;
        }

        public final void setLogoURL(String logoURL) {
            this.logoURL = logoURL;
        }

        @Override
        public final Builder logoURL(String logoURL) {
            this.logoURL = logoURL;
            return this;
        }

        public final Instant getRegisteredAt() {
            return this.registeredAt;
        }

        public final void setRegisteredAt(Instant registeredAt) {
            this.registeredAt = registeredAt;
        }

        @Override
        public final Builder registeredAt(Instant registeredAt) {
            this.registeredAt = registeredAt;
            return this;
        }

        public final String getRegisteredBy() {
            return this.registeredBy;
        }

        public final void setRegisteredBy(String registeredBy) {
            this.registeredBy = registeredBy;
        }

        @Override
        public final Builder registeredBy(String registeredBy) {
            this.registeredBy = registeredBy;
            return this;
        }

        public final Collection<String> getSupportedDataTransferTypes() {
            if (this.supportedDataTransferTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedDataTransferTypes;
        }

        public final void setSupportedDataTransferTypes(Collection<String> supportedDataTransferTypes) {
            this.supportedDataTransferTypes = SupportedDataTransferTypeListCopier.copy(supportedDataTransferTypes);
        }

        @Override
        public final Builder supportedDataTransferTypesWithStrings(Collection<String> supportedDataTransferTypes) {
            this.supportedDataTransferTypes = SupportedDataTransferTypeListCopier.copy(supportedDataTransferTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataTransferTypesWithStrings(String ... supportedDataTransferTypes) {
            this.supportedDataTransferTypesWithStrings(Arrays.asList(supportedDataTransferTypes));
            return this;
        }

        @Override
        public final Builder supportedDataTransferTypes(Collection<SupportedDataTransferType> supportedDataTransferTypes) {
            this.supportedDataTransferTypes = SupportedDataTransferTypeListCopier.copyEnumToString(supportedDataTransferTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataTransferTypes(SupportedDataTransferType ... supportedDataTransferTypes) {
            this.supportedDataTransferTypes(Arrays.asList(supportedDataTransferTypes));
            return this;
        }

        public final List<DataTransferApi.Builder> getSupportedDataTransferApis() {
            List<DataTransferApi.Builder> result = SupportedDataTransferApisCopier.copyToBuilder(this.supportedDataTransferApis);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedDataTransferApis(Collection<DataTransferApi.BuilderImpl> supportedDataTransferApis) {
            this.supportedDataTransferApis = SupportedDataTransferApisCopier.copyFromBuilder(supportedDataTransferApis);
        }

        @Override
        public final Builder supportedDataTransferApis(Collection<DataTransferApi> supportedDataTransferApis) {
            this.supportedDataTransferApis = SupportedDataTransferApisCopier.copy(supportedDataTransferApis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataTransferApis(DataTransferApi ... supportedDataTransferApis) {
            this.supportedDataTransferApis(Arrays.asList(supportedDataTransferApis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataTransferApis(Consumer<DataTransferApi.Builder> ... supportedDataTransferApis) {
            this.supportedDataTransferApis(Stream.of(supportedDataTransferApis).map(c -> (DataTransferApi)((DataTransferApi.Builder)DataTransferApi.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ConnectorConfiguration build() {
            return new ConnectorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorConfiguration> {
        public Builder canUseAsSource(Boolean var1);

        public Builder canUseAsDestination(Boolean var1);

        public Builder supportedDestinationConnectorsWithStrings(Collection<String> var1);

        public Builder supportedDestinationConnectorsWithStrings(String ... var1);

        public Builder supportedDestinationConnectors(Collection<ConnectorType> var1);

        public Builder supportedDestinationConnectors(ConnectorType ... var1);

        public Builder supportedSchedulingFrequenciesWithStrings(Collection<String> var1);

        public Builder supportedSchedulingFrequenciesWithStrings(String ... var1);

        public Builder supportedSchedulingFrequencies(Collection<ScheduleFrequencyType> var1);

        public Builder supportedSchedulingFrequencies(ScheduleFrequencyType ... var1);

        public Builder isPrivateLinkEnabled(Boolean var1);

        public Builder isPrivateLinkEndpointUrlRequired(Boolean var1);

        public Builder supportedTriggerTypesWithStrings(Collection<String> var1);

        public Builder supportedTriggerTypesWithStrings(String ... var1);

        public Builder supportedTriggerTypes(Collection<TriggerType> var1);

        public Builder supportedTriggerTypes(TriggerType ... var1);

        public Builder connectorMetadata(ConnectorMetadata var1);

        default public Builder connectorMetadata(Consumer<ConnectorMetadata.Builder> connectorMetadata) {
            return this.connectorMetadata((ConnectorMetadata)((ConnectorMetadata.Builder)ConnectorMetadata.builder().applyMutation(connectorMetadata)).build());
        }

        public Builder connectorType(String var1);

        public Builder connectorType(ConnectorType var1);

        public Builder connectorLabel(String var1);

        public Builder connectorDescription(String var1);

        public Builder connectorOwner(String var1);

        public Builder connectorName(String var1);

        public Builder connectorVersion(String var1);

        public Builder connectorArn(String var1);

        public Builder connectorModes(Collection<String> var1);

        public Builder connectorModes(String ... var1);

        public Builder authenticationConfig(AuthenticationConfig var1);

        default public Builder authenticationConfig(Consumer<AuthenticationConfig.Builder> authenticationConfig) {
            return this.authenticationConfig((AuthenticationConfig)((AuthenticationConfig.Builder)AuthenticationConfig.builder().applyMutation(authenticationConfig)).build());
        }

        public Builder connectorRuntimeSettings(Collection<ConnectorRuntimeSetting> var1);

        public Builder connectorRuntimeSettings(ConnectorRuntimeSetting ... var1);

        public Builder connectorRuntimeSettings(Consumer<ConnectorRuntimeSetting.Builder> ... var1);

        public Builder supportedApiVersions(Collection<String> var1);

        public Builder supportedApiVersions(String ... var1);

        public Builder supportedOperatorsWithStrings(Collection<String> var1);

        public Builder supportedOperatorsWithStrings(String ... var1);

        public Builder supportedOperators(Collection<Operators> var1);

        public Builder supportedOperators(Operators ... var1);

        public Builder supportedWriteOperationsWithStrings(Collection<String> var1);

        public Builder supportedWriteOperationsWithStrings(String ... var1);

        public Builder supportedWriteOperations(Collection<WriteOperationType> var1);

        public Builder supportedWriteOperations(WriteOperationType ... var1);

        public Builder connectorProvisioningType(String var1);

        public Builder connectorProvisioningType(ConnectorProvisioningType var1);

        public Builder connectorProvisioningConfig(ConnectorProvisioningConfig var1);

        default public Builder connectorProvisioningConfig(Consumer<ConnectorProvisioningConfig.Builder> connectorProvisioningConfig) {
            return this.connectorProvisioningConfig((ConnectorProvisioningConfig)((ConnectorProvisioningConfig.Builder)ConnectorProvisioningConfig.builder().applyMutation(connectorProvisioningConfig)).build());
        }

        public Builder logoURL(String var1);

        public Builder registeredAt(Instant var1);

        public Builder registeredBy(String var1);

        public Builder supportedDataTransferTypesWithStrings(Collection<String> var1);

        public Builder supportedDataTransferTypesWithStrings(String ... var1);

        public Builder supportedDataTransferTypes(Collection<SupportedDataTransferType> var1);

        public Builder supportedDataTransferTypes(SupportedDataTransferType ... var1);

        public Builder supportedDataTransferApis(Collection<DataTransferApi> var1);

        public Builder supportedDataTransferApis(DataTransferApi ... var1);

        public Builder supportedDataTransferApis(Consumer<DataTransferApi.Builder> ... var1);
    }
}

