/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.appflow.AppflowClient;
import software.amazon.awssdk.services.appflow.AppflowServiceClientConfiguration;
import software.amazon.awssdk.services.appflow.internal.AppflowServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.appflow.model.AccessDeniedException;
import software.amazon.awssdk.services.appflow.model.AppflowException;
import software.amazon.awssdk.services.appflow.model.CancelFlowExecutionsRequest;
import software.amazon.awssdk.services.appflow.model.CancelFlowExecutionsResponse;
import software.amazon.awssdk.services.appflow.model.ConflictException;
import software.amazon.awssdk.services.appflow.model.ConnectorAuthenticationException;
import software.amazon.awssdk.services.appflow.model.ConnectorServerException;
import software.amazon.awssdk.services.appflow.model.CreateConnectorProfileRequest;
import software.amazon.awssdk.services.appflow.model.CreateConnectorProfileResponse;
import software.amazon.awssdk.services.appflow.model.CreateFlowRequest;
import software.amazon.awssdk.services.appflow.model.CreateFlowResponse;
import software.amazon.awssdk.services.appflow.model.DeleteConnectorProfileRequest;
import software.amazon.awssdk.services.appflow.model.DeleteConnectorProfileResponse;
import software.amazon.awssdk.services.appflow.model.DeleteFlowRequest;
import software.amazon.awssdk.services.appflow.model.DeleteFlowResponse;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityResponse;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorResponse;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse;
import software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest;
import software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse;
import software.amazon.awssdk.services.appflow.model.DescribeFlowRequest;
import software.amazon.awssdk.services.appflow.model.DescribeFlowResponse;
import software.amazon.awssdk.services.appflow.model.InternalServerException;
import software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesRequest;
import software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesResponse;
import software.amazon.awssdk.services.appflow.model.ListConnectorsRequest;
import software.amazon.awssdk.services.appflow.model.ListConnectorsResponse;
import software.amazon.awssdk.services.appflow.model.ListFlowsRequest;
import software.amazon.awssdk.services.appflow.model.ListFlowsResponse;
import software.amazon.awssdk.services.appflow.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appflow.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appflow.model.RegisterConnectorRequest;
import software.amazon.awssdk.services.appflow.model.RegisterConnectorResponse;
import software.amazon.awssdk.services.appflow.model.ResetConnectorMetadataCacheRequest;
import software.amazon.awssdk.services.appflow.model.ResetConnectorMetadataCacheResponse;
import software.amazon.awssdk.services.appflow.model.ResourceNotFoundException;
import software.amazon.awssdk.services.appflow.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.appflow.model.StartFlowRequest;
import software.amazon.awssdk.services.appflow.model.StartFlowResponse;
import software.amazon.awssdk.services.appflow.model.StopFlowRequest;
import software.amazon.awssdk.services.appflow.model.StopFlowResponse;
import software.amazon.awssdk.services.appflow.model.TagResourceRequest;
import software.amazon.awssdk.services.appflow.model.TagResourceResponse;
import software.amazon.awssdk.services.appflow.model.ThrottlingException;
import software.amazon.awssdk.services.appflow.model.UnregisterConnectorRequest;
import software.amazon.awssdk.services.appflow.model.UnregisterConnectorResponse;
import software.amazon.awssdk.services.appflow.model.UnsupportedOperationException;
import software.amazon.awssdk.services.appflow.model.UntagResourceRequest;
import software.amazon.awssdk.services.appflow.model.UntagResourceResponse;
import software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileRequest;
import software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileResponse;
import software.amazon.awssdk.services.appflow.model.UpdateConnectorRegistrationRequest;
import software.amazon.awssdk.services.appflow.model.UpdateConnectorRegistrationResponse;
import software.amazon.awssdk.services.appflow.model.UpdateFlowRequest;
import software.amazon.awssdk.services.appflow.model.UpdateFlowResponse;
import software.amazon.awssdk.services.appflow.model.ValidationException;
import software.amazon.awssdk.services.appflow.transform.CancelFlowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.CreateConnectorProfileRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.CreateFlowRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DeleteConnectorProfileRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DeleteFlowRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DescribeConnectorEntityRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DescribeConnectorProfilesRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DescribeConnectorRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DescribeConnectorsRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DescribeFlowExecutionRecordsRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DescribeFlowRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.ListConnectorEntitiesRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.ListConnectorsRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.ListFlowsRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.RegisterConnectorRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.ResetConnectorMetadataCacheRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.StartFlowRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.StopFlowRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.UnregisterConnectorRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.UpdateConnectorProfileRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.UpdateConnectorRegistrationRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.UpdateFlowRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultAppflowClient
implements AppflowClient {
    private static final Logger log = Logger.loggerFor(DefaultAppflowClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAppflowClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Appflow#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelFlowExecutionsResponse cancelFlowExecutions(CancelFlowExecutionsRequest cancelFlowExecutionsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelFlowExecutionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelFlowExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, cancelFlowExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelFlowExecutions");
            CancelFlowExecutionsResponse cancelFlowExecutionsResponse = (CancelFlowExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelFlowExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelFlowExecutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelFlowExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelFlowExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$cancelFlowExecutions$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConnectorProfileResponse createConnectorProfile(CreateConnectorProfileRequest createConnectorProfileRequest) throws ValidationException, ConflictException, ServiceQuotaExceededException, ConnectorAuthenticationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConnectorProfileResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createConnectorProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, createConnectorProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConnectorProfile");
            CreateConnectorProfileResponse createConnectorProfileResponse = (CreateConnectorProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConnectorProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createConnectorProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConnectorProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConnectorProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$createConnectorProfile$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFlowResponse createFlow(CreateFlowRequest createFlowRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException, ConnectorAuthenticationException, ConnectorServerException, AccessDeniedException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, createFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFlow");
            CreateFlowResponse createFlowResponse = (CreateFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFlow").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$createFlow$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConnectorProfileResponse deleteConnectorProfile(DeleteConnectorProfileRequest deleteConnectorProfileRequest) throws ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConnectorProfileResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConnectorProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, deleteConnectorProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConnectorProfile");
            DeleteConnectorProfileResponse deleteConnectorProfileResponse = (DeleteConnectorProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConnectorProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConnectorProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConnectorProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConnectorProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$deleteConnectorProfile$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFlowResponse deleteFlow(DeleteFlowRequest deleteFlowRequest) throws ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, deleteFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFlow");
            DeleteFlowResponse deleteFlowResponse = (DeleteFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFlow").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$deleteFlow$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectorResponse describeConnector(DescribeConnectorRequest describeConnectorRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConnectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, describeConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnector");
            DescribeConnectorResponse describeConnectorResponse = (DescribeConnectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConnectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConnectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$describeConnector$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectorEntityResponse describeConnectorEntity(DescribeConnectorEntityRequest describeConnectorEntityRequest) throws ValidationException, ResourceNotFoundException, ConnectorAuthenticationException, ConnectorServerException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectorEntityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConnectorEntityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, describeConnectorEntityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnectorEntity");
            DescribeConnectorEntityResponse describeConnectorEntityResponse = (DescribeConnectorEntityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnectorEntity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConnectorEntityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConnectorEntityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConnectorEntityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$describeConnectorEntity$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectorProfilesResponse describeConnectorProfiles(DescribeConnectorProfilesRequest describeConnectorProfilesRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectorProfilesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConnectorProfilesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, describeConnectorProfilesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnectorProfiles");
            DescribeConnectorProfilesResponse describeConnectorProfilesResponse = (DescribeConnectorProfilesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnectorProfiles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConnectorProfilesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConnectorProfilesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConnectorProfilesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$describeConnectorProfiles$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectorsResponse describeConnectors(DescribeConnectorsRequest describeConnectorsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConnectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, describeConnectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnectors");
            DescribeConnectorsResponse describeConnectorsResponse = (DescribeConnectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConnectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConnectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConnectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$describeConnectors$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFlowResponse describeFlow(DescribeFlowRequest describeFlowRequest) throws ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, describeFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFlow");
            DescribeFlowResponse describeFlowResponse = (DescribeFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFlow").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$describeFlow$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFlowExecutionRecordsResponse describeFlowExecutionRecords(DescribeFlowExecutionRecordsRequest describeFlowExecutionRecordsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFlowExecutionRecordsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFlowExecutionRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, describeFlowExecutionRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFlowExecutionRecords");
            DescribeFlowExecutionRecordsResponse describeFlowExecutionRecordsResponse = (DescribeFlowExecutionRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFlowExecutionRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFlowExecutionRecordsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFlowExecutionRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFlowExecutionRecordsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$describeFlowExecutionRecords$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConnectorEntitiesResponse listConnectorEntities(ListConnectorEntitiesRequest listConnectorEntitiesRequest) throws ValidationException, ResourceNotFoundException, ConnectorAuthenticationException, ConnectorServerException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConnectorEntitiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listConnectorEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, listConnectorEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConnectorEntities");
            ListConnectorEntitiesResponse listConnectorEntitiesResponse = (ListConnectorEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConnectorEntities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listConnectorEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListConnectorEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listConnectorEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$listConnectorEntities$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConnectorsResponse listConnectors(ListConnectorsRequest listConnectorsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConnectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listConnectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, listConnectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConnectors");
            ListConnectorsResponse listConnectorsResponse = (ListConnectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConnectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listConnectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListConnectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listConnectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$listConnectors$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFlowsResponse listFlows(ListFlowsRequest listFlowsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFlowsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFlowsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, listFlowsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFlows");
            ListFlowsResponse listFlowsResponse = (ListFlowsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFlows").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listFlowsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFlowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFlowsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$listFlows$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$listTagsForResource$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterConnectorResponse registerConnector(RegisterConnectorRequest registerConnectorRequest) throws ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, InternalServerException, ConnectorServerException, ConnectorAuthenticationException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterConnectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerConnectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, registerConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterConnector");
            RegisterConnectorResponse registerConnectorResponse = (RegisterConnectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterConnector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerConnectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerConnectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$registerConnector$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResetConnectorMetadataCacheResponse resetConnectorMetadataCache(ResetConnectorMetadataCacheRequest resetConnectorMetadataCacheRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetConnectorMetadataCacheResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resetConnectorMetadataCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, resetConnectorMetadataCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetConnectorMetadataCache");
            ResetConnectorMetadataCacheResponse resetConnectorMetadataCacheResponse = (ResetConnectorMetadataCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetConnectorMetadataCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)resetConnectorMetadataCacheRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResetConnectorMetadataCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resetConnectorMetadataCacheResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$resetConnectorMetadataCache$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartFlowResponse startFlow(StartFlowRequest startFlowRequest) throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, startFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartFlow");
            StartFlowResponse startFlowResponse = (StartFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartFlow").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$startFlow$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopFlowResponse stopFlow(StopFlowRequest stopFlowRequest) throws ConflictException, ResourceNotFoundException, UnsupportedOperationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, stopFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopFlow");
            StopFlowResponse stopFlowResponse = (StopFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopFlow").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$stopFlow$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$tagResource$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnregisterConnectorResponse unregisterConnector(UnregisterConnectorRequest unregisterConnectorRequest) throws ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnregisterConnectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)unregisterConnectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, unregisterConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnregisterConnector");
            UnregisterConnectorResponse unregisterConnectorResponse = (UnregisterConnectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnregisterConnector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)unregisterConnectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UnregisterConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return unregisterConnectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$unregisterConnector$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$untagResource$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConnectorProfileResponse updateConnectorProfile(UpdateConnectorProfileRequest updateConnectorProfileRequest) throws ValidationException, ResourceNotFoundException, ConflictException, ConnectorAuthenticationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConnectorProfileResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateConnectorProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, updateConnectorProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConnectorProfile");
            UpdateConnectorProfileResponse updateConnectorProfileResponse = (UpdateConnectorProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConnectorProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateConnectorProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConnectorProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConnectorProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$updateConnectorProfile$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConnectorRegistrationResponse updateConnectorRegistration(UpdateConnectorRegistrationRequest updateConnectorRegistrationRequest) throws ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, InternalServerException, ConnectorServerException, ConnectorAuthenticationException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConnectorRegistrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateConnectorRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, updateConnectorRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConnectorRegistration");
            UpdateConnectorRegistrationResponse updateConnectorRegistrationResponse = (UpdateConnectorRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConnectorRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateConnectorRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConnectorRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConnectorRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$updateConnectorRegistration$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFlowResponse updateFlow(UpdateFlowRequest updateFlowRequest) throws ValidationException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException, ConnectorAuthenticationException, ConnectorServerException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ConnectorAuthenticationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(ConnectorAuthenticationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ConnectorServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConnectorServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConnectorServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(clientConfiguration, updateFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlow");
            UpdateFlowResponse updateFlowResponse = (UpdateFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlow").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$updateFlow$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "appflow";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        AppflowServiceClientConfigurationBuilder serviceConfigBuilder = new AppflowServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AppflowException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final AppflowServiceClientConfiguration serviceClientConfiguration() {
        return new AppflowServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateFlow$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConnectorRegistration$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConnectorProfile$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unregisterConnector$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopFlow$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startFlow$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetConnectorMetadataCache$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerConnector$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFlows$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConnectors$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConnectorEntities$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFlowExecutionRecords$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFlow$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnectors$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnectorProfiles$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnectorEntity$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnector$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFlow$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConnectorProfile$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFlow$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConnectorProfile$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelFlowExecutions$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

