/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties that are applied when the custom connector is being used as a destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomConnectorDestinationProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomConnectorDestinationProperties.Builder, CustomConnectorDestinationProperties> {
    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityName").getter(getter(CustomConnectorDestinationProperties::entityName))
            .setter(setter(Builder::entityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityName").build()).build();

    private static final SdkField<ErrorHandlingConfig> ERROR_HANDLING_CONFIG_FIELD = SdkField
            .<ErrorHandlingConfig> builder(MarshallingType.SDK_POJO).memberName("errorHandlingConfig")
            .getter(getter(CustomConnectorDestinationProperties::errorHandlingConfig))
            .setter(setter(Builder::errorHandlingConfig)).constructor(ErrorHandlingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorHandlingConfig").build())
            .build();

    private static final SdkField<String> WRITE_OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("writeOperationType").getter(getter(CustomConnectorDestinationProperties::writeOperationTypeAsString))
            .setter(setter(Builder::writeOperationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeOperationType").build())
            .build();

    private static final SdkField<List<String>> ID_FIELD_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("idFieldNames")
            .getter(getter(CustomConnectorDestinationProperties::idFieldNames))
            .setter(setter(Builder::idFieldNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idFieldNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> CUSTOM_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("customProperties")
            .getter(getter(CustomConnectorDestinationProperties::customProperties))
            .setter(setter(Builder::customProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_NAME_FIELD,
            ERROR_HANDLING_CONFIG_FIELD, WRITE_OPERATION_TYPE_FIELD, ID_FIELD_NAMES_FIELD, CUSTOM_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String entityName;

    private final ErrorHandlingConfig errorHandlingConfig;

    private final String writeOperationType;

    private final List<String> idFieldNames;

    private final Map<String, String> customProperties;

    private CustomConnectorDestinationProperties(BuilderImpl builder) {
        this.entityName = builder.entityName;
        this.errorHandlingConfig = builder.errorHandlingConfig;
        this.writeOperationType = builder.writeOperationType;
        this.idFieldNames = builder.idFieldNames;
        this.customProperties = builder.customProperties;
    }

    /**
     * <p>
     * The entity specified in the custom connector as a destination in the flow.
     * </p>
     * 
     * @return The entity specified in the custom connector as a destination in the flow.
     */
    public final String entityName() {
        return entityName;
    }

    /**
     * <p>
     * The settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as
     * destination.
     * </p>
     * 
     * @return The settings that determine how Amazon AppFlow handles an error when placing data in the custom connector
     *         as destination.
     */
    public final ErrorHandlingConfig errorHandlingConfig() {
        return errorHandlingConfig;
    }

    /**
     * <p>
     * Specifies the type of write operation to be performed in the custom connector when it's used as destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #writeOperationType} will return {@link WriteOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #writeOperationTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of write operation to be performed in the custom connector when it's used as
     *         destination.
     * @see WriteOperationType
     */
    public final WriteOperationType writeOperationType() {
        return WriteOperationType.fromValue(writeOperationType);
    }

    /**
     * <p>
     * Specifies the type of write operation to be performed in the custom connector when it's used as destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #writeOperationType} will return {@link WriteOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #writeOperationTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of write operation to be performed in the custom connector when it's used as
     *         destination.
     * @see WriteOperationType
     */
    public final String writeOperationTypeAsString() {
        return writeOperationType;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdFieldNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIdFieldNames() {
        return idFieldNames != null && !(idFieldNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete,
     * or upsert.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdFieldNames} method.
     * </p>
     * 
     * @return The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update,
     *         delete, or upsert.
     */
    public final List<String> idFieldNames() {
        return idFieldNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomProperties() {
        return customProperties != null && !(customProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The custom properties that are specific to the connector when it's used as a destination in the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomProperties} method.
     * </p>
     * 
     * @return The custom properties that are specific to the connector when it's used as a destination in the flow.
     */
    public final Map<String, String> customProperties() {
        return customProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityName());
        hashCode = 31 * hashCode + Objects.hashCode(errorHandlingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(writeOperationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdFieldNames() ? idFieldNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomProperties() ? customProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomConnectorDestinationProperties)) {
            return false;
        }
        CustomConnectorDestinationProperties other = (CustomConnectorDestinationProperties) obj;
        return Objects.equals(entityName(), other.entityName())
                && Objects.equals(errorHandlingConfig(), other.errorHandlingConfig())
                && Objects.equals(writeOperationTypeAsString(), other.writeOperationTypeAsString())
                && hasIdFieldNames() == other.hasIdFieldNames() && Objects.equals(idFieldNames(), other.idFieldNames())
                && hasCustomProperties() == other.hasCustomProperties()
                && Objects.equals(customProperties(), other.customProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomConnectorDestinationProperties").add("EntityName", entityName())
                .add("ErrorHandlingConfig", errorHandlingConfig()).add("WriteOperationType", writeOperationTypeAsString())
                .add("IdFieldNames", hasIdFieldNames() ? idFieldNames() : null)
                .add("CustomProperties", hasCustomProperties() ? customProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entityName":
            return Optional.ofNullable(clazz.cast(entityName()));
        case "errorHandlingConfig":
            return Optional.ofNullable(clazz.cast(errorHandlingConfig()));
        case "writeOperationType":
            return Optional.ofNullable(clazz.cast(writeOperationTypeAsString()));
        case "idFieldNames":
            return Optional.ofNullable(clazz.cast(idFieldNames()));
        case "customProperties":
            return Optional.ofNullable(clazz.cast(customProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entityName", ENTITY_NAME_FIELD);
        map.put("errorHandlingConfig", ERROR_HANDLING_CONFIG_FIELD);
        map.put("writeOperationType", WRITE_OPERATION_TYPE_FIELD);
        map.put("idFieldNames", ID_FIELD_NAMES_FIELD);
        map.put("customProperties", CUSTOM_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomConnectorDestinationProperties, T> g) {
        return obj -> g.apply((CustomConnectorDestinationProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomConnectorDestinationProperties> {
        /**
         * <p>
         * The entity specified in the custom connector as a destination in the flow.
         * </p>
         * 
         * @param entityName
         *        The entity specified in the custom connector as a destination in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityName(String entityName);

        /**
         * <p>
         * The settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as
         * destination.
         * </p>
         * 
         * @param errorHandlingConfig
         *        The settings that determine how Amazon AppFlow handles an error when placing data in the custom
         *        connector as destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorHandlingConfig(ErrorHandlingConfig errorHandlingConfig);

        /**
         * <p>
         * The settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as
         * destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorHandlingConfig.Builder} avoiding the
         * need to create one manually via {@link ErrorHandlingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorHandlingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #errorHandlingConfig(ErrorHandlingConfig)}.
         * 
         * @param errorHandlingConfig
         *        a consumer that will call methods on {@link ErrorHandlingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorHandlingConfig(ErrorHandlingConfig)
         */
        default Builder errorHandlingConfig(Consumer<ErrorHandlingConfig.Builder> errorHandlingConfig) {
            return errorHandlingConfig(ErrorHandlingConfig.builder().applyMutation(errorHandlingConfig).build());
        }

        /**
         * <p>
         * Specifies the type of write operation to be performed in the custom connector when it's used as destination.
         * </p>
         * 
         * @param writeOperationType
         *        Specifies the type of write operation to be performed in the custom connector when it's used as
         *        destination.
         * @see WriteOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WriteOperationType
         */
        Builder writeOperationType(String writeOperationType);

        /**
         * <p>
         * Specifies the type of write operation to be performed in the custom connector when it's used as destination.
         * </p>
         * 
         * @param writeOperationType
         *        Specifies the type of write operation to be performed in the custom connector when it's used as
         *        destination.
         * @see WriteOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WriteOperationType
         */
        Builder writeOperationType(WriteOperationType writeOperationType);

        /**
         * <p>
         * The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update,
         * delete, or upsert.
         * </p>
         * 
         * @param idFieldNames
         *        The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as
         *        update, delete, or upsert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idFieldNames(Collection<String> idFieldNames);

        /**
         * <p>
         * The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update,
         * delete, or upsert.
         * </p>
         * 
         * @param idFieldNames
         *        The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as
         *        update, delete, or upsert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idFieldNames(String... idFieldNames);

        /**
         * <p>
         * The custom properties that are specific to the connector when it's used as a destination in the flow.
         * </p>
         * 
         * @param customProperties
         *        The custom properties that are specific to the connector when it's used as a destination in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customProperties(Map<String, String> customProperties);
    }

    static final class BuilderImpl implements Builder {
        private String entityName;

        private ErrorHandlingConfig errorHandlingConfig;

        private String writeOperationType;

        private List<String> idFieldNames = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> customProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomConnectorDestinationProperties model) {
            entityName(model.entityName);
            errorHandlingConfig(model.errorHandlingConfig);
            writeOperationType(model.writeOperationType);
            idFieldNames(model.idFieldNames);
            customProperties(model.customProperties);
        }

        public final String getEntityName() {
            return entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final ErrorHandlingConfig.Builder getErrorHandlingConfig() {
            return errorHandlingConfig != null ? errorHandlingConfig.toBuilder() : null;
        }

        public final void setErrorHandlingConfig(ErrorHandlingConfig.BuilderImpl errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig != null ? errorHandlingConfig.build() : null;
        }

        @Override
        public final Builder errorHandlingConfig(ErrorHandlingConfig errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig;
            return this;
        }

        public final String getWriteOperationType() {
            return writeOperationType;
        }

        public final void setWriteOperationType(String writeOperationType) {
            this.writeOperationType = writeOperationType;
        }

        @Override
        public final Builder writeOperationType(String writeOperationType) {
            this.writeOperationType = writeOperationType;
            return this;
        }

        @Override
        public final Builder writeOperationType(WriteOperationType writeOperationType) {
            this.writeOperationType(writeOperationType == null ? null : writeOperationType.toString());
            return this;
        }

        public final Collection<String> getIdFieldNames() {
            if (idFieldNames instanceof SdkAutoConstructList) {
                return null;
            }
            return idFieldNames;
        }

        public final void setIdFieldNames(Collection<String> idFieldNames) {
            this.idFieldNames = IdFieldNameListCopier.copy(idFieldNames);
        }

        @Override
        public final Builder idFieldNames(Collection<String> idFieldNames) {
            this.idFieldNames = IdFieldNameListCopier.copy(idFieldNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idFieldNames(String... idFieldNames) {
            idFieldNames(Arrays.asList(idFieldNames));
            return this;
        }

        public final Map<String, String> getCustomProperties() {
            if (customProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return customProperties;
        }

        public final void setCustomProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
        }

        @Override
        public final Builder customProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
            return this;
        }

        @Override
        public CustomConnectorDestinationProperties build() {
            return new CustomConnectorDestinationProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
