/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties that are applied when using SAPOData as a flow source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SAPODataSourceProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<SAPODataSourceProperties.Builder, SAPODataSourceProperties> {
    private static final SdkField<String> OBJECT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("objectPath").getter(getter(SAPODataSourceProperties::objectPath)).setter(setter(Builder::objectPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectPath").build()).build();

    private static final SdkField<SAPODataParallelismConfig> PARALLELISM_CONFIG_FIELD = SdkField
            .<SAPODataParallelismConfig> builder(MarshallingType.SDK_POJO).memberName("parallelismConfig")
            .getter(getter(SAPODataSourceProperties::parallelismConfig)).setter(setter(Builder::parallelismConfig))
            .constructor(SAPODataParallelismConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parallelismConfig").build()).build();

    private static final SdkField<SAPODataPaginationConfig> PAGINATION_CONFIG_FIELD = SdkField
            .<SAPODataPaginationConfig> builder(MarshallingType.SDK_POJO).memberName("paginationConfig")
            .getter(getter(SAPODataSourceProperties::paginationConfig)).setter(setter(Builder::paginationConfig))
            .constructor(SAPODataPaginationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paginationConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_PATH_FIELD,
            PARALLELISM_CONFIG_FIELD, PAGINATION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String objectPath;

    private final SAPODataParallelismConfig parallelismConfig;

    private final SAPODataPaginationConfig paginationConfig;

    private SAPODataSourceProperties(BuilderImpl builder) {
        this.objectPath = builder.objectPath;
        this.parallelismConfig = builder.parallelismConfig;
        this.paginationConfig = builder.paginationConfig;
    }

    /**
     * <p>
     * The object path specified in the SAPOData flow source.
     * </p>
     * 
     * @return The object path specified in the SAPOData flow source.
     */
    public final String objectPath() {
        return objectPath;
    }

    /**
     * <p>
     * Sets the number of concurrent processes that transfers OData records from your SAP instance.
     * </p>
     * 
     * @return Sets the number of concurrent processes that transfers OData records from your SAP instance.
     */
    public final SAPODataParallelismConfig parallelismConfig() {
        return parallelismConfig;
    }

    /**
     * <p>
     * Sets the page size for each concurrent process that transfers OData records from your SAP instance.
     * </p>
     * 
     * @return Sets the page size for each concurrent process that transfers OData records from your SAP instance.
     */
    public final SAPODataPaginationConfig paginationConfig() {
        return paginationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectPath());
        hashCode = 31 * hashCode + Objects.hashCode(parallelismConfig());
        hashCode = 31 * hashCode + Objects.hashCode(paginationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAPODataSourceProperties)) {
            return false;
        }
        SAPODataSourceProperties other = (SAPODataSourceProperties) obj;
        return Objects.equals(objectPath(), other.objectPath()) && Objects.equals(parallelismConfig(), other.parallelismConfig())
                && Objects.equals(paginationConfig(), other.paginationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SAPODataSourceProperties").add("ObjectPath", objectPath())
                .add("ParallelismConfig", parallelismConfig()).add("PaginationConfig", paginationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "objectPath":
            return Optional.ofNullable(clazz.cast(objectPath()));
        case "parallelismConfig":
            return Optional.ofNullable(clazz.cast(parallelismConfig()));
        case "paginationConfig":
            return Optional.ofNullable(clazz.cast(paginationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("objectPath", OBJECT_PATH_FIELD);
        map.put("parallelismConfig", PARALLELISM_CONFIG_FIELD);
        map.put("paginationConfig", PAGINATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SAPODataSourceProperties, T> g) {
        return obj -> g.apply((SAPODataSourceProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SAPODataSourceProperties> {
        /**
         * <p>
         * The object path specified in the SAPOData flow source.
         * </p>
         * 
         * @param objectPath
         *        The object path specified in the SAPOData flow source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectPath(String objectPath);

        /**
         * <p>
         * Sets the number of concurrent processes that transfers OData records from your SAP instance.
         * </p>
         * 
         * @param parallelismConfig
         *        Sets the number of concurrent processes that transfers OData records from your SAP instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelismConfig(SAPODataParallelismConfig parallelismConfig);

        /**
         * <p>
         * Sets the number of concurrent processes that transfers OData records from your SAP instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link SAPODataParallelismConfig.Builder}
         * avoiding the need to create one manually via {@link SAPODataParallelismConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SAPODataParallelismConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #parallelismConfig(SAPODataParallelismConfig)}.
         * 
         * @param parallelismConfig
         *        a consumer that will call methods on {@link SAPODataParallelismConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parallelismConfig(SAPODataParallelismConfig)
         */
        default Builder parallelismConfig(Consumer<SAPODataParallelismConfig.Builder> parallelismConfig) {
            return parallelismConfig(SAPODataParallelismConfig.builder().applyMutation(parallelismConfig).build());
        }

        /**
         * <p>
         * Sets the page size for each concurrent process that transfers OData records from your SAP instance.
         * </p>
         * 
         * @param paginationConfig
         *        Sets the page size for each concurrent process that transfers OData records from your SAP instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationConfig(SAPODataPaginationConfig paginationConfig);

        /**
         * <p>
         * Sets the page size for each concurrent process that transfers OData records from your SAP instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link SAPODataPaginationConfig.Builder}
         * avoiding the need to create one manually via {@link SAPODataPaginationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SAPODataPaginationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #paginationConfig(SAPODataPaginationConfig)}.
         * 
         * @param paginationConfig
         *        a consumer that will call methods on {@link SAPODataPaginationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #paginationConfig(SAPODataPaginationConfig)
         */
        default Builder paginationConfig(Consumer<SAPODataPaginationConfig.Builder> paginationConfig) {
            return paginationConfig(SAPODataPaginationConfig.builder().applyMutation(paginationConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String objectPath;

        private SAPODataParallelismConfig parallelismConfig;

        private SAPODataPaginationConfig paginationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SAPODataSourceProperties model) {
            objectPath(model.objectPath);
            parallelismConfig(model.parallelismConfig);
            paginationConfig(model.paginationConfig);
        }

        public final String getObjectPath() {
            return objectPath;
        }

        public final void setObjectPath(String objectPath) {
            this.objectPath = objectPath;
        }

        @Override
        public final Builder objectPath(String objectPath) {
            this.objectPath = objectPath;
            return this;
        }

        public final SAPODataParallelismConfig.Builder getParallelismConfig() {
            return parallelismConfig != null ? parallelismConfig.toBuilder() : null;
        }

        public final void setParallelismConfig(SAPODataParallelismConfig.BuilderImpl parallelismConfig) {
            this.parallelismConfig = parallelismConfig != null ? parallelismConfig.build() : null;
        }

        @Override
        public final Builder parallelismConfig(SAPODataParallelismConfig parallelismConfig) {
            this.parallelismConfig = parallelismConfig;
            return this;
        }

        public final SAPODataPaginationConfig.Builder getPaginationConfig() {
            return paginationConfig != null ? paginationConfig.toBuilder() : null;
        }

        public final void setPaginationConfig(SAPODataPaginationConfig.BuilderImpl paginationConfig) {
            this.paginationConfig = paginationConfig != null ? paginationConfig.build() : null;
        }

        @Override
        public final Builder paginationConfig(SAPODataPaginationConfig paginationConfig) {
            this.paginationConfig = paginationConfig;
            return this;
        }

        @Override
        public SAPODataSourceProperties build() {
            return new SAPODataSourceProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
