/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about the DataIntegration association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIntegrationAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIntegrationAssociationSummary.Builder, DataIntegrationAssociationSummary> {
    private static final SdkField<String> DATA_INTEGRATION_ASSOCIATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DataIntegrationAssociationArn")
            .getter(getter(DataIntegrationAssociationSummary::dataIntegrationAssociationArn))
            .setter(setter(Builder::dataIntegrationAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataIntegrationAssociationArn")
                    .build()).build();

    private static final SdkField<String> DATA_INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataIntegrationArn").getter(getter(DataIntegrationAssociationSummary::dataIntegrationArn))
            .setter(setter(Builder::dataIntegrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataIntegrationArn").build())
            .build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(DataIntegrationAssociationSummary::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_INTEGRATION_ASSOCIATION_ARN_FIELD, DATA_INTEGRATION_ARN_FIELD, CLIENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataIntegrationAssociationArn;

    private final String dataIntegrationArn;

    private final String clientId;

    private DataIntegrationAssociationSummary(BuilderImpl builder) {
        this.dataIntegrationAssociationArn = builder.dataIntegrationAssociationArn;
        this.dataIntegrationArn = builder.dataIntegrationArn;
        this.clientId = builder.clientId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the DataIntegration association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the DataIntegration association.
     */
    public final String dataIntegrationAssociationArn() {
        return dataIntegrationAssociationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN)of the DataIntegration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN)of the DataIntegration.
     */
    public final String dataIntegrationArn() {
        return dataIntegrationArn;
    }

    /**
     * <p>
     * The identifier for teh client that is associated with the DataIntegration association.
     * </p>
     * 
     * @return The identifier for teh client that is associated with the DataIntegration association.
     */
    public final String clientId() {
        return clientId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataIntegrationAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataIntegrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationAssociationSummary)) {
            return false;
        }
        DataIntegrationAssociationSummary other = (DataIntegrationAssociationSummary) obj;
        return Objects.equals(dataIntegrationAssociationArn(), other.dataIntegrationAssociationArn())
                && Objects.equals(dataIntegrationArn(), other.dataIntegrationArn())
                && Objects.equals(clientId(), other.clientId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIntegrationAssociationSummary")
                .add("DataIntegrationAssociationArn", dataIntegrationAssociationArn())
                .add("DataIntegrationArn", dataIntegrationArn()).add("ClientId", clientId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataIntegrationAssociationArn":
            return Optional.ofNullable(clazz.cast(dataIntegrationAssociationArn()));
        case "DataIntegrationArn":
            return Optional.ofNullable(clazz.cast(dataIntegrationArn()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationAssociationSummary, T> g) {
        return obj -> g.apply((DataIntegrationAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIntegrationAssociationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the DataIntegration association.
         * </p>
         * 
         * @param dataIntegrationAssociationArn
         *        The Amazon Resource Name (ARN) of the DataIntegration association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataIntegrationAssociationArn(String dataIntegrationAssociationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN)of the DataIntegration.
         * </p>
         * 
         * @param dataIntegrationArn
         *        The Amazon Resource Name (ARN)of the DataIntegration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataIntegrationArn(String dataIntegrationArn);

        /**
         * <p>
         * The identifier for teh client that is associated with the DataIntegration association.
         * </p>
         * 
         * @param clientId
         *        The identifier for teh client that is associated with the DataIntegration association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);
    }

    static final class BuilderImpl implements Builder {
        private String dataIntegrationAssociationArn;

        private String dataIntegrationArn;

        private String clientId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationAssociationSummary model) {
            dataIntegrationAssociationArn(model.dataIntegrationAssociationArn);
            dataIntegrationArn(model.dataIntegrationArn);
            clientId(model.clientId);
        }

        public final String getDataIntegrationAssociationArn() {
            return dataIntegrationAssociationArn;
        }

        public final void setDataIntegrationAssociationArn(String dataIntegrationAssociationArn) {
            this.dataIntegrationAssociationArn = dataIntegrationAssociationArn;
        }

        @Override
        public final Builder dataIntegrationAssociationArn(String dataIntegrationAssociationArn) {
            this.dataIntegrationAssociationArn = dataIntegrationAssociationArn;
            return this;
        }

        public final String getDataIntegrationArn() {
            return dataIntegrationArn;
        }

        public final void setDataIntegrationArn(String dataIntegrationArn) {
            this.dataIntegrationArn = dataIntegrationArn;
        }

        @Override
        public final Builder dataIntegrationArn(String dataIntegrationArn) {
            this.dataIntegrationArn = dataIntegrationArn;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        public DataIntegrationAssociationSummary build() {
            return new DataIntegrationAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
