/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataIntegrationRequest extends AppIntegrationsRequest implements
        ToCopyableBuilder<CreateDataIntegrationRequest.Builder, CreateDataIntegrationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateDataIntegrationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateDataIntegrationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KmsKey")
            .getter(getter(CreateDataIntegrationRequest::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()).build();

    private static final SdkField<String> SOURCE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceURI").getter(getter(CreateDataIntegrationRequest::sourceURI)).setter(setter(Builder::sourceURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceURI").build()).build();

    private static final SdkField<ScheduleConfiguration> SCHEDULE_CONFIG_FIELD = SdkField
            .<ScheduleConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScheduleConfig")
            .getter(getter(CreateDataIntegrationRequest::scheduleConfig)).setter(setter(Builder::scheduleConfig))
            .constructor(ScheduleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfig").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateDataIntegrationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateDataIntegrationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            KMS_KEY_FIELD, SOURCE_URI_FIELD, SCHEDULE_CONFIG_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private final String name;

    private final String description;

    private final String kmsKey;

    private final String sourceURI;

    private final ScheduleConfiguration scheduleConfig;

    private final Map<String, String> tags;

    private final String clientToken;

    private CreateDataIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.kmsKey = builder.kmsKey;
        this.sourceURI = builder.sourceURI;
        this.scheduleConfig = builder.scheduleConfig;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the DataIntegration.
     * </p>
     * 
     * @return The name of the DataIntegration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the DataIntegration.
     * </p>
     * 
     * @return A description of the DataIntegration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The KMS key for the DataIntegration.
     * </p>
     * 
     * @return The KMS key for the DataIntegration.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The URI of the data source.
     * </p>
     * 
     * @return The URI of the data source.
     */
    public final String sourceURI() {
        return sourceURI;
    }

    /**
     * <p>
     * The name of the data and how often it should be pulled from the source.
     * </p>
     * 
     * @return The name of the data and how often it should be pulled from the source.
     */
    public final ScheduleConfiguration scheduleConfig() {
        return scheduleConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(sourceURI());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataIntegrationRequest)) {
            return false;
        }
        CreateDataIntegrationRequest other = (CreateDataIntegrationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(kmsKey(), other.kmsKey()) && Objects.equals(sourceURI(), other.sourceURI())
                && Objects.equals(scheduleConfig(), other.scheduleConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataIntegrationRequest").add("Name", name()).add("Description", description())
                .add("KmsKey", kmsKey()).add("SourceURI", sourceURI()).add("ScheduleConfig", scheduleConfig())
                .add("Tags", hasTags() ? tags() : null).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "SourceURI":
            return Optional.ofNullable(clazz.cast(sourceURI()));
        case "ScheduleConfig":
            return Optional.ofNullable(clazz.cast(scheduleConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataIntegrationRequest, T> g) {
        return obj -> g.apply((CreateDataIntegrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataIntegrationRequest> {
        /**
         * <p>
         * The name of the DataIntegration.
         * </p>
         * 
         * @param name
         *        The name of the DataIntegration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the DataIntegration.
         * </p>
         * 
         * @param description
         *        A description of the DataIntegration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The KMS key for the DataIntegration.
         * </p>
         * 
         * @param kmsKey
         *        The KMS key for the DataIntegration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The URI of the data source.
         * </p>
         * 
         * @param sourceURI
         *        The URI of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceURI(String sourceURI);

        /**
         * <p>
         * The name of the data and how often it should be pulled from the source.
         * </p>
         * 
         * @param scheduleConfig
         *        The name of the data and how often it should be pulled from the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleConfig(ScheduleConfiguration scheduleConfig);

        /**
         * <p>
         * The name of the data and how often it should be pulled from the source.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduleConfiguration.Builder} avoiding the need
         * to create one manually via {@link ScheduleConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduleConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleConfig(ScheduleConfiguration)}.
         * 
         * @param scheduleConfig
         *        a consumer that will call methods on {@link ScheduleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleConfig(ScheduleConfiguration)
         */
        default Builder scheduleConfig(Consumer<ScheduleConfiguration.Builder> scheduleConfig) {
            return scheduleConfig(ScheduleConfiguration.builder().applyMutation(scheduleConfig).build());
        }

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppIntegrationsRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String kmsKey;

        private String sourceURI;

        private ScheduleConfiguration scheduleConfig;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataIntegrationRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            kmsKey(model.kmsKey);
            sourceURI(model.sourceURI);
            scheduleConfig(model.scheduleConfig);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        @Transient
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getSourceURI() {
            return sourceURI;
        }

        public final void setSourceURI(String sourceURI) {
            this.sourceURI = sourceURI;
        }

        @Override
        @Transient
        public final Builder sourceURI(String sourceURI) {
            this.sourceURI = sourceURI;
            return this;
        }

        public final ScheduleConfiguration.Builder getScheduleConfig() {
            return scheduleConfig != null ? scheduleConfig.toBuilder() : null;
        }

        public final void setScheduleConfig(ScheduleConfiguration.BuilderImpl scheduleConfig) {
            this.scheduleConfig = scheduleConfig != null ? scheduleConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder scheduleConfig(ScheduleConfiguration scheduleConfig) {
            this.scheduleConfig = scheduleConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataIntegrationRequest build() {
            return new CreateDataIntegrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
