/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about the Application Association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationAssociationSummary.Builder, ApplicationAssociationSummary> {
    private static final SdkField<String> APPLICATION_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationAssociationArn").getter(getter(ApplicationAssociationSummary::applicationAssociationArn))
            .setter(setter(Builder::applicationAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationAssociationArn").build())
            .build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn").getter(getter(ApplicationAssociationSummary::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(ApplicationAssociationSummary::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_ASSOCIATION_ARN_FIELD, APPLICATION_ARN_FIELD, CLIENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationAssociationArn;

    private final String applicationArn;

    private final String clientId;

    private ApplicationAssociationSummary(BuilderImpl builder) {
        this.applicationAssociationArn = builder.applicationAssociationArn;
        this.applicationArn = builder.applicationArn;
        this.clientId = builder.clientId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Application Association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Application Association.
     */
    public final String applicationAssociationArn() {
        return applicationAssociationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Application.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The identifier for the client that is associated with the Application Association.
     * </p>
     * 
     * @return The identifier for the client that is associated with the Application Association.
     */
    public final String clientId() {
        return clientId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationAssociationSummary)) {
            return false;
        }
        ApplicationAssociationSummary other = (ApplicationAssociationSummary) obj;
        return Objects.equals(applicationAssociationArn(), other.applicationAssociationArn())
                && Objects.equals(applicationArn(), other.applicationArn()) && Objects.equals(clientId(), other.clientId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationAssociationSummary").add("ApplicationAssociationArn", applicationAssociationArn())
                .add("ApplicationArn", applicationArn()).add("ClientId", clientId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationAssociationArn":
            return Optional.ofNullable(clazz.cast(applicationAssociationArn()));
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationAssociationSummary, T> g) {
        return obj -> g.apply((ApplicationAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationAssociationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Application Association.
         * </p>
         * 
         * @param applicationAssociationArn
         *        The Amazon Resource Name (ARN) of the Application Association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationAssociationArn(String applicationAssociationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Application.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of the Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The identifier for the client that is associated with the Application Association.
         * </p>
         * 
         * @param clientId
         *        The identifier for the client that is associated with the Application Association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);
    }

    static final class BuilderImpl implements Builder {
        private String applicationAssociationArn;

        private String applicationArn;

        private String clientId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationAssociationSummary model) {
            applicationAssociationArn(model.applicationAssociationArn);
            applicationArn(model.applicationArn);
            clientId(model.clientId);
        }

        public final String getApplicationAssociationArn() {
            return applicationAssociationArn;
        }

        public final void setApplicationAssociationArn(String applicationAssociationArn) {
            this.applicationAssociationArn = applicationAssociationArn;
        }

        @Override
        public final Builder applicationAssociationArn(String applicationAssociationArn) {
            this.applicationAssociationArn = applicationAssociationArn;
            return this;
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        public ApplicationAssociationSummary build() {
            return new ApplicationAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
