/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationRequest extends AppIntegrationsRequest implements
        ToCopyableBuilder<UpdateApplicationRequest.Builder, UpdateApplicationRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateApplicationRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationIdentifier").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateApplicationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateApplicationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ApplicationSourceConfig> APPLICATION_SOURCE_CONFIG_FIELD = SdkField
            .<ApplicationSourceConfig> builder(MarshallingType.SDK_POJO).memberName("ApplicationSourceConfig")
            .getter(getter(UpdateApplicationRequest::applicationSourceConfig)).setter(setter(Builder::applicationSourceConfig))
            .constructor(ApplicationSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSourceConfig").build())
            .build();

    private static final SdkField<List<Subscription>> SUBSCRIPTIONS_FIELD = SdkField
            .<List<Subscription>> builder(MarshallingType.LIST)
            .memberName("Subscriptions")
            .getter(getter(UpdateApplicationRequest::subscriptions))
            .setter(setter(Builder::subscriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Subscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(Subscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Publication>> PUBLICATIONS_FIELD = SdkField
            .<List<Publication>> builder(MarshallingType.LIST)
            .memberName("Publications")
            .getter(getter(UpdateApplicationRequest::publications))
            .setter(setter(Builder::publications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Publications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Publication> builder(MarshallingType.SDK_POJO)
                                            .constructor(Publication::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(UpdateApplicationRequest::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, APPLICATION_SOURCE_CONFIG_FIELD, SUBSCRIPTIONS_FIELD, PUBLICATIONS_FIELD, PERMISSIONS_FIELD));

    private final String arn;

    private final String name;

    private final String description;

    private final ApplicationSourceConfig applicationSourceConfig;

    private final List<Subscription> subscriptions;

    private final List<Publication> publications;

    private final List<String> permissions;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.applicationSourceConfig = builder.applicationSourceConfig;
        this.subscriptions = builder.subscriptions;
        this.publications = builder.publications;
        this.permissions = builder.permissions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Application.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the application.
     * </p>
     * 
     * @return The description of the application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration for where the application should be loaded from.
     * </p>
     * 
     * @return The configuration for where the application should be loaded from.
     */
    public final ApplicationSourceConfig applicationSourceConfig() {
        return applicationSourceConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subscriptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     *
     * @deprecated Subscriptions has been replaced with Permissions
     */
    @Deprecated
    public final boolean hasSubscriptions() {
        return subscriptions != null && !(subscriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The events that the application subscribes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscriptions} method.
     * </p>
     * 
     * @return The events that the application subscribes.
     * @deprecated Subscriptions has been replaced with Permissions
     */
    @Deprecated
    public final List<Subscription> subscriptions() {
        return subscriptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Publications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     *
     * @deprecated Publications has been replaced with Permissions
     */
    @Deprecated
    public final boolean hasPublications() {
        return publications != null && !(publications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The events that the application publishes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPublications} method.
     * </p>
     * 
     * @return The events that the application publishes.
     * @deprecated Publications has been replaced with Permissions
     */
    @Deprecated
    public final List<Publication> publications() {
        return publications;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration of events or requests that the application has access to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The configuration of events or requests that the application has access to.
     */
    public final List<String> permissions() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscriptions() ? subscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPublications() ? publications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(applicationSourceConfig(), other.applicationSourceConfig())
                && hasSubscriptions() == other.hasSubscriptions() && Objects.equals(subscriptions(), other.subscriptions())
                && hasPublications() == other.hasPublications() && Objects.equals(publications(), other.publications())
                && hasPermissions() == other.hasPermissions() && Objects.equals(permissions(), other.permissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationRequest").add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("ApplicationSourceConfig", applicationSourceConfig())
                .add("Subscriptions", hasSubscriptions() ? subscriptions() : null)
                .add("Publications", hasPublications() ? publications() : null)
                .add("Permissions", hasPermissions() ? permissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ApplicationSourceConfig":
            return Optional.ofNullable(clazz.cast(applicationSourceConfig()));
        case "Subscriptions":
            return Optional.ofNullable(clazz.cast(subscriptions()));
        case "Publications":
            return Optional.ofNullable(clazz.cast(publications()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppIntegrationsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApplicationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Application.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param name
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the application.
         * </p>
         * 
         * @param description
         *        The description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration for where the application should be loaded from.
         * </p>
         * 
         * @param applicationSourceConfig
         *        The configuration for where the application should be loaded from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSourceConfig(ApplicationSourceConfig applicationSourceConfig);

        /**
         * <p>
         * The configuration for where the application should be loaded from.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationSourceConfig.Builder} avoiding
         * the need to create one manually via {@link ApplicationSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationSourceConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #applicationSourceConfig(ApplicationSourceConfig)}.
         * 
         * @param applicationSourceConfig
         *        a consumer that will call methods on {@link ApplicationSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSourceConfig(ApplicationSourceConfig)
         */
        default Builder applicationSourceConfig(Consumer<ApplicationSourceConfig.Builder> applicationSourceConfig) {
            return applicationSourceConfig(ApplicationSourceConfig.builder().applyMutation(applicationSourceConfig).build());
        }

        /**
         * <p>
         * The events that the application subscribes.
         * </p>
         * 
         * @param subscriptions
         *        The events that the application subscribes.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Subscriptions has been replaced with Permissions
         */
        @Deprecated
        Builder subscriptions(Collection<Subscription> subscriptions);

        /**
         * <p>
         * The events that the application subscribes.
         * </p>
         * 
         * @param subscriptions
         *        The events that the application subscribes.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Subscriptions has been replaced with Permissions
         */
        @Deprecated
        Builder subscriptions(Subscription... subscriptions);

        /**
         * <p>
         * The events that the application subscribes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appintegrations.model.Subscription.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.appintegrations.model.Subscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appintegrations.model.Subscription.Builder#build()} is called
         * immediately and its result is passed to {@link #subscriptions(List<Subscription>)}.
         * 
         * @param subscriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appintegrations.model.Subscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriptions(java.util.Collection<Subscription>)
         * @deprecated Subscriptions has been replaced with Permissions
         */
        @Deprecated
        Builder subscriptions(Consumer<Subscription.Builder>... subscriptions);

        /**
         * <p>
         * The events that the application publishes.
         * </p>
         * 
         * @param publications
         *        The events that the application publishes.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Publications has been replaced with Permissions
         */
        @Deprecated
        Builder publications(Collection<Publication> publications);

        /**
         * <p>
         * The events that the application publishes.
         * </p>
         * 
         * @param publications
         *        The events that the application publishes.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Publications has been replaced with Permissions
         */
        @Deprecated
        Builder publications(Publication... publications);

        /**
         * <p>
         * The events that the application publishes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appintegrations.model.Publication.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.appintegrations.model.Publication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appintegrations.model.Publication.Builder#build()} is called
         * immediately and its result is passed to {@link #publications(List<Publication>)}.
         * 
         * @param publications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appintegrations.model.Publication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publications(java.util.Collection<Publication>)
         * @deprecated Publications has been replaced with Permissions
         */
        @Deprecated
        Builder publications(Consumer<Publication.Builder>... publications);

        /**
         * <p>
         * The configuration of events or requests that the application has access to.
         * </p>
         * 
         * @param permissions
         *        The configuration of events or requests that the application has access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<String> permissions);

        /**
         * <p>
         * The configuration of events or requests that the application has access to.
         * </p>
         * 
         * @param permissions
         *        The configuration of events or requests that the application has access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(String... permissions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppIntegrationsRequest.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private ApplicationSourceConfig applicationSourceConfig;

        private List<Subscription> subscriptions = DefaultSdkAutoConstructList.getInstance();

        private List<Publication> publications = DefaultSdkAutoConstructList.getInstance();

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            arn(model.arn);
            name(model.name);
            description(model.description);
            applicationSourceConfig(model.applicationSourceConfig);
            subscriptions(model.subscriptions);
            publications(model.publications);
            permissions(model.permissions);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ApplicationSourceConfig.Builder getApplicationSourceConfig() {
            return applicationSourceConfig != null ? applicationSourceConfig.toBuilder() : null;
        }

        public final void setApplicationSourceConfig(ApplicationSourceConfig.BuilderImpl applicationSourceConfig) {
            this.applicationSourceConfig = applicationSourceConfig != null ? applicationSourceConfig.build() : null;
        }

        @Override
        public final Builder applicationSourceConfig(ApplicationSourceConfig applicationSourceConfig) {
            this.applicationSourceConfig = applicationSourceConfig;
            return this;
        }

        @Deprecated
        public final List<Subscription.Builder> getSubscriptions() {
            List<Subscription.Builder> result = SubscriptionListCopier.copyToBuilder(this.subscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copyFromBuilder(subscriptions);
        }

        @Override
        @Deprecated
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder subscriptions(Subscription... subscriptions) {
            subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder subscriptions(Consumer<Subscription.Builder>... subscriptions) {
            subscriptions(Stream.of(subscriptions).map(c -> Subscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final List<Publication.Builder> getPublications() {
            List<Publication.Builder> result = PublicationListCopier.copyToBuilder(this.publications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setPublications(Collection<Publication.BuilderImpl> publications) {
            this.publications = PublicationListCopier.copyFromBuilder(publications);
        }

        @Override
        @Deprecated
        public final Builder publications(Collection<Publication> publications) {
            this.publications = PublicationListCopier.copy(publications);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder publications(Publication... publications) {
            publications(Arrays.asList(publications));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder publications(Consumer<Publication.Builder>... publications) {
            publications(Stream.of(publications).map(c -> Publication.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getPermissions() {
            if (permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        @Override
        public final Builder permissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(String... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
