/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for what files should be pulled from the source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FileConfiguration.Builder, FileConfiguration> {
    private static final SdkField<List<String>> FOLDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Folders")
            .getter(getter(FileConfiguration::folders))
            .setter(setter(Builder::folders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Folders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> FILTERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Filters")
            .getter(getter(FileConfiguration::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOLDERS_FIELD, FILTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> folders;

    private final Map<String, List<String>> filters;

    private FileConfiguration(BuilderImpl builder) {
        this.folders = builder.folders;
        this.filters = builder.filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Folders property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFolders() {
        return folders != null && !(folders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifiers for the source folders to pull all files from recursively.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFolders} method.
     * </p>
     * 
     * @return Identifiers for the source folders to pull all files from recursively.
     */
    public final List<String> folders() {
        return folders;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Restrictions for what files should be pulled from the source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Restrictions for what files should be pulled from the source.
     */
    public final Map<String, List<String>> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFolders() ? folders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileConfiguration)) {
            return false;
        }
        FileConfiguration other = (FileConfiguration) obj;
        return hasFolders() == other.hasFolders() && Objects.equals(folders(), other.folders())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileConfiguration").add("Folders", hasFolders() ? folders() : null)
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Folders":
            return Optional.ofNullable(clazz.cast(folders()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileConfiguration, T> g) {
        return obj -> g.apply((FileConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileConfiguration> {
        /**
         * <p>
         * Identifiers for the source folders to pull all files from recursively.
         * </p>
         * 
         * @param folders
         *        Identifiers for the source folders to pull all files from recursively.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folders(Collection<String> folders);

        /**
         * <p>
         * Identifiers for the source folders to pull all files from recursively.
         * </p>
         * 
         * @param folders
         *        Identifiers for the source folders to pull all files from recursively.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folders(String... folders);

        /**
         * <p>
         * Restrictions for what files should be pulled from the source.
         * </p>
         * 
         * @param filters
         *        Restrictions for what files should be pulled from the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Map<String, ? extends Collection<String>> filters);
    }

    static final class BuilderImpl implements Builder {
        private List<String> folders = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<String>> filters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FileConfiguration model) {
            folders(model.folders);
            filters(model.filters);
        }

        public final Collection<String> getFolders() {
            if (folders instanceof SdkAutoConstructList) {
                return null;
            }
            return folders;
        }

        public final void setFolders(Collection<String> folders) {
            this.folders = FolderListCopier.copy(folders);
        }

        @Override
        public final Builder folders(Collection<String> folders) {
            this.folders = FolderListCopier.copy(folders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(String... folders) {
            folders(Arrays.asList(folders));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getFilters() {
            if (filters instanceof SdkAutoConstructMap) {
                return null;
            }
            return filters;
        }

        public final void setFilters(Map<String, ? extends Collection<String>> filters) {
            this.filters = FieldsMapCopier.copy(filters);
        }

        @Override
        public final Builder filters(Map<String, ? extends Collection<String>> filters) {
            this.filters = FieldsMapCopier.copy(filters);
            return this;
        }

        @Override
        public FileConfiguration build() {
            return new FileConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
