/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataIntegrationAssociationRequest extends AppIntegrationsRequest implements
        ToCopyableBuilder<UpdateDataIntegrationAssociationRequest.Builder, UpdateDataIntegrationAssociationRequest> {
    private static final SdkField<String> DATA_INTEGRATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataIntegrationIdentifier")
            .getter(getter(UpdateDataIntegrationAssociationRequest::dataIntegrationIdentifier))
            .setter(setter(Builder::dataIntegrationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final SdkField<String> DATA_INTEGRATION_ASSOCIATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DataIntegrationAssociationIdentifier")
            .getter(getter(UpdateDataIntegrationAssociationRequest::dataIntegrationAssociationIdentifier))
            .setter(setter(Builder::dataIntegrationAssociationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataIntegrationAssociationIdentifier")
                    .build()).build();

    private static final SdkField<ExecutionConfiguration> EXECUTION_CONFIGURATION_FIELD = SdkField
            .<ExecutionConfiguration> builder(MarshallingType.SDK_POJO).memberName("ExecutionConfiguration")
            .getter(getter(UpdateDataIntegrationAssociationRequest::executionConfiguration))
            .setter(setter(Builder::executionConfiguration)).constructor(ExecutionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_INTEGRATION_IDENTIFIER_FIELD, DATA_INTEGRATION_ASSOCIATION_IDENTIFIER_FIELD, EXECUTION_CONFIGURATION_FIELD));

    private final String dataIntegrationIdentifier;

    private final String dataIntegrationAssociationIdentifier;

    private final ExecutionConfiguration executionConfiguration;

    private UpdateDataIntegrationAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.dataIntegrationIdentifier = builder.dataIntegrationIdentifier;
        this.dataIntegrationAssociationIdentifier = builder.dataIntegrationAssociationIdentifier;
        this.executionConfiguration = builder.executionConfiguration;
    }

    /**
     * <p>
     * A unique identifier for the DataIntegration.
     * </p>
     * 
     * @return A unique identifier for the DataIntegration.
     */
    public final String dataIntegrationIdentifier() {
        return dataIntegrationIdentifier;
    }

    /**
     * <p>
     * A unique identifier. of the DataIntegrationAssociation resource
     * </p>
     * 
     * @return A unique identifier. of the DataIntegrationAssociation resource
     */
    public final String dataIntegrationAssociationIdentifier() {
        return dataIntegrationAssociationIdentifier;
    }

    /**
     * <p>
     * The configuration for how the files should be pulled from the source.
     * </p>
     * 
     * @return The configuration for how the files should be pulled from the source.
     */
    public final ExecutionConfiguration executionConfiguration() {
        return executionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataIntegrationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dataIntegrationAssociationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(executionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataIntegrationAssociationRequest)) {
            return false;
        }
        UpdateDataIntegrationAssociationRequest other = (UpdateDataIntegrationAssociationRequest) obj;
        return Objects.equals(dataIntegrationIdentifier(), other.dataIntegrationIdentifier())
                && Objects.equals(dataIntegrationAssociationIdentifier(), other.dataIntegrationAssociationIdentifier())
                && Objects.equals(executionConfiguration(), other.executionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataIntegrationAssociationRequest")
                .add("DataIntegrationIdentifier", dataIntegrationIdentifier())
                .add("DataIntegrationAssociationIdentifier", dataIntegrationAssociationIdentifier())
                .add("ExecutionConfiguration", executionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataIntegrationIdentifier":
            return Optional.ofNullable(clazz.cast(dataIntegrationIdentifier()));
        case "DataIntegrationAssociationIdentifier":
            return Optional.ofNullable(clazz.cast(dataIntegrationAssociationIdentifier()));
        case "ExecutionConfiguration":
            return Optional.ofNullable(clazz.cast(executionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataIntegrationAssociationRequest, T> g) {
        return obj -> g.apply((UpdateDataIntegrationAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDataIntegrationAssociationRequest> {
        /**
         * <p>
         * A unique identifier for the DataIntegration.
         * </p>
         * 
         * @param dataIntegrationIdentifier
         *        A unique identifier for the DataIntegration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataIntegrationIdentifier(String dataIntegrationIdentifier);

        /**
         * <p>
         * A unique identifier. of the DataIntegrationAssociation resource
         * </p>
         * 
         * @param dataIntegrationAssociationIdentifier
         *        A unique identifier. of the DataIntegrationAssociation resource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataIntegrationAssociationIdentifier(String dataIntegrationAssociationIdentifier);

        /**
         * <p>
         * The configuration for how the files should be pulled from the source.
         * </p>
         * 
         * @param executionConfiguration
         *        The configuration for how the files should be pulled from the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionConfiguration(ExecutionConfiguration executionConfiguration);

        /**
         * <p>
         * The configuration for how the files should be pulled from the source.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionConfiguration.Builder} avoiding
         * the need to create one manually via {@link ExecutionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #executionConfiguration(ExecutionConfiguration)}.
         * 
         * @param executionConfiguration
         *        a consumer that will call methods on {@link ExecutionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionConfiguration(ExecutionConfiguration)
         */
        default Builder executionConfiguration(Consumer<ExecutionConfiguration.Builder> executionConfiguration) {
            return executionConfiguration(ExecutionConfiguration.builder().applyMutation(executionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppIntegrationsRequest.BuilderImpl implements Builder {
        private String dataIntegrationIdentifier;

        private String dataIntegrationAssociationIdentifier;

        private ExecutionConfiguration executionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataIntegrationAssociationRequest model) {
            super(model);
            dataIntegrationIdentifier(model.dataIntegrationIdentifier);
            dataIntegrationAssociationIdentifier(model.dataIntegrationAssociationIdentifier);
            executionConfiguration(model.executionConfiguration);
        }

        public final String getDataIntegrationIdentifier() {
            return dataIntegrationIdentifier;
        }

        public final void setDataIntegrationIdentifier(String dataIntegrationIdentifier) {
            this.dataIntegrationIdentifier = dataIntegrationIdentifier;
        }

        @Override
        public final Builder dataIntegrationIdentifier(String dataIntegrationIdentifier) {
            this.dataIntegrationIdentifier = dataIntegrationIdentifier;
            return this;
        }

        public final String getDataIntegrationAssociationIdentifier() {
            return dataIntegrationAssociationIdentifier;
        }

        public final void setDataIntegrationAssociationIdentifier(String dataIntegrationAssociationIdentifier) {
            this.dataIntegrationAssociationIdentifier = dataIntegrationAssociationIdentifier;
        }

        @Override
        public final Builder dataIntegrationAssociationIdentifier(String dataIntegrationAssociationIdentifier) {
            this.dataIntegrationAssociationIdentifier = dataIntegrationAssociationIdentifier;
            return this;
        }

        public final ExecutionConfiguration.Builder getExecutionConfiguration() {
            return executionConfiguration != null ? executionConfiguration.toBuilder() : null;
        }

        public final void setExecutionConfiguration(ExecutionConfiguration.BuilderImpl executionConfiguration) {
            this.executionConfiguration = executionConfiguration != null ? executionConfiguration.build() : null;
        }

        @Override
        public final Builder executionConfiguration(ExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataIntegrationAssociationRequest build() {
            return new UpdateDataIntegrationAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
