/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationResponse extends AppIntegrationsResponse implements
        ToCopyableBuilder<GetApplicationResponse.Builder, GetApplicationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetApplicationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetApplicationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetApplicationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(GetApplicationResponse::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetApplicationResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ApplicationSourceConfig> APPLICATION_SOURCE_CONFIG_FIELD = SdkField
            .<ApplicationSourceConfig> builder(MarshallingType.SDK_POJO).memberName("ApplicationSourceConfig")
            .getter(getter(GetApplicationResponse::applicationSourceConfig)).setter(setter(Builder::applicationSourceConfig))
            .constructor(ApplicationSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSourceConfig").build())
            .build();

    private static final SdkField<List<Subscription>> SUBSCRIPTIONS_FIELD = SdkField
            .<List<Subscription>> builder(MarshallingType.LIST)
            .memberName("Subscriptions")
            .getter(getter(GetApplicationResponse::subscriptions))
            .setter(setter(Builder::subscriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Subscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(Subscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Publication>> PUBLICATIONS_FIELD = SdkField
            .<List<Publication>> builder(MarshallingType.LIST)
            .memberName("Publications")
            .getter(getter(GetApplicationResponse::publications))
            .setter(setter(Builder::publications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Publications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Publication> builder(MarshallingType.SDK_POJO)
                                            .constructor(Publication::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(GetApplicationResponse::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(GetApplicationResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetApplicationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(GetApplicationResponse::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            NAME_FIELD, NAMESPACE_FIELD, DESCRIPTION_FIELD, APPLICATION_SOURCE_CONFIG_FIELD, SUBSCRIPTIONS_FIELD,
            PUBLICATIONS_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, TAGS_FIELD, PERMISSIONS_FIELD));

    private final String arn;

    private final String id;

    private final String name;

    private final String namespace;

    private final String description;

    private final ApplicationSourceConfig applicationSourceConfig;

    private final List<Subscription> subscriptions;

    private final List<Publication> publications;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private final Map<String, String> tags;

    private final List<String> permissions;

    private GetApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.namespace = builder.namespace;
        this.description = builder.description;
        this.applicationSourceConfig = builder.applicationSourceConfig;
        this.subscriptions = builder.subscriptions;
        this.publications = builder.publications;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.tags = builder.tags;
        this.permissions = builder.permissions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Application.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A unique identifier for the Application.
     * </p>
     * 
     * @return A unique identifier for the Application.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The namespace of the application.
     * </p>
     * 
     * @return The namespace of the application.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The description of the application.
     * </p>
     * 
     * @return The description of the application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration for where the application should be loaded from.
     * </p>
     * 
     * @return The configuration for where the application should be loaded from.
     */
    public final ApplicationSourceConfig applicationSourceConfig() {
        return applicationSourceConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subscriptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     *
     * @deprecated Subscriptions has been replaced with Permissions
     */
    @Deprecated
    public final boolean hasSubscriptions() {
        return subscriptions != null && !(subscriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The events that the application subscribes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscriptions} method.
     * </p>
     * 
     * @return The events that the application subscribes.
     * @deprecated Subscriptions has been replaced with Permissions
     */
    @Deprecated
    public final List<Subscription> subscriptions() {
        return subscriptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Publications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     *
     * @deprecated Publications has been replaced with Permissions
     */
    @Deprecated
    public final boolean hasPublications() {
        return publications != null && !(publications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The events that the application publishes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPublications} method.
     * </p>
     * 
     * @return The events that the application publishes.
     * @deprecated Publications has been replaced with Permissions
     */
    @Deprecated
    public final List<Publication> publications() {
        return publications;
    }

    /**
     * <p>
     * The created time of the Application.
     * </p>
     * 
     * @return The created time of the Application.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The last modified time of the Application.
     * </p>
     * 
     * @return The last modified time of the Application.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration of events or requests that the application has access to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The configuration of events or requests that the application has access to.
     */
    public final List<String> permissions() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscriptions() ? subscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPublications() ? publications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationResponse)) {
            return false;
        }
        GetApplicationResponse other = (GetApplicationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(description(), other.description())
                && Objects.equals(applicationSourceConfig(), other.applicationSourceConfig())
                && hasSubscriptions() == other.hasSubscriptions() && Objects.equals(subscriptions(), other.subscriptions())
                && hasPublications() == other.hasPublications() && Objects.equals(publications(), other.publications())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissions(), other.permissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationResponse").add("Arn", arn()).add("Id", id()).add("Name", name())
                .add("Namespace", namespace()).add("Description", description())
                .add("ApplicationSourceConfig", applicationSourceConfig())
                .add("Subscriptions", hasSubscriptions() ? subscriptions() : null)
                .add("Publications", hasPublications() ? publications() : null).add("CreatedTime", createdTime())
                .add("LastModifiedTime", lastModifiedTime()).add("Tags", hasTags() ? tags() : null)
                .add("Permissions", hasPermissions() ? permissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ApplicationSourceConfig":
            return Optional.ofNullable(clazz.cast(applicationSourceConfig()));
        case "Subscriptions":
            return Optional.ofNullable(clazz.cast(subscriptions()));
        case "Publications":
            return Optional.ofNullable(clazz.cast(publications()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationResponse, T> g) {
        return obj -> g.apply((GetApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppIntegrationsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetApplicationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Application.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A unique identifier for the Application.
         * </p>
         * 
         * @param id
         *        A unique identifier for the Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param name
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The namespace of the application.
         * </p>
         * 
         * @param namespace
         *        The namespace of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The description of the application.
         * </p>
         * 
         * @param description
         *        The description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration for where the application should be loaded from.
         * </p>
         * 
         * @param applicationSourceConfig
         *        The configuration for where the application should be loaded from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSourceConfig(ApplicationSourceConfig applicationSourceConfig);

        /**
         * <p>
         * The configuration for where the application should be loaded from.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationSourceConfig.Builder} avoiding
         * the need to create one manually via {@link ApplicationSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationSourceConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #applicationSourceConfig(ApplicationSourceConfig)}.
         * 
         * @param applicationSourceConfig
         *        a consumer that will call methods on {@link ApplicationSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSourceConfig(ApplicationSourceConfig)
         */
        default Builder applicationSourceConfig(Consumer<ApplicationSourceConfig.Builder> applicationSourceConfig) {
            return applicationSourceConfig(ApplicationSourceConfig.builder().applyMutation(applicationSourceConfig).build());
        }

        /**
         * <p>
         * The events that the application subscribes.
         * </p>
         * 
         * @param subscriptions
         *        The events that the application subscribes.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Subscriptions has been replaced with Permissions
         */
        @Deprecated
        Builder subscriptions(Collection<Subscription> subscriptions);

        /**
         * <p>
         * The events that the application subscribes.
         * </p>
         * 
         * @param subscriptions
         *        The events that the application subscribes.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Subscriptions has been replaced with Permissions
         */
        @Deprecated
        Builder subscriptions(Subscription... subscriptions);

        /**
         * <p>
         * The events that the application subscribes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appintegrations.model.Subscription.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.appintegrations.model.Subscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appintegrations.model.Subscription.Builder#build()} is called
         * immediately and its result is passed to {@link #subscriptions(List<Subscription>)}.
         * 
         * @param subscriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appintegrations.model.Subscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriptions(java.util.Collection<Subscription>)
         * @deprecated Subscriptions has been replaced with Permissions
         */
        @Deprecated
        Builder subscriptions(Consumer<Subscription.Builder>... subscriptions);

        /**
         * <p>
         * The events that the application publishes.
         * </p>
         * 
         * @param publications
         *        The events that the application publishes.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Publications has been replaced with Permissions
         */
        @Deprecated
        Builder publications(Collection<Publication> publications);

        /**
         * <p>
         * The events that the application publishes.
         * </p>
         * 
         * @param publications
         *        The events that the application publishes.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Publications has been replaced with Permissions
         */
        @Deprecated
        Builder publications(Publication... publications);

        /**
         * <p>
         * The events that the application publishes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appintegrations.model.Publication.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.appintegrations.model.Publication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appintegrations.model.Publication.Builder#build()} is called
         * immediately and its result is passed to {@link #publications(List<Publication>)}.
         * 
         * @param publications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appintegrations.model.Publication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publications(java.util.Collection<Publication>)
         * @deprecated Publications has been replaced with Permissions
         */
        @Deprecated
        Builder publications(Consumer<Publication.Builder>... publications);

        /**
         * <p>
         * The created time of the Application.
         * </p>
         * 
         * @param createdTime
         *        The created time of the Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The last modified time of the Application.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last modified time of the Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The configuration of events or requests that the application has access to.
         * </p>
         * 
         * @param permissions
         *        The configuration of events or requests that the application has access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<String> permissions);

        /**
         * <p>
         * The configuration of events or requests that the application has access to.
         * </p>
         * 
         * @param permissions
         *        The configuration of events or requests that the application has access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(String... permissions);
    }

    static final class BuilderImpl extends AppIntegrationsResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String name;

        private String namespace;

        private String description;

        private ApplicationSourceConfig applicationSourceConfig;

        private List<Subscription> subscriptions = DefaultSdkAutoConstructList.getInstance();

        private List<Publication> publications = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTime;

        private Instant lastModifiedTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            name(model.name);
            namespace(model.namespace);
            description(model.description);
            applicationSourceConfig(model.applicationSourceConfig);
            subscriptions(model.subscriptions);
            publications(model.publications);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
            tags(model.tags);
            permissions(model.permissions);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ApplicationSourceConfig.Builder getApplicationSourceConfig() {
            return applicationSourceConfig != null ? applicationSourceConfig.toBuilder() : null;
        }

        public final void setApplicationSourceConfig(ApplicationSourceConfig.BuilderImpl applicationSourceConfig) {
            this.applicationSourceConfig = applicationSourceConfig != null ? applicationSourceConfig.build() : null;
        }

        @Override
        public final Builder applicationSourceConfig(ApplicationSourceConfig applicationSourceConfig) {
            this.applicationSourceConfig = applicationSourceConfig;
            return this;
        }

        @Deprecated
        public final List<Subscription.Builder> getSubscriptions() {
            List<Subscription.Builder> result = SubscriptionListCopier.copyToBuilder(this.subscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copyFromBuilder(subscriptions);
        }

        @Override
        @Deprecated
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder subscriptions(Subscription... subscriptions) {
            subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder subscriptions(Consumer<Subscription.Builder>... subscriptions) {
            subscriptions(Stream.of(subscriptions).map(c -> Subscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final List<Publication.Builder> getPublications() {
            List<Publication.Builder> result = PublicationListCopier.copyToBuilder(this.publications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setPublications(Collection<Publication.BuilderImpl> publications) {
            this.publications = PublicationListCopier.copyFromBuilder(publications);
        }

        @Override
        @Deprecated
        public final Builder publications(Collection<Publication> publications) {
            this.publications = PublicationListCopier.copy(publications);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder publications(Publication... publications) {
            publications(Arrays.asList(publications));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder publications(Consumer<Publication.Builder>... publications) {
            publications(Stream.of(publications).map(c -> Publication.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getPermissions() {
            if (permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        @Override
        public final Builder permissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(String... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        public GetApplicationResponse build() {
            return new GetApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
