/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appintegrations.model.ApplicationApprovedOriginsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalUrlConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalUrlConfig> {
    private static final SdkField<String> ACCESS_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessUrl").getter(ExternalUrlConfig.getter(ExternalUrlConfig::accessUrl)).setter(ExternalUrlConfig.setter(Builder::accessUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessUrl").build()}).build();
    private static final SdkField<List<String>> APPROVED_ORIGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApprovedOrigins").getter(ExternalUrlConfig.getter(ExternalUrlConfig::approvedOrigins)).setter(ExternalUrlConfig.setter(Builder::approvedOrigins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedOrigins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_URL_FIELD, APPROVED_ORIGINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccessUrl", ACCESS_URL_FIELD);
            this.put("ApprovedOrigins", APPROVED_ORIGINS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accessUrl;
    private final List<String> approvedOrigins;

    private ExternalUrlConfig(BuilderImpl builder) {
        this.accessUrl = builder.accessUrl;
        this.approvedOrigins = builder.approvedOrigins;
    }

    public final String accessUrl() {
        return this.accessUrl;
    }

    public final boolean hasApprovedOrigins() {
        return this.approvedOrigins != null && !(this.approvedOrigins instanceof SdkAutoConstructList);
    }

    public final List<String> approvedOrigins() {
        return this.approvedOrigins;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApprovedOrigins() ? this.approvedOrigins() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalUrlConfig)) {
            return false;
        }
        ExternalUrlConfig other = (ExternalUrlConfig)obj;
        return Objects.equals(this.accessUrl(), other.accessUrl()) && this.hasApprovedOrigins() == other.hasApprovedOrigins() && Objects.equals(this.approvedOrigins(), other.approvedOrigins());
    }

    public final String toString() {
        return ToString.builder((String)"ExternalUrlConfig").add("AccessUrl", (Object)this.accessUrl()).add("ApprovedOrigins", this.hasApprovedOrigins() ? this.approvedOrigins() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessUrl": {
                return Optional.ofNullable(clazz.cast(this.accessUrl()));
            }
            case "ApprovedOrigins": {
                return Optional.ofNullable(clazz.cast(this.approvedOrigins()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExternalUrlConfig, T> g) {
        return obj -> g.apply((ExternalUrlConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessUrl;
        private List<String> approvedOrigins = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalUrlConfig model) {
            this.accessUrl(model.accessUrl);
            this.approvedOrigins(model.approvedOrigins);
        }

        public final String getAccessUrl() {
            return this.accessUrl;
        }

        public final void setAccessUrl(String accessUrl) {
            this.accessUrl = accessUrl;
        }

        @Override
        public final Builder accessUrl(String accessUrl) {
            this.accessUrl = accessUrl;
            return this;
        }

        public final Collection<String> getApprovedOrigins() {
            if (this.approvedOrigins instanceof SdkAutoConstructList) {
                return null;
            }
            return this.approvedOrigins;
        }

        public final void setApprovedOrigins(Collection<String> approvedOrigins) {
            this.approvedOrigins = ApplicationApprovedOriginsCopier.copy(approvedOrigins);
        }

        @Override
        public final Builder approvedOrigins(Collection<String> approvedOrigins) {
            this.approvedOrigins = ApplicationApprovedOriginsCopier.copy(approvedOrigins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedOrigins(String ... approvedOrigins) {
            this.approvedOrigins(Arrays.asList(approvedOrigins));
            return this;
        }

        public ExternalUrlConfig build() {
            return new ExternalUrlConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalUrlConfig> {
        public Builder accessUrl(String var1);

        public Builder approvedOrigins(Collection<String> var1);

        public Builder approvedOrigins(String ... var1);
    }
}

