/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataIntegrationResponse extends AppIntegrationsResponse implements
        ToCopyableBuilder<CreateDataIntegrationResponse.Builder, CreateDataIntegrationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateDataIntegrationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CreateDataIntegrationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateDataIntegrationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateDataIntegrationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KmsKey")
            .getter(getter(CreateDataIntegrationResponse::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()).build();

    private static final SdkField<String> SOURCE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceURI").getter(getter(CreateDataIntegrationResponse::sourceURI)).setter(setter(Builder::sourceURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceURI").build()).build();

    private static final SdkField<ScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField
            .<ScheduleConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScheduleConfiguration")
            .getter(getter(CreateDataIntegrationResponse::scheduleConfiguration)).setter(setter(Builder::scheduleConfiguration))
            .constructor(ScheduleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateDataIntegrationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateDataIntegrationResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<FileConfiguration> FILE_CONFIGURATION_FIELD = SdkField
            .<FileConfiguration> builder(MarshallingType.SDK_POJO).memberName("FileConfiguration")
            .getter(getter(CreateDataIntegrationResponse::fileConfiguration)).setter(setter(Builder::fileConfiguration))
            .constructor(FileConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileConfiguration").build()).build();

    private static final SdkField<Map<String, Map<String, List<String>>>> OBJECT_CONFIGURATION_FIELD = SdkField
            .<Map<String, Map<String, List<String>>>> builder(MarshallingType.MAP)
            .memberName("ObjectConfiguration")
            .getter(getter(CreateDataIntegrationResponse::objectConfiguration))
            .setter(setter(Builder::objectConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, List<String>>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<String> builder(
                                                                                                            MarshallingType.STRING)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, KMS_KEY_FIELD, SOURCE_URI_FIELD, SCHEDULE_CONFIGURATION_FIELD, TAGS_FIELD,
            CLIENT_TOKEN_FIELD, FILE_CONFIGURATION_FIELD, OBJECT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String id;

    private final String name;

    private final String description;

    private final String kmsKey;

    private final String sourceURI;

    private final ScheduleConfiguration scheduleConfiguration;

    private final Map<String, String> tags;

    private final String clientToken;

    private final FileConfiguration fileConfiguration;

    private final Map<String, Map<String, List<String>>> objectConfiguration;

    private CreateDataIntegrationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.kmsKey = builder.kmsKey;
        this.sourceURI = builder.sourceURI;
        this.scheduleConfiguration = builder.scheduleConfiguration;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.fileConfiguration = builder.fileConfiguration;
        this.objectConfiguration = builder.objectConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN)
     * </p>
     * 
     * @return The Amazon Resource Name (ARN)
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A unique identifier.
     * </p>
     * 
     * @return A unique identifier.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the DataIntegration.
     * </p>
     * 
     * @return The name of the DataIntegration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the DataIntegration.
     * </p>
     * 
     * @return A description of the DataIntegration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The KMS key ARN for the DataIntegration.
     * </p>
     * 
     * @return The KMS key ARN for the DataIntegration.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The URI of the data source.
     * </p>
     * 
     * @return The URI of the data source.
     */
    public final String sourceURI() {
        return sourceURI;
    }

    /**
     * <p>
     * The name of the data and how often it should be pulled from the source.
     * </p>
     * 
     * @return The name of the data and how often it should be pulled from the source.
     */
    public final ScheduleConfiguration scheduleConfiguration() {
        return scheduleConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The configuration for what files should be pulled from the source.
     * </p>
     * 
     * @return The configuration for what files should be pulled from the source.
     */
    public final FileConfiguration fileConfiguration() {
        return fileConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ObjectConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasObjectConfiguration() {
        return objectConfiguration != null && !(objectConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The configuration for what data should be pulled from the source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObjectConfiguration} method.
     * </p>
     * 
     * @return The configuration for what data should be pulled from the source.
     */
    public final Map<String, Map<String, List<String>>> objectConfiguration() {
        return objectConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(sourceURI());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(fileConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasObjectConfiguration() ? objectConfiguration() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataIntegrationResponse)) {
            return false;
        }
        CreateDataIntegrationResponse other = (CreateDataIntegrationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(sourceURI(), other.sourceURI())
                && Objects.equals(scheduleConfiguration(), other.scheduleConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(fileConfiguration(), other.fileConfiguration())
                && hasObjectConfiguration() == other.hasObjectConfiguration()
                && Objects.equals(objectConfiguration(), other.objectConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataIntegrationResponse").add("Arn", arn()).add("Id", id()).add("Name", name())
                .add("Description", description()).add("KmsKey", kmsKey()).add("SourceURI", sourceURI())
                .add("ScheduleConfiguration", scheduleConfiguration()).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).add("FileConfiguration", fileConfiguration())
                .add("ObjectConfiguration", hasObjectConfiguration() ? objectConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "SourceURI":
            return Optional.ofNullable(clazz.cast(sourceURI()));
        case "ScheduleConfiguration":
            return Optional.ofNullable(clazz.cast(scheduleConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "FileConfiguration":
            return Optional.ofNullable(clazz.cast(fileConfiguration()));
        case "ObjectConfiguration":
            return Optional.ofNullable(clazz.cast(objectConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("KmsKey", KMS_KEY_FIELD);
        map.put("SourceURI", SOURCE_URI_FIELD);
        map.put("ScheduleConfiguration", SCHEDULE_CONFIGURATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("FileConfiguration", FILE_CONFIGURATION_FIELD);
        map.put("ObjectConfiguration", OBJECT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataIntegrationResponse, T> g) {
        return obj -> g.apply((CreateDataIntegrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataIntegrationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN)
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A unique identifier.
         * </p>
         * 
         * @param id
         *        A unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the DataIntegration.
         * </p>
         * 
         * @param name
         *        The name of the DataIntegration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the DataIntegration.
         * </p>
         * 
         * @param description
         *        A description of the DataIntegration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The KMS key ARN for the DataIntegration.
         * </p>
         * 
         * @param kmsKey
         *        The KMS key ARN for the DataIntegration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The URI of the data source.
         * </p>
         * 
         * @param sourceURI
         *        The URI of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceURI(String sourceURI);

        /**
         * <p>
         * The name of the data and how often it should be pulled from the source.
         * </p>
         * 
         * @param scheduleConfiguration
         *        The name of the data and how often it should be pulled from the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration);

        /**
         * <p>
         * The name of the data and how often it should be pulled from the source.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduleConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScheduleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleConfiguration(ScheduleConfiguration)}.
         * 
         * @param scheduleConfiguration
         *        a consumer that will call methods on {@link ScheduleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleConfiguration(ScheduleConfiguration)
         */
        default Builder scheduleConfiguration(Consumer<ScheduleConfiguration.Builder> scheduleConfiguration) {
            return scheduleConfiguration(ScheduleConfiguration.builder().applyMutation(scheduleConfiguration).build());
        }

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The configuration for what files should be pulled from the source.
         * </p>
         * 
         * @param fileConfiguration
         *        The configuration for what files should be pulled from the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileConfiguration(FileConfiguration fileConfiguration);

        /**
         * <p>
         * The configuration for what files should be pulled from the source.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileConfiguration.Builder} avoiding the
         * need to create one manually via {@link FileConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #fileConfiguration(FileConfiguration)}.
         * 
         * @param fileConfiguration
         *        a consumer that will call methods on {@link FileConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileConfiguration(FileConfiguration)
         */
        default Builder fileConfiguration(Consumer<FileConfiguration.Builder> fileConfiguration) {
            return fileConfiguration(FileConfiguration.builder().applyMutation(fileConfiguration).build());
        }

        /**
         * <p>
         * The configuration for what data should be pulled from the source.
         * </p>
         * 
         * @param objectConfiguration
         *        The configuration for what data should be pulled from the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectConfiguration(Map<String, ? extends Map<String, ? extends Collection<String>>> objectConfiguration);
    }

    static final class BuilderImpl extends AppIntegrationsResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String name;

        private String description;

        private String kmsKey;

        private String sourceURI;

        private ScheduleConfiguration scheduleConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private FileConfiguration fileConfiguration;

        private Map<String, Map<String, List<String>>> objectConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataIntegrationResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            name(model.name);
            description(model.description);
            kmsKey(model.kmsKey);
            sourceURI(model.sourceURI);
            scheduleConfiguration(model.scheduleConfiguration);
            tags(model.tags);
            clientToken(model.clientToken);
            fileConfiguration(model.fileConfiguration);
            objectConfiguration(model.objectConfiguration);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getSourceURI() {
            return sourceURI;
        }

        public final void setSourceURI(String sourceURI) {
            this.sourceURI = sourceURI;
        }

        @Override
        public final Builder sourceURI(String sourceURI) {
            this.sourceURI = sourceURI;
            return this;
        }

        public final ScheduleConfiguration.Builder getScheduleConfiguration() {
            return scheduleConfiguration != null ? scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(ScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final FileConfiguration.Builder getFileConfiguration() {
            return fileConfiguration != null ? fileConfiguration.toBuilder() : null;
        }

        public final void setFileConfiguration(FileConfiguration.BuilderImpl fileConfiguration) {
            this.fileConfiguration = fileConfiguration != null ? fileConfiguration.build() : null;
        }

        @Override
        public final Builder fileConfiguration(FileConfiguration fileConfiguration) {
            this.fileConfiguration = fileConfiguration;
            return this;
        }

        public final Map<String, ? extends Map<String, ? extends Collection<String>>> getObjectConfiguration() {
            if (objectConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return objectConfiguration;
        }

        public final void setObjectConfiguration(
                Map<String, ? extends Map<String, ? extends Collection<String>>> objectConfiguration) {
            this.objectConfiguration = ObjectConfigurationCopier.copy(objectConfiguration);
        }

        @Override
        public final Builder objectConfiguration(
                Map<String, ? extends Map<String, ? extends Collection<String>>> objectConfiguration) {
            this.objectConfiguration = ObjectConfigurationCopier.copy(objectConfiguration);
            return this;
        }

        @Override
        public CreateDataIntegrationResponse build() {
            return new CreateDataIntegrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
