/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about the DataIntegration association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIntegrationAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIntegrationAssociationSummary.Builder, DataIntegrationAssociationSummary> {
    private static final SdkField<String> DATA_INTEGRATION_ASSOCIATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DataIntegrationAssociationArn")
            .getter(getter(DataIntegrationAssociationSummary::dataIntegrationAssociationArn))
            .setter(setter(Builder::dataIntegrationAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataIntegrationAssociationArn")
                    .build()).build();

    private static final SdkField<String> DATA_INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataIntegrationArn").getter(getter(DataIntegrationAssociationSummary::dataIntegrationArn))
            .setter(setter(Builder::dataIntegrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataIntegrationArn").build())
            .build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(DataIntegrationAssociationSummary::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> DESTINATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationURI").getter(getter(DataIntegrationAssociationSummary::destinationURI))
            .setter(setter(Builder::destinationURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationURI").build()).build();

    private static final SdkField<LastExecutionStatus> LAST_EXECUTION_STATUS_FIELD = SdkField
            .<LastExecutionStatus> builder(MarshallingType.SDK_POJO).memberName("LastExecutionStatus")
            .getter(getter(DataIntegrationAssociationSummary::lastExecutionStatus)).setter(setter(Builder::lastExecutionStatus))
            .constructor(LastExecutionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionStatus").build())
            .build();

    private static final SdkField<ExecutionConfiguration> EXECUTION_CONFIGURATION_FIELD = SdkField
            .<ExecutionConfiguration> builder(MarshallingType.SDK_POJO).memberName("ExecutionConfiguration")
            .getter(getter(DataIntegrationAssociationSummary::executionConfiguration))
            .setter(setter(Builder::executionConfiguration)).constructor(ExecutionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_INTEGRATION_ASSOCIATION_ARN_FIELD, DATA_INTEGRATION_ARN_FIELD, CLIENT_ID_FIELD, DESTINATION_URI_FIELD,
            LAST_EXECUTION_STATUS_FIELD, EXECUTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataIntegrationAssociationArn;

    private final String dataIntegrationArn;

    private final String clientId;

    private final String destinationURI;

    private final LastExecutionStatus lastExecutionStatus;

    private final ExecutionConfiguration executionConfiguration;

    private DataIntegrationAssociationSummary(BuilderImpl builder) {
        this.dataIntegrationAssociationArn = builder.dataIntegrationAssociationArn;
        this.dataIntegrationArn = builder.dataIntegrationArn;
        this.clientId = builder.clientId;
        this.destinationURI = builder.destinationURI;
        this.lastExecutionStatus = builder.lastExecutionStatus;
        this.executionConfiguration = builder.executionConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the DataIntegration association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the DataIntegration association.
     */
    public final String dataIntegrationAssociationArn() {
        return dataIntegrationAssociationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the DataIntegration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the DataIntegration.
     */
    public final String dataIntegrationArn() {
        return dataIntegrationArn;
    }

    /**
     * <p>
     * The identifier for the client that is associated with the DataIntegration association.
     * </p>
     * 
     * @return The identifier for the client that is associated with the DataIntegration association.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The URI of the data destination.
     * </p>
     * 
     * @return The URI of the data destination.
     */
    public final String destinationURI() {
        return destinationURI;
    }

    /**
     * <p>
     * The execution status of the last job.
     * </p>
     * 
     * @return The execution status of the last job.
     */
    public final LastExecutionStatus lastExecutionStatus() {
        return lastExecutionStatus;
    }

    /**
     * Returns the value of the ExecutionConfiguration property for this object.
     * 
     * @return The value of the ExecutionConfiguration property for this object.
     */
    public final ExecutionConfiguration executionConfiguration() {
        return executionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataIntegrationAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataIntegrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationURI());
        hashCode = 31 * hashCode + Objects.hashCode(lastExecutionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(executionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationAssociationSummary)) {
            return false;
        }
        DataIntegrationAssociationSummary other = (DataIntegrationAssociationSummary) obj;
        return Objects.equals(dataIntegrationAssociationArn(), other.dataIntegrationAssociationArn())
                && Objects.equals(dataIntegrationArn(), other.dataIntegrationArn())
                && Objects.equals(clientId(), other.clientId()) && Objects.equals(destinationURI(), other.destinationURI())
                && Objects.equals(lastExecutionStatus(), other.lastExecutionStatus())
                && Objects.equals(executionConfiguration(), other.executionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIntegrationAssociationSummary")
                .add("DataIntegrationAssociationArn", dataIntegrationAssociationArn())
                .add("DataIntegrationArn", dataIntegrationArn()).add("ClientId", clientId())
                .add("DestinationURI", destinationURI()).add("LastExecutionStatus", lastExecutionStatus())
                .add("ExecutionConfiguration", executionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataIntegrationAssociationArn":
            return Optional.ofNullable(clazz.cast(dataIntegrationAssociationArn()));
        case "DataIntegrationArn":
            return Optional.ofNullable(clazz.cast(dataIntegrationArn()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "DestinationURI":
            return Optional.ofNullable(clazz.cast(destinationURI()));
        case "LastExecutionStatus":
            return Optional.ofNullable(clazz.cast(lastExecutionStatus()));
        case "ExecutionConfiguration":
            return Optional.ofNullable(clazz.cast(executionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataIntegrationAssociationArn", DATA_INTEGRATION_ASSOCIATION_ARN_FIELD);
        map.put("DataIntegrationArn", DATA_INTEGRATION_ARN_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("DestinationURI", DESTINATION_URI_FIELD);
        map.put("LastExecutionStatus", LAST_EXECUTION_STATUS_FIELD);
        map.put("ExecutionConfiguration", EXECUTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationAssociationSummary, T> g) {
        return obj -> g.apply((DataIntegrationAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIntegrationAssociationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the DataIntegration association.
         * </p>
         * 
         * @param dataIntegrationAssociationArn
         *        The Amazon Resource Name (ARN) of the DataIntegration association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataIntegrationAssociationArn(String dataIntegrationAssociationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the DataIntegration.
         * </p>
         * 
         * @param dataIntegrationArn
         *        The Amazon Resource Name (ARN) of the DataIntegration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataIntegrationArn(String dataIntegrationArn);

        /**
         * <p>
         * The identifier for the client that is associated with the DataIntegration association.
         * </p>
         * 
         * @param clientId
         *        The identifier for the client that is associated with the DataIntegration association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The URI of the data destination.
         * </p>
         * 
         * @param destinationURI
         *        The URI of the data destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationURI(String destinationURI);

        /**
         * <p>
         * The execution status of the last job.
         * </p>
         * 
         * @param lastExecutionStatus
         *        The execution status of the last job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastExecutionStatus(LastExecutionStatus lastExecutionStatus);

        /**
         * <p>
         * The execution status of the last job.
         * </p>
         * This is a convenience method that creates an instance of the {@link LastExecutionStatus.Builder} avoiding the
         * need to create one manually via {@link LastExecutionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LastExecutionStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #lastExecutionStatus(LastExecutionStatus)}.
         * 
         * @param lastExecutionStatus
         *        a consumer that will call methods on {@link LastExecutionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastExecutionStatus(LastExecutionStatus)
         */
        default Builder lastExecutionStatus(Consumer<LastExecutionStatus.Builder> lastExecutionStatus) {
            return lastExecutionStatus(LastExecutionStatus.builder().applyMutation(lastExecutionStatus).build());
        }

        /**
         * Sets the value of the ExecutionConfiguration property for this object.
         *
         * @param executionConfiguration
         *        The new value for the ExecutionConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionConfiguration(ExecutionConfiguration executionConfiguration);

        /**
         * Sets the value of the ExecutionConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ExecutionConfiguration.Builder} avoiding
         * the need to create one manually via {@link ExecutionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #executionConfiguration(ExecutionConfiguration)}.
         * 
         * @param executionConfiguration
         *        a consumer that will call methods on {@link ExecutionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionConfiguration(ExecutionConfiguration)
         */
        default Builder executionConfiguration(Consumer<ExecutionConfiguration.Builder> executionConfiguration) {
            return executionConfiguration(ExecutionConfiguration.builder().applyMutation(executionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String dataIntegrationAssociationArn;

        private String dataIntegrationArn;

        private String clientId;

        private String destinationURI;

        private LastExecutionStatus lastExecutionStatus;

        private ExecutionConfiguration executionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationAssociationSummary model) {
            dataIntegrationAssociationArn(model.dataIntegrationAssociationArn);
            dataIntegrationArn(model.dataIntegrationArn);
            clientId(model.clientId);
            destinationURI(model.destinationURI);
            lastExecutionStatus(model.lastExecutionStatus);
            executionConfiguration(model.executionConfiguration);
        }

        public final String getDataIntegrationAssociationArn() {
            return dataIntegrationAssociationArn;
        }

        public final void setDataIntegrationAssociationArn(String dataIntegrationAssociationArn) {
            this.dataIntegrationAssociationArn = dataIntegrationAssociationArn;
        }

        @Override
        public final Builder dataIntegrationAssociationArn(String dataIntegrationAssociationArn) {
            this.dataIntegrationAssociationArn = dataIntegrationAssociationArn;
            return this;
        }

        public final String getDataIntegrationArn() {
            return dataIntegrationArn;
        }

        public final void setDataIntegrationArn(String dataIntegrationArn) {
            this.dataIntegrationArn = dataIntegrationArn;
        }

        @Override
        public final Builder dataIntegrationArn(String dataIntegrationArn) {
            this.dataIntegrationArn = dataIntegrationArn;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getDestinationURI() {
            return destinationURI;
        }

        public final void setDestinationURI(String destinationURI) {
            this.destinationURI = destinationURI;
        }

        @Override
        public final Builder destinationURI(String destinationURI) {
            this.destinationURI = destinationURI;
            return this;
        }

        public final LastExecutionStatus.Builder getLastExecutionStatus() {
            return lastExecutionStatus != null ? lastExecutionStatus.toBuilder() : null;
        }

        public final void setLastExecutionStatus(LastExecutionStatus.BuilderImpl lastExecutionStatus) {
            this.lastExecutionStatus = lastExecutionStatus != null ? lastExecutionStatus.build() : null;
        }

        @Override
        public final Builder lastExecutionStatus(LastExecutionStatus lastExecutionStatus) {
            this.lastExecutionStatus = lastExecutionStatus;
            return this;
        }

        public final ExecutionConfiguration.Builder getExecutionConfiguration() {
            return executionConfiguration != null ? executionConfiguration.toBuilder() : null;
        }

        public final void setExecutionConfiguration(ExecutionConfiguration.BuilderImpl executionConfiguration) {
            this.executionConfiguration = executionConfiguration != null ? executionConfiguration.build() : null;
        }

        @Override
        public final Builder executionConfiguration(ExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
            return this;
        }

        @Override
        public DataIntegrationAssociationSummary build() {
            return new DataIntegrationAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
