/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The event integration association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventIntegrationAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<EventIntegrationAssociation.Builder, EventIntegrationAssociation> {
    private static final SdkField<String> EVENT_INTEGRATION_ASSOCIATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EventIntegrationAssociationArn")
            .getter(getter(EventIntegrationAssociation::eventIntegrationAssociationArn))
            .setter(setter(Builder::eventIntegrationAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventIntegrationAssociationArn")
                    .build()).build();

    private static final SdkField<String> EVENT_INTEGRATION_ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EventIntegrationAssociationId")
            .getter(getter(EventIntegrationAssociation::eventIntegrationAssociationId))
            .setter(setter(Builder::eventIntegrationAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventIntegrationAssociationId")
                    .build()).build();

    private static final SdkField<String> EVENT_INTEGRATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventIntegrationName").getter(getter(EventIntegrationAssociation::eventIntegrationName))
            .setter(setter(Builder::eventIntegrationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventIntegrationName").build())
            .build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(EventIntegrationAssociation::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> EVENT_BRIDGE_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventBridgeRuleName").getter(getter(EventIntegrationAssociation::eventBridgeRuleName))
            .setter(setter(Builder::eventBridgeRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeRuleName").build())
            .build();

    private static final SdkField<Map<String, String>> CLIENT_ASSOCIATION_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ClientAssociationMetadata")
            .getter(getter(EventIntegrationAssociation::clientAssociationMetadata))
            .setter(setter(Builder::clientAssociationMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientAssociationMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EVENT_INTEGRATION_ASSOCIATION_ARN_FIELD, EVENT_INTEGRATION_ASSOCIATION_ID_FIELD, EVENT_INTEGRATION_NAME_FIELD,
            CLIENT_ID_FIELD, EVENT_BRIDGE_RULE_NAME_FIELD, CLIENT_ASSOCIATION_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventIntegrationAssociationArn;

    private final String eventIntegrationAssociationId;

    private final String eventIntegrationName;

    private final String clientId;

    private final String eventBridgeRuleName;

    private final Map<String, String> clientAssociationMetadata;

    private EventIntegrationAssociation(BuilderImpl builder) {
        this.eventIntegrationAssociationArn = builder.eventIntegrationAssociationArn;
        this.eventIntegrationAssociationId = builder.eventIntegrationAssociationId;
        this.eventIntegrationName = builder.eventIntegrationName;
        this.clientId = builder.clientId;
        this.eventBridgeRuleName = builder.eventBridgeRuleName;
        this.clientAssociationMetadata = builder.clientAssociationMetadata;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the event integration association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the event integration association.
     */
    public final String eventIntegrationAssociationArn() {
        return eventIntegrationAssociationArn;
    }

    /**
     * <p>
     * The identifier for the event integration association.
     * </p>
     * 
     * @return The identifier for the event integration association.
     */
    public final String eventIntegrationAssociationId() {
        return eventIntegrationAssociationId;
    }

    /**
     * <p>
     * The name of the event integration.
     * </p>
     * 
     * @return The name of the event integration.
     */
    public final String eventIntegrationName() {
        return eventIntegrationName;
    }

    /**
     * <p>
     * The identifier for the client that is associated with the event integration.
     * </p>
     * 
     * @return The identifier for the client that is associated with the event integration.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The name of the EventBridge rule.
     * </p>
     * 
     * @return The name of the EventBridge rule.
     */
    public final String eventBridgeRuleName() {
        return eventBridgeRuleName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientAssociationMetadata property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasClientAssociationMetadata() {
        return clientAssociationMetadata != null && !(clientAssociationMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata associated with the client.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientAssociationMetadata} method.
     * </p>
     * 
     * @return The metadata associated with the client.
     */
    public final Map<String, String> clientAssociationMetadata() {
        return clientAssociationMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventIntegrationAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventIntegrationAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(eventIntegrationName());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(eventBridgeRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(hasClientAssociationMetadata() ? clientAssociationMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventIntegrationAssociation)) {
            return false;
        }
        EventIntegrationAssociation other = (EventIntegrationAssociation) obj;
        return Objects.equals(eventIntegrationAssociationArn(), other.eventIntegrationAssociationArn())
                && Objects.equals(eventIntegrationAssociationId(), other.eventIntegrationAssociationId())
                && Objects.equals(eventIntegrationName(), other.eventIntegrationName())
                && Objects.equals(clientId(), other.clientId())
                && Objects.equals(eventBridgeRuleName(), other.eventBridgeRuleName())
                && hasClientAssociationMetadata() == other.hasClientAssociationMetadata()
                && Objects.equals(clientAssociationMetadata(), other.clientAssociationMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventIntegrationAssociation")
                .add("EventIntegrationAssociationArn", eventIntegrationAssociationArn())
                .add("EventIntegrationAssociationId", eventIntegrationAssociationId())
                .add("EventIntegrationName", eventIntegrationName()).add("ClientId", clientId())
                .add("EventBridgeRuleName", eventBridgeRuleName())
                .add("ClientAssociationMetadata", hasClientAssociationMetadata() ? clientAssociationMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventIntegrationAssociationArn":
            return Optional.ofNullable(clazz.cast(eventIntegrationAssociationArn()));
        case "EventIntegrationAssociationId":
            return Optional.ofNullable(clazz.cast(eventIntegrationAssociationId()));
        case "EventIntegrationName":
            return Optional.ofNullable(clazz.cast(eventIntegrationName()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "EventBridgeRuleName":
            return Optional.ofNullable(clazz.cast(eventBridgeRuleName()));
        case "ClientAssociationMetadata":
            return Optional.ofNullable(clazz.cast(clientAssociationMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventIntegrationAssociationArn", EVENT_INTEGRATION_ASSOCIATION_ARN_FIELD);
        map.put("EventIntegrationAssociationId", EVENT_INTEGRATION_ASSOCIATION_ID_FIELD);
        map.put("EventIntegrationName", EVENT_INTEGRATION_NAME_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("EventBridgeRuleName", EVENT_BRIDGE_RULE_NAME_FIELD);
        map.put("ClientAssociationMetadata", CLIENT_ASSOCIATION_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventIntegrationAssociation, T> g) {
        return obj -> g.apply((EventIntegrationAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventIntegrationAssociation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the event integration association.
         * </p>
         * 
         * @param eventIntegrationAssociationArn
         *        The Amazon Resource Name (ARN) for the event integration association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventIntegrationAssociationArn(String eventIntegrationAssociationArn);

        /**
         * <p>
         * The identifier for the event integration association.
         * </p>
         * 
         * @param eventIntegrationAssociationId
         *        The identifier for the event integration association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventIntegrationAssociationId(String eventIntegrationAssociationId);

        /**
         * <p>
         * The name of the event integration.
         * </p>
         * 
         * @param eventIntegrationName
         *        The name of the event integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventIntegrationName(String eventIntegrationName);

        /**
         * <p>
         * The identifier for the client that is associated with the event integration.
         * </p>
         * 
         * @param clientId
         *        The identifier for the client that is associated with the event integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The name of the EventBridge rule.
         * </p>
         * 
         * @param eventBridgeRuleName
         *        The name of the EventBridge rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeRuleName(String eventBridgeRuleName);

        /**
         * <p>
         * The metadata associated with the client.
         * </p>
         * 
         * @param clientAssociationMetadata
         *        The metadata associated with the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientAssociationMetadata(Map<String, String> clientAssociationMetadata);
    }

    static final class BuilderImpl implements Builder {
        private String eventIntegrationAssociationArn;

        private String eventIntegrationAssociationId;

        private String eventIntegrationName;

        private String clientId;

        private String eventBridgeRuleName;

        private Map<String, String> clientAssociationMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventIntegrationAssociation model) {
            eventIntegrationAssociationArn(model.eventIntegrationAssociationArn);
            eventIntegrationAssociationId(model.eventIntegrationAssociationId);
            eventIntegrationName(model.eventIntegrationName);
            clientId(model.clientId);
            eventBridgeRuleName(model.eventBridgeRuleName);
            clientAssociationMetadata(model.clientAssociationMetadata);
        }

        public final String getEventIntegrationAssociationArn() {
            return eventIntegrationAssociationArn;
        }

        public final void setEventIntegrationAssociationArn(String eventIntegrationAssociationArn) {
            this.eventIntegrationAssociationArn = eventIntegrationAssociationArn;
        }

        @Override
        public final Builder eventIntegrationAssociationArn(String eventIntegrationAssociationArn) {
            this.eventIntegrationAssociationArn = eventIntegrationAssociationArn;
            return this;
        }

        public final String getEventIntegrationAssociationId() {
            return eventIntegrationAssociationId;
        }

        public final void setEventIntegrationAssociationId(String eventIntegrationAssociationId) {
            this.eventIntegrationAssociationId = eventIntegrationAssociationId;
        }

        @Override
        public final Builder eventIntegrationAssociationId(String eventIntegrationAssociationId) {
            this.eventIntegrationAssociationId = eventIntegrationAssociationId;
            return this;
        }

        public final String getEventIntegrationName() {
            return eventIntegrationName;
        }

        public final void setEventIntegrationName(String eventIntegrationName) {
            this.eventIntegrationName = eventIntegrationName;
        }

        @Override
        public final Builder eventIntegrationName(String eventIntegrationName) {
            this.eventIntegrationName = eventIntegrationName;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getEventBridgeRuleName() {
            return eventBridgeRuleName;
        }

        public final void setEventBridgeRuleName(String eventBridgeRuleName) {
            this.eventBridgeRuleName = eventBridgeRuleName;
        }

        @Override
        public final Builder eventBridgeRuleName(String eventBridgeRuleName) {
            this.eventBridgeRuleName = eventBridgeRuleName;
            return this;
        }

        public final Map<String, String> getClientAssociationMetadata() {
            if (clientAssociationMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return clientAssociationMetadata;
        }

        public final void setClientAssociationMetadata(Map<String, String> clientAssociationMetadata) {
            this.clientAssociationMetadata = ClientAssociationMetadataCopier.copy(clientAssociationMetadata);
        }

        @Override
        public final Builder clientAssociationMetadata(Map<String, String> clientAssociationMetadata) {
            this.clientAssociationMetadata = ClientAssociationMetadataCopier.copy(clientAssociationMetadata);
            return this;
        }

        @Override
        public EventIntegrationAssociation build() {
            return new EventIntegrationAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
