/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for how the files should be pulled from the source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionConfiguration.Builder, ExecutionConfiguration> {
    private static final SdkField<String> EXECUTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionMode").getter(getter(ExecutionConfiguration::executionModeAsString))
            .setter(setter(Builder::executionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionMode").build()).build();

    private static final SdkField<OnDemandConfiguration> ON_DEMAND_CONFIGURATION_FIELD = SdkField
            .<OnDemandConfiguration> builder(MarshallingType.SDK_POJO).memberName("OnDemandConfiguration")
            .getter(getter(ExecutionConfiguration::onDemandConfiguration)).setter(setter(Builder::onDemandConfiguration))
            .constructor(OnDemandConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandConfiguration").build())
            .build();

    private static final SdkField<ScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField
            .<ScheduleConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScheduleConfiguration")
            .getter(getter(ExecutionConfiguration::scheduleConfiguration)).setter(setter(Builder::scheduleConfiguration))
            .constructor(ScheduleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_MODE_FIELD,
            ON_DEMAND_CONFIGURATION_FIELD, SCHEDULE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String executionMode;

    private final OnDemandConfiguration onDemandConfiguration;

    private final ScheduleConfiguration scheduleConfiguration;

    private ExecutionConfiguration(BuilderImpl builder) {
        this.executionMode = builder.executionMode;
        this.onDemandConfiguration = builder.onDemandConfiguration;
        this.scheduleConfiguration = builder.scheduleConfiguration;
    }

    /**
     * <p>
     * The mode for data import/export execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionMode}
     * will return {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #executionModeAsString}.
     * </p>
     * 
     * @return The mode for data import/export execution.
     * @see ExecutionMode
     */
    public final ExecutionMode executionMode() {
        return ExecutionMode.fromValue(executionMode);
    }

    /**
     * <p>
     * The mode for data import/export execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionMode}
     * will return {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #executionModeAsString}.
     * </p>
     * 
     * @return The mode for data import/export execution.
     * @see ExecutionMode
     */
    public final String executionModeAsString() {
        return executionMode;
    }

    /**
     * Returns the value of the OnDemandConfiguration property for this object.
     * 
     * @return The value of the OnDemandConfiguration property for this object.
     */
    public final OnDemandConfiguration onDemandConfiguration() {
        return onDemandConfiguration;
    }

    /**
     * Returns the value of the ScheduleConfiguration property for this object.
     * 
     * @return The value of the ScheduleConfiguration property for this object.
     */
    public final ScheduleConfiguration scheduleConfiguration() {
        return scheduleConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionConfiguration)) {
            return false;
        }
        ExecutionConfiguration other = (ExecutionConfiguration) obj;
        return Objects.equals(executionModeAsString(), other.executionModeAsString())
                && Objects.equals(onDemandConfiguration(), other.onDemandConfiguration())
                && Objects.equals(scheduleConfiguration(), other.scheduleConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionConfiguration").add("ExecutionMode", executionModeAsString())
                .add("OnDemandConfiguration", onDemandConfiguration()).add("ScheduleConfiguration", scheduleConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionMode":
            return Optional.ofNullable(clazz.cast(executionModeAsString()));
        case "OnDemandConfiguration":
            return Optional.ofNullable(clazz.cast(onDemandConfiguration()));
        case "ScheduleConfiguration":
            return Optional.ofNullable(clazz.cast(scheduleConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExecutionMode", EXECUTION_MODE_FIELD);
        map.put("OnDemandConfiguration", ON_DEMAND_CONFIGURATION_FIELD);
        map.put("ScheduleConfiguration", SCHEDULE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionConfiguration, T> g) {
        return obj -> g.apply((ExecutionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionConfiguration> {
        /**
         * <p>
         * The mode for data import/export execution.
         * </p>
         * 
         * @param executionMode
         *        The mode for data import/export execution.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder executionMode(String executionMode);

        /**
         * <p>
         * The mode for data import/export execution.
         * </p>
         * 
         * @param executionMode
         *        The mode for data import/export execution.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder executionMode(ExecutionMode executionMode);

        /**
         * Sets the value of the OnDemandConfiguration property for this object.
         *
         * @param onDemandConfiguration
         *        The new value for the OnDemandConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandConfiguration(OnDemandConfiguration onDemandConfiguration);

        /**
         * Sets the value of the OnDemandConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OnDemandConfiguration.Builder} avoiding
         * the need to create one manually via {@link OnDemandConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnDemandConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #onDemandConfiguration(OnDemandConfiguration)}.
         * 
         * @param onDemandConfiguration
         *        a consumer that will call methods on {@link OnDemandConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onDemandConfiguration(OnDemandConfiguration)
         */
        default Builder onDemandConfiguration(Consumer<OnDemandConfiguration.Builder> onDemandConfiguration) {
            return onDemandConfiguration(OnDemandConfiguration.builder().applyMutation(onDemandConfiguration).build());
        }

        /**
         * Sets the value of the ScheduleConfiguration property for this object.
         *
         * @param scheduleConfiguration
         *        The new value for the ScheduleConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration);

        /**
         * Sets the value of the ScheduleConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ScheduleConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScheduleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleConfiguration(ScheduleConfiguration)}.
         * 
         * @param scheduleConfiguration
         *        a consumer that will call methods on {@link ScheduleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleConfiguration(ScheduleConfiguration)
         */
        default Builder scheduleConfiguration(Consumer<ScheduleConfiguration.Builder> scheduleConfiguration) {
            return scheduleConfiguration(ScheduleConfiguration.builder().applyMutation(scheduleConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String executionMode;

        private OnDemandConfiguration onDemandConfiguration;

        private ScheduleConfiguration scheduleConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionConfiguration model) {
            executionMode(model.executionMode);
            onDemandConfiguration(model.onDemandConfiguration);
            scheduleConfiguration(model.scheduleConfiguration);
        }

        public final String getExecutionMode() {
            return executionMode;
        }

        public final void setExecutionMode(String executionMode) {
            this.executionMode = executionMode;
        }

        @Override
        public final Builder executionMode(String executionMode) {
            this.executionMode = executionMode;
            return this;
        }

        @Override
        public final Builder executionMode(ExecutionMode executionMode) {
            this.executionMode(executionMode == null ? null : executionMode.toString());
            return this;
        }

        public final OnDemandConfiguration.Builder getOnDemandConfiguration() {
            return onDemandConfiguration != null ? onDemandConfiguration.toBuilder() : null;
        }

        public final void setOnDemandConfiguration(OnDemandConfiguration.BuilderImpl onDemandConfiguration) {
            this.onDemandConfiguration = onDemandConfiguration != null ? onDemandConfiguration.build() : null;
        }

        @Override
        public final Builder onDemandConfiguration(OnDemandConfiguration onDemandConfiguration) {
            this.onDemandConfiguration = onDemandConfiguration;
            return this;
        }

        public final ScheduleConfiguration.Builder getScheduleConfiguration() {
            return scheduleConfiguration != null ? scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(ScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        @Override
        public ExecutionConfiguration build() {
            return new ExecutionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
